/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.WidgetResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.WidgetDAO;
import id.onyx.obdp.server.orm.dao.WidgetLayoutDAO;
import id.onyx.obdp.server.orm.entities.WidgetEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutEntity;
import id.onyx.obdp.server.orm.entities.WidgetLayoutUserWidgetEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

@StaticallyInject
public class WidgetLayoutResourceProvider
extends AbstractControllerResourceProvider {
    public static final String WIDGETLAYOUT_ID_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "id");
    public static final String WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "cluster_name");
    public static final String WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "section_name");
    public static final String WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "layout_name");
    public static final String WIDGETLAYOUT_SCOPE_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "scope");
    public static final String WIDGETLAYOUT_WIDGETS_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "widgets");
    public static final String WIDGETLAYOUT_USERNAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "user_name");
    public static final String WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("WidgetLayoutInfo", "display_name");
    private static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)WIDGETLAYOUT_ID_PROPERTY_ID).build();
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)WIDGETLAYOUT_ID_PROPERTY_ID).add((Object)WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_WIDGETS_PROPERTY_ID).add((Object)WIDGETLAYOUT_SCOPE_PROPERTY_ID).add((Object)WIDGETLAYOUT_USERNAME_PROPERTY_ID).add((Object)WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.WidgetLayout, (Object)WIDGETLAYOUT_ID_PROPERTY_ID).put((Object)Resource.Type.Cluster, (Object)WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.User, (Object)WIDGETLAYOUT_USERNAME_PROPERTY_ID).build();
    @Inject
    private static WidgetDAO widgetDAO;
    @Inject
    private static WidgetLayoutDAO widgetLayoutDAO;

    public WidgetLayoutResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.WidgetLayout, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(final Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (final Map<String, Object> properties : request.getProperties()) {
            WidgetLayoutEntity widgetLayoutEntity = this.createResources(new AbstractResourceProvider.Command<WidgetLayoutEntity>(){

                @Override
                public WidgetLayoutEntity invoke() throws OBDPException {
                    String[] requiredProperties;
                    for (String propertyName : requiredProperties = new String[]{WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID, WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID, WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID, WIDGETLAYOUT_SCOPE_PROPERTY_ID, WIDGETLAYOUT_WIDGETS_PROPERTY_ID, WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID, WIDGETLAYOUT_USERNAME_PROPERTY_ID}) {
                        if (properties.get(propertyName) != null) continue;
                        throw new OBDPException("Property " + propertyName + " should be provided");
                    }
                    WidgetLayoutEntity entity = new WidgetLayoutEntity();
                    String userName = WidgetLayoutResourceProvider.this.getUserName(properties);
                    LinkedHashSet widgetsSet = (LinkedHashSet)properties.get(WIDGETLAYOUT_WIDGETS_PROPERTY_ID);
                    String clusterName = properties.get(WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID).toString();
                    entity.setLayoutName(properties.get(WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID).toString());
                    entity.setClusterId(WidgetLayoutResourceProvider.this.getManagementController().getClusters().getCluster(clusterName).getClusterId());
                    entity.setSectionName(properties.get(WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID).toString());
                    entity.setScope(properties.get(WIDGETLAYOUT_SCOPE_PROPERTY_ID).toString());
                    entity.setUserName(userName);
                    entity.setDisplayName(properties.get(WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID).toString());
                    LinkedList<WidgetLayoutUserWidgetEntity> widgetLayoutUserWidgetEntityList = new LinkedList<WidgetLayoutUserWidgetEntity>();
                    int order = 0;
                    for (Object widgetObject : widgetsSet) {
                        HashMap widget = (HashMap)widgetObject;
                        long id = Integer.parseInt(widget.get("id").toString());
                        WidgetEntity widgetEntity = widgetDAO.findById(id);
                        if (widgetEntity == null) {
                            throw new OBDPException("Widget with id " + widget.get("id") + " does not exists");
                        }
                        WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity = new WidgetLayoutUserWidgetEntity();
                        widgetLayoutUserWidgetEntity.setWidget(widgetEntity);
                        widgetLayoutUserWidgetEntity.setWidgetOrder(order++);
                        widgetLayoutUserWidgetEntity.setWidgetLayout(entity);
                        widgetLayoutUserWidgetEntityList.add(widgetLayoutUserWidgetEntity);
                        widgetEntity.getListWidgetLayoutUserWidgetEntity().add(widgetLayoutUserWidgetEntity);
                    }
                    entity.setListWidgetLayoutUserWidgetEntity(widgetLayoutUserWidgetEntityList);
                    widgetLayoutDAO.create(entity);
                    WidgetLayoutResourceProvider.this.notifyCreate(Resource.Type.WidgetLayout, request);
                    return entity;
                }
            });
            ResourceImpl resource = new ResourceImpl(Resource.Type.WidgetLayout);
            resource.setProperty(WIDGETLAYOUT_ID_PROPERTY_ID, widgetLayoutEntity.getId());
            associatedResources.add(resource);
        }
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<WidgetLayoutEntity> layoutEntities = new ArrayList<WidgetLayoutEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            if (propertyMap.get(WIDGETLAYOUT_ID_PROPERTY_ID) != null) {
                Long id;
                try {
                    id = Long.parseLong(propertyMap.get(WIDGETLAYOUT_ID_PROPERTY_ID).toString());
                }
                catch (Exception ex) {
                    throw new SystemException("WidgetLayout should have numerical id");
                }
                WidgetLayoutEntity entity = widgetLayoutDAO.findById(id);
                if (entity == null) {
                    throw new NoSuchResourceException("WidgetLayout with id " + id + " does not exists");
                }
                layoutEntities.add(entity);
                continue;
            }
            layoutEntities.addAll(widgetLayoutDAO.findAll());
        }
        for (WidgetLayoutEntity layoutEntity : layoutEntities) {
            String clusterName;
            ResourceImpl resource = new ResourceImpl(Resource.Type.WidgetLayout);
            resource.setProperty(WIDGETLAYOUT_ID_PROPERTY_ID, layoutEntity.getId());
            try {
                clusterName = this.getManagementController().getClusters().getClusterById(layoutEntity.getClusterId()).getClusterName();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage());
            }
            resource.setProperty(WIDGETLAYOUT_CLUSTER_NAME_PROPERTY_ID, clusterName);
            resource.setProperty(WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID, layoutEntity.getLayoutName());
            resource.setProperty(WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID, layoutEntity.getSectionName());
            resource.setProperty(WIDGETLAYOUT_SCOPE_PROPERTY_ID, layoutEntity.getScope());
            resource.setProperty(WIDGETLAYOUT_USERNAME_PROPERTY_ID, layoutEntity.getUserName());
            resource.setProperty(WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID, layoutEntity.getDisplayName());
            ArrayList widgets = new ArrayList();
            List<WidgetLayoutUserWidgetEntity> widgetLayoutUserWidgetEntityList = layoutEntity.getListWidgetLayoutUserWidgetEntity();
            for (WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity : widgetLayoutUserWidgetEntityList) {
                WidgetEntity widgetEntity = widgetLayoutUserWidgetEntity.getWidget();
                HashMap<String, WidgetResponse> widgetInfoMap = new HashMap<String, WidgetResponse>();
                widgetInfoMap.put("WidgetInfo", WidgetResponse.coerce(widgetEntity));
                widgets.add(widgetInfoMap);
            }
            resource.setProperty(WIDGETLAYOUT_WIDGETS_PROPERTY_ID, widgets);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final Set<Map<String, Object>> propertyMaps = request.getProperties();
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void invoke() throws OBDPException {
                for (Map propertyMap : propertyMaps) {
                    Long layoutId;
                    try {
                        layoutId = Long.parseLong(propertyMap.get(WIDGETLAYOUT_ID_PROPERTY_ID).toString());
                    }
                    catch (Exception ex) {
                        throw new OBDPException("WidgetLayout should have numerical id");
                    }
                    lock.writeLock().lock();
                    try {
                        WidgetLayoutEntity entity = widgetLayoutDAO.findById(layoutId);
                        if (entity == null) {
                            throw new ObjectNotFoundException("There is no widget layout with id " + layoutId);
                        }
                        if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID)))) {
                            entity.setLayoutName(propertyMap.get(WIDGETLAYOUT_LAYOUT_NAME_PROPERTY_ID).toString());
                        }
                        if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID)))) {
                            entity.setSectionName(propertyMap.get(WIDGETLAYOUT_SECTION_NAME_PROPERTY_ID).toString());
                        }
                        if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID)))) {
                            entity.setDisplayName(propertyMap.get(WIDGETLAYOUT_DISPLAY_NAME_PROPERTY_ID).toString());
                        }
                        if (StringUtils.isNotBlank((String)ObjectUtils.toString(propertyMap.get(WIDGETLAYOUT_SCOPE_PROPERTY_ID)))) {
                            entity.setScope(propertyMap.get(WIDGETLAYOUT_SCOPE_PROPERTY_ID).toString());
                        }
                        LinkedHashSet widgetsSet = (LinkedHashSet)propertyMap.get(WIDGETLAYOUT_WIDGETS_PROPERTY_ID);
                        for (WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity : entity.getListWidgetLayoutUserWidgetEntity()) {
                            widgetLayoutUserWidgetEntity.getWidget().getListWidgetLayoutUserWidgetEntity().remove(widgetLayoutUserWidgetEntity);
                        }
                        entity.setListWidgetLayoutUserWidgetEntity(new LinkedList<WidgetLayoutUserWidgetEntity>());
                        LinkedList<WidgetLayoutUserWidgetEntity> widgetLayoutUserWidgetEntityList = new LinkedList<WidgetLayoutUserWidgetEntity>();
                        int order = 0;
                        for (Object widgetObject : widgetsSet) {
                            HashMap widget = (HashMap)widgetObject;
                            long id = Integer.parseInt(widget.get("id").toString());
                            WidgetEntity widgetEntity = widgetDAO.findById(id);
                            if (widgetEntity == null) {
                                throw new OBDPException("Widget with id " + widget.get("id") + " does not exists");
                            }
                            WidgetLayoutUserWidgetEntity widgetLayoutUserWidgetEntity = new WidgetLayoutUserWidgetEntity();
                            widgetLayoutUserWidgetEntity.setWidget(widgetEntity);
                            widgetLayoutUserWidgetEntity.setWidgetOrder(order++);
                            widgetLayoutUserWidgetEntity.setWidgetLayout(entity);
                            widgetLayoutUserWidgetEntityList.add(widgetLayoutUserWidgetEntity);
                            widgetEntity.getListWidgetLayoutUserWidgetEntity().add(widgetLayoutUserWidgetEntity);
                            entity.getListWidgetLayoutUserWidgetEntity().add(widgetLayoutUserWidgetEntity);
                        }
                        widgetLayoutDAO.mergeWithFlush(entity);
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                }
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        ArrayList<WidgetLayoutEntity> entitiesToBeRemoved = new ArrayList<WidgetLayoutEntity>();
        for (Map<String, Object> propertyMap : propertyMaps) {
            Long id;
            try {
                id = Long.parseLong(propertyMap.get(WIDGETLAYOUT_ID_PROPERTY_ID).toString());
            }
            catch (Exception ex) {
                throw new SystemException("WidgetLayout should have numerical id");
            }
            WidgetLayoutEntity entity = widgetLayoutDAO.findById(id);
            if (entity == null) {
                throw new NoSuchResourceException("There is no widget layout with id " + id);
            }
            entitiesToBeRemoved.add(entity);
        }
        for (WidgetLayoutEntity entity : entitiesToBeRemoved) {
            if (entity.getListWidgetLayoutUserWidgetEntity() != null) {
                for (WidgetLayoutUserWidgetEntity layoutUserWidgetEntity : entity.getListWidgetLayoutUserWidgetEntity()) {
                    if (layoutUserWidgetEntity.getWidget().getListWidgetLayoutUserWidgetEntity() == null) continue;
                    layoutUserWidgetEntity.getWidget().getListWidgetLayoutUserWidgetEntity().remove(layoutUserWidgetEntity);
                }
            }
            widgetLayoutDAO.remove(entity);
        }
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private String getUserName(Map<String, Object> properties) {
        if (properties.get(WIDGETLAYOUT_USERNAME_PROPERTY_ID) != null) {
            return properties.get(WIDGETLAYOUT_USERNAME_PROPERTY_ID).toString();
        }
        return this.getManagementController().getAuthName();
    }

    public static enum SCOPE {
        CLUSTER,
        USER;

    }
}

