/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.ViewVersionResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.configuration.ParameterConfig;
import id.onyx.obdp.view.ViewDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ViewVersionResourceProvider
extends AbstractResourceProvider {
    public static final String VIEW_VERSION_INFO = "ViewVersionInfo";
    public static final String VIEW_NAME_PROPERTY_ID = "view_name";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String BUILD_NUMBER_PROPERTY_ID = "build_number";
    public static final String LABEL_PROPERTY_ID = "label";
    public static final String DESCRIPTION_PROPERTY_ID = "description";
    public static final String MIN_AMBARI_VERSION_PROPERTY_ID = "min_ambari_version";
    public static final String MAX_AMBARI_VERSION_PROPERTY_ID = "max_ambari_version";
    public static final String PARAMETERS_PROPERTY_ID = "parameters";
    public static final String ARCHIVE_PROPERTY_ID = "archive";
    public static final String MASKER_CLASS_PROPERTY_ID = "masker_class";
    public static final String STATUS_PROPERTY_ID = "status";
    public static final String STATUS_DETAIL_PROPERTY_ID = "status_detail";
    public static final String CLUSTER_CONFIGURABLE_PROPERTY_ID = "cluster_configurable";
    public static final String SYSTEM_PROPERTY_ID = "system";
    public static final String VIEW_NAME = "ViewVersionInfo/view_name";
    public static final String VERSION = "ViewVersionInfo/version";
    public static final String BUILD_NUMBER = "ViewVersionInfo/build_number";
    public static final String LABEL = "ViewVersionInfo/label";
    public static final String DESCRIPTION = "ViewVersionInfo/description";
    public static final String MIN_AMBARI_VERSION = "ViewVersionInfo/min_ambari_version";
    public static final String MAX_AMBARI_VERSION = "ViewVersionInfo/max_ambari_version";
    public static final String PARAMETERS = "ViewVersionInfo/parameters";
    public static final String ARCHIVE = "ViewVersionInfo/archive";
    public static final String MASKER_CLASS = "ViewVersionInfo/masker_class";
    public static final String STATUS = "ViewVersionInfo/status";
    public static final String STATUS_DETAIL = "ViewVersionInfo/status_detail";
    public static final String CLUSTER_CONFIGURABLE = "ViewVersionInfo/cluster_configurable";
    public static final String SYSTEM = "ViewVersionInfo/system";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.View, (Object)"ViewVersionInfo/view_name").put((Object)Resource.Type.ViewVersion, (Object)"ViewVersionInfo/version").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ViewVersionInfo/view_name", "ViewVersionInfo/version", "ViewVersionInfo/build_number", "ViewVersionInfo/label", "ViewVersionInfo/description", "ViewVersionInfo/min_ambari_version", "ViewVersionInfo/max_ambari_version", "ViewVersionInfo/parameters", "ViewVersionInfo/archive", "ViewVersionInfo/masker_class", "ViewVersionInfo/status", "ViewVersionInfo/status_detail", "ViewVersionInfo/cluster_configurable", "ViewVersionInfo/system"});

    public ViewVersionResourceProvider() {
        super(propertyIds, keyPropertyIds);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            propertyMaps.add(Collections.emptyMap());
        }
        for (Map<String, Object> propertyMap : propertyMaps) {
            String viewName = (String)propertyMap.get(VIEW_NAME);
            String viewVersion = (String)propertyMap.get(VERSION);
            for (ViewEntity viewDefinition : viewRegistry.getDefinitions()) {
                if (viewName != null && !viewName.equals(viewDefinition.getCommonName()) || viewVersion != null && !viewVersion.equals(viewDefinition.getVersion())) continue;
                ResourceImpl resource = new ResourceImpl(Resource.Type.ViewVersion);
                ViewVersionResponse viewVersionResponse = this.getResponse(viewDefinition);
                ViewVersionResponse.ViewVersionInfo viewVersionInfo = viewVersionResponse.getViewVersionInfo();
                ViewVersionResourceProvider.setResourceProperty(resource, VIEW_NAME, viewVersionInfo.getViewName(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, VERSION, viewVersionInfo.getVersion(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, BUILD_NUMBER, viewVersionInfo.getBuildNumber(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, LABEL, viewVersionInfo.getLabel(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, DESCRIPTION, viewVersionInfo.getDescription(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, MIN_AMBARI_VERSION, viewVersionInfo.getMinAmbariVersion(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, MAX_AMBARI_VERSION, viewVersionInfo.getMaxAmbariVersion(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, PARAMETERS, viewVersionInfo.getParameters(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, ARCHIVE, viewVersionInfo.getArchive(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, MASKER_CLASS, viewVersionInfo.getMaskerClass(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, STATUS, viewVersionInfo.getStatus().toString(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, STATUS_DETAIL, viewVersionInfo.getStatusDetail(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, CLUSTER_CONFIGURABLE, viewVersionInfo.isClusterConfigurable(), requestedIds);
                ViewVersionResourceProvider.setResourceProperty(resource, SYSTEM, viewVersionInfo.isSystem(), requestedIds);
                resources.add(resource);
            }
        }
        return resources;
    }

    public ViewVersionResponse getResponse(ViewEntity viewDefinition) {
        String archive = viewDefinition.getArchive();
        String buildNumber = viewDefinition.getBuild();
        boolean clusterConfigurable = viewDefinition.isClusterConfigurable();
        String description = viewDefinition.getDescription();
        String label = viewDefinition.getLabel();
        String maskerClass = viewDefinition.getMask();
        String maxAmbariVersion = viewDefinition.getConfiguration().getMaxAmbariVersion();
        String minAmbariVersion = viewDefinition.getConfiguration().getMinAmbariVersion();
        List<ParameterConfig> parameters = viewDefinition.getConfiguration().getParameters();
        ViewDefinition.ViewStatus status = viewDefinition.getStatus();
        String statusDetail = viewDefinition.getStatusDetail();
        boolean system = viewDefinition.isSystem();
        String version = viewDefinition.getVersion();
        String viewName = viewDefinition.getCommonName();
        ViewVersionResponse.ViewVersionInfo viewVersionInfo = new ViewVersionResponse.ViewVersionInfo(archive, buildNumber, clusterConfigurable, description, label, maskerClass, maxAmbariVersion, minAmbariVersion, parameters, status, statusDetail, system, version, viewName);
        return new ViewVersionResponse(viewVersionInfo);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

