/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.ViewURLDAO;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.orm.entities.ViewURLEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.validation.ValidationException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class ViewURLResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String VIEW_URL_INFO = "ViewUrlInfo";
    public static final String URL_NAME_PROPERTY_ID = "url_name";
    public static final String URL_SUFFIX_PROPERTY_ID = "url_suffix";
    public static final String VIEW_INSTANCE_VERSION_PROPERTY_ID = "view_instance_version";
    public static final String VIEW_INSTANCE_NAME_PROPERTY_ID = "view_instance_name";
    public static final String VIEW_INSTANCE_COMMON_NAME_PROPERTY_ID = "view_instance_common_name";
    public static final String URL_NAME = "ViewUrlInfo/url_name";
    public static final String URL_SUFFIX = "ViewUrlInfo/url_suffix";
    public static final String VIEW_INSTANCE_VERSION = "ViewUrlInfo/view_instance_version";
    public static final String VIEW_INSTANCE_NAME = "ViewUrlInfo/view_instance_name";
    public static final String VIEW_INSTANCE_COMMON_NAME = "ViewUrlInfo/view_instance_common_name";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.ViewURL, (Object)"ViewUrlInfo/url_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ViewUrlInfo/url_name", "ViewUrlInfo/url_suffix", "ViewUrlInfo/view_instance_version", "ViewUrlInfo/view_instance_name", "ViewUrlInfo/view_instance_common_name"});
    @Inject
    private static ViewURLDAO viewURLDAO;

    public ViewURLResourceProvider() {
        super(Resource.Type.ViewURL, propertyIds, keyPropertyIds);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_VIEWS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(this.getCreateCommand(properties));
        }
        this.notifyCreate(Resource.Type.ViewURL, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet resources = Sets.newHashSet();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            String urlNameProperty = (String)propertyMap.get(URL_NAME);
            if (!Strings.isNullOrEmpty((String)urlNameProperty)) {
                Optional<ViewURLEntity> urlEntity = viewURLDAO.findByName(urlNameProperty);
                if (!urlEntity.isPresent()) continue;
                resources.add(this.toResource((ViewURLEntity)urlEntity.get()));
                continue;
            }
            List<ViewURLEntity> urlEntities = viewURLDAO.findAll();
            for (ViewURLEntity urlEntity : urlEntities) {
                resources.add(this.toResource(urlEntity));
            }
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                this.modifyResources(this.getUpdateCommand(propertyMap));
            }
        }
        this.notifyUpdate(Resource.Type.ViewInstance, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getDeleteCommand(predicate));
        this.notifyDelete(Resource.Type.ViewInstance, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected Resource toResource(ViewURLEntity viewURLEntity) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.ViewURL);
        resource.setProperty(URL_NAME, viewURLEntity.getUrlName());
        resource.setProperty(URL_SUFFIX, viewURLEntity.getUrlSuffix());
        ViewInstanceEntity viewInstanceEntity = viewURLEntity.getViewInstanceEntity();
        if (viewInstanceEntity == null) {
            return resource;
        }
        ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
        String viewName = viewEntity.getCommonName();
        String version = viewEntity.getVersion();
        String name = viewInstanceEntity.getName();
        resource.setProperty(VIEW_INSTANCE_NAME, name);
        resource.setProperty(VIEW_INSTANCE_VERSION, version);
        resource.setProperty(VIEW_INSTANCE_COMMON_NAME, viewName);
        return resource;
    }

    private ViewURLEntity toEntity(Map<String, Object> properties) throws OBDPException {
        String name = (String)properties.get(URL_NAME);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The View URL is a required property.");
        }
        String suffix = (String)properties.get(URL_SUFFIX);
        String commonName = (String)properties.get(VIEW_INSTANCE_COMMON_NAME);
        String instanceName = (String)properties.get(VIEW_INSTANCE_NAME);
        String instanceVersion = (String)properties.get(VIEW_INSTANCE_VERSION);
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        ViewInstanceEntity instanceEntity = viewRegistry.getInstanceDefinition(commonName, instanceVersion, instanceName);
        ViewURLEntity urlEntity = new ViewURLEntity();
        urlEntity.setUrlName(name);
        urlEntity.setUrlSuffix(suffix);
        urlEntity.setViewInstanceEntity(instanceEntity);
        return urlEntity;
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                String version;
                ViewURLEntity urlEntity;
                ViewInstanceEntity viewInstanceEntity;
                ViewEntity viewEntity;
                String viewName;
                ViewRegistry viewRegistry = ViewRegistry.getInstance();
                ViewEntity view = viewRegistry.getDefinition(viewName = (viewEntity = (viewInstanceEntity = (urlEntity = ViewURLResourceProvider.this.toEntity(properties)).getViewInstanceEntity()).getViewEntity()).getCommonName(), version = viewEntity.getVersion());
                if (view == null) {
                    throw new IllegalStateException("The view " + viewName + " is not registered.");
                }
                if (!view.isDeployed()) {
                    throw new IllegalStateException("The view " + viewName + " is not loaded.");
                }
                if (viewInstanceEntity.getViewUrl() != null) {
                    throw new OBDPException("The view instance selected already has a linked URL");
                }
                if (viewURLDAO.findByName(urlEntity.getUrlName()).isPresent()) {
                    throw new OBDPException("This view URL name exists, URL names should be unique");
                }
                if (viewURLDAO.findBySuffix(urlEntity.getUrlSuffix()).isPresent()) {
                    throw new OBDPException("This view URL suffix has already been recorded, URL suffixes should be unique");
                }
                viewURLDAO.save(urlEntity);
                viewInstanceEntity.setViewUrl(urlEntity);
                try {
                    viewRegistry.updateViewInstance(viewInstanceEntity);
                }
                catch (ValidationException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                catch (id.onyx.obdp.view.SystemException e) {
                    throw new OBDPException("Caught exception trying to update view URL.", (Throwable)e);
                }
                viewRegistry.updateView(viewInstanceEntity);
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getUpdateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ViewRegistry registry = ViewRegistry.getInstance();
                String name = (String)properties.get(ViewURLResourceProvider.URL_NAME);
                String suffix = (String)properties.get(ViewURLResourceProvider.URL_SUFFIX);
                Optional<ViewURLEntity> entity = viewURLDAO.findByName(name);
                if (!entity.isPresent()) {
                    throw new OBDPException("URL with name " + name + "was not found");
                }
                ((ViewURLEntity)entity.get()).setUrlSuffix(suffix);
                viewURLDAO.update((ViewURLEntity)entity.get());
                ViewInstanceEntity viewInstanceEntity = ((ViewURLEntity)entity.get()).getViewInstanceEntity();
                try {
                    registry.updateViewInstance(viewInstanceEntity);
                }
                catch (ValidationException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                catch (id.onyx.obdp.view.SystemException e) {
                    throw new OBDPException("Caught exception trying to update view URL.", (Throwable)e);
                }
                registry.updateView(viewInstanceEntity);
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ViewRegistry viewRegistry = ViewRegistry.getInstance();
                Comparable deletedUrl = ((EqualsPredicate)predicate).getValue();
                String toDelete = deletedUrl.toString();
                Optional<ViewURLEntity> urlEntity = viewURLDAO.findByName(toDelete);
                if (!urlEntity.isPresent()) {
                    throw new OBDPException("The URL " + toDelete + "does not exist");
                }
                ViewInstanceEntity viewInstanceEntity = ((ViewURLEntity)urlEntity.get()).getViewInstanceEntity();
                if (viewInstanceEntity != null) {
                    viewInstanceEntity.clearUrl();
                    try {
                        viewRegistry.updateViewInstance(viewInstanceEntity);
                    }
                    catch (ValidationException e) {
                        throw new IllegalArgumentException(e.getMessage(), e);
                    }
                    catch (id.onyx.obdp.view.SystemException e) {
                        throw new OBDPException("Caught exception trying to update view URL.", (Throwable)e);
                    }
                    viewRegistry.updateView(viewInstanceEntity);
                }
                ((ViewURLEntity)urlEntity.get()).clearEntity();
                viewURLDAO.delete((ViewURLEntity)urlEntity.get());
                return null;
            }
        };
    }
}

