/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.ViewRegistry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String VIEW_INFO = "ViewInfo";
    public static final String VIEW_NAME_PROPERTY_ID = "view_name";
    public static final String VIEW_NAME = "ViewInfo/view_name";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.View, (Object)"ViewInfo/view_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ViewInfo/view_name"});

    public ViewResourceProvider() {
        super(Resource.Type.View, propertyIds, keyPropertyIds);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_VIEWS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            propertyMaps.add(Collections.emptyMap());
        }
        for (Map<String, Object> propertyMap : propertyMaps) {
            String viewName = (String)propertyMap.get(VIEW_NAME);
            for (ViewEntity viewDefinition : viewRegistry.getDefinitions()) {
                if (viewName != null && !viewName.equals(viewDefinition.getCommonName()) || !viewRegistry.includeDefinition(viewDefinition)) continue;
                ResourceImpl resource = new ResourceImpl(Resource.Type.View);
                ViewResourceProvider.setResourceProperty(resource, VIEW_NAME, viewDefinition.getCommonName(), requestedIds);
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

