/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.PrivilegeResourceProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.ResourceEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.ViewRegistry;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewPrivilegeResourceProvider
extends PrivilegeResourceProvider<ViewInstanceEntity> {
    public static final String VIEW_NAME_PROPERTY_ID = "view_name";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String INSTANCE_NAME_PROPERTY_ID = "instance_name";
    public static final String VIEW_NAME = "PrivilegeInfo/view_name";
    public static final String VERSION = "PrivilegeInfo/version";
    public static final String INSTANCE_NAME = "PrivilegeInfo/instance_name";
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"PrivilegeInfo/view_name", "PrivilegeInfo/version", "PrivilegeInfo/instance_name", "PrivilegeInfo/privilege_id", "PrivilegeInfo/permission_name", "PrivilegeInfo/permission_label", "PrivilegeInfo/principal_name", "PrivilegeInfo/principal_type"});
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.View, (Object)"PrivilegeInfo/view_name").put((Object)Resource.Type.ViewVersion, (Object)"PrivilegeInfo/version").put((Object)Resource.Type.ViewInstance, (Object)"PrivilegeInfo/instance_name").put((Object)Resource.Type.ViewPrivilege, (Object)"PrivilegeInfo/privilege_id").build();
    private final PermissionEntity viewUsePermission = permissionDAO.findById(4);

    public ViewPrivilegeResourceProvider() {
        super(propertyIds, keyPropertyIds, Resource.Type.ViewPrivilege);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_VIEWS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    public Map<Long, ViewInstanceEntity> getResourceEntities(Map<String, Object> properties) throws OBDPException {
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        String viewName = (String)properties.get(VIEW_NAME);
        String viewVersion = (String)properties.get(VERSION);
        String instanceName = (String)properties.get(INSTANCE_NAME);
        if (viewName != null && viewVersion != null && instanceName != null) {
            ViewInstanceEntity viewInstanceEntity = viewRegistry.getInstanceDefinition(viewName, viewVersion, instanceName);
            if (viewInstanceEntity == null) {
                throw new OBDPException("View instance " + instanceName + " of " + viewName + viewVersion + " was not found");
            }
            ViewEntity view = viewInstanceEntity.getViewEntity();
            return view.isDeployed() ? Collections.singletonMap(viewInstanceEntity.getResource().getId(), viewInstanceEntity) : Collections.emptyMap();
        }
        HashSet<Object> viewEntities = new HashSet<Object>();
        if (viewVersion != null) {
            ViewEntity viewEntity = viewRegistry.getDefinition(viewName, viewVersion);
            if (viewEntity != null) {
                viewEntities.add(viewEntity);
            }
        } else {
            for (ViewEntity viewEntity : viewRegistry.getDefinitions()) {
                if (viewName != null && !viewEntity.getCommonName().equals(viewName)) continue;
                viewEntities.add(viewEntity);
            }
        }
        HashMap<Long, ViewInstanceEntity> resourceEntities = new HashMap<Long, ViewInstanceEntity>();
        for (ViewEntity viewEntity : viewEntities) {
            if (!viewEntity.isDeployed()) continue;
            for (ViewInstanceEntity viewInstanceEntity : viewEntity.getInstances()) {
                resourceEntities.put(viewInstanceEntity.getResource().getId(), viewInstanceEntity);
            }
        }
        return resourceEntities;
    }

    @Override
    public Long getResourceEntityId(Predicate predicate) {
        String instanceName;
        String viewVersion;
        String viewName;
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        ViewInstanceEntity viewInstanceEntity = viewRegistry.getInstanceDefinition(viewName = ViewPrivilegeResourceProvider.getQueryParameterValue(VIEW_NAME, predicate).toString(), viewVersion = ViewPrivilegeResourceProvider.getQueryParameterValue(VERSION, predicate).toString(), instanceName = ViewPrivilegeResourceProvider.getQueryParameterValue(INSTANCE_NAME, predicate).toString());
        if (viewInstanceEntity != null) {
            ViewEntity view = viewInstanceEntity.getViewEntity();
            return view.isDeployed() ? viewInstanceEntity.getResource().getId() : null;
        }
        return null;
    }

    @Override
    protected boolean checkResourceTypes(PrivilegeEntity entity) throws OBDPException {
        return super.checkResourceTypes(entity) || entity.getPermission().getResourceType().getId().equals(ResourceType.VIEW.getId());
    }

    @Override
    protected Resource toResource(PrivilegeEntity privilegeEntity, Map<Long, UserEntity> userEntities, Map<Long, GroupEntity> groupEntities, Map<Long, PermissionEntity> roleEntities, Map<Long, ViewInstanceEntity> resourceEntities, Set<String> requestedIds) {
        Resource resource = super.toResource(privilegeEntity, userEntities, groupEntities, roleEntities, resourceEntities, requestedIds);
        if (resource != null) {
            ViewInstanceEntity viewInstanceEntity = resourceEntities.get(privilegeEntity.getResource().getId());
            ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
            if (!viewEntity.isDeployed()) {
                return null;
            }
            ViewPrivilegeResourceProvider.setResourceProperty(resource, VIEW_NAME, viewEntity.getCommonName(), requestedIds);
            ViewPrivilegeResourceProvider.setResourceProperty(resource, VERSION, viewEntity.getVersion(), requestedIds);
            ViewPrivilegeResourceProvider.setResourceProperty(resource, INSTANCE_NAME, viewInstanceEntity.getName(), requestedIds);
        }
        return resource;
    }

    @Override
    protected PermissionEntity getPermission(String permissionName, ResourceEntity resourceEntity) throws OBDPException {
        return permissionName.equals("VIEW.USER") ? this.viewUsePermission : super.getPermission(permissionName, resourceEntity);
    }
}

