/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.ViewPermissionResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.view.ViewRegistry;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ViewPermissionResourceProvider
extends AbstractResourceProvider {
    private static PermissionDAO permissionDAO;
    public static final String PERMISSION_INFO = "PermissionInfo";
    public static final String VIEW_NAME_PROPERTY_ID = "view_name";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String PERMISSION_ID_PROPERTY_ID = "permission_id";
    public static final String PERMISSION_NAME_PROPERTY_ID = "permission_name";
    public static final String RESOURCE_NAME_PROPERTY_ID = "resource_name";
    public static final String VIEW_NAME = "PermissionInfo/view_name";
    public static final String VERSION = "PermissionInfo/version";
    public static final String PERMISSION_ID = "PermissionInfo/permission_id";
    public static final String PERMISSION_NAME = "PermissionInfo/permission_name";
    public static final String RESOURCE_NAME = "PermissionInfo/resource_name";
    private static final Map<Resource.Type, String> keyPropertyIds;
    private static final Set<String> propertyIds;

    public ViewPermissionResourceProvider() {
        super(propertyIds, keyPropertyIds);
    }

    public static void init(PermissionDAO dao) {
        permissionDAO = dao;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        PermissionEntity viewUsePermission = permissionDAO.findViewUsePermission();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            ViewEntity viewEntity;
            Object viewName = propertyMap.get(VIEW_NAME);
            Object viewVersion = propertyMap.get(VERSION);
            if (viewName == null || viewVersion == null || !(viewEntity = viewRegistry.getDefinition(viewName.toString(), viewVersion.toString())).isDeployed()) continue;
            ViewPermissionResponse viewPermissionResponse = this.getResponse(viewUsePermission, viewEntity.getResourceType(), viewEntity);
            resources.add(this.toResource(viewPermissionResponse, requestedIds));
        }
        for (PermissionEntity permissionEntity : permissionDAO.findAll()) {
            ResourceTypeEntity resourceType = permissionEntity.getResourceType();
            ViewEntity viewEntity = viewRegistry.getDefinition(resourceType);
            if (viewEntity == null || !viewEntity.isDeployed()) continue;
            ViewPermissionResponse viewPermissionResponse = this.getResponse(permissionEntity, resourceType, viewEntity);
            resources.add(this.toResource(viewPermissionResponse, requestedIds));
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private ViewPermissionResponse getResponse(PermissionEntity entity, ResourceTypeEntity resourceType, ViewEntity viewEntity) {
        String viewName = viewEntity.getCommonName();
        String version = viewEntity.getVersion();
        Integer permissionId = entity.getId();
        String permissionName = entity.getPermissionName();
        String resourceName = resourceType.getName();
        ViewPermissionResponse.ViewPermissionInfo viewPermissionInfo = new ViewPermissionResponse.ViewPermissionInfo(viewName, version, permissionId, permissionName, resourceName);
        return new ViewPermissionResponse(viewPermissionInfo);
    }

    private Resource toResource(ViewPermissionResponse viewPermissionResponse, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.ViewPermission);
        ViewPermissionResponse.ViewPermissionInfo viewPermissionInfo = viewPermissionResponse.getViewPermissionInfo();
        ViewPermissionResourceProvider.setResourceProperty(resource, VIEW_NAME, viewPermissionInfo.getViewName(), requestedIds);
        ViewPermissionResourceProvider.setResourceProperty(resource, VERSION, viewPermissionInfo.getVersion(), requestedIds);
        ViewPermissionResourceProvider.setResourceProperty(resource, PERMISSION_ID, viewPermissionInfo.getPermissionId(), requestedIds);
        ViewPermissionResourceProvider.setResourceProperty(resource, PERMISSION_NAME, viewPermissionInfo.getPermissionName(), requestedIds);
        ViewPermissionResourceProvider.setResourceProperty(resource, RESOURCE_NAME, viewPermissionInfo.getResourceName(), requestedIds);
        return resource;
    }

    static {
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.View, (Object)VIEW_NAME).put((Object)Resource.Type.ViewVersion, (Object)VERSION).put((Object)Resource.Type.ViewPermission, (Object)PERMISSION_ID).build();
        propertyIds = Sets.newHashSet((Object[])new String[]{VIEW_NAME, VERSION, PERMISSION_ID, PERMISSION_NAME, RESOURCE_NAME});
    }
}

