/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceDataEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.orm.entities.ViewURLEntity;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.view.ViewRegistry;
import id.onyx.obdp.server.view.validation.InstanceValidationResultImpl;
import id.onyx.obdp.server.view.validation.ValidationException;
import id.onyx.obdp.server.view.validation.ValidationResultImpl;
import id.onyx.obdp.view.ClusterType;
import id.onyx.obdp.view.validation.Validator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ViewInstanceResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String VIEW_INSTANCE_INFO = "ViewInstanceInfo";
    public static final String VIEW_NAME_PROPERTY_ID = "view_name";
    public static final String VERSION_PROPERTY_ID = "version";
    public static final String INSTANCE_NAME_PROPERTY_ID = "instance_name";
    public static final String LABEL_PROPERTY_ID = "label";
    public static final String DESCRIPTION_PROPERTY_ID = "description";
    public static final String VISIBLE_PROPERTY_ID = "visible";
    public static final String ICON_PATH_PROPERTY_ID = "icon_path";
    public static final String ICON64_PATH_PROPERTY_ID = "icon64_path";
    public static final String PROPERTIES_PROPERTY_ID = "properties";
    public static final String INSTANCE_DATA_PROPERTY_ID = "instance_data";
    public static final String CONTEXT_PATH_PROPERTY_ID = "context_path";
    public static final String STATIC_PROPERTY_ID = "static";
    public static final String CLUSTER_HANDLE_PROPERTY_ID = "cluster_handle";
    public static final String CLUSTER_TYPE_PROPERTY_ID = "cluster_type";
    public static final String SHORT_URL_PROPERTY_ID = "short_url";
    public static final String SHORT_URL_NAME_PROPERTY_ID = "short_url_name";
    public static final String VALIDATION_RESULT_PROPERTY_ID = "validation_result";
    public static final String PROPERTY_VALIDATION_RESULTS_PROPERTY_ID = "property_validation_results";
    public static final String VIEW_NAME = "ViewInstanceInfo/view_name";
    public static final String VERSION = "ViewInstanceInfo/version";
    public static final String INSTANCE_NAME = "ViewInstanceInfo/instance_name";
    public static final String LABEL = "ViewInstanceInfo/label";
    public static final String DESCRIPTION = "ViewInstanceInfo/description";
    public static final String VISIBLE = "ViewInstanceInfo/visible";
    public static final String ICON_PATH = "ViewInstanceInfo/icon_path";
    public static final String ICON64_PATH = "ViewInstanceInfo/icon64_path";
    public static final String PROPERTIES = "ViewInstanceInfo/properties";
    public static final String INSTANCE_DATA = "ViewInstanceInfo/instance_data";
    public static final String CONTEXT_PATH = "ViewInstanceInfo/context_path";
    public static final String STATIC = "ViewInstanceInfo/static";
    public static final String CLUSTER_HANDLE = "ViewInstanceInfo/cluster_handle";
    public static final String CLUSTER_TYPE = "ViewInstanceInfo/cluster_type";
    public static final String SHORT_URL = "ViewInstanceInfo/short_url";
    public static final String SHORT_URL_NAME = "ViewInstanceInfo/short_url_name";
    public static final String VALIDATION_RESULT = "ViewInstanceInfo/validation_result";
    public static final String PROPERTY_VALIDATION_RESULTS = "ViewInstanceInfo/property_validation_results";
    private static final String PROPERTIES_PREFIX = "ViewInstanceInfo/properties/";
    private static final String DATA_PREFIX = "ViewInstanceInfo/instance_data/";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.View, (Object)"ViewInstanceInfo/view_name").put((Object)Resource.Type.ViewVersion, (Object)"ViewInstanceInfo/version").put((Object)Resource.Type.ViewInstance, (Object)"ViewInstanceInfo/instance_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"ViewInstanceInfo/view_name", "ViewInstanceInfo/version", "ViewInstanceInfo/instance_name", "ViewInstanceInfo/label", "ViewInstanceInfo/description", "ViewInstanceInfo/visible", "ViewInstanceInfo/icon_path", "ViewInstanceInfo/icon64_path", "ViewInstanceInfo/properties", "ViewInstanceInfo/instance_data", "ViewInstanceInfo/context_path", "ViewInstanceInfo/static", "ViewInstanceInfo/cluster_handle", "ViewInstanceInfo/cluster_type", "ViewInstanceInfo/short_url", "ViewInstanceInfo/short_url_name", "ViewInstanceInfo/validation_result", "ViewInstanceInfo/property_validation_results"});

    @Inject
    public ViewInstanceResourceProvider() {
        super(Resource.Type.ViewInstance, propertyIds, keyPropertyIds);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_VIEWS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        for (Map<String, Object> properties : request.getProperties()) {
            this.createResources(this.getCreateCommand(properties));
        }
        this.notifyCreate(Resource.Type.ViewInstance, request);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            propertyMaps.add(Collections.emptyMap());
        }
        for (Map<String, Object> propertyMap : propertyMaps) {
            String viewName = (String)propertyMap.get(VIEW_NAME);
            String viewVersion = (String)propertyMap.get(VERSION);
            String instanceName = (String)propertyMap.get(INSTANCE_NAME);
            for (ViewEntity viewDefinition : viewRegistry.getDefinitions()) {
                if (!viewDefinition.isDeployed() || viewName != null && !viewName.equals(viewDefinition.getCommonName())) continue;
                for (ViewInstanceEntity viewInstanceDefinition : viewRegistry.getInstanceDefinitions(viewDefinition)) {
                    if (instanceName != null && !instanceName.equals(viewInstanceDefinition.getName()) || viewVersion != null && !viewVersion.equals(viewDefinition.getVersion()) || !this.includeInstance(viewInstanceDefinition, true)) continue;
                    Resource resource = this.toResource(viewInstanceDefinition, requestedIds);
                    resources.add(resource);
                }
            }
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                this.modifyResources(this.getUpdateCommand(propertyMap));
            }
        }
        this.notifyUpdate(Resource.Type.ViewInstance, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        this.modifyResources(this.getDeleteCommand(predicate));
        this.notifyDelete(Resource.Type.ViewInstance, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected Resource toResource(ViewInstanceEntity viewInstanceEntity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.ViewInstance);
        ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
        String viewName = viewEntity.getCommonName();
        String version = viewEntity.getVersion();
        String name = viewInstanceEntity.getName();
        ViewInstanceResourceProvider.setResourceProperty(resource, VIEW_NAME, viewName, requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, VERSION, version, requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, INSTANCE_NAME, name, requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, LABEL, viewInstanceEntity.getLabel(), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, DESCRIPTION, viewInstanceEntity.getDescription(), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, VISIBLE, viewInstanceEntity.isVisible(), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, STATIC, viewInstanceEntity.isXmlDriven(), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, CLUSTER_HANDLE, viewInstanceEntity.getClusterHandle(), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, CLUSTER_TYPE, viewInstanceEntity.getClusterType(), requestedIds);
        ViewURLEntity viewUrl = viewInstanceEntity.getViewUrl();
        if (viewUrl != null) {
            ViewInstanceResourceProvider.setResourceProperty(resource, SHORT_URL, viewUrl.getUrlSuffix(), requestedIds);
            ViewInstanceResourceProvider.setResourceProperty(resource, SHORT_URL_NAME, viewUrl.getUrlName(), requestedIds);
        }
        if (ViewRegistry.getInstance().checkAdmin()) {
            ViewInstanceResourceProvider.setResourceProperty(resource, PROPERTIES, viewInstanceEntity.getPropertyMap(), requestedIds);
        }
        HashMap<String, String> applicationData = new HashMap<String, String>();
        String currentUserName = viewInstanceEntity.getCurrentUserName();
        for (ViewInstanceDataEntity viewInstanceDataEntity : viewInstanceEntity.getData()) {
            if (!currentUserName.equals(viewInstanceDataEntity.getUser())) continue;
            applicationData.put(viewInstanceDataEntity.getName(), viewInstanceDataEntity.getValue());
        }
        ViewInstanceResourceProvider.setResourceProperty(resource, INSTANCE_DATA, applicationData, requestedIds);
        String contextPath = ViewInstanceEntity.getContextPath(viewName, version, name);
        ViewInstanceResourceProvider.setResourceProperty(resource, CONTEXT_PATH, contextPath, requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, ICON_PATH, ViewInstanceResourceProvider.getIconPath(contextPath, viewInstanceEntity.getIcon()), requestedIds);
        ViewInstanceResourceProvider.setResourceProperty(resource, ICON64_PATH, ViewInstanceResourceProvider.getIconPath(contextPath, viewInstanceEntity.getIcon64()), requestedIds);
        if (viewEntity.hasValidator() && (ViewInstanceResourceProvider.isPropertyRequested(VALIDATION_RESULT, requestedIds) || ViewInstanceResourceProvider.isPropertyRequested(PROPERTY_VALIDATION_RESULTS, requestedIds))) {
            InstanceValidationResultImpl result = viewInstanceEntity.getValidationResult(viewEntity, Validator.ValidationContext.EXISTING);
            ViewInstanceResourceProvider.setResourceProperty(resource, VALIDATION_RESULT, ValidationResultImpl.create(result), requestedIds);
            ViewInstanceResourceProvider.setResourceProperty(resource, PROPERTY_VALIDATION_RESULTS, result.getPropertyResults(), requestedIds);
        }
        return resource;
    }

    private ViewInstanceEntity toEntity(Map<String, Object> properties, boolean update) throws OBDPException {
        String visible;
        String name = (String)properties.get(INSTANCE_NAME);
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("View instance name must be provided");
        }
        String version = (String)properties.get(VERSION);
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("View version must be provided");
        }
        String commonViewName = (String)properties.get(VIEW_NAME);
        if (commonViewName == null || commonViewName.isEmpty()) {
            throw new IllegalArgumentException("View name must be provided");
        }
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        ViewEntity viewEntity = viewRegistry.getDefinition(commonViewName, version);
        String viewName = ViewEntity.getViewName(commonViewName, version);
        if (viewEntity == null) {
            throw new IllegalArgumentException("View name " + viewName + " does not exist.");
        }
        ViewInstanceEntity viewInstanceEntity = null;
        if (update) {
            viewInstanceEntity = viewRegistry.getViewInstanceEntity(viewName, name);
        }
        if (viewInstanceEntity == null) {
            viewInstanceEntity = new ViewInstanceEntity();
            viewInstanceEntity.setName(name);
            viewInstanceEntity.setViewName(viewName);
            viewInstanceEntity.setViewEntity(viewEntity);
        }
        if (properties.containsKey(LABEL)) {
            viewInstanceEntity.setLabel((String)properties.get(LABEL));
        }
        if (properties.containsKey(DESCRIPTION)) {
            viewInstanceEntity.setDescription((String)properties.get(DESCRIPTION));
        }
        viewInstanceEntity.setVisible((visible = (String)properties.get(VISIBLE)) == null ? true : Boolean.valueOf(visible));
        if (properties.containsKey(ICON_PATH)) {
            viewInstanceEntity.setIcon((String)properties.get(ICON_PATH));
        }
        if (properties.containsKey(ICON64_PATH)) {
            viewInstanceEntity.setIcon64((String)properties.get(ICON64_PATH));
        }
        if (properties.containsKey(CLUSTER_HANDLE)) {
            String handle = (String)properties.get(CLUSTER_HANDLE);
            if (handle != null) {
                viewInstanceEntity.setClusterHandle(Long.valueOf(handle));
            } else {
                viewInstanceEntity.setClusterHandle(null);
            }
        }
        if (properties.containsKey(CLUSTER_TYPE)) {
            String clusterType = (String)properties.get(CLUSTER_TYPE);
            viewInstanceEntity.setClusterType(ClusterType.valueOf((String)clusterType));
        }
        HashMap<String, String> instanceProperties = new HashMap<String, String>();
        boolean isUserAdmin = viewRegistry.checkAdmin();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            if (propertyName.startsWith(PROPERTIES_PREFIX)) {
                if (!isUserAdmin) continue;
                instanceProperties.put(entry.getKey().substring(PROPERTIES_PREFIX.length()), (String)entry.getValue());
                continue;
            }
            if (!propertyName.startsWith(DATA_PREFIX)) continue;
            viewInstanceEntity.putInstanceData(entry.getKey().substring(DATA_PREFIX.length()), (String)entry.getValue());
        }
        if (!instanceProperties.isEmpty()) {
            try {
                viewRegistry.setViewInstanceProperties(viewInstanceEntity, instanceProperties, viewEntity.getConfiguration(), viewEntity.getClassLoader());
            }
            catch (id.onyx.obdp.view.SystemException e) {
                throw new OBDPException("Caught exception trying to set view properties.", (Throwable)e);
            }
        }
        return viewInstanceEntity;
    }

    private AbstractResourceProvider.Command<Void> getCreateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ViewInstanceResourceProvider.this.create(properties);
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getUpdateCommand(final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ViewInstanceResourceProvider.this.update(properties);
                return null;
            }
        };
    }

    private AbstractResourceProvider.Command<Void> getDeleteCommand(final Predicate predicate) {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                ViewInstanceResourceProvider.this.delete(predicate);
                return null;
            }
        };
    }

    @Transactional
    void create(Map<String, Object> properties) throws OBDPException {
        try {
            ViewRegistry viewRegistry = ViewRegistry.getInstance();
            ViewInstanceEntity instanceEntity = this.toEntity(properties, false);
            ViewEntity viewEntity = instanceEntity.getViewEntity();
            String viewName = viewEntity.getCommonName();
            String version = viewEntity.getVersion();
            ViewEntity view = viewRegistry.getDefinition(viewName, version);
            if (view == null) {
                throw new IllegalStateException("The view " + viewName + " is not registered.");
            }
            if (!view.isDeployed()) {
                throw new IllegalStateException("The view " + viewName + " is not loaded.");
            }
            if (viewRegistry.instanceExists(instanceEntity)) {
                throw new DuplicateResourceException("The instance " + instanceEntity.getName() + " already exists.");
            }
            viewRegistry.installViewInstance(instanceEntity);
        }
        catch (id.onyx.obdp.view.SystemException e) {
            throw new OBDPException("Caught exception trying to create view instance.", (Throwable)e);
        }
        catch (ValidationException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Transactional
    void update(Map<String, Object> properties) throws OBDPException {
        ViewInstanceEntity instance = this.toEntity(properties, true);
        ViewEntity view = instance.getViewEntity();
        if (this.includeInstance(view.getCommonName(), view.getVersion(), instance.getInstanceName(), false)) {
            try {
                ViewRegistry.getInstance().updateViewInstance(instance);
                ViewRegistry.getInstance().updateView(instance);
            }
            catch (id.onyx.obdp.view.SystemException e) {
                throw new OBDPException("Caught exception trying to update view instance.", (Throwable)e);
            }
            catch (ValidationException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    @Transactional
    void delete(Predicate predicate) {
        Set<String> requestedIds = this.getRequestPropertyIds(PropertyHelper.getReadRequest(new String[0]), predicate);
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        HashSet<ViewInstanceEntity> viewInstanceEntities = new HashSet<ViewInstanceEntity>();
        for (ViewEntity viewEntity : viewRegistry.getDefinitions()) {
            if (!viewEntity.isDeployed()) continue;
            for (ViewInstanceEntity viewInstanceEntity : viewRegistry.getInstanceDefinitions(viewEntity)) {
                Resource resource = this.toResource(viewInstanceEntity, requestedIds);
                if (predicate != null && !predicate.evaluate(resource) || !this.includeInstance(viewInstanceEntity, false)) continue;
                viewInstanceEntities.add(viewInstanceEntity);
            }
        }
        for (ViewInstanceEntity viewInstanceEntity : viewInstanceEntities) {
            viewRegistry.uninstallViewInstance(viewInstanceEntity);
        }
    }

    private static String getIconPath(String contextPath, String iconPath) {
        return iconPath == null || iconPath.length() == 0 ? null : contextPath + (iconPath.startsWith("/") ? "" : "/") + iconPath;
    }

    private boolean includeInstance(String viewName, String version, String instanceName, boolean readOnly) {
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        return viewRegistry.checkPermission(viewName, version, instanceName, readOnly);
    }

    private boolean includeInstance(ViewInstanceEntity instanceEntity, boolean readOnly) {
        ViewRegistry viewRegistry = ViewRegistry.getInstance();
        return viewRegistry.checkPermission(instanceEntity, readOnly);
    }
}

