/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.resources.OperatingSystemResourceDefinition;
import id.onyx.obdp.server.api.resources.RepositoryResourceDefinition;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.OperatingSystemResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryResourceProvider;
import id.onyx.obdp.server.controller.internal.RepositoryVersionResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.URLRedirectProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.RepoDefinitionEntity;
import id.onyx.obdp.server.orm.entities.RepoOsEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.stack.RepoUtil;
import id.onyx.obdp.server.stack.upgrade.RepositoryVersionHelper;
import id.onyx.obdp.server.state.RepositoryInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.repository.VersionDefinitionXml;
import id.onyx.obdp.server.state.stack.RepoTag;
import id.onyx.obdp.spi.RepositoryType;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class VersionDefinitionResourceProvider
extends AbstractAuthorizedResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(VersionDefinitionResourceProvider.class);
    public static final String VERSION_DEF = "VersionDefinition";
    public static final String VERSION_DEF_BASE64_PROPERTY = "version_base64";
    public static final String VERSION_DEF_STACK_NAME = "VersionDefinition/stack_name";
    public static final String VERSION_DEF_STACK_VERSION = "VersionDefinition/stack_version";
    public static final String VERSION_DEF_ID = "VersionDefinition/id";
    protected static final String VERSION_DEF_TYPE_PROPERTY_ID = "VersionDefinition/type";
    protected static final String VERSION_DEF_DEFINITION_URL = "VersionDefinition/version_url";
    public static final String VERSION_DEF_AVAILABLE_DEFINITION = "VersionDefinition/available";
    protected static final String VERSION_DEF_DEFINITION_BASE64 = PropertyHelper.getPropertyId("VersionDefinition", "version_base64");
    protected static final String VERSION_DEF_FULL_VERSION = "VersionDefinition/repository_version";
    protected static final String VERSION_DEF_RELEASE_VERSION = "VersionDefinition/release/version";
    protected static final String VERSION_DEF_RELEASE_BUILD = "VersionDefinition/release/build";
    protected static final String VERSION_DEF_RELEASE_NOTES = "VersionDefinition/release/notes";
    protected static final String VERSION_DEF_RELEASE_COMPATIBLE_WITH = "VersionDefinition/release/compatible_with";
    protected static final String VERSION_DEF_AVAILABLE_SERVICES = "VersionDefinition/services";
    protected static final String VERSION_DEF_STACK_SERVICES = "VersionDefinition/stack_services";
    protected static final String VERSION_DEF_STACK_DEFAULT = "VersionDefinition/stack_default";
    protected static final String VERSION_DEF_STACK_REPO_UPDATE_LINK_EXISTS = "VersionDefinition/stack_repo_update_link_exists";
    protected static final String VERSION_DEF_DISPLAY_NAME = "VersionDefinition/display_name";
    protected static final String VERSION_DEF_VALIDATION = "VersionDefinition/validation";
    protected static final String SHOW_AVAILABLE = "VersionDefinition/show_available";
    protected static final String VERSION_DEF_MIN_JDK = "VersionDefinition/min_jdk";
    protected static final String VERSION_DEF_MAX_JDK = "VersionDefinition/max_jdk";
    public static final String DIRECTIVE_SKIP_URL_CHECK = "skip_url_check";
    public static final String SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID = new OperatingSystemResourceDefinition().getPluralName();
    @Inject
    private static RepositoryVersionDAO s_repoVersionDAO;
    @Inject
    private static Provider<OBDPMetaInfo> s_metaInfo;
    @Inject
    private static Provider<RepositoryVersionHelper> s_repoVersionHelper;
    @Inject
    private static StackDAO s_stackDAO;
    @Inject
    private static Configuration s_configuration;
    private static final Set<String> PK_PROPERTY_IDS;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;

    VersionDefinitionResourceProvider() {
        super(Resource.Type.VersionDefinition, PROPERTY_IDS, KEY_PROPERTY_IDS);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS));
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_STACK_VERSIONS));
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Resource res;
        String err;
        Set<Map<String, Object>> requestProperties = request.getProperties();
        if (requestProperties.size() > 1) {
            throw new IllegalArgumentException("Cannot process more than one file per request");
        }
        Map<String, Object> properties = requestProperties.iterator().next();
        if (!(properties.containsKey(VERSION_DEF_DEFINITION_URL) || properties.containsKey(VERSION_DEF_DEFINITION_BASE64) || properties.containsKey(VERSION_DEF_AVAILABLE_DEFINITION))) {
            throw new IllegalArgumentException(String.format("Creation method is not known.  %s or %s is required or upload the file directly", VERSION_DEF_DEFINITION_URL, VERSION_DEF_AVAILABLE_DEFINITION));
        }
        if (properties.containsKey(VERSION_DEF_DEFINITION_URL) && properties.containsKey(VERSION_DEF_DEFINITION_BASE64)) {
            throw new IllegalArgumentException(String.format("Specify ONLY the url with %s or upload the file directly", VERSION_DEF_DEFINITION_URL));
        }
        final String definitionUrl = (String)properties.get(VERSION_DEF_DEFINITION_URL);
        final String definitionBase64 = (String)properties.get(VERSION_DEF_DEFINITION_BASE64);
        final String definitionName = (String)properties.get(VERSION_DEF_AVAILABLE_DEFINITION);
        final HashSet<String> validations = new HashSet<String>();
        final boolean dryRun = request.isDryRunRequest();
        final boolean skipUrlCheck = null != request.getRequestInfoProperties() ? BooleanUtils.toBoolean((String)request.getRequestInfoProperties().get(DIRECTIVE_SKIP_URL_CHECK)) : false;
        XmlHolder xmlHolder = this.createResources(new AbstractResourceProvider.Command<XmlHolder>(){

            @Override
            public XmlHolder invoke() throws OBDPException {
                XmlHolder holder = null;
                if (null != definitionUrl) {
                    holder = VersionDefinitionResourceProvider.this.loadXml(definitionUrl);
                } else if (null != definitionBase64) {
                    holder = VersionDefinitionResourceProvider.this.loadXml(Base64.decodeBase64((String)definitionBase64));
                } else if (null != definitionName) {
                    VersionDefinitionXml xml = ((OBDPMetaInfo)s_metaInfo.get()).getVersionDefinition(definitionName);
                    if (null == xml) {
                        throw new OBDPException(String.format("Version %s not found", definitionName));
                    }
                    holder = new XmlHolder();
                    holder.xml = xml;
                    try {
                        holder.xmlString = xml.toXml();
                    }
                    catch (Exception e) {
                        throw new OBDPException(String.format("The available repository %s does not serialize", definitionName), (Throwable)e);
                    }
                } else {
                    throw new OBDPException("Cannot determine creation method");
                }
                VersionDefinitionResourceProvider.this.toRepositoryVersionEntity(holder);
                try {
                    RepositoryVersionResourceProvider.validateRepositoryVersion(s_repoVersionDAO, (OBDPMetaInfo)s_metaInfo.get(), holder.entity, skipUrlCheck);
                }
                catch (OBDPException e) {
                    if (dryRun) {
                        validations.add(e.getMessage());
                    }
                    throw e;
                }
                VersionDefinitionResourceProvider.this.checkForParent(holder);
                return holder;
            }
        });
        if (StringUtils.isNotBlank((String)ObjectUtils.toString((Object)properties.get(VERSION_DEF_DISPLAY_NAME)))) {
            xmlHolder.xml.release.display = properties.get(VERSION_DEF_DISPLAY_NAME).toString();
            xmlHolder.entity.setDisplayName(properties.get(VERSION_DEF_DISPLAY_NAME).toString());
            xmlHolder.entity.setVersion(properties.get(VERSION_DEF_DISPLAY_NAME).toString());
        }
        if (s_repoVersionDAO.findByDisplayName(xmlHolder.entity.getDisplayName()) != null) {
            err = String.format("Repository version with name %s already exists.", xmlHolder.entity.getDisplayName());
            if (dryRun) {
                validations.add(err);
            } else {
                throw new ResourceAlreadyExistsException(err);
            }
        }
        if (s_repoVersionDAO.findByStackAndVersion(xmlHolder.entity.getStack(), xmlHolder.entity.getVersion()) != null) {
            err = String.format("Repository version for stack %s and version %s already exists.", xmlHolder.entity.getStackId(), xmlHolder.entity.getVersion());
            if (dryRun) {
                validations.add(err);
            } else {
                throw new ResourceAlreadyExistsException(err);
            }
        }
        if (dryRun) {
            HashSet ids = Sets.newHashSet((Object[])new String[]{VERSION_DEF_TYPE_PROPERTY_ID, VERSION_DEF_FULL_VERSION, VERSION_DEF_RELEASE_BUILD, VERSION_DEF_RELEASE_COMPATIBLE_WITH, VERSION_DEF_RELEASE_NOTES, VERSION_DEF_RELEASE_VERSION, VERSION_DEF_DISPLAY_NAME, VERSION_DEF_AVAILABLE_SERVICES, VERSION_DEF_VALIDATION, VERSION_DEF_MIN_JDK, VERSION_DEF_MAX_JDK, VERSION_DEF_STACK_SERVICES});
            res = this.toResource(null, xmlHolder.xml, ids, validations);
            if (null != definitionName) {
                res.setProperty(SHOW_AVAILABLE, true);
            }
            VersionDefinitionResourceProvider.setResourceProperty(res, VERSION_DEF_FULL_VERSION, xmlHolder.entity.getVersion(), ids);
            this.addSubresources(res, xmlHolder.entity);
        } else {
            s_repoVersionDAO.create(xmlHolder.entity);
            res = this.toResource(xmlHolder.entity, Collections.emptySet());
            this.notifyCreate(Resource.Type.VersionDefinition, request);
        }
        RequestStatusImpl status = new RequestStatusImpl(null, Collections.singleton(res));
        return status;
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> results = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            List<RepositoryVersionEntity> versions = s_repoVersionDAO.findRepositoriesWithVersionDefinitions();
            for (RepositoryVersionEntity entity : versions) {
                results.add(this.toResource(entity, requestPropertyIds));
            }
        } else {
            for (Map<String, Object> propertyMap : propertyMaps) {
                Resource res;
                if (propertyMap.containsKey(SHOW_AVAILABLE) && Boolean.parseBoolean(propertyMap.get(SHOW_AVAILABLE).toString())) {
                    for (Map.Entry<String, VersionDefinitionXml> entry : ((OBDPMetaInfo)s_metaInfo.get()).getVersionDefinitions().entrySet()) {
                        res = this.toResource(entry.getKey(), entry.getValue(), requestPropertyIds, null);
                        res.setProperty(SHOW_AVAILABLE, true);
                        results.add(res);
                    }
                    continue;
                }
                String id = (String)propertyMap.get(VERSION_DEF_ID);
                if (null != id) {
                    if (NumberUtils.isDigits((String)id)) {
                        RepositoryVersionEntity entity = (RepositoryVersionEntity)s_repoVersionDAO.findByPK(Long.parseLong(id));
                        if (null == entity) continue;
                        results.add(this.toResource(entity, requestPropertyIds));
                        continue;
                    }
                    VersionDefinitionXml xml = ((OBDPMetaInfo)s_metaInfo.get()).getVersionDefinition(id);
                    if (null == xml) {
                        throw new NoSuchResourceException(String.format("Could not find version %s", id));
                    }
                    res = this.toResource(id, xml, requestPropertyIds, null);
                    res.setProperty(SHOW_AVAILABLE, true);
                    results.add(res);
                    continue;
                }
                List<RepositoryVersionEntity> versions = s_repoVersionDAO.findRepositoriesWithVersionDefinitions();
                for (RepositoryVersionEntity entity : versions) {
                    results.add(this.toResource(entity, requestPropertyIds));
                }
            }
        }
        return results;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Cannot update Version Definitions");
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Cannot delete Version Definitions");
    }

    private void checkForParent(XmlHolder holder) throws OBDPException {
        RepositoryVersionEntity entity = holder.entity;
        if (entity.getType() == RepositoryType.STANDARD) {
            return;
        }
        List<RepositoryVersionEntity> entities = s_repoVersionDAO.findByStackAndType(entity.getStackId(), RepositoryType.STANDARD);
        if (entities.isEmpty()) {
            throw new IllegalArgumentException(String.format("Patch %s was uploaded, but there are no repositories for %s", entity.getVersion(), entity.getStackId().toString()));
        }
        ArrayList<RepositoryVersionEntity> matching = new ArrayList<RepositoryVersionEntity>();
        boolean emptyCompatible = StringUtils.isBlank((String)holder.xml.release.compatibleWith);
        for (RepositoryVersionEntity version : entities) {
            String baseVersion = version.getVersion();
            if (baseVersion.lastIndexOf(45) > -1) {
                baseVersion = baseVersion.substring(0, baseVersion.lastIndexOf(45));
            }
            if (emptyCompatible) {
                if (!baseVersion.equals(holder.xml.release.version)) continue;
                matching.add(version);
                continue;
            }
            if (!baseVersion.matches(holder.xml.release.compatibleWith)) continue;
            matching.add(version);
        }
        RepositoryVersionEntity parent = null;
        if (matching.isEmpty()) {
            String format = "No versions matched pattern %s";
            throw new IllegalArgumentException(String.format(format, emptyCompatible ? holder.xml.release.version : holder.xml.release.compatibleWith));
        }
        if (matching.size() > 1) {
            Function<RepositoryVersionEntity, String> function = new Function<RepositoryVersionEntity, String>(){

                public String apply(RepositoryVersionEntity input) {
                    return input.getVersion();
                }
            };
            Collection versions = Collections2.transform(matching, (Function)function);
            List<RepositoryVersionEntity> used = s_repoVersionDAO.findByServiceDesiredVersion(matching);
            if (used.isEmpty()) {
                throw new IllegalArgumentException(String.format("Could not determine which version to associate patch %s. Remove one of %s and try again.", entity.getVersion(), StringUtils.join((Collection)versions, (String)", ")));
            }
            if (used.size() > 1) {
                Collection usedVersions = Collections2.transform(used, (Function)function);
                throw new IllegalArgumentException(String.format("Patch %s was found to match more than one repository in use: %s. Move all services to a common version and try again.", entity.getVersion(), StringUtils.join((Collection)usedVersions, (String)", ")));
            }
            parent = used.get(0);
            LOG.warn("Patch {} was found to match more than one repository in {}. Repository {} is in use and will be the parent.", new Object[]{entity.getVersion(), StringUtils.join((Collection)versions, (String)", "), parent.getVersion()});
        } else {
            parent = (RepositoryVersionEntity)matching.get(0);
        }
        if (null == parent) {
            throw new IllegalArgumentException(String.format("Could not find any parent repository for %s.", entity.getVersion()));
        }
        entity.setParent(parent);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    @Override
    protected ResourceType getResourceType(Request request, Predicate predicate) {
        return ResourceType.OBDP;
    }

    private XmlHolder loadXml(byte[] decoded) {
        XmlHolder holder = new XmlHolder();
        try {
            holder.xmlString = new String(decoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            holder.xmlString = new String(decoded);
        }
        try {
            holder.xml = VersionDefinitionXml.load(holder.xmlString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return holder;
    }

    private XmlHolder loadXml(String definitionUrl) throws OBDPException {
        XmlHolder holder = new XmlHolder();
        holder.url = definitionUrl;
        int connectTimeout = s_configuration.getVersionDefinitionConnectTimeout();
        int readTimeout = s_configuration.getVersionDefinitionReadTimeout();
        try {
            URI uri = new URI(definitionUrl);
            if (uri.getScheme().equalsIgnoreCase("file")) {
                if (!s_configuration.areFileVDFAllowed()) {
                    throw new OBDPException("File URL for VDF are not enabled");
                }
                InputStream stream = uri.toURL().openStream();
                holder.xmlString = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            } else {
                URLRedirectProvider provider = new URLRedirectProvider(connectTimeout, readTimeout, true);
                URLRedirectProvider.RequestResult requestResult = provider.executeGet(definitionUrl);
                if (requestResult.getCode() != 200) {
                    String err = String.format("Could not load url from '%s' with code '%d'.  %s", definitionUrl, requestResult.getCode(), requestResult.getContent());
                    throw new OBDPException(err);
                }
                holder.xmlString = requestResult.getContent();
            }
            holder.xml = VersionDefinitionXml.load(holder.xmlString);
        }
        catch (Exception e) {
            String err = String.format("Could not load url from %s.  %s", definitionUrl, e.getMessage());
            throw new OBDPException(err, (Throwable)e);
        }
        return holder;
    }

    protected void toRepositoryVersionEntity(XmlHolder holder) throws OBDPException {
        RepositoryVersionEntity entity = new RepositoryVersionEntity();
        StackId stackId = new StackId(holder.xml.release.stackId);
        StackEntity stackEntity = s_stackDAO.find(stackId.getStackName(), stackId.getStackVersion());
        entity.setStack(stackEntity);
        String credentials = null;
        if (holder.url != null) {
            try {
                URI uri = new URI(holder.url);
                credentials = uri.getUserInfo();
            }
            catch (URISyntaxException e) {
                throw new OBDPException(String.format("Could not parse url %s", holder.url), (Throwable)e);
            }
        }
        List<RepositoryInfo> repos = holder.xml.repositoryInfo.getRepositories(credentials);
        StackInfo stack = ((OBDPMetaInfo)s_metaInfo.get()).getStack(stackId);
        ListMultimap<String, RepositoryInfo> stackReposByOs = stack.getRepositoriesByOs();
        repos.addAll(RepoUtil.getServiceRepos(repos, stackReposByOs));
        entity.addRepoOsEntities(((RepositoryVersionHelper)s_repoVersionHelper.get()).createRepoOsEntities(repos));
        entity.setVersion(holder.xml.release.getFullVersion(stack.getReleaseVersion()));
        if (StringUtils.isNotEmpty((String)holder.xml.release.display)) {
            entity.setDisplayName(holder.xml.release.display);
        } else {
            entity.setDisplayName(stackId.getStackName() + "-" + entity.getVersion());
        }
        entity.setType(holder.xml.release.repositoryType);
        entity.setVersionUrl(holder.url);
        entity.setVersionXml(holder.xmlString);
        entity.setVersionXsd(holder.xml.xsdLocation);
        holder.entity = entity;
    }

    private Resource toResource(String id, VersionDefinitionXml xml, Set<String> requestedIds, Set<String> validations) throws SystemException {
        ResourceImpl resource = new ResourceImpl(Resource.Type.VersionDefinition);
        resource.setProperty(VERSION_DEF_ID, id);
        StackId stackId = new StackId(xml.release.stackId);
        resource.setProperty(VERSION_DEF_STACK_NAME, stackId.getStackName());
        resource.setProperty(VERSION_DEF_STACK_VERSION, stackId.getStackVersion());
        StackInfo stack = null;
        try {
            stack = ((OBDPMetaInfo)s_metaInfo.get()).getStack(stackId.getStackName(), stackId.getStackVersion());
        }
        catch (OBDPException e) {
            throw new SystemException(String.format("Could not load stack %s", stackId));
        }
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_TYPE_PROPERTY_ID, xml.release.repositoryType, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_FULL_VERSION, xml.release.getFullVersion(stack.getReleaseVersion()), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_BUILD, xml.release.build, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_COMPATIBLE_WITH, xml.release.compatibleWith, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_NOTES, xml.release.releaseNotes, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_VERSION, xml.release.version, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_DEFAULT, xml.isStackDefault(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_REPO_UPDATE_LINK_EXISTS, stack.getRepositoryXml().getLatestURI() != null, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_DISPLAY_NAME, xml.release.display, requestedIds);
        if (null != validations) {
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_VALIDATION, validations, requestedIds);
        }
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_AVAILABLE_SERVICES, xml.getAvailableServices(stack), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_SERVICES, xml.getStackServices(stack), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_MIN_JDK, stack.getMinJdk(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_MAX_JDK, stack.getMaxJdk(), requestedIds);
        return resource;
    }

    private Resource toResource(RepositoryVersionEntity entity, Set<String> requestedIds) throws SystemException {
        ResourceImpl resource = new ResourceImpl(Resource.Type.VersionDefinition);
        resource.setProperty(VERSION_DEF_ID, entity.getId());
        VersionDefinitionXml xml = null;
        try {
            xml = entity.getRepositoryXml();
        }
        catch (Exception e) {
            String msg = String.format("Could not load version definition %s", entity.getId());
            throw new SystemException(msg, e);
        }
        StackId stackId = new StackId(xml.release.stackId);
        resource.setProperty(VERSION_DEF_STACK_NAME, stackId.getStackName());
        resource.setProperty(VERSION_DEF_STACK_VERSION, stackId.getStackVersion());
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_TYPE_PROPERTY_ID, entity.getType(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_DEFINITION_URL, entity.getVersionUrl(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_FULL_VERSION, entity.getVersion(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_BUILD, xml.release.build, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_COMPATIBLE_WITH, xml.release.compatibleWith, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_NOTES, xml.release.releaseNotes, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_RELEASE_VERSION, xml.release.version, requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_DEFAULT, xml.isStackDefault(), requestedIds);
        VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_DISPLAY_NAME, xml.release.display, requestedIds);
        StackInfo stack = null;
        if (VersionDefinitionResourceProvider.isPropertyRequested(VERSION_DEF_AVAILABLE_SERVICES, requestedIds) || VersionDefinitionResourceProvider.isPropertyRequested(VERSION_DEF_STACK_SERVICES, requestedIds)) {
            try {
                stack = ((OBDPMetaInfo)s_metaInfo.get()).getStack(stackId.getStackName(), stackId.getStackVersion());
            }
            catch (OBDPException e) {
                throw new SystemException(String.format("Could not load stack %s", stackId));
            }
        }
        if (null != stack) {
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_AVAILABLE_SERVICES, xml.getAvailableServices(stack), requestedIds);
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_SERVICES, xml.getStackServices(stack), requestedIds);
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_MIN_JDK, stack.getMinJdk(), requestedIds);
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_MAX_JDK, stack.getMaxJdk(), requestedIds);
            VersionDefinitionResourceProvider.setResourceProperty(resource, VERSION_DEF_STACK_REPO_UPDATE_LINK_EXISTS, stack.getRepositoryXml().getLatestURI() != null, requestedIds);
        }
        return resource;
    }

    private void addSubresources(Resource res, RepositoryVersionEntity entity) {
        JsonNodeFactory factory = JsonNodeFactory.instance;
        ArrayNode subs = factory.arrayNode();
        for (RepoOsEntity os : entity.getRepoOsEntities()) {
            ObjectNode osBase = factory.objectNode();
            ObjectNode osElement = factory.objectNode();
            osElement.put(PropertyHelper.getPropertyName("OperatingSystems/ambari_managed_repositories"), os.isAmbariManaged());
            osElement.put(PropertyHelper.getPropertyName(OperatingSystemResourceProvider.OPERATING_SYSTEM_OS_TYPE_PROPERTY_ID), os.getFamily());
            osElement.put(PropertyHelper.getPropertyName(OperatingSystemResourceProvider.OPERATING_SYSTEM_STACK_NAME_PROPERTY_ID), entity.getStackName());
            osElement.put(PropertyHelper.getPropertyName(OperatingSystemResourceProvider.OPERATING_SYSTEM_STACK_VERSION_PROPERTY_ID), entity.getStackVersion());
            osBase.put(PropertyHelper.getPropertyCategory("OperatingSystems/ambari_managed_repositories"), (JsonNode)osElement);
            ArrayNode reposArray = factory.arrayNode();
            for (RepoDefinitionEntity repo : os.getRepoDefinitionEntities()) {
                ObjectNode repoBase = factory.objectNode();
                ObjectNode repoElement = factory.objectNode();
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_BASE_URL_PROPERTY_ID), repo.getBaseUrl());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_OS_TYPE_PROPERTY_ID), os.getFamily());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_REPO_ID_PROPERTY_ID), repo.getRepoID());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_REPO_NAME_PROPERTY_ID), repo.getRepoName());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_DISTRIBUTION_PROPERTY_ID), repo.getDistribution());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_COMPONENTS_PROPERTY_ID), repo.getComponents());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_STACK_NAME_PROPERTY_ID), entity.getStackName());
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_STACK_VERSION_PROPERTY_ID), entity.getStackVersion());
                ArrayNode applicableServicesNode = factory.arrayNode();
                if (repo.getApplicableServices() != null) {
                    for (String applicableService : repo.getApplicableServices()) {
                        applicableServicesNode.add(applicableService);
                    }
                }
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_APPLICABLE_SERVICES_PROPERTY_ID), (JsonNode)applicableServicesNode);
                ArrayNode tagsNode = factory.arrayNode();
                for (RepoTag repoTag : repo.getTags()) {
                    tagsNode.add(repoTag.toString());
                }
                repoElement.put(PropertyHelper.getPropertyName(RepositoryResourceProvider.REPOSITORY_TAGS_PROPERTY_ID), (JsonNode)tagsNode);
                repoBase.put(PropertyHelper.getPropertyCategory(RepositoryResourceProvider.REPOSITORY_BASE_URL_PROPERTY_ID), (JsonNode)repoElement);
                reposArray.add((JsonNode)repoBase);
            }
            osBase.put(new RepositoryResourceDefinition().getPluralName(), (JsonNode)reposArray);
            subs.add((JsonNode)osBase);
        }
        res.setProperty(new OperatingSystemResourceDefinition().getPluralName(), subs);
    }

    static {
        PK_PROPERTY_IDS = Sets.newHashSet((Object[])new String[]{VERSION_DEF_ID, VERSION_DEF_STACK_NAME, VERSION_DEF_STACK_VERSION, VERSION_DEF_FULL_VERSION});
        PROPERTY_IDS = Sets.newHashSet((Object[])new String[]{VERSION_DEF_ID, VERSION_DEF_TYPE_PROPERTY_ID, VERSION_DEF_DEFINITION_URL, VERSION_DEF_DEFINITION_BASE64, VERSION_DEF_AVAILABLE_DEFINITION, VERSION_DEF_STACK_NAME, VERSION_DEF_STACK_VERSION, VERSION_DEF_FULL_VERSION, VERSION_DEF_RELEASE_NOTES, VERSION_DEF_RELEASE_COMPATIBLE_WITH, VERSION_DEF_RELEASE_VERSION, VERSION_DEF_RELEASE_BUILD, VERSION_DEF_AVAILABLE_SERVICES, VERSION_DEF_STACK_SERVICES, VERSION_DEF_STACK_DEFAULT, VERSION_DEF_STACK_REPO_UPDATE_LINK_EXISTS, VERSION_DEF_DISPLAY_NAME, VERSION_DEF_VALIDATION, VERSION_DEF_MIN_JDK, VERSION_DEF_MAX_JDK, SUBRESOURCE_OPERATING_SYSTEMS_PROPERTY_ID, SHOW_AVAILABLE});
        KEY_PROPERTY_IDS = Collections.singletonMap(Resource.Type.VersionDefinition, VERSION_DEF_ID);
    }

    private static class XmlHolder {
        String url = null;
        String xmlString = null;
        VersionDefinitionXml xml = null;
        RepositoryVersionEntity entity = null;

        private XmlHolder() {
        }
    }
}

