/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorException;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequestException;
import id.onyx.obdp.server.api.services.stackadvisor.validations.ValidationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.StackAdvisorResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationResourceProvider
extends StackAdvisorResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ValidationResourceProvider.class);
    protected static final String VALIDATION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Validation", "id");
    protected static final String VALIDATE_PROPERTY_ID = "validate";
    protected static final String ITEMS_PROPERTY_ID = "items";
    protected static final String TYPE_PROPERTY_ID = "type";
    protected static final String LEVE_PROPERTY_ID = "level";
    protected static final String MESSAGE_PROPERTY_ID = "message";
    protected static final String COMPONENT_NAME_PROPERTY_ID = "component-name";
    protected static final String HOST_PROPERTY_ID = "host";
    protected static final String CONFIG_TYPE_PROPERTY_ID = "config-type";
    protected static final String CONFIG_NAME_PROPERTY_ID = "config-name";
    protected static final String HOST_GROUP_PROPERTY_ID = "host-group";
    protected static final String HOSTS_PROPERTY_ID = "hosts";
    protected static final String SERVICES_PROPERTY_ID = "services";
    protected static final String RECOMMENDATIONS_PROPERTY_ID = "recommendations";
    protected static final String ITEMS_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("items", "type");
    protected static final String ITEMS_LEVE_PROPERTY_ID = PropertyHelper.getPropertyId("items", "level");
    protected static final String ITEMS_MESSAGE_PROPERTY_ID = PropertyHelper.getPropertyId("items", "message");
    protected static final String ITEMS_COMPONENT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("items", "component-name");
    protected static final String ITEMS_HOST_PROPERTY_ID = PropertyHelper.getPropertyId("items", "host");
    protected static final String ITEMS_CONFIG_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("items", "config-type");
    protected static final String ITEMS_CONFIG_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("items", "config-name");
    protected static final String ITEMS_HOST_GROUP_PROPERTY_ID = PropertyHelper.getPropertyId("items", "host-group");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Validation, (Object)VALIDATION_ID_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{VALIDATION_ID_PROPERTY_ID, "validate", "items", STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, ITEMS_TYPE_PROPERTY_ID, ITEMS_LEVE_PROPERTY_ID, ITEMS_MESSAGE_PROPERTY_ID, ITEMS_COMPONENT_NAME_PROPERTY_ID, ITEMS_HOST_PROPERTY_ID, ITEMS_CONFIG_TYPE_PROPERTY_ID, ITEMS_CONFIG_NAME_PROPERTY_ID, ITEMS_HOST_GROUP_PROPERTY_ID, "hosts", "services", "recommendations"});

    protected ValidationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Validation, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    protected String getRequestTypePropertyId() {
        return VALIDATE_PROPERTY_ID;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        ValidationResponse response;
        StackAdvisorRequest validationRequest = this.prepareStackAdvisorRequest(request);
        try {
            response = saHelper.validate(validationRequest);
        }
        catch (StackAdvisorRequestException e) {
            LOG.warn("Error occurred during validation", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (StackAdvisorException e) {
            LOG.warn("Error occurred during validation", (Throwable)e);
            throw new SystemException(e.getMessage(), e);
        }
        Resource validation = this.createResources(new AbstractResourceProvider.Command<Resource>(){

            @Override
            public Resource invoke() throws OBDPException {
                ResourceImpl resource = new ResourceImpl(Resource.Type.Validation);
                BaseProvider.setResourceProperty(resource, VALIDATION_ID_PROPERTY_ID, response.getId(), ValidationResourceProvider.this.getPropertyIds());
                BaseProvider.setResourceProperty(resource, StackAdvisorResourceProvider.STACK_NAME_PROPERTY_ID, response.getVersion().getStackName(), ValidationResourceProvider.this.getPropertyIds());
                BaseProvider.setResourceProperty(resource, StackAdvisorResourceProvider.STACK_VERSION_PROPERTY_ID, response.getVersion().getStackVersion(), ValidationResourceProvider.this.getPropertyIds());
                ArrayList listItemProps = new ArrayList();
                Set<ValidationResponse.ValidationItem> items = response.getItems();
                for (ValidationResponse.ValidationItem item : items) {
                    HashMap<String, String> mapItemProps = new HashMap<String, String>();
                    mapItemProps.put(ValidationResourceProvider.TYPE_PROPERTY_ID, item.getType());
                    mapItemProps.put(ValidationResourceProvider.LEVE_PROPERTY_ID, item.getLevel());
                    mapItemProps.put(ValidationResourceProvider.MESSAGE_PROPERTY_ID, item.getMessage());
                    if (item.getComponentName() != null) {
                        mapItemProps.put(ValidationResourceProvider.COMPONENT_NAME_PROPERTY_ID, item.getComponentName());
                    }
                    if (item.getHost() != null) {
                        mapItemProps.put(ValidationResourceProvider.HOST_PROPERTY_ID, item.getHost());
                    }
                    if (item.getConfigType() != null) {
                        mapItemProps.put(ValidationResourceProvider.CONFIG_TYPE_PROPERTY_ID, item.getConfigType());
                        mapItemProps.put(ValidationResourceProvider.CONFIG_NAME_PROPERTY_ID, item.getConfigName());
                    }
                    listItemProps.add(mapItemProps);
                }
                BaseProvider.setResourceProperty(resource, ValidationResourceProvider.ITEMS_PROPERTY_ID, listItemProps, ValidationResourceProvider.this.getPropertyIds());
                return resource;
            }
        });
        this.notifyCreate(Resource.Type.Validation, request);
        HashSet<Resource> resources = new HashSet<Resource>(Arrays.asList(validation));
        return new RequestStatusImpl(null, resources);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

