/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.UserRequest;
import id.onyx.obdp.server.controller.UserResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.ResourcePredicateEvaluator;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateBuilder;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.entities.MemberEntity;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.text.NumberFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserResourceProvider
extends AbstractControllerResourceProvider
implements ResourcePredicateEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(UserResourceProvider.class);
    public static final String USER_RESOURCE_CATEGORY = "Users";
    public static final String USERNAME_PROPERTY_ID = "user_name";
    public static final String DISPLAY_NAME_PROPERTY_ID = "display_name";
    public static final String LOCAL_USERNAME_PROPERTY_ID = "local_user_name";
    public static final String ACTIVE_PROPERTY_ID = "active";
    public static final String CREATE_TIME_PROPERTY_ID = "created";
    public static final String CONSECUTIVE_FAILURES_PROPERTY_ID = "consecutive_failures";
    public static final String ADMIN_PROPERTY_ID = "admin";
    public static final String GROUPS_PROPERTY_ID = "groups";
    public static final String USER_USERNAME_PROPERTY_ID = "Users/user_name";
    public static final String USER_DISPLAY_NAME_PROPERTY_ID = "Users/display_name";
    public static final String USER_LOCAL_USERNAME_PROPERTY_ID = "Users/local_user_name";
    public static final String USER_ACTIVE_PROPERTY_ID = "Users/active";
    public static final String USER_CREATE_TIME_PROPERTY_ID = "Users/created";
    public static final String USER_CONSECUTIVE_FAILURES_PROPERTY_ID = "Users/consecutive_failures";
    public static final String USER_ADMIN_PROPERTY_ID = "Users/admin";
    public static final String USER_GROUPS_PROPERTY_ID = "Users/groups";
    @Deprecated
    public static final String PASSWORD_PROPERTY_ID = "password";
    @Deprecated
    public static final String OLD_PASSWORD_PROPERTY_ID = "old_password";
    @Deprecated
    public static final String LDAP_USER_PROPERTY_ID = "ldap_user";
    @Deprecated
    public static final String USER_TYPE_PROPERTY_ID = "user_type";
    @Deprecated
    public static final String USER_PASSWORD_PROPERTY_ID = "Users/password";
    @Deprecated
    public static final String USER_OLD_PASSWORD_PROPERTY_ID = "Users/old_password";
    @Deprecated
    public static final String USER_LDAP_USER_PROPERTY_ID = "Users/ldap_user";
    @Deprecated
    public static final String USER_USER_TYPE_PROPERTY_ID = "Users/user_type";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.User, (Object)"Users/user_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"Users/user_name", "Users/display_name", "Users/local_user_name", "Users/active", "Users/created", "Users/consecutive_failures", "Users/groups", "Users/password", "Users/old_password", "Users/ldap_user", "Users/user_type", "Users/admin"});
    @Inject
    private Users users;

    @AssistedInject
    UserResourceProvider(@Assisted OBDPManagementController managementController) {
        super(Resource.Type.User, propertyIds, keyPropertyIds, managementController);
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_USERS));
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.OBDP_MANAGE_USERS));
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<UserRequest> requests = new HashSet<UserRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                try {
                    UserResourceProvider.this.createUsers(requests);
                }
                catch (AuthorizationException e) {
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserRequest> requests = new HashSet<UserRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(null));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<UserResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<UserResponse>>(){

            @Override
            public Set<UserResponse> invoke() throws OBDPException, AuthorizationException {
                return UserResourceProvider.this.getUsers(requests);
            }
        });
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found user responses matching get user request, userRequestSize={}, userResponseSize={}", (Object)requests.size(), (Object)responses.size());
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (UserResponse userResponse : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.User);
            UserResourceProvider.setResourceProperty(resource, USER_USERNAME_PROPERTY_ID, userResponse.getUsername(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_DISPLAY_NAME_PROPERTY_ID, userResponse.getDisplayName(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_LOCAL_USERNAME_PROPERTY_ID, userResponse.getLocalUsername(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_LDAP_USER_PROPERTY_ID, userResponse.isLdapUser(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_USER_TYPE_PROPERTY_ID, (Object)userResponse.getAuthenticationType(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_ACTIVE_PROPERTY_ID, userResponse.isActive(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_GROUPS_PROPERTY_ID, userResponse.getGroups(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_ADMIN_PROPERTY_ID, userResponse.isAdmin(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_CONSECUTIVE_FAILURES_PROPERTY_ID, userResponse.getConsecutiveFailures(), requestedIds);
            UserResourceProvider.setResourceProperty(resource, USER_CREATE_TIME_PROPERTY_ID, userResponse.getCreateTime(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserRequest> requests = new HashSet<UserRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(request.getProperties().iterator().next(), predicate)) {
            UserRequest req = this.getRequest(propertyMap);
            requests.add(req);
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                UserResourceProvider.this.updateUsers(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserRequest> requests = new HashSet<UserRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            UserRequest req = this.getRequest(propertyMap);
            requests.add(req);
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                UserResourceProvider.this.deleteUsers(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public boolean evaluate(Predicate predicate, Resource resource) {
        EqualsPredicate equalsPredicate;
        String propertyId;
        if (predicate instanceof EqualsPredicate && (propertyId = (equalsPredicate = (EqualsPredicate)predicate).getPropertyId()).equals(USER_USERNAME_PROPERTY_ID)) {
            return equalsPredicate.evaluateIgnoreCase(resource);
        }
        return predicate.evaluate(resource);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    private UserRequest getRequest(Map<String, Object> properties) {
        if (properties == null) {
            return new UserRequest(null);
        }
        UserRequest request = new UserRequest((String)properties.get(USER_USERNAME_PROPERTY_ID));
        request.setDisplayName((String)properties.get(USER_DISPLAY_NAME_PROPERTY_ID));
        request.setLocalUserName((String)properties.get(USER_LOCAL_USERNAME_PROPERTY_ID));
        request.setPassword((String)properties.get(USER_PASSWORD_PROPERTY_ID));
        request.setOldPassword((String)properties.get(USER_OLD_PASSWORD_PROPERTY_ID));
        if (null != properties.get(USER_ACTIVE_PROPERTY_ID)) {
            request.setActive(Boolean.valueOf(properties.get(USER_ACTIVE_PROPERTY_ID).toString()));
        }
        if (null != properties.get(USER_ADMIN_PROPERTY_ID)) {
            request.setAdmin(Boolean.valueOf(properties.get(USER_ADMIN_PROPERTY_ID).toString()));
        }
        if (null != properties.get(USER_CONSECUTIVE_FAILURES_PROPERTY_ID)) {
            request.setConsecutiveFailures(Integer.parseInt(properties.get(USER_CONSECUTIVE_FAILURES_PROPERTY_ID).toString()));
        }
        return request;
    }

    private void createUsers(Set<UserRequest> requests) throws OBDPException, AuthorizationException {
        String username;
        for (UserRequest request : requests) {
            username = request.getUsername();
            if (StringUtils.isEmpty((String)username)) {
                throw new OBDPException("Username must be supplied.");
            }
            if (this.users.getUser(username) == null) continue;
            String message = requests.size() == 1 ? "The requested username already exists." : "One or more of the requested usernames already exists.";
            throw new DuplicateResourceException(message);
        }
        for (UserRequest request : requests) {
            UserEntity userEntity;
            username = request.getUsername();
            String displayName = StringUtils.defaultIfEmpty((String)request.getDisplayName(), (String)username);
            String localUserName = StringUtils.defaultIfEmpty((String)request.getLocalUserName(), (String)username);
            String password = request.getPassword();
            if (!StringUtils.isEmpty((String)password)) {
                this.users.validatePassword(password, username);
            }
            if ((userEntity = this.users.createUser(username, localUserName, displayName, request.isActive())) == null) continue;
            if (Boolean.TRUE.equals(request.isAdmin())) {
                this.users.grantAdminPrivilege(userEntity);
            }
            if (StringUtils.isEmpty((String)password)) continue;
            this.addOrUpdateLocalAuthenticationSource(true, userEntity, request.getPassword(), null);
        }
    }

    private void updateUsers(Set<UserRequest> requests) throws OBDPException, AuthorizationException {
        boolean asUserAdministrator = AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS);
        String authenticatedUsername = AuthorizationHelper.getAuthenticatedName();
        for (final UserRequest request : requests) {
            String requestedUsername = request.getUsername();
            if (!asUserAdministrator && !authenticatedUsername.equalsIgnoreCase(requestedUsername)) {
                throw new AuthorizationException();
            }
            UserEntity userEntity = this.users.getUserEntity(requestedUsername);
            if (null == userEntity) continue;
            boolean hasUpdates = false;
            if (this.isValueChanged(request.isActive(), userEntity.getActive())) {
                if (!asUserAdministrator) {
                    throw new AuthorizationException("The authenticated user is not authorized to update the requested user's active property");
                }
                hasUpdates = true;
            }
            if (this.isValueChanged(request.getLocalUserName(), userEntity.getLocalUsername())) {
                if (!asUserAdministrator) {
                    throw new AuthorizationException("The authenticated user is not authorized to update the requested user's local username property");
                }
                hasUpdates = true;
            }
            boolean bl = hasUpdates = hasUpdates || this.isValueChanged(request.getDisplayName(), userEntity.getDisplayName());
            if (hasUpdates) {
                this.users.safelyUpdateUserEntity(userEntity, new Users.Command(){

                    @Override
                    public void perform(UserEntity userEntity) {
                        if (UserResourceProvider.this.isValueChanged(request.isActive(), userEntity.getActive())) {
                            userEntity.setActive(request.isActive());
                        }
                        if (UserResourceProvider.this.isValueChanged(request.getLocalUserName(), userEntity.getLocalUsername())) {
                            userEntity.setLocalUsername(request.getLocalUserName());
                        }
                        if (UserResourceProvider.this.isValueChanged(request.getDisplayName(), userEntity.getDisplayName())) {
                            userEntity.setDisplayName(request.getDisplayName());
                        }
                    }
                });
            }
            if (null != request.isAdmin()) {
                if (!asUserAdministrator) {
                    throw new AuthorizationException("The authenticated user is not authorized to update the requested resource property");
                }
                if (request.isAdmin().booleanValue()) {
                    this.users.grantAdminPrivilege(userEntity);
                } else {
                    this.users.revokeAdminPrivilege(userEntity);
                }
            }
            if (request.getPassword() != null) {
                this.addOrUpdateLocalAuthenticationSource(asUserAdministrator, userEntity, request.getPassword(), request.getOldPassword());
            }
            if (request.getConsecutiveFailures() == null) continue;
            if (!asUserAdministrator) {
                throw new AuthorizationException("The authenticated user is not authorized to update the requested resource property");
            }
            this.users.safelyUpdateUserEntity(userEntity, user -> user.setConsecutiveFailures(request.getConsecutiveFailures()));
        }
    }

    private void addOrUpdateLocalAuthenticationSource(boolean asUserAdministrator, UserEntity subjectUserEntity, String password, String oldPassword) throws AuthorizationException, OBDPException {
        ResourceProvider provider = AbstractControllerResourceProvider.getResourceProvider(Resource.Type.UserAuthenticationSource, this.getManagementController());
        if (provider != null) {
            UserAuthenticationEntity userAuthenticationEntity = null;
            List<UserAuthenticationEntity> authenticationEntities = subjectUserEntity.getAuthenticationEntities();
            for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
                if (authenticationEntity.getAuthenticationType() != UserAuthenticationType.LOCAL) continue;
                userAuthenticationEntity = authenticationEntity;
                break;
            }
            if (userAuthenticationEntity == null) {
                if (!asUserAdministrator) {
                    throw new AuthorizationException("The authenticated user is not authorized to create a local authentication source.");
                }
                HashSet<Map<String, Object>> propertiesSet = new HashSet<Map<String, Object>>();
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put("AuthenticationSourceInfo/user_name", subjectUserEntity.getUserName());
                properties.put("AuthenticationSourceInfo/authentication_type", UserAuthenticationType.LOCAL.name());
                properties.put("AuthenticationSourceInfo/key", password);
                propertiesSet.add(properties);
                try {
                    provider.createResources(PropertyHelper.getCreateRequest(propertiesSet, null));
                }
                catch (Exception e) {
                    throw new OBDPException(e.getMessage(), (Throwable)e);
                }
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("AuthenticationSourceInfo/old_key", oldPassword);
            properties.put("AuthenticationSourceInfo/key", password);
            Predicate predicate1 = new PredicateBuilder().property("AuthenticationSourceInfo/user_name").equals(subjectUserEntity.getUserName()).toPredicate();
            Predicate predicate2 = new PredicateBuilder().property("AuthenticationSourceInfo/source_id").equals(this.convertIdToString(userAuthenticationEntity.getUserAuthenticationId())).toPredicate();
            try {
                provider.updateResources(PropertyHelper.getUpdateRequest(properties, null), new AndPredicate(predicate1, predicate2));
            }
            catch (Exception e) {
                throw new OBDPException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String convertIdToString(Long id) {
        if (id == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getIntegerInstance();
        format.setGroupingUsed(false);
        return format.format(id);
    }

    private boolean isValueChanged(Object newValue, Object currentValue) {
        return newValue != null && !newValue.equals(currentValue);
    }

    private void deleteUsers(Set<UserRequest> requests) throws OBDPException {
        for (UserRequest r : requests) {
            String username = r.getUsername();
            if (StringUtils.isEmpty((String)username)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received a delete user request, username= {}", (Object)username);
            }
            this.users.removeUser(this.users.getUserEntity(username));
        }
    }

    private Set<UserResponse> getUsers(Set<UserRequest> requests) throws OBDPException, AuthorizationException {
        HashSet<UserResponse> responses = new HashSet<UserResponse>();
        for (UserRequest r : requests) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received a getUsers request, userRequest={}", (Object)r.toString());
            }
            String requestedUsername = r.getUsername();
            String authenticatedUsername = AuthorizationHelper.getAuthenticatedName();
            if (!AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS)) {
                if (null == requestedUsername) {
                    requestedUsername = authenticatedUsername;
                } else if (!requestedUsername.equalsIgnoreCase(authenticatedUsername)) {
                    throw new AuthorizationException();
                }
            }
            if (null == requestedUsername) {
                for (UserEntity u : this.users.getAllUserEntities()) {
                    responses.add(this.createUserResponse(u));
                }
                continue;
            }
            UserEntity u = this.users.getUserEntity(requestedUsername);
            if (null == u) {
                if (requests.size() != 1) continue;
                throw new ObjectNotFoundException("Cannot find user '" + requestedUsername + "'");
            }
            responses.add(this.createUserResponse(u));
        }
        return responses;
    }

    private UserResponse createUserResponse(UserEntity userEntity) {
        List<UserAuthenticationEntity> authenticationEntities = userEntity.getAuthenticationEntities();
        boolean isLdapUser = false;
        UserAuthenticationType userType = UserAuthenticationType.LOCAL;
        for (UserAuthenticationEntity userAuthenticationEntity : authenticationEntities) {
            if (userAuthenticationEntity.getAuthenticationType() == UserAuthenticationType.LDAP) {
                isLdapUser = true;
                userType = UserAuthenticationType.LDAP;
                continue;
            }
            if (userAuthenticationEntity.getAuthenticationType() != UserAuthenticationType.PAM) continue;
            userType = UserAuthenticationType.PAM;
        }
        HashSet<String> groups = new HashSet<String>();
        for (MemberEntity memberEntity : userEntity.getMemberEntities()) {
            groups.add(memberEntity.getGroup().getGroupName());
        }
        boolean bl = this.users.hasAdminPrivilege(userEntity);
        UserResponse userResponse = new UserResponse(userEntity.getUserName(), userEntity.getDisplayName(), userEntity.getLocalUsername(), userType, isLdapUser, userEntity.getActive(), bl, userEntity.getConsecutiveFailures(), new Date(userEntity.getCreateTime()));
        userResponse.setGroups(groups);
        return userResponse;
    }
}

