/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.UserPrivilegeResponse;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.ClusterDAO;
import id.onyx.obdp.server.orm.dao.GroupDAO;
import id.onyx.obdp.server.orm.dao.UserDAO;
import id.onyx.obdp.server.orm.dao.ViewInstanceDAO;
import id.onyx.obdp.server.orm.entities.ClusterEntity;
import id.onyx.obdp.server.orm.entities.GroupEntity;
import id.onyx.obdp.server.orm.entities.PrincipalEntity;
import id.onyx.obdp.server.orm.entities.PrincipalTypeEntity;
import id.onyx.obdp.server.orm.entities.PrivilegeEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.orm.entities.ViewEntity;
import id.onyx.obdp.server.orm.entities.ViewInstanceEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class UserPrivilegeResourceProvider
extends ReadOnlyResourceProvider {
    protected static final String USER_NAME_PROPERTY_ID = "user_name";
    protected static final String PRIVILEGE_ID = "PrivilegeInfo/privilege_id";
    protected static final String PERMISSION_NAME = "PrivilegeInfo/permission_name";
    protected static final String PERMISSION_LABEL = "PrivilegeInfo/permission_label";
    protected static final String PRINCIPAL_NAME = "PrivilegeInfo/principal_name";
    protected static final String PRINCIPAL_TYPE = "PrivilegeInfo/principal_type";
    protected static final String VIEW_NAME = "PrivilegeInfo/view_name";
    protected static final String VIEW_VERSION = "PrivilegeInfo/version";
    protected static final String INSTANCE_NAME = "PrivilegeInfo/instance_name";
    protected static final String CLUSTER_NAME = "PrivilegeInfo/cluster_name";
    protected static final String TYPE = "PrivilegeInfo/type";
    protected static final String USER_NAME = "PrivilegeInfo/user_name";
    private static UserDAO userDAO;
    private static ClusterDAO clusterDAO;
    private static GroupDAO groupDAO;
    private static ViewInstanceDAO viewInstanceDAO;
    private static Users users;
    private static final Set<String> propertyIds;
    private static final Set<String> pkPropertyIds;
    private static final Map<Resource.Type, String> keyPropertyIds;
    private ThreadLocal<LoadingCache<Long, ClusterEntity>> clusterCache = new ThreadLocal<LoadingCache<Long, ClusterEntity>>(){

        @Override
        protected LoadingCache<Long, ClusterEntity> initialValue() {
            CacheLoader<Long, ClusterEntity> loader = new CacheLoader<Long, ClusterEntity>(){

                public ClusterEntity load(Long key) throws Exception {
                    return clusterDAO.findByResourceId(key);
                }
            };
            return CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build((CacheLoader)loader);
        }
    };
    private ThreadLocal<LoadingCache<Long, ViewInstanceEntity>> viewInstanceCache = new ThreadLocal<LoadingCache<Long, ViewInstanceEntity>>(){

        @Override
        protected LoadingCache<Long, ViewInstanceEntity> initialValue() {
            CacheLoader<Long, ViewInstanceEntity> loader = new CacheLoader<Long, ViewInstanceEntity>(){

                public ViewInstanceEntity load(Long key) throws Exception {
                    return viewInstanceDAO.findByResourceId(key);
                }
            };
            return CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build((CacheLoader)loader);
        }
    };
    private ThreadLocal<LoadingCache<String, UserEntity>> usersCache = new ThreadLocal<LoadingCache<String, UserEntity>>(){

        @Override
        protected LoadingCache<String, UserEntity> initialValue() {
            CacheLoader<String, UserEntity> loader = new CacheLoader<String, UserEntity>(){

                public UserEntity load(String key) throws Exception {
                    return userDAO.findUserByName(key);
                }
            };
            return CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build((CacheLoader)loader);
        }
    };
    private ThreadLocal<LoadingCache<PrincipalEntity, GroupEntity>> groupsCache = new ThreadLocal<LoadingCache<PrincipalEntity, GroupEntity>>(){

        @Override
        protected LoadingCache<PrincipalEntity, GroupEntity> initialValue() {
            CacheLoader<PrincipalEntity, GroupEntity> loader = new CacheLoader<PrincipalEntity, GroupEntity>(){

                public GroupEntity load(PrincipalEntity key) throws Exception {
                    return groupDAO.findGroupByPrincipal(key);
                }
            };
            return CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build((CacheLoader)loader);
        }
    };

    public static void init(UserDAO userDAO, ClusterDAO clusterDAO, GroupDAO groupDAO, ViewInstanceDAO viewInstanceDAO, Users users) {
        UserPrivilegeResourceProvider.userDAO = userDAO;
        UserPrivilegeResourceProvider.clusterDAO = clusterDAO;
        UserPrivilegeResourceProvider.groupDAO = groupDAO;
        UserPrivilegeResourceProvider.viewInstanceDAO = viewInstanceDAO;
        UserPrivilegeResourceProvider.users = users;
    }

    private GroupEntity getCachedGroupByPrincipal(PrincipalEntity principalEntity) {
        GroupEntity entity = (GroupEntity)this.groupsCache.get().getIfPresent((Object)principalEntity);
        if (entity == null) {
            for (GroupEntity groupEntity : groupDAO.findAll()) {
                this.groupsCache.get().put((Object)groupEntity.getPrincipal(), (Object)groupEntity);
            }
            entity = (GroupEntity)this.groupsCache.get().getUnchecked((Object)principalEntity);
        }
        return entity;
    }

    public UserPrivilegeResourceProvider() {
        super(Resource.Type.UserPrivilege, propertyIds, keyPropertyIds, null);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_ASSIGN_ROLES);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        boolean isUserAdministrator = AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String userName = (String)propertyMap.get(USER_NAME);
            if (!isUserAdministrator && !AuthorizationHelper.getAuthenticatedName().equalsIgnoreCase(userName)) {
                throw new AuthorizationException();
            }
            if (userName == null) continue;
            UserEntity userEntity = (UserEntity)this.usersCache.get().getIfPresent((Object)userName);
            if (userEntity == null) {
                TreeMap<String, UserEntity> userNames = new TreeMap<String, UserEntity>();
                for (UserEntity entity : userDAO.findAll()) {
                    UserEntity existing = (UserEntity)userNames.get(entity.getUserName());
                    if (existing != null) continue;
                    userNames.put(entity.getUserName(), entity);
                }
                this.usersCache.get().putAll(userNames);
                userEntity = (UserEntity)this.usersCache.get().getIfPresent((Object)userName);
            }
            if (userEntity == null) {
                userEntity = userDAO.findUserByName(userName);
            }
            if (userEntity == null) {
                throw new NoSuchParentResourceException("User was not found");
            }
            Collection<PrivilegeEntity> privileges = users.getUserPrivileges(userEntity);
            for (PrivilegeEntity privilegeEntity : privileges) {
                UserPrivilegeResponse response = this.getResponse(privilegeEntity, userName);
                resources.add(this.toResource(response, requestedIds));
            }
        }
        return resources;
    }

    protected UserPrivilegeResponse getResponse(PrivilegeEntity privilegeEntity, String userName) {
        String permissionLabel = privilegeEntity.getPermission().getPermissionLabel();
        String permissionName = privilegeEntity.getPermission().getPermissionName();
        String principalTypeName = privilegeEntity.getPrincipal().getPrincipalType().getName();
        UserPrivilegeResponse userPrivilegeResponse = new UserPrivilegeResponse(userName, permissionLabel, permissionName, privilegeEntity.getId(), PrincipalTypeEntity.PrincipalType.valueOf(principalTypeName));
        if (principalTypeName.equals(PrincipalTypeEntity.USER_PRINCIPAL_TYPE_NAME)) {
            UserEntity user = userDAO.findUserByPrincipal(privilegeEntity.getPrincipal());
            userPrivilegeResponse.setPrincipalName(user.getUserName());
        } else if (principalTypeName.equals(PrincipalTypeEntity.GROUP_PRINCIPAL_TYPE_NAME)) {
            GroupEntity groupEntity = this.getCachedGroupByPrincipal(privilegeEntity.getPrincipal());
            userPrivilegeResponse.setPrincipalName(groupEntity.getGroupName());
        }
        String typeName = privilegeEntity.getResource().getResourceType().getName();
        ResourceType resourceType = ResourceType.translate(typeName);
        if (resourceType != null) {
            switch (resourceType) {
                case OBDP: {
                    break;
                }
                case CLUSTER: {
                    ClusterEntity clusterEntity = (ClusterEntity)this.clusterCache.get().getUnchecked((Object)privilegeEntity.getResource().getId());
                    userPrivilegeResponse.setClusterName(clusterEntity.getClusterName());
                    break;
                }
                case VIEW: {
                    ViewInstanceEntity viewInstanceEntity = (ViewInstanceEntity)this.viewInstanceCache.get().getUnchecked((Object)privilegeEntity.getResource().getId());
                    ViewEntity viewEntity = viewInstanceEntity.getViewEntity();
                    userPrivilegeResponse.setViewName(viewEntity.getCommonName());
                    userPrivilegeResponse.setVersion(viewEntity.getVersion());
                    userPrivilegeResponse.setInstanceName(viewInstanceEntity.getName());
                }
            }
            userPrivilegeResponse.setType(resourceType);
        }
        return userPrivilegeResponse;
    }

    protected Resource toResource(UserPrivilegeResponse response, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.UserPrivilege);
        UserPrivilegeResourceProvider.setResourceProperty(resource, USER_NAME, response.getUserName(), requestedIds);
        UserPrivilegeResourceProvider.setResourceProperty(resource, PRIVILEGE_ID, response.getPrivilegeId(), requestedIds);
        UserPrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_NAME, response.getPermissionName(), requestedIds);
        UserPrivilegeResourceProvider.setResourceProperty(resource, PERMISSION_LABEL, response.getPermissionLabel(), requestedIds);
        UserPrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_TYPE, response.getPrincipalType().name(), requestedIds);
        if (response.getPrincipalName() != null) {
            UserPrivilegeResourceProvider.setResourceProperty(resource, PRINCIPAL_NAME, response.getPrincipalName(), requestedIds);
        }
        if (response.getType() != null) {
            UserPrivilegeResourceProvider.setResourceProperty(resource, TYPE, response.getType().name(), requestedIds);
            switch (response.getType()) {
                case CLUSTER: {
                    UserPrivilegeResourceProvider.setResourceProperty(resource, CLUSTER_NAME, response.getClusterName(), requestedIds);
                    break;
                }
                case VIEW: {
                    UserPrivilegeResourceProvider.setResourceProperty(resource, VIEW_NAME, response.getViewName(), requestedIds);
                    UserPrivilegeResourceProvider.setResourceProperty(resource, VIEW_VERSION, response.getVersion(), requestedIds);
                    UserPrivilegeResourceProvider.setResourceProperty(resource, INSTANCE_NAME, response.getInstanceName(), requestedIds);
                }
            }
        }
        return resource;
    }

    static {
        propertyIds = Sets.newHashSet((Object[])new String[]{PRIVILEGE_ID, PERMISSION_NAME, PERMISSION_LABEL, PRINCIPAL_NAME, PRINCIPAL_TYPE, VIEW_NAME, VIEW_VERSION, INSTANCE_NAME, CLUSTER_NAME, TYPE, USER_NAME});
        pkPropertyIds = ImmutableSet.builder().add((Object)PRIVILEGE_ID).build();
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.User, (Object)USER_NAME).put((Object)Resource.Type.UserPrivilege, (Object)PRIVILEGE_ID).build();
    }
}

