/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.UserAuthorizationResponse;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.spi.ClusterController;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.ClusterControllerHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.ResourceTypeDAO;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.ResourceTypeEntity;
import id.onyx.obdp.server.orm.entities.RoleAuthorizationEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class UserAuthorizationResourceProvider
extends ReadOnlyResourceProvider {
    public static final String AUTHORIZATION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "authorization_id");
    public static final String USERNAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "user_name");
    public static final String AUTHORIZATION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "authorization_name");
    public static final String AUTHORIZATION_RESOURCE_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "resource_type");
    public static final String AUTHORIZATION_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "cluster_name");
    public static final String AUTHORIZATION_VIEW_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "view_name");
    public static final String AUTHORIZATION_VIEW_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "view_version");
    public static final String AUTHORIZATION_VIEW_INSTANCE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "view_instance_name");
    private static final Set<String> PK_PROPERTY_IDS;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;
    @Inject
    private static PermissionDAO permissionDAO;
    @Inject
    private static ResourceTypeDAO resourceTypeDAO;
    private final ClusterController clusterController = ClusterControllerHelper.getClusterController();

    public static void init(PermissionDAO permissionDAO, ResourceTypeDAO resourceTypeDAO) {
        UserAuthorizationResourceProvider.permissionDAO = permissionDAO;
        UserAuthorizationResourceProvider.resourceTypeDAO = resourceTypeDAO;
    }

    public UserAuthorizationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.UserAuthorization, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        ResourceProvider userPrivilegeProvider = this.clusterController.ensureResourceProvider(Resource.Type.UserPrivilege);
        boolean isUserAdministrator = AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            Predicate internalPredicate;
            String username = (String)propertyMap.get(USERNAME_PROPERTY_ID);
            if (!isUserAdministrator && !AuthorizationHelper.getAuthenticatedName().equalsIgnoreCase(username)) {
                throw new AuthorizationException();
            }
            Request internalRequest = this.createUserPrivilegeRequest();
            Set<Resource> internalResources = userPrivilegeProvider.getResources(internalRequest, internalPredicate = this.createUserPrivilegePredicate(username));
            if (internalResources == null) continue;
            for (Resource internalResource : internalResources) {
                PermissionEntity permissionEntity;
                Collection<RoleAuthorizationEntity> authorizationEntities;
                String permissionName = (String)internalResource.getPropertyValue("PrivilegeInfo/permission_name");
                String resourceType = (String)internalResource.getPropertyValue("PrivilegeInfo/type");
                ResourceTypeEntity resourceTypeEntity = resourceTypeDAO.findByName(resourceType);
                if (resourceTypeEntity == null || (authorizationEntities = (permissionEntity = permissionDAO.findPermissionByNameAndType(permissionName, resourceTypeEntity)) == null ? null : permissionEntity.getAuthorizations()) == null) continue;
                if ("VIEW".equals(resourceType)) {
                    this.addViewResources(resources, username, resourceType, internalResource, authorizationEntities, requestedIds);
                    continue;
                }
                this.addClusterResources(resources, username, resourceType, internalResource, authorizationEntities, requestedIds);
            }
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Predicate createUserPrivilegePredicate(String username) {
        return new EqualsPredicate("PrivilegeInfo/user_name", username);
    }

    private Request createUserPrivilegeRequest() {
        HashSet<String> propertyIds = new HashSet<String>();
        propertyIds.add("PrivilegeInfo/privilege_id");
        propertyIds.add("PrivilegeInfo/permission_name");
        propertyIds.add("PrivilegeInfo/type");
        propertyIds.add("PrivilegeInfo/cluster_name");
        propertyIds.add("PrivilegeInfo/view_name");
        propertyIds.add("PrivilegeInfo/version");
        propertyIds.add("PrivilegeInfo/instance_name");
        return new RequestImpl(propertyIds, null, null, null);
    }

    private void addClusterResources(Set<Resource> resources, String username, String resourceType, Resource privilegeResource, Collection<RoleAuthorizationEntity> authorizationEntities, Set<String> requestedIds) {
        for (RoleAuthorizationEntity entity : authorizationEntities) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.UserAuthorization);
            String clusterName = (String)privilegeResource.getPropertyValue("PrivilegeInfo/cluster_name");
            UserAuthorizationResponse userAuthorizationResponse = this.getResponse(entity.getAuthorizationId(), entity.getAuthorizationName(), clusterName, resourceType, username);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_ID_PROPERTY_ID, userAuthorizationResponse.getAuthorizationId(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, USERNAME_PROPERTY_ID, username, requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_NAME_PROPERTY_ID, entity.getAuthorizationName(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_RESOURCE_TYPE_PROPERTY_ID, resourceType, requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_CLUSTER_NAME_PROPERTY_ID, privilegeResource.getPropertyValue("PrivilegeInfo/cluster_name"), requestedIds);
            resources.add(resource);
        }
    }

    private void addViewResources(Set<Resource> resources, String username, String resourceType, Resource privilegeResource, Collection<RoleAuthorizationEntity> authorizationEntities, Set<String> requestedIds) {
        for (RoleAuthorizationEntity entity : authorizationEntities) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.UserAuthorization);
            String viewName = (String)privilegeResource.getPropertyValue("PrivilegeInfo/view_name");
            String viewVersion = (String)privilegeResource.getPropertyValue("PrivilegeInfo/version");
            String viewInstanceName = (String)privilegeResource.getPropertyValue("PrivilegeInfo/instance_name");
            UserAuthorizationResponse userAuthorizationResponse = this.getResponse(entity.getAuthorizationId(), entity.getAuthorizationName(), resourceType, username, viewName, viewVersion, viewInstanceName);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_ID_PROPERTY_ID, userAuthorizationResponse.getAuthorizationId(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, USERNAME_PROPERTY_ID, userAuthorizationResponse.getUserName(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_NAME_PROPERTY_ID, userAuthorizationResponse.getAuthorizationName(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_RESOURCE_TYPE_PROPERTY_ID, userAuthorizationResponse.getResourceType(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_VIEW_NAME_PROPERTY_ID, userAuthorizationResponse.getViewName(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_VIEW_VERSION_PROPERTY_ID, userAuthorizationResponse.getViewVersion(), requestedIds);
            UserAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_VIEW_INSTANCE_NAME_PROPERTY_ID, userAuthorizationResponse.getViewInstanceName(), requestedIds);
            resources.add(resource);
        }
    }

    private UserAuthorizationResponse getResponse(String authorizationId, String authorizationName, String clusterName, String resourceType, String userName) {
        return new UserAuthorizationResponse(authorizationId, authorizationName, clusterName, resourceType, userName);
    }

    private UserAuthorizationResponse getResponse(String authorizationId, String authorizationName, String resourceType, String userName, String viewName, String viewVersion, String viewInstanceName) {
        return new UserAuthorizationResponse(authorizationId, authorizationName, resourceType, userName, viewName, viewVersion, viewInstanceName);
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(AUTHORIZATION_ID_PROPERTY_ID);
        set.add(USERNAME_PROPERTY_ID);
        set.add(AUTHORIZATION_RESOURCE_TYPE_PROPERTY_ID);
        PK_PROPERTY_IDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(AUTHORIZATION_ID_PROPERTY_ID);
        set.add(USERNAME_PROPERTY_ID);
        set.add(AUTHORIZATION_NAME_PROPERTY_ID);
        set.add(AUTHORIZATION_RESOURCE_TYPE_PROPERTY_ID);
        set.add(AUTHORIZATION_CLUSTER_NAME_PROPERTY_ID);
        set.add(AUTHORIZATION_VIEW_NAME_PROPERTY_ID);
        set.add(AUTHORIZATION_VIEW_VERSION_PROPERTY_ID);
        set.add(AUTHORIZATION_VIEW_INSTANCE_NAME_PROPERTY_ID);
        PROPERTY_IDS = Collections.unmodifiableSet(set);
        HashMap<Resource.Type, String> map = new HashMap<Resource.Type, String>();
        map.put(Resource.Type.User, USERNAME_PROPERTY_ID);
        map.put(Resource.Type.UserAuthorization, AUTHORIZATION_ID_PROPERTY_ID);
        KEY_PROPERTY_IDS = Collections.unmodifiableMap(map);
    }
}

