/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.UserAuthenticationSourceRequest;
import id.onyx.obdp.server.controller.UserAuthenticationSourceResponse;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.entities.UserAuthenticationEntity;
import id.onyx.obdp.server.orm.entities.UserEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.security.authorization.UserAuthenticationType;
import id.onyx.obdp.server.security.authorization.Users;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;

public class UserAuthenticationSourceResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String AUTHENTICATION_SOURCE_RESOURCE_CATEGORY = "AuthenticationSourceInfo";
    public static final String AUTHENTICATION_SOURCE_ID_PROPERTY_ID = "source_id";
    public static final String USER_NAME_PROPERTY_ID = "user_name";
    public static final String AUTHENTICATION_TYPE_PROPERTY_ID = "authentication_type";
    public static final String KEY_PROPERTY_ID = "key";
    public static final String OLD_KEY_PROPERTY_ID = "old_key";
    public static final String CREATED_PROPERTY_ID = "created";
    public static final String UPDATED_PROPERTY_ID = "updated";
    public static final String AUTHENTICATION_AUTHENTICATION_SOURCE_ID_PROPERTY_ID = "AuthenticationSourceInfo/source_id";
    public static final String AUTHENTICATION_USER_NAME_PROPERTY_ID = "AuthenticationSourceInfo/user_name";
    public static final String AUTHENTICATION_AUTHENTICATION_TYPE_PROPERTY_ID = "AuthenticationSourceInfo/authentication_type";
    public static final String AUTHENTICATION_KEY_PROPERTY_ID = "AuthenticationSourceInfo/key";
    public static final String AUTHENTICATION_OLD_KEY_PROPERTY_ID = "AuthenticationSourceInfo/old_key";
    public static final String AUTHENTICATION_CREATED_PROPERTY_ID = "AuthenticationSourceInfo/created";
    public static final String AUTHENTICATION_UPDATED_PROPERTY_ID = "AuthenticationSourceInfo/updated";
    private static final Set<String> PK_PROPERTY_IDS = ImmutableSet.of((Object)"AuthenticationSourceInfo/source_id");
    private static final Set<String> PROPERTY_IDS = ImmutableSet.of((Object)"AuthenticationSourceInfo/source_id", (Object)"AuthenticationSourceInfo/user_name", (Object)"AuthenticationSourceInfo/authentication_type", (Object)"AuthenticationSourceInfo/key", (Object)"AuthenticationSourceInfo/old_key", (Object)"AuthenticationSourceInfo/created", (Object[])new String[]{"AuthenticationSourceInfo/updated"});
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = ImmutableMap.of((Object)Resource.Type.User, (Object)"AuthenticationSourceInfo/user_name", (Object)Resource.Type.UserAuthenticationSource, (Object)"AuthenticationSourceInfo/source_id");
    @Inject
    private Users users;

    public UserAuthenticationSourceResourceProvider() {
        super(Resource.Type.UserAuthenticationSource, PROPERTY_IDS, KEY_PROPERTY_IDS);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_USERS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredGetAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        final HashSet<UserAuthenticationSourceRequest> requests = new HashSet<UserAuthenticationSourceRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                UserAuthenticationSourceResourceProvider.this.createUserAuthenticationSources(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserAuthenticationSourceRequest> requests = new HashSet<UserAuthenticationSourceRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(null));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<UserAuthenticationSourceResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<UserAuthenticationSourceResponse>>(){

            @Override
            public Set<UserAuthenticationSourceResponse> invoke() throws OBDPException, AuthorizationException {
                return UserAuthenticationSourceResourceProvider.this.getUserAuthenticationSources(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (UserAuthenticationSourceResponse response : responses) {
            resources.add(this.toResource(response, requestedIds));
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserAuthenticationSourceRequest> requests = new HashSet<UserAuthenticationSourceRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(request.getProperties().iterator().next(), predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                UserAuthenticationSourceResourceProvider.this.updateUserAuthenticationSources(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<UserAuthenticationSourceRequest> requests = new HashSet<UserAuthenticationSourceRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        this.modifyResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                UserAuthenticationSourceResourceProvider.this.deleteUserAuthenticationSources(requests);
                return null;
            }
        });
        return this.getRequestStatus(null);
    }

    private UserAuthenticationSourceRequest getRequest(Map<String, Object> properties) {
        String oldKey;
        String key;
        UserAuthenticationType authenticationType;
        Long sourceId;
        String username;
        if (properties == null) {
            username = null;
            sourceId = null;
            authenticationType = null;
            key = null;
            oldKey = null;
        } else {
            username = (String)properties.get(AUTHENTICATION_USER_NAME_PROPERTY_ID);
            key = (String)properties.get(AUTHENTICATION_KEY_PROPERTY_ID);
            oldKey = (String)properties.get(AUTHENTICATION_OLD_KEY_PROPERTY_ID);
            String tmp = (String)properties.get(AUTHENTICATION_AUTHENTICATION_SOURCE_ID_PROPERTY_ID);
            sourceId = StringUtils.isEmpty((String)tmp) ? null : Long.valueOf(Long.parseLong(tmp));
            tmp = (String)properties.get(AUTHENTICATION_AUTHENTICATION_TYPE_PROPERTY_ID);
            authenticationType = StringUtils.isEmpty((String)tmp) ? null : UserAuthenticationType.valueOf(tmp.trim().toUpperCase());
        }
        return new UserAuthenticationSourceRequest(username, sourceId, authenticationType, key, oldKey);
    }

    private void createUserAuthenticationSources(Set<UserAuthenticationSourceRequest> requests) throws OBDPException {
        for (UserAuthenticationSourceRequest request : requests) {
            String username = request.getUsername();
            if (StringUtils.isEmpty((String)username)) {
                throw new OBDPException("Username must be supplied.");
            }
            UserAuthenticationType authenticationType = request.getAuthenticationType();
            if (authenticationType == null) {
                throw new OBDPException("A value authentication type must be supplied.");
            }
            UserEntity userEntity = this.users.getUserEntity(username);
            if (userEntity == null) {
                throw new OBDPException("There is no user with the supplied username");
            }
            this.users.addAuthentication(userEntity, authenticationType, request.getKey());
        }
    }

    private Set<UserAuthenticationSourceResponse> getUserAuthenticationSources(Set<UserAuthenticationSourceRequest> requests) throws OBDPException, AuthorizationException {
        HashSet<UserAuthenticationSourceResponse> responses = new HashSet<UserAuthenticationSourceResponse>();
        for (UserAuthenticationSourceRequest request : requests) {
            Collection<UserAuthenticationEntity> authenticationEntities;
            String requestedUsername = request.getUsername();
            String authenticatedUsername = AuthorizationHelper.getAuthenticatedName();
            if (!AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS)) {
                if (null == requestedUsername) {
                    requestedUsername = authenticatedUsername;
                } else if (!requestedUsername.equalsIgnoreCase(authenticatedUsername)) {
                    throw new AuthorizationException();
                }
            }
            if ((authenticationEntities = this.users.getUserAuthenticationEntities(requestedUsername, request.getAuthenticationType())) == null) continue;
            for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
                responses.add(this.createUserAuthenticationSourceResponse(authenticationEntity));
            }
        }
        return responses;
    }

    private void deleteUserAuthenticationSources(Set<UserAuthenticationSourceRequest> requests) throws OBDPException, AuthorizationException {
        for (UserAuthenticationSourceRequest r : requests) {
            String username = r.getUsername();
            Long sourceId = r.getSourceId();
            if (StringUtils.isEmpty((String)username) || sourceId == null) continue;
            this.users.removeAuthentication(username, sourceId);
        }
    }

    private void updateUserAuthenticationSources(Set<UserAuthenticationSourceRequest> requests) throws AuthorizationException, OBDPException {
        Integer authenticatedUserId = AuthorizationHelper.getAuthenticatedId();
        for (UserAuthenticationSourceRequest request : requests) {
            String requestedUsername = request.getUsername();
            UserEntity userEntity = this.users.getUserEntity(requestedUsername);
            if (null == userEntity) continue;
            boolean isSelf = authenticatedUserId.equals(userEntity.getUserId());
            if (!isSelf && !AuthorizationHelper.isAuthorized(ResourceType.OBDP, null, RoleAuthorization.OBDP_MANAGE_USERS)) {
                throw new AuthorizationException("You are not authorized perform this operation");
            }
            UserAuthenticationEntity userAuthenticationEntity = null;
            Long sourceId = request.getSourceId();
            if (sourceId != null) {
                List<UserAuthenticationEntity> authenticationEntities = userEntity.getAuthenticationEntities();
                for (UserAuthenticationEntity authenticationEntity : authenticationEntities) {
                    if (!sourceId.equals(authenticationEntity.getUserAuthenticationId())) continue;
                    userAuthenticationEntity = authenticationEntity;
                    break;
                }
            }
            if (userAuthenticationEntity == null) {
                throw new ResourceNotFoundException("The requested authentication source was not found.");
            }
            if (request.getAuthenticationType() != null && request.getAuthenticationType() != userAuthenticationEntity.getAuthenticationType()) {
                throw new ResourceNotFoundException("The requested authentication source was not found - mismatch on authentication type");
            }
            this.users.modifyAuthentication(userAuthenticationEntity, request.getOldKey(), request.getKey(), isSelf);
        }
    }

    private UserAuthenticationSourceResponse createUserAuthenticationSourceResponse(UserAuthenticationEntity entity) {
        return new UserAuthenticationSourceResponse(entity.getUser().getUserName(), entity.getUserAuthenticationId(), entity.getAuthenticationType(), entity.getAuthenticationKey(), new Date(entity.getCreateTime()), new Date(entity.getUpdateTime()));
    }

    private Resource toResource(UserAuthenticationSourceResponse response, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.UserAuthenticationSource);
        UserAuthenticationSourceResourceProvider.setResourceProperty(resource, AUTHENTICATION_USER_NAME_PROPERTY_ID, response.getUserName(), requestedIds);
        UserAuthenticationSourceResourceProvider.setResourceProperty(resource, AUTHENTICATION_AUTHENTICATION_SOURCE_ID_PROPERTY_ID, response.getSourceId(), requestedIds);
        UserAuthenticationSourceResourceProvider.setResourceProperty(resource, AUTHENTICATION_AUTHENTICATION_TYPE_PROPERTY_ID, response.getAuthenticationType().name(), requestedIds);
        UserAuthenticationSourceResourceProvider.setResourceProperty(resource, AUTHENTICATION_CREATED_PROPERTY_ID, response.getCreateTime(), requestedIds);
        UserAuthenticationSourceResourceProvider.setResourceProperty(resource, AUTHENTICATION_UPDATED_PROPERTY_ID, response.getUpdateTime(), requestedIds);
        return resource;
    }
}

