/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.TaskResourceProvider;
import id.onyx.obdp.server.controller.internal.UpgradeSummary;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.state.Cluster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class UpgradeSummaryResourceProvider
extends AbstractControllerResourceProvider {
    protected static final String UPGRADE_SUMMARY_CLUSTER_NAME = "UpgradeSummary/cluster_name";
    protected static final String UPGRADE_SUMMARY_REQUEST_ID = "UpgradeSummary/request_id";
    protected static final String UPGRADE_SUMMARY_FAIL_REASON = PropertyHelper.getPropertyId("UpgradeSummary", "fail_reason");
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("UpgradeSummary/request_id", "UpgradeSummary/cluster_name"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static Map<String, String> TASK_MAPPED_IDS = new HashMap<String, String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    private static UpgradeDAO s_upgradeDAO = null;
    @Inject
    private static HostRoleCommandDAO s_hostRoleCommandDAO = null;
    @Inject
    private static UpgradeHelper s_upgradeHelper;
    private static final Logger LOG;

    public UpgradeSummaryResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.UpgradeSummary, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Resource only supports GET operation.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            Cluster cluster;
            String clusterName = (String)propertyMap.get(UPGRADE_SUMMARY_CLUSTER_NAME);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("The cluster name is required when querying for upgrades");
            }
            try {
                cluster = this.getManagementController().getClusters().getCluster(clusterName);
            }
            catch (OBDPException e) {
                throw new NoSuchResourceException(String.format("Cluster %s could not be loaded", clusterName));
            }
            List<Object> upgrades = new ArrayList();
            String upgradeRequestIdStr = (String)propertyMap.get(UPGRADE_SUMMARY_REQUEST_ID);
            if (null != upgradeRequestIdStr) {
                UpgradeEntity upgrade = s_upgradeDAO.findUpgradeByRequestId(Long.valueOf(upgradeRequestIdStr));
                if (null != upgrade) {
                    upgrades.add(upgrade);
                }
            } else {
                upgrades = s_upgradeDAO.findUpgrades(cluster.getClusterId());
            }
            for (UpgradeEntity upgradeEntity : upgrades) {
                ResourceImpl resource = new ResourceImpl(Resource.Type.UpgradeSummary);
                Long upgradeRequestId = upgradeEntity.getRequestId();
                UpgradeSummaryResourceProvider.setResourceProperty(resource, UPGRADE_SUMMARY_CLUSTER_NAME, clusterName, requestPropertyIds);
                UpgradeSummaryResourceProvider.setResourceProperty(resource, UPGRADE_SUMMARY_REQUEST_ID, upgradeEntity.getRequestId(), requestPropertyIds);
                HostRoleCommandEntity mostRecentFailure = s_hostRoleCommandDAO.findMostRecentFailure(upgradeRequestId);
                String displayText = null;
                HostRoleCommandEntity failedTask = null;
                if (mostRecentFailure != null) {
                    UpgradeSummary summary = new UpgradeSummary(mostRecentFailure);
                    displayText = summary.getDisplayText();
                    failedTask = summary.getFailedTask();
                    Resource taskResource = s_upgradeHelper.getTaskResource(clusterName, failedTask.getRequestId(), failedTask.getStageId(), failedTask.getTaskId());
                    if (taskResource != null) {
                        for (Map.Entry<String, String> property : TASK_MAPPED_IDS.entrySet()) {
                            String taskPropertyId = property.getKey();
                            String upgradeSummaryPropertyId = property.getValue();
                            UpgradeSummaryResourceProvider.setResourceProperty(resource, upgradeSummaryPropertyId, taskResource.getPropertyValue(taskPropertyId), requestPropertyIds);
                        }
                    }
                }
                UpgradeSummaryResourceProvider.setResourceProperty(resource, UPGRADE_SUMMARY_FAIL_REASON, displayText, requestPropertyIds);
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Resource only supports GET operation.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Resource only supports GET operation.");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    static {
        PROPERTY_IDS.add(UPGRADE_SUMMARY_CLUSTER_NAME);
        PROPERTY_IDS.add(UPGRADE_SUMMARY_REQUEST_ID);
        PROPERTY_IDS.add(UPGRADE_SUMMARY_FAIL_REASON);
        for (String p : TaskResourceProvider.PROPERTY_IDS) {
            TASK_MAPPED_IDS.put(p, p.replace("Tasks/", "UpgradeSummary/failed_task/"));
        }
        PROPERTY_IDS.addAll(TASK_MAPPED_IDS.values());
        KEY_PROPERTY_IDS.put(Resource.Type.UpgradeSummary, UPGRADE_SUMMARY_REQUEST_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, UPGRADE_SUMMARY_CLUSTER_NAME);
        LOG = LoggerFactory.getLogger(UpgradeSummaryResourceProvider.class);
    }
}

