/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.persist.Transactional;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.Role;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.ActionManager;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.actionmanager.RequestFactory;
import id.onyx.obdp.server.actionmanager.Stage;
import id.onyx.obdp.server.actionmanager.StageFactory;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.cleanup.ClasspathScannerUtils;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.ActionExecutionContext;
import id.onyx.obdp.server.controller.ExecuteCommandJson;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.KerberosHelperImpl;
import id.onyx.obdp.server.controller.OBDPActionExecutionHelper;
import id.onyx.obdp.server.controller.OBDPCustomCommandExecutionHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.UpdateConfigurationPolicy;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.internal.RequestResourceFilter;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.events.UpdateEventType;
import id.onyx.obdp.server.events.UpgradeUpdateEvent;
import id.onyx.obdp.server.events.publishers.STOMPUpdatePublisher;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.RequestDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.orm.entities.RequestEntity;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeHistoryEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.serveraction.ServerAction;
import id.onyx.obdp.server.serveraction.kerberos.KerberosOperationException;
import id.onyx.obdp.server.serveraction.upgrades.PluginUpgradeServerAction;
import id.onyx.obdp.server.stack.upgrade.AddComponentTask;
import id.onyx.obdp.server.stack.upgrade.ConfigUpgradePack;
import id.onyx.obdp.server.stack.upgrade.ConfigureTask;
import id.onyx.obdp.server.stack.upgrade.CreateAndConfigureTask;
import id.onyx.obdp.server.stack.upgrade.Direction;
import id.onyx.obdp.server.stack.upgrade.ManualTask;
import id.onyx.obdp.server.stack.upgrade.ServerSideActionTask;
import id.onyx.obdp.server.stack.upgrade.Task;
import id.onyx.obdp.server.stack.upgrade.UpdateStackGrouping;
import id.onyx.obdp.server.stack.upgrade.UpgradePack;
import id.onyx.obdp.server.stack.upgrade.UpgradeScope;
import id.onyx.obdp.server.stack.upgrade.orchestrate.StageWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.TaskWrapper;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContext;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeContextFactory;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeGroupHolder;
import id.onyx.obdp.server.stack.upgrade.orchestrate.UpgradeHelper;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.svccomphost.ServiceComponentHostServerActionEvent;
import id.onyx.obdp.spi.upgrade.UpgradeAction;
import id.onyx.obdp.spi.upgrade.UpgradeType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class UpgradeResourceProvider
extends AbstractControllerResourceProvider {
    public static final String UPGRADE_CLUSTER_NAME = "Upgrade/cluster_name";
    public static final String UPGRADE_REPO_VERSION_ID = "Upgrade/repository_version_id";
    public static final String UPGRADE_TYPE = "Upgrade/upgrade_type";
    public static final String UPGRADE_PACK = "Upgrade/pack";
    public static final String UPGRADE_ID = "Upgrade/upgrade_id";
    public static final String UPGRADE_REQUEST_ID = "Upgrade/request_id";
    public static final String UPGRADE_ASSOCIATED_VERSION = "Upgrade/associated_version";
    public static final String UPGRADE_VERSIONS = "Upgrade/versions";
    public static final String UPGRADE_DIRECTION = "Upgrade/direction";
    public static final String UPGRADE_DOWNGRADE_ALLOWED = "Upgrade/downgrade_allowed";
    public static final String UPGRADE_REQUEST_STATUS = "Upgrade/request_status";
    public static final String UPGRADE_SUSPENDED = "Upgrade/suspended";
    public static final String UPGRADE_ABORT_REASON = "Upgrade/abort_reason";
    public static final String UPGRADE_SKIP_PREREQUISITE_CHECKS = "Upgrade/skip_prerequisite_checks";
    public static final String UPGRADE_FAIL_ON_CHECK_WARNINGS = "Upgrade/fail_on_check_warnings";
    public static final String UPGRADE_SKIP_FAILURES = "Upgrade/skip_failures";
    public static final String UPGRADE_SKIP_SC_FAILURES = "Upgrade/skip_service_check_failures";
    public static final String UPGRADE_SKIP_MANUAL_VERIFICATION = "Upgrade/skip_manual_verification";
    public static final String UPGRADE_HOST_ORDERED_HOSTS = "Upgrade/host_order";
    public static final String UPGRADE_REVERT_UPGRADE_ID = "Upgrade/revert_upgrade_id";
    protected static final String EXECUTE_TASK_ROLE = "ru_execute_tasks";
    private static final String REQUEST_CONTEXT_ID = "Upgrade/request_context";
    private static final String REQUEST_TYPE_ID = "Upgrade/type";
    private static final String REQUEST_CREATE_TIME_ID = "Upgrade/create_time";
    private static final String REQUEST_START_TIME_ID = "Upgrade/start_time";
    private static final String REQUEST_END_TIME_ID = "Upgrade/end_time";
    private static final String REQUEST_EXCLUSIVE_ID = "Upgrade/exclusive";
    protected static final String REQUEST_PROGRESS_PERCENT_ID = "Upgrade/progress_percent";
    private static final String REQUEST_STATUS_PROPERTY_ID = "Upgrade/request_status";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("Upgrade/request_id", "Upgrade/cluster_name"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final String DEFAULT_REASON_TEMPLATE = "Aborting upgrade %s";
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    static UpgradeDAO s_upgradeDAO;
    @Inject
    private static Provider<OBDPMetaInfo> s_metaProvider;
    @Inject
    private static Provider<RequestFactory> s_requestFactory;
    @Inject
    private static Provider<StageFactory> s_stageFactory;
    @Inject
    private static Provider<Clusters> clusters;
    @Inject
    private static Provider<OBDPActionExecutionHelper> s_actionExecutionHelper;
    @Inject
    private static Provider<OBDPCustomCommandExecutionHelper> s_commandExecutionHelper;
    @Inject
    private static RequestDAO s_requestDAO;
    @Inject
    private static HostRoleCommandDAO s_hostRoleCommandDAO;
    @Inject
    private static UpgradeHelper s_upgradeHelper;
    @Inject
    private static Configuration s_configuration;
    @Inject
    private static UpgradeContextFactory s_upgradeContextFactory;
    @Inject
    private STOMPUpdatePublisher STOMPUpdatePublisher;
    @Inject
    private HostRoleCommandDAO hostRoleCommandDAO;
    @Inject
    private RequestDAO requestDAO;
    @Inject
    private static Provider<KerberosHelper> s_kerberosHelper;
    private static final Logger LOG;

    @Inject
    public UpgradeResourceProvider(@Assisted OBDPManagementController controller) {
        super(Resource.Type.Upgrade, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Cluster cluster;
        Set<Map<String, Object>> requestMaps = request.getProperties();
        if (requestMaps.size() > 1) {
            throw new SystemException("Can only initiate one upgrade per request.");
        }
        final Map<String, Object> requestMap = requestMaps.iterator().next();
        String clusterName = (String)requestMap.get(UPGRADE_CLUSTER_NAME);
        try {
            cluster = ((Clusters)clusters.get()).getCluster(clusterName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(String.format("Cluster %s could not be loaded", clusterName));
        }
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK))) {
            throw new AuthorizationException("The authenticated user does not have authorization to manage upgrade and downgrade");
        }
        UpgradeEntity entity = this.createResources(new AbstractResourceProvider.Command<UpgradeEntity>(){

            @Override
            public UpgradeEntity invoke() throws OBDPException, AuthorizationException {
                UpgradeContext upgradeContext = s_upgradeContextFactory.create(cluster, requestMap);
                try {
                    return UpgradeResourceProvider.this.createUpgrade(upgradeContext);
                }
                catch (Exception e) {
                    LOG.error("Error appears during upgrade task submitting", (Throwable)e);
                    ((Clusters)clusters.get()).invalidate(cluster);
                    throw e;
                }
            }
        });
        if (null == entity) {
            throw new SystemException("Could not load upgrade");
        }
        this.notifyCreate(Resource.Type.Upgrade, request);
        ResourceImpl res = new ResourceImpl(Resource.Type.Upgrade);
        res.setProperty(UPGRADE_REQUEST_ID, entity.getRequestId());
        return new RequestStatusImpl(null, Collections.singleton(res));
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> results = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            Cluster cluster;
            String clusterName = (String)propertyMap.get(UPGRADE_CLUSTER_NAME);
            if (null == clusterName || clusterName.isEmpty()) {
                throw new IllegalArgumentException("The cluster name is required when querying for upgrades");
            }
            try {
                cluster = ((Clusters)clusters.get()).getCluster(clusterName);
            }
            catch (OBDPException e) {
                throw new NoSuchResourceException(String.format("Cluster %s could not be loaded", clusterName));
            }
            List<Object> upgrades = new ArrayList();
            String upgradeIdStr = (String)propertyMap.get(UPGRADE_REQUEST_ID);
            if (null != upgradeIdStr) {
                UpgradeEntity upgrade = s_upgradeDAO.findUpgradeByRequestId(Long.valueOf(upgradeIdStr));
                if (null != upgrade) {
                    upgrades.add(upgrade);
                }
            } else {
                upgrades = s_upgradeDAO.findUpgrades(cluster.getClusterId());
            }
            for (UpgradeEntity upgradeEntity : upgrades) {
                Resource r = this.toResource(upgradeEntity, clusterName, requestPropertyIds);
                results.add(r);
                RequestEntity rentity = s_requestDAO.findByPK(upgradeEntity.getRequestId());
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_CONTEXT_ID, rentity.getRequestContext(), requestPropertyIds);
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_TYPE_ID, (Object)rentity.getRequestType(), requestPropertyIds);
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_CREATE_TIME_ID, rentity.getCreateTime(), requestPropertyIds);
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_START_TIME_ID, rentity.getStartTime(), requestPropertyIds);
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_END_TIME_ID, rentity.getEndTime(), requestPropertyIds);
                UpgradeResourceProvider.setResourceProperty(r, REQUEST_EXCLUSIVE_ID, rentity.isExclusive(), requestPropertyIds);
                Map<Long, HostRoleCommandStatusSummaryDTO> summary = s_hostRoleCommandDAO.findAggregateCounts(upgradeEntity.getRequestId());
                CalculatedStatus calc = CalculatedStatus.statusFromStageSummary(summary, summary.keySet());
                if (calc.getStatus() == HostRoleStatus.ABORTED && upgradeEntity.isSuspended()) {
                    double percent = UpgradeResourceProvider.calculateAbortedProgress(summary);
                    UpgradeResourceProvider.setResourceProperty(r, REQUEST_PROGRESS_PERCENT_ID, percent * 100.0, requestPropertyIds);
                } else {
                    UpgradeResourceProvider.setResourceProperty(r, REQUEST_PROGRESS_PERCENT_ID, calc.getPercent(), requestPropertyIds);
                }
                UpgradeResourceProvider.setResourceProperty(r, "Upgrade/request_status", (Object)calc.getStatus(), requestPropertyIds);
            }
        }
        return results;
    }

    public static double calculateAbortedProgress(Map<Long, HostRoleCommandStatusSummaryDTO> summary) {
        HashMap<HostRoleStatus, Integer> countTotals = new HashMap<HostRoleStatus, Integer>();
        int totalTasks = 0;
        for (HostRoleCommandStatusSummaryDTO statusSummary : summary.values()) {
            totalTasks += statusSummary.getTaskTotal();
            for (Map.Entry entry : statusSummary.getCounts().entrySet()) {
                if (!countTotals.containsKey(entry.getKey())) {
                    countTotals.put((HostRoleStatus)((Object)entry.getKey()), 0);
                }
                countTotals.put((HostRoleStatus)((Object)entry.getKey()), (Integer)countTotals.get(entry.getKey()) + (Integer)entry.getValue());
            }
        }
        double percent = 0.0;
        block7: for (HostRoleStatus status : HostRoleStatus.values()) {
            if (!countTotals.containsKey((Object)status)) {
                countTotals.put(status, 0);
            }
            double countValue = ((Integer)countTotals.get((Object)status)).intValue();
            switch (status) {
                case ABORTED: {
                    continue block7;
                }
                case HOLDING: 
                case HOLDING_FAILED: 
                case HOLDING_TIMEDOUT: 
                case IN_PROGRESS: 
                case PENDING: {
                    percent += countValue * 0.35;
                    continue block7;
                }
                case QUEUED: {
                    percent += countValue * 0.09;
                    continue block7;
                }
                default: {
                    if (!status.isCompletedState()) continue block7;
                    percent += countValue / (double)totalTasks;
                }
            }
        }
        return percent;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Cluster cluster;
        Set<Map<String, Object>> requestMaps = request.getProperties();
        if (requestMaps.size() > 1) {
            throw new SystemException("Can only update one upgrade per request.");
        }
        Map<String, Object> propertyMap = requestMaps.iterator().next();
        String clusterName = (String)propertyMap.get(UPGRADE_CLUSTER_NAME);
        try {
            cluster = ((Clusters)clusters.get()).getCluster(clusterName);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(String.format("Cluster %s could not be loaded", clusterName));
        }
        if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK))) {
            throw new AuthorizationException("The authenticated user does not have authorization to manage upgrade and downgrade");
        }
        String requestIdProperty = (String)propertyMap.get(UPGRADE_REQUEST_ID);
        if (null == requestIdProperty) {
            throw new IllegalArgumentException(String.format("%s is required", UPGRADE_REQUEST_ID));
        }
        long requestId = Long.parseLong(requestIdProperty);
        UpgradeEntity upgradeEntity = s_upgradeDAO.findUpgradeByRequestId(requestId);
        if (null == upgradeEntity) {
            String exceptionMessage = MessageFormat.format("The upgrade with request ID {0} was not found", requestIdProperty);
            throw new NoSuchParentResourceException(exceptionMessage);
        }
        ArrayList updatableProperties = Lists.newArrayList((Object[])new String[]{"Upgrade/request_status", UPGRADE_SKIP_FAILURES, UPGRADE_SKIP_SC_FAILURES});
        boolean isRequiredPropertyInRequest = CollectionUtils.containsAny((Collection)updatableProperties, propertyMap.keySet());
        if (!isRequiredPropertyInRequest) {
            String exceptionMessage = MessageFormat.format("At least one of the following properties is required in the request: {0}", StringUtils.join((Collection)updatableProperties, (String)", "));
            throw new IllegalArgumentException(exceptionMessage);
        }
        String requestStatus = (String)propertyMap.get("Upgrade/request_status");
        String skipFailuresRequestProperty = (String)propertyMap.get(UPGRADE_SKIP_FAILURES);
        String skipServiceCheckFailuresRequestProperty = (String)propertyMap.get(UPGRADE_SKIP_SC_FAILURES);
        if (null != requestStatus) {
            HostRoleStatus status = HostRoleStatus.valueOf(requestStatus);
            boolean suspended = false;
            if (status == HostRoleStatus.ABORTED && !propertyMap.containsKey(UPGRADE_SUSPENDED)) {
                throw new IllegalArgumentException(String.format("When changing the state of an upgrade to %s, the %s property is required to be either true or false.", new Object[]{status, UPGRADE_SUSPENDED}));
            }
            if (status == HostRoleStatus.ABORTED) {
                suspended = Boolean.valueOf((String)propertyMap.get(UPGRADE_SUSPENDED));
            }
            try {
                this.setUpgradeRequestStatus(cluster, requestId, status, suspended, propertyMap);
            }
            catch (OBDPException ambariException) {
                throw new SystemException(ambariException.getMessage(), ambariException);
            }
        }
        if (StringUtils.isNotEmpty((String)skipFailuresRequestProperty) || StringUtils.isNotEmpty((String)skipServiceCheckFailuresRequestProperty)) {
            boolean skipFailures = upgradeEntity.isComponentFailureAutoSkipped();
            boolean skipServiceCheckFailures = upgradeEntity.isServiceCheckFailureAutoSkipped();
            if (null != skipFailuresRequestProperty) {
                skipFailures = Boolean.parseBoolean(skipFailuresRequestProperty);
            }
            if (null != skipServiceCheckFailuresRequestProperty) {
                skipServiceCheckFailures = Boolean.parseBoolean(skipServiceCheckFailuresRequestProperty);
            }
            s_hostRoleCommandDAO.updateAutomaticSkipOnFailure(requestId, skipFailures, skipServiceCheckFailures);
            upgradeEntity.setAutoSkipComponentFailures(skipFailures);
            upgradeEntity.setAutoSkipServiceCheckFailures(skipServiceCheckFailures);
            s_upgradeDAO.merge(upgradeEntity);
        }
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Cannot delete Upgrades");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Resource toResource(UpgradeEntity entity, String clusterName, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Upgrade);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_ID, entity.getId(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_CLUSTER_NAME, clusterName, requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_TYPE, entity.getUpgradeType(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_PACK, entity.getUpgradePackage(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_REQUEST_ID, entity.getRequestId(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_DIRECTION, (Object)entity.getDirection(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_SUSPENDED, entity.isSuspended(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_DOWNGRADE_ALLOWED, entity.isDowngradeAllowed(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_SKIP_FAILURES, entity.isComponentFailureAutoSkipped(), requestedIds);
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_SKIP_SC_FAILURES, entity.isServiceCheckFailureAutoSkipped(), requestedIds);
        RepositoryVersionEntity repositoryVersion = entity.getRepositoryVersion();
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_ASSOCIATED_VERSION, repositoryVersion.getVersion(), requestedIds);
        HashMap<String, RepositoryVersions> repositoryVersions = new HashMap<String, RepositoryVersions>();
        for (UpgradeHistoryEntity history : entity.getHistory()) {
            RepositoryVersions serviceVersions = (RepositoryVersions)repositoryVersions.get(history.getServiceName());
            if (null != serviceVersions) continue;
            serviceVersions = new RepositoryVersions(history.getFromReposistoryVersion(), history.getTargetRepositoryVersion());
            repositoryVersions.put(history.getServiceName(), serviceVersions);
        }
        UpgradeResourceProvider.setResourceProperty(resource, UPGRADE_VERSIONS, repositoryVersions, requestedIds);
        return resource;
    }

    private void injectVariables(ConfigHelper configHelper, Cluster cluster, UpgradeItemEntity upgradeItem) {
        String regexp = "(\\{\\{.*?\\}\\})";
        String task = upgradeItem.getTasks();
        if (task != null && !task.isEmpty()) {
            Matcher m = Pattern.compile("(\\{\\{.*?\\}\\})").matcher(task);
            while (m.find()) {
                String origVar = m.group(1);
                String configValue = configHelper.getPlaceholderValueFromDesiredConfigurations(cluster, origVar);
                if (null != configValue) {
                    task = task.replace(origVar, configValue);
                    continue;
                }
                LOG.error("Unable to retrieve value for {}", (Object)origVar);
            }
            upgradeItem.setTasks(task);
        }
    }

    protected UpgradeEntity createUpgrade(UpgradeContext upgradeContext) throws OBDPException, AuthorizationException {
        UpgradePack pack = upgradeContext.getUpgradePack();
        Cluster cluster = upgradeContext.getCluster();
        Direction direction = upgradeContext.getDirection();
        ConfigHelper configHelper = this.getManagementController().getConfigHelper();
        List<UpgradeGroupHolder> groups = s_upgradeHelper.createSequence(pack, upgradeContext);
        if (groups.isEmpty()) {
            throw new OBDPException("There are no groupings available");
        }
        if (pack.getType() == UpgradeType.NON_ROLLING) {
            boolean foundUpdateDesiredRepositoryIdGrouping = false;
            for (UpgradeGroupHolder group : groups) {
                if (group.groupClass != UpdateStackGrouping.class) continue;
                foundUpdateDesiredRepositoryIdGrouping = true;
                break;
            }
            if (!foundUpdateDesiredRepositoryIdGrouping) {
                throw new OBDPException(String.format("Express upgrade packs are required to have a group of type %s. The upgrade pack %s is missing this grouping.", "update-stack", pack.getName()));
            }
        }
        ArrayList<UpgradeGroupEntity> groupEntities = new ArrayList<UpgradeGroupEntity>();
        RequestStageContainer req = this.createRequest(upgradeContext);
        UpgradeEntity upgrade = new UpgradeEntity();
        upgrade.setRepositoryVersion(upgradeContext.getRepositoryVersion());
        upgrade.setClusterId(cluster.getClusterId());
        upgrade.setDirection(direction);
        upgrade.setUpgradePackage(pack.getName());
        upgrade.setUpgradePackStackId(pack.getOwnerStackId());
        upgrade.setUpgradeType(pack.getType());
        upgrade.setAutoSkipComponentFailures(upgradeContext.isComponentFailureAutoSkipped());
        upgrade.setAutoSkipServiceCheckFailures(upgradeContext.isServiceCheckFailureAutoSkipped());
        upgrade.setDowngradeAllowed(upgradeContext.isDowngradeAllowed());
        upgrade.setOrchestration(upgradeContext.getOrchestrationType());
        this.addComponentHistoryToUpgrade(cluster, upgrade, upgradeContext);
        if (pack.getType() == UpgradeType.ROLLING || pack.getType() == UpgradeType.HOST_ORDERED) {
            Object targetStack;
            if (direction == Direction.UPGRADE) {
                targetStack = upgradeContext.getRepositoryVersion().getStack();
                cluster.setDesiredStackVersion(new StackId(((StackEntity)targetStack).getStackName(), ((StackEntity)targetStack).getStackVersion()));
            }
            s_upgradeHelper.updateDesiredRepositoriesAndConfigs(upgradeContext);
            s_upgradeHelper.publishDesiredRepositoriesUpdates(upgradeContext);
            if (direction == Direction.DOWNGRADE) {
                targetStack = upgradeContext.getCluster().getCurrentStackVersion();
                cluster.setDesiredStackVersion((StackId)targetStack);
            }
        }
        ConfigUpgradePack configUpgradePack = ConfigurationPackBuilder.build(upgradeContext);
        StackId effectiveStack = upgradeContext.getTargetStack();
        if (upgradeContext.getType() == UpgradeType.NON_ROLLING) {
            effectiveStack = upgradeContext.getSourceStack();
        }
        for (UpgradeGroupHolder group : groups) {
            if (upgradeContext.getType() == UpgradeType.NON_ROLLING && UpdateStackGrouping.class.equals(group.groupClass)) {
                effectiveStack = upgradeContext.getTargetStack();
            }
            ArrayList<UpgradeItemEntity> itemEntities = new ArrayList<UpgradeItemEntity>();
            block8: for (StageWrapper wrapper : group.items) {
                switch (wrapper.getType()) {
                    case SERVER_SIDE_ACTION: {
                        for (TaskWrapper taskWrapper : wrapper.getTasks()) {
                            for (Task task : taskWrapper.getTasks()) {
                                if (upgradeContext.isManualVerificationAutoSkipped() && task.getType() == Task.Type.MANUAL) continue;
                                UpgradeItemEntity itemEntity = new UpgradeItemEntity();
                                itemEntity.setText(wrapper.getText());
                                itemEntity.setTasks(wrapper.getTasksJson());
                                itemEntity.setHosts(wrapper.getHostsJson());
                                this.injectVariables(configHelper, cluster, itemEntity);
                                if (!this.makeServerSideStage(group, upgradeContext, effectiveStack, req, itemEntity, (ServerSideActionTask)task, configUpgradePack)) continue;
                                itemEntities.add(itemEntity);
                            }
                        }
                        continue block8;
                    }
                    case REGENERATE_KEYTABS: {
                        try {
                            int stageCount = req.getStages().size();
                            HashMap<String, String> requestProperties = new HashMap<String, String>();
                            requestProperties.put(KerberosHelperImpl.SupportedCustomOperation.REGENERATE_KEYTABS.name().toLowerCase(), "missing");
                            requestProperties.put("allow_retry_on_failure", Boolean.TRUE.toString().toLowerCase());
                            requestProperties.put("config_update_policy", UpdateConfigurationPolicy.NEW_AND_IDENTITIES.name());
                            req = ((KerberosHelper)s_kerberosHelper.get()).executeCustomOperations(cluster, requestProperties, req, null);
                            List<Stage> stages = req.getStages();
                            int newStageCount = stages.size();
                            for (int i = stageCount; i < newStageCount; ++i) {
                                Stage stage = stages.get(i);
                                stage.setSkippable(group.skippable);
                                stage.setAutoSkipFailureSupported(group.supportsAutoSkipOnFailure);
                                UpgradeItemEntity itemEntity = new UpgradeItemEntity();
                                itemEntity.setStageId(stage.getStageId());
                                itemEntity.setText(stage.getRequestContext());
                                itemEntity.setTasks(wrapper.getTasksJson());
                                itemEntity.setHosts(wrapper.getHostsJson());
                                itemEntities.add(itemEntity);
                                this.injectVariables(configHelper, cluster, itemEntity);
                            }
                            continue block8;
                        }
                        catch (KerberosOperationException kerberosOperationException) {
                            throw new OBDPException("Unable to build keytab regeneration stage", (Throwable)kerberosOperationException);
                        }
                    }
                    default: {
                        UpgradeItemEntity itemEntity = new UpgradeItemEntity();
                        itemEntity.setText(wrapper.getText());
                        itemEntity.setTasks(wrapper.getTasksJson());
                        itemEntity.setHosts(wrapper.getHostsJson());
                        itemEntities.add(itemEntity);
                        this.injectVariables(configHelper, cluster, itemEntity);
                        this.createStage(group, upgradeContext, effectiveStack, req, itemEntity, wrapper);
                        break;
                    }
                }
            }
            if (itemEntities.isEmpty()) continue;
            UpgradeGroupEntity groupEntity = new UpgradeGroupEntity();
            groupEntity.setName(group.name);
            groupEntity.setTitle(group.title);
            groupEntity.setItems(itemEntities);
            groupEntities.add(groupEntity);
        }
        upgrade.setUpgradeGroups(groupEntities);
        req.getRequestStatusResponse();
        return this.createUpgradeInsideTransaction(cluster, req, upgrade, upgradeContext);
    }

    @Transactional
    UpgradeEntity createUpgradeInsideTransaction(Cluster cluster, RequestStageContainer request, UpgradeEntity upgradeEntity, UpgradeContext upgradeContext) throws OBDPException {
        if (upgradeContext.isPatchRevert()) {
            UpgradeEntity upgradeBeingReverted = s_upgradeDAO.findUpgrade(upgradeContext.getPatchRevertUpgradeId());
            upgradeBeingReverted.setRevertAllowed(false);
            upgradeBeingReverted = s_upgradeDAO.merge(upgradeBeingReverted);
        }
        request.persist();
        RequestEntity requestEntity = s_requestDAO.findByPK(request.getId());
        upgradeEntity.setRequestEntity(requestEntity);
        s_upgradeDAO.create(upgradeEntity);
        this.STOMPUpdatePublisher.publish(UpgradeUpdateEvent.formFullEvent(s_hostRoleCommandDAO, s_requestDAO, upgradeEntity, UpdateEventType.CREATE));
        cluster.setUpgradeEntity(upgradeEntity);
        return upgradeEntity;
    }

    private RequestStageContainer createRequest(UpgradeContext upgradeContext) throws OBDPException {
        ActionManager actionManager = this.getManagementController().getActionManager();
        RequestStageContainer requestStages = new RequestStageContainer(actionManager.getNextRequestId(), null, (RequestFactory)s_requestFactory.get(), actionManager);
        Direction direction = upgradeContext.getDirection();
        RepositoryVersionEntity repositoryVersion = upgradeContext.getRepositoryVersion();
        requestStages.setRequestContext(String.format("%s %s %s", direction.getVerb(true), direction.getPreposition(), repositoryVersion.getVersion()));
        return requestStages;
    }

    private void createStage(UpgradeGroupHolder group, UpgradeContext context, StackId stackId, RequestStageContainer request, UpgradeItemEntity entity, StageWrapper wrapper) throws OBDPException {
        boolean skippable = group.skippable;
        boolean supportsAutoSkipOnFailure = group.supportsAutoSkipOnFailure;
        boolean allowRetry = group.allowRetry;
        switch (wrapper.getType()) {
            case CONFIGURE: 
            case START: 
            case STOP: 
            case RESTART: {
                this.makeCommandStage(context, request, stackId, entity, wrapper, skippable, supportsAutoSkipOnFailure, allowRetry);
                break;
            }
            case UPGRADE_TASKS: {
                this.makeActionStage(context, request, stackId, entity, wrapper, skippable, supportsAutoSkipOnFailure, allowRetry);
                break;
            }
            case SERVICE_CHECK: {
                this.makeServiceCheckStage(context, request, stackId, entity, wrapper, skippable, supportsAutoSkipOnFailure, allowRetry);
                break;
            }
        }
    }

    private void applyAdditionalParameters(StageWrapper wrapper, Map<String, String> commandParams) {
        if (wrapper.getParams() != null) {
            for (Map.Entry<String, String> pair : wrapper.getParams().entrySet()) {
                if (commandParams.containsKey(pair.getKey())) continue;
                commandParams.put(pair.getKey(), pair.getValue());
            }
        }
    }

    private void makeActionStage(UpgradeContext context, RequestStageContainer request, StackId stackId, UpgradeItemEntity entity, StageWrapper wrapper, boolean skippable, boolean supportsAutoSkipOnFailure, boolean allowRetry) throws OBDPException {
        if (0 == wrapper.getHosts().size()) {
            throw new OBDPException(String.format("Cannot create action for '%s' with no hosts", wrapper.getText()));
        }
        Cluster cluster = context.getCluster();
        LOG.debug("Analyzing upgrade item {} with tasks: {}.", (Object)entity.getText(), (Object)entity.getTasks());
        String serviceName = null;
        String componentName = null;
        if (wrapper.getTasks() != null && wrapper.getTasks().size() > 0 && wrapper.getTasks().get(0).getService() != null) {
            TaskWrapper taskWrapper = wrapper.getTasks().get(0);
            serviceName = taskWrapper.getService();
            componentName = taskWrapper.getComponent();
        }
        Map<String, String> params = this.getNewParameterMap(request, context);
        params.put("tasks", entity.getTasks());
        if (context.isScoped(UpgradeScope.COMPLETE) && null == componentName) {
            if (context.getDirection().isUpgrade()) {
                params.put("version", context.getRepositoryVersion().getVersion());
            } else {
                UpgradeEntity lastUpgrade = s_upgradeDAO.findLastUpgradeForCluster(cluster.getClusterId(), Direction.UPGRADE);
                UpgradeHistoryEntity lastHistory = lastUpgrade.getHistory().iterator().next();
                params.put("version", lastHistory.getFromReposistoryVersion().getVersion());
            }
        }
        this.applyAdditionalParameters(wrapper, params);
        RequestResourceFilter filter = new RequestResourceFilter(serviceName, componentName, new ArrayList<String>(wrapper.getHosts()));
        ActionExecutionContext actionContext = this.buildActionExecutionContext(cluster, context, EXECUTE_TASK_ROLE, stackId, Collections.singletonList(filter), params, allowRetry, wrapper.getMaxTimeout(s_configuration));
        ExecuteCommandJson jsons = ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).getCommandJson(actionContext, cluster, stackId, null);
        Stage stage = ((StageFactory)s_stageFactory.get()).createNew(request.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), entity.getText(), jsons.getCommandParamsForStage(), jsons.getHostParamsForStage());
        stage.setSkippable(skippable);
        stage.setAutoSkipFailureSupported(supportsAutoSkipOnFailure);
        long stageId = request.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        stage.setStageId(stageId);
        entity.setStageId(stageId);
        ((OBDPActionExecutionHelper)s_actionExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, null);
        for (Map<String, HostRoleCommand> map : stage.getHostRoleCommands().values()) {
            for (HostRoleCommand hrc : map.values()) {
                hrc.setCommandDetail(entity.getText());
            }
        }
        request.addStages(Collections.singletonList(stage));
    }

    private void makeCommandStage(UpgradeContext context, RequestStageContainer request, StackId stackId, UpgradeItemEntity entity, StageWrapper wrapper, boolean skippable, boolean supportsAutoSkipOnFailure, boolean allowRetry) throws OBDPException {
        Cluster cluster = context.getCluster();
        ArrayList<RequestResourceFilter> filters = new ArrayList<RequestResourceFilter>();
        for (TaskWrapper tw : wrapper.getTasks()) {
            String serviceName = tw.getService();
            String componentName = tw.getComponent();
            filters.add(new RequestResourceFilter(serviceName, componentName, new ArrayList<String>(tw.getHosts())));
        }
        String function = null;
        switch (wrapper.getType()) {
            case CONFIGURE: 
            case START: 
            case STOP: 
            case RESTART: {
                function = wrapper.getType().name();
                break;
            }
            default: {
                function = "UNKNOWN";
            }
        }
        Map<String, String> commandParams = this.getNewParameterMap(request, context);
        this.applyAdditionalParameters(wrapper, commandParams);
        ActionExecutionContext actionContext = this.buildActionExecutionContext(cluster, context, function, stackId, filters, commandParams, allowRetry, wrapper.getMaxTimeout(s_configuration));
        actionContext.setIsFutureCommand(true);
        ExecuteCommandJson jsons = ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).getCommandJson(actionContext, cluster, stackId, null);
        Stage stage = ((StageFactory)s_stageFactory.get()).createNew(request.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), entity.getText(), jsons.getCommandParamsForStage(), jsons.getHostParamsForStage());
        stage.setSkippable(skippable);
        stage.setAutoSkipFailureSupported(supportsAutoSkipOnFailure);
        long stageId = request.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        stage.setStageId(stageId);
        entity.setStageId(stageId);
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("command", function);
        if (allowRetry && context.getType() == UpgradeType.HOST_ORDERED) {
            requestParams.put("command_retry_enabled", Boolean.TRUE.toString().toLowerCase());
        }
        ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, requestParams, jsons);
        request.addStages(Collections.singletonList(stage));
    }

    private void makeServiceCheckStage(UpgradeContext context, RequestStageContainer request, StackId stackId, UpgradeItemEntity entity, StageWrapper wrapper, boolean skippable, boolean supportsAutoSkipOnFailure, boolean allowRetry) throws OBDPException {
        ArrayList<RequestResourceFilter> filters = new ArrayList<RequestResourceFilter>();
        for (TaskWrapper tw : wrapper.getTasks()) {
            List<String> hosts = tw.getHosts().stream().collect(Collectors.toList());
            filters.add(new RequestResourceFilter(tw.getService(), "", hosts));
        }
        Cluster cluster = context.getCluster();
        Map<String, String> commandParams = this.getNewParameterMap(request, context);
        this.applyAdditionalParameters(wrapper, commandParams);
        ActionExecutionContext actionContext = this.buildActionExecutionContext(cluster, context, "SERVICE_CHECK", stackId, filters, commandParams, allowRetry, wrapper.getMaxTimeout(s_configuration));
        actionContext.setAutoSkipFailures(context.isServiceCheckFailureAutoSkipped());
        ExecuteCommandJson jsons = ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).getCommandJson(actionContext, cluster, stackId, null);
        Stage stage = ((StageFactory)s_stageFactory.get()).createNew(request.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), entity.getText(), jsons.getCommandParamsForStage(), jsons.getHostParamsForStage());
        stage.setSkippable(skippable);
        stage.setAutoSkipFailureSupported(supportsAutoSkipOnFailure);
        long stageId = request.getLastStageId() + 1L;
        if (0L == stageId) {
            stageId = 1L;
        }
        stage.setStageId(stageId);
        entity.setStageId(stageId);
        Map<String, String> requestParams = this.getNewParameterMap(request, context);
        ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).addExecutionCommandsToStage(actionContext, stage, requestParams, jsons);
        request.addStages(Collections.singletonList(stage));
    }

    private boolean makeServerSideStage(UpgradeGroupHolder group, UpgradeContext context, StackId stackId, RequestStageContainer request, UpgradeItemEntity entity, ServerSideActionTask task, ConfigUpgradePack configUpgradePack) throws OBDPException {
        String classToSchedule;
        Stage stage;
        Object itemDetail;
        Map<String, String> commandParams;
        Cluster cluster;
        block21: {
            cluster = context.getCluster();
            UpgradePack upgradePack = context.getUpgradePack();
            commandParams = this.getNewParameterMap(request, context);
            commandParams.put("upgrade_pack", upgradePack.getName());
            itemDetail = entity.getText();
            Object stageText = StringUtils.abbreviate((String)entity.getText(), (int)255);
            boolean process = true;
            switch (task.getType()) {
                case SERVER_ACTION: 
                case MANUAL: {
                    ServerSideActionTask serverTask = task;
                    if (null != serverTask.summary) {
                        stageText = serverTask.summary;
                    }
                    if (task.getType() == Task.Type.MANUAL) {
                        ManualTask mt = (ManualTask)task;
                        if (StringUtils.isNotBlank((String)mt.structuredOut)) {
                            commandParams.put("structured_out", mt.structuredOut);
                        }
                    }
                    if (serverTask.messages.isEmpty()) break;
                    JsonArray messageArray = new JsonArray();
                    for (String message : serverTask.messages) {
                        JsonObject messageObj = new JsonObject();
                        messageObj.addProperty("message", message);
                        messageArray.add((JsonElement)messageObj);
                    }
                    itemDetail = messageArray.toString();
                    entity.setText((String)itemDetail);
                    itemDetail = StringUtils.join(serverTask.messages, (String)" ");
                    break;
                }
                case CONFIGURE: {
                    ConfigureTask ct = (ConfigureTask)task;
                    if (context.getOrchestrationType().isRevertable() && !ct.supportsPatch) {
                        process = false;
                    }
                    Map<String, String> configurationChanges = ct.getConfigurationChanges(cluster, configUpgradePack);
                    commandParams.putAll(configurationChanges);
                    String configType = configurationChanges.get("configure-task-config-type");
                    itemDetail = null != configType ? String.format("Updating configuration %s", configType) : "Skipping Configuration Task " + StringUtils.defaultString((String)ct.id, (String)"(missing id)");
                    entity.setText((String)itemDetail);
                    String configureTaskSummary = ct.getSummary(configUpgradePack);
                    if (null != configureTaskSummary) {
                        stageText = configureTaskSummary;
                        break;
                    }
                    stageText = itemDetail;
                    break;
                }
                case CREATE_AND_CONFIGURE: {
                    ConfigureTask ct = (CreateAndConfigureTask)task;
                    if (context.getOrchestrationType().isRevertable() && !((CreateAndConfigureTask)ct).supportsPatch) {
                        process = false;
                    }
                    Map<String, String> configurationChanges = ct.getConfigurationChanges(cluster, configUpgradePack);
                    commandParams.putAll(configurationChanges);
                    String configType = configurationChanges.get("configure-task-config-type");
                    itemDetail = null != configType ? String.format("Updating configuration %s", configType) : "Skipping Configuration Task " + StringUtils.defaultString((String)((CreateAndConfigureTask)ct).id, (String)"(missing id)");
                    entity.setText((String)itemDetail);
                    String configureTaskSummary = ct.getSummary(configUpgradePack);
                    if (null != configureTaskSummary) {
                        stageText = configureTaskSummary;
                        break;
                    }
                    stageText = itemDetail;
                    break;
                }
                case ADD_COMPONENT: {
                    AddComponentTask addComponentTask = (AddComponentTask)task;
                    String serializedTask = addComponentTask.toJson();
                    commandParams.put("add-component-task", serializedTask);
                    break;
                }
            }
            if (!process) {
                return false;
            }
            ActionExecutionContext actionContext = this.buildActionExecutionContext(cluster, context, Role.AMBARI_SERVER_ACTION.toString(), stackId, Collections.emptyList(), commandParams, group.allowRetry, -1);
            ExecuteCommandJson jsons = ((OBDPCustomCommandExecutionHelper)s_commandExecutionHelper.get()).getCommandJson(actionContext, cluster, context.getRepositoryVersion().getStackId(), null);
            stage = ((StageFactory)s_stageFactory.get()).createNew(request.getId(), "/tmp/obdp", cluster.getClusterName(), cluster.getClusterId(), (String)stageText, jsons.getCommandParamsForStage(), jsons.getHostParamsForStage());
            stage.setSkippable(group.skippable);
            stage.setAutoSkipFailureSupported(group.supportsAutoSkipOnFailure);
            long stageId = request.getLastStageId() + 1L;
            if (0L == stageId) {
                stageId = 1L;
            }
            stage.setStageId(stageId);
            entity.setStageId(stageId);
            Map<String, String> taskParameters = task.getParameters();
            commandParams.putAll(taskParameters);
            StackInfo stackInfo = ((OBDPMetaInfo)s_metaProvider.get()).getStack(stackId);
            ClassLoader classLoader = stackInfo.getLibraryClassLoader();
            if (null == classLoader) {
                classLoader = ClasspathScannerUtils.class.getClassLoader();
            }
            String taskClass = task.getImplementationClass();
            try {
                Class<?> clazz = classLoader.loadClass(taskClass);
                if (UpgradeAction.class.isAssignableFrom(clazz)) {
                    classToSchedule = PluginUpgradeServerAction.class.getName();
                    commandParams.put("WRAPPED_CLASS_NAME", taskClass);
                    break block21;
                }
                if (ServerAction.class.isAssignableFrom(clazz)) {
                    classToSchedule = task.getImplementationClass();
                    break block21;
                }
                throw new OBDPException("The class " + taskClass + " was not able to be scheduled during the upgrade because it is not compatible");
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Unable to load {} specified in the upgrade pack", (Object)taskClass, (Object)cnfe);
                throw new OBDPException("The class " + taskClass + " was not able to be scheduled during the upgrade because it was not found");
            }
        }
        stage.addServerActionCommand(classToSchedule, this.getManagementController().getAuthName(), Role.AMBARI_SERVER_ACTION, RoleCommand.EXECUTE, cluster.getClusterName(), new ServiceComponentHostServerActionEvent(null, System.currentTimeMillis()), commandParams, (String)itemDetail, null, s_configuration.getDefaultServerTaskTimeout(), group.allowRetry, context.isComponentFailureAutoSkipped());
        request.addStages(Collections.singletonList(stage));
        return true;
    }

    private Map<String, String> getNewParameterMap(RequestStageContainer requestStageContainer, UpgradeContext context) {
        Map<String, String> parameters = context.getInitializedCommandParameters();
        parameters.put("request_id", String.valueOf(requestStageContainer.getId()));
        return parameters;
    }

    @Transactional
    void setUpgradeRequestStatus(Cluster cluster, long requestId, HostRoleStatus status, boolean suspended, Map<String, Object> propertyMap) throws OBDPException {
        if (status != HostRoleStatus.ABORTED && status != HostRoleStatus.PENDING) {
            throw new IllegalArgumentException(String.format("Cannot set status %s, only %s is allowed", new Object[]{status, EnumSet.of(HostRoleStatus.ABORTED, HostRoleStatus.PENDING)}));
        }
        String reason = (String)propertyMap.get(UPGRADE_ABORT_REASON);
        if (null == reason) {
            reason = String.format(DEFAULT_REASON_TEMPLATE, requestId);
        }
        Map<Long, HostRoleCommandStatusSummaryDTO> aggregateCounts = s_hostRoleCommandDAO.findAggregateCounts(requestId);
        CalculatedStatus calculatedStatus = CalculatedStatus.statusFromStageSummary(aggregateCounts, aggregateCounts.keySet());
        HostRoleStatus internalStatus = calculatedStatus.getStatus();
        if (HostRoleStatus.PENDING == status && internalStatus != HostRoleStatus.ABORTED && internalStatus != HostRoleStatus.IN_PROGRESS) {
            throw new IllegalArgumentException(String.format("Can only set status to %s when the upgrade is %s (currently %s)", new Object[]{status, HostRoleStatus.ABORTED, internalStatus}));
        }
        ActionManager actionManager = this.getManagementController().getActionManager();
        if (HostRoleStatus.ABORTED == status && !internalStatus.isCompletedState()) {
            actionManager.cancelRequest(requestId, reason);
            UpgradeEntity upgradeEntity = s_upgradeDAO.findUpgradeByRequestId(requestId);
            if (suspended) {
                upgradeEntity.setSuspended(suspended);
                upgradeEntity = s_upgradeDAO.merge(upgradeEntity);
                this.STOMPUpdatePublisher.publish(UpgradeUpdateEvent.formUpdateEvent(this.hostRoleCommandDAO, this.requestDAO, upgradeEntity));
            } else {
                cluster.setUpgradeEntity(null);
            }
        } else if (status == HostRoleStatus.PENDING) {
            ArrayList<Long> taskIds = new ArrayList<Long>();
            List<HostRoleCommandEntity> hrcEntities = s_hostRoleCommandDAO.findByRequestIdAndStatuses(requestId, Sets.newHashSet((Object[])new HostRoleStatus[]{HostRoleStatus.ABORTED}));
            for (HostRoleCommandEntity hrcEntity : hrcEntities) {
                taskIds.add(hrcEntity.getTaskId());
            }
            actionManager.resubmitTasks(taskIds);
            UpgradeEntity lastUpgradeItemForCluster = s_upgradeDAO.findLastUpgradeOrDowngradeForCluster(cluster.getClusterId());
            lastUpgradeItemForCluster.setSuspended(false);
            lastUpgradeItemForCluster = s_upgradeDAO.merge(lastUpgradeItemForCluster);
            this.STOMPUpdatePublisher.publish(UpgradeUpdateEvent.formUpdateEvent(this.hostRoleCommandDAO, this.requestDAO, lastUpgradeItemForCluster));
        }
    }

    private void addComponentHistoryToUpgrade(Cluster cluster, UpgradeEntity upgrade, UpgradeContext upgradeContext) throws OBDPException {
        Set<String> services = upgradeContext.getSupportedServices();
        for (String serviceName : services) {
            Service service = cluster.getService(serviceName);
            Map<String, ServiceComponent> componentMap = service.getServiceComponents();
            for (ServiceComponent component : componentMap.values()) {
                UpgradeHistoryEntity history = new UpgradeHistoryEntity();
                history.setUpgrade(upgrade);
                history.setServiceName(serviceName);
                history.setComponentName(component.getName());
                if (upgradeContext.getDirection() == Direction.UPGRADE) {
                    history.setFromRepositoryVersion(component.getDesiredRepositoryVersion());
                    history.setTargetRepositoryVersion(upgradeContext.getRepositoryVersion());
                } else {
                    RepositoryVersionEntity targetRepositoryVersion = upgradeContext.getTargetRepositoryVersion(serviceName);
                    history.setFromRepositoryVersion(upgradeContext.getRepositoryVersion());
                    history.setTargetRepositoryVersion(targetRepositoryVersion);
                }
                upgrade.addHistory(history);
            }
        }
    }

    private ActionExecutionContext buildActionExecutionContext(Cluster cluster, UpgradeContext context, String role, StackId stackId, List<RequestResourceFilter> resourceFilters, Map<String, String> commandParams, boolean allowRetry, int timeout) {
        ActionExecutionContext actionContext = new ActionExecutionContext(cluster.getClusterName(), role, resourceFilters, commandParams);
        actionContext.setStackId(stackId);
        actionContext.setTimeout(timeout);
        actionContext.setRetryAllowed(allowRetry);
        actionContext.setAutoSkipFailures(context.isComponentFailureAutoSkipped());
        actionContext.setMaintenanceModeHostExcluded(true);
        return actionContext;
    }

    static {
        s_metaProvider = null;
        clusters = null;
        s_requestDAO = null;
        s_hostRoleCommandDAO = null;
        PROPERTY_IDS.add(UPGRADE_CLUSTER_NAME);
        PROPERTY_IDS.add(UPGRADE_REPO_VERSION_ID);
        PROPERTY_IDS.add(UPGRADE_TYPE);
        PROPERTY_IDS.add(UPGRADE_PACK);
        PROPERTY_IDS.add(UPGRADE_ID);
        PROPERTY_IDS.add(UPGRADE_REQUEST_ID);
        PROPERTY_IDS.add(UPGRADE_ASSOCIATED_VERSION);
        PROPERTY_IDS.add(UPGRADE_VERSIONS);
        PROPERTY_IDS.add(UPGRADE_DIRECTION);
        PROPERTY_IDS.add(UPGRADE_DOWNGRADE_ALLOWED);
        PROPERTY_IDS.add(UPGRADE_SUSPENDED);
        PROPERTY_IDS.add(UPGRADE_SKIP_FAILURES);
        PROPERTY_IDS.add(UPGRADE_SKIP_SC_FAILURES);
        PROPERTY_IDS.add(UPGRADE_SKIP_MANUAL_VERIFICATION);
        PROPERTY_IDS.add(UPGRADE_SKIP_PREREQUISITE_CHECKS);
        PROPERTY_IDS.add(UPGRADE_FAIL_ON_CHECK_WARNINGS);
        PROPERTY_IDS.add(UPGRADE_HOST_ORDERED_HOSTS);
        PROPERTY_IDS.add(UPGRADE_REVERT_UPGRADE_ID);
        PROPERTY_IDS.add(REQUEST_CONTEXT_ID);
        PROPERTY_IDS.add(REQUEST_CREATE_TIME_ID);
        PROPERTY_IDS.add(REQUEST_END_TIME_ID);
        PROPERTY_IDS.add(REQUEST_EXCLUSIVE_ID);
        PROPERTY_IDS.add(REQUEST_PROGRESS_PERCENT_ID);
        PROPERTY_IDS.add(REQUEST_START_TIME_ID);
        PROPERTY_IDS.add("Upgrade/request_status");
        PROPERTY_IDS.add(REQUEST_TYPE_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Upgrade, UPGRADE_REQUEST_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, UPGRADE_CLUSTER_NAME);
        LOG = LoggerFactory.getLogger(UpgradeResourceProvider.class);
    }

    static final class RepositoryVersions {
        @JsonProperty(value="from_repository_id")
        final long fromRepositoryId;
        @JsonProperty(value="from_repository_version")
        final String fromRepositoryVersion;
        @JsonProperty(value="to_repository_id")
        final long toRepositoryId;
        @JsonProperty(value="to_repository_version")
        final String toRepositoryVersion;

        public RepositoryVersions(RepositoryVersionEntity from, RepositoryVersionEntity to) {
            this.fromRepositoryId = from.getId();
            this.fromRepositoryVersion = from.getVersion();
            this.toRepositoryId = to.getId();
            this.toRepositoryVersion = to.getVersion();
        }
    }

    public static final class ConfigurationPackBuilder {
        public static ConfigUpgradePack build(UpgradeContext cx) {
            UpgradePack upgradePack = cx.getUpgradePack();
            StackId stackId = cx.getDirection() == Direction.UPGRADE ? cx.getStackIdFromVersions(cx.getSourceVersions()) : cx.getStackIdFromVersions(cx.getTargetVersions());
            List<UpgradePack.IntermediateStack> intermediateStacks = upgradePack.getIntermediateStacks();
            ConfigUpgradePack configUpgradePack = ((OBDPMetaInfo)s_metaProvider.get()).getConfigUpgradePack(stackId.getStackName(), stackId.getStackVersion());
            if (null != intermediateStacks) {
                ArrayList configPacksToMerge = Lists.newArrayList((Object[])new ConfigUpgradePack[]{configUpgradePack});
                for (UpgradePack.IntermediateStack intermediateStack : intermediateStacks) {
                    ConfigUpgradePack intermediateConfigUpgradePack = ((OBDPMetaInfo)s_metaProvider.get()).getConfigUpgradePack(stackId.getStackName(), intermediateStack.version);
                    configPacksToMerge.add(intermediateConfigUpgradePack);
                }
                configUpgradePack = ConfigUpgradePack.merge(configPacksToMerge);
            }
            return configUpgradePack;
        }
    }
}

