/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.StageResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.StageDAO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.orm.entities.StageEntityPK;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.utils.SecretReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class UpgradeItemResourceProvider
extends ReadOnlyResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeItemResourceProvider.class);
    public static final String UPGRADE_CLUSTER_NAME = "UpgradeItem/cluster_name";
    public static final String UPGRADE_REQUEST_ID = "UpgradeItem/request_id";
    public static final String UPGRADE_GROUP_ID = "UpgradeItem/group_id";
    public static final String UPGRADE_ITEM_STAGE_ID = "UpgradeItem/stage_id";
    public static final String UPGRADE_ITEM_TEXT = "UpgradeItem/text";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("UpgradeItem/request_id", "UpgradeItem/stage_id"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    private static Map<String, String> STAGE_MAPPED_IDS = new HashMap<String, String>();
    @Inject
    private static UpgradeDAO s_dao;
    @Inject
    private static StageDAO s_stageDao;
    @Inject
    private static HostRoleCommandDAO s_hostRoleCommandDAO;

    UpgradeItemResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.UpgradeItem, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            String statusPropertyId;
            Map<String, Object> updateProperties = iterator.next();
            String stageStatus = (String)updateProperties.get(statusPropertyId = STAGE_MAPPED_IDS.get("Stage/status"));
            if (null == stageStatus) {
                throw new IllegalArgumentException("Upgrade items can only have their status changed.");
            }
            HostRoleStatus desiredStatus = HostRoleStatus.valueOf(stageStatus);
            Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
            for (Resource resource : resources) {
                Cluster cluster;
                String clusterName = (String)resource.getPropertyValue(UPGRADE_CLUSTER_NAME);
                try {
                    cluster = this.getManagementController().getClusters().getCluster(clusterName);
                }
                catch (OBDPException e) {
                    throw new NoSuchParentResourceException(String.format("Cluster %s could not be loaded", clusterName));
                }
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), EnumSet.of(RoleAuthorization.CLUSTER_UPGRADE_DOWNGRADE_STACK))) {
                    throw new AuthorizationException("The authenticated user does not have authorization to manage upgrade and downgrade");
                }
                Long requestId = (Long)resource.getPropertyValue(UPGRADE_REQUEST_ID);
                Long stageId = (Long)resource.getPropertyValue(UPGRADE_ITEM_STAGE_ID);
                StageEntityPK primaryKey = new StageEntityPK();
                primaryKey.setRequestId(requestId);
                primaryKey.setStageId(stageId);
                StageEntity stageEntity = s_stageDao.findByPK(primaryKey);
                if (null == stageEntity) {
                    LOG.warn("Unable to change the status of request {} and stage {} to {} because it does not exist", new Object[]{requestId, stageId, desiredStatus});
                    return this.getRequestStatus(null);
                }
                s_stageDao.updateStageStatus(stageEntity, desiredStatus, this.getManagementController().getActionManager());
            }
        }
        this.notifyUpdate(Resource.Type.UpgradeItem, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String requestIdStr = (String)propertyMap.get(UPGRADE_REQUEST_ID);
            String groupIdStr = (String)propertyMap.get(UPGRADE_GROUP_ID);
            String stageIdStr = (String)propertyMap.get(UPGRADE_ITEM_STAGE_ID);
            if (null == requestIdStr || requestIdStr.isEmpty()) {
                throw new IllegalArgumentException("The upgrade id is required when querying for upgrades");
            }
            if (null == groupIdStr || groupIdStr.isEmpty()) {
                throw new IllegalArgumentException("The upgrade group id is required when querying for upgrades");
            }
            Long requestId = Long.valueOf(requestIdStr);
            Long groupId = Long.valueOf(groupIdStr);
            Long stageId = null;
            if (null != stageIdStr) {
                stageId = Long.valueOf(stageIdStr);
            }
            List<Object> entities = new ArrayList<UpgradeItemEntity>();
            if (null == stageId) {
                UpgradeGroupEntity group = s_dao.findUpgradeGroup(groupId);
                if (null == group || null == group.getItems()) {
                    throw new NoSuchResourceException(String.format("Cannot load upgrade for %s", requestIdStr));
                }
                entities = group.getItems();
            } else {
                UpgradeItemEntity entity = s_dao.findUpgradeItemByRequestAndStage(requestId, stageId);
                if (null != entity) {
                    entities.add(entity);
                }
            }
            Map<Long, HostRoleCommandStatusSummaryDTO> requestAggregateCounts = s_hostRoleCommandDAO.findAggregateCounts(requestId);
            HashMap<Long, Map<Long, HostRoleCommandStatusSummaryDTO>> cache = new HashMap<Long, Map<Long, HostRoleCommandStatusSummaryDTO>>();
            cache.put(requestId, requestAggregateCounts);
            for (UpgradeItemEntity upgradeItemEntity : entities) {
                Resource upgradeItemResource = this.toResource(upgradeItemEntity, requestPropertyIds);
                StageEntityPK stagePrimaryKey = new StageEntityPK();
                stagePrimaryKey.setRequestId(requestId);
                stagePrimaryKey.setStageId(upgradeItemEntity.getStageId());
                StageEntity stageEntity = s_stageDao.findByPK(stagePrimaryKey);
                Resource stageResource = StageResourceProvider.toResource(cache, stageEntity, StageResourceProvider.PROPERTY_IDS);
                for (String propertyId : StageResourceProvider.PROPERTY_IDS) {
                    Object value = stageResource.getPropertyValue(propertyId);
                    if (StageResourceProvider.PROPERTIES_TO_MASK_PASSWORD_IN.contains(propertyId) && value.getClass().equals(String.class) && !StringUtils.isBlank((String)((String)value))) {
                        value = SecretReference.maskPasswordInPropertyMap((String)value);
                    }
                    UpgradeItemResourceProvider.setResourceProperty(upgradeItemResource, STAGE_MAPPED_IDS.get(propertyId), value, requestPropertyIds);
                }
                results.add(upgradeItemResource);
            }
        }
        return results;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Resource toResource(UpgradeItemEntity item, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.UpgradeItem);
        UpgradeGroupEntity group = item.getGroupEntity();
        UpgradeEntity upgrade = group.getUpgradeEntity();
        UpgradeItemResourceProvider.setResourceProperty(resource, UPGRADE_REQUEST_ID, upgrade.getRequestId(), requestedIds);
        UpgradeItemResourceProvider.setResourceProperty(resource, UPGRADE_GROUP_ID, group.getId(), requestedIds);
        UpgradeItemResourceProvider.setResourceProperty(resource, UPGRADE_ITEM_STAGE_ID, item.getStageId(), requestedIds);
        UpgradeItemResourceProvider.setResourceProperty(resource, UPGRADE_ITEM_TEXT, item.getText(), requestedIds);
        return resource;
    }

    static {
        PROPERTY_IDS.add(UPGRADE_ITEM_STAGE_ID);
        PROPERTY_IDS.add(UPGRADE_GROUP_ID);
        PROPERTY_IDS.add(UPGRADE_REQUEST_ID);
        PROPERTY_IDS.add(UPGRADE_ITEM_TEXT);
        for (String p : StageResourceProvider.PROPERTY_IDS) {
            STAGE_MAPPED_IDS.put(p, p.replace("Stage/", "UpgradeItem/"));
        }
        PROPERTY_IDS.addAll(STAGE_MAPPED_IDS.values());
        KEY_PROPERTY_IDS.put(Resource.Type.UpgradeItem, UPGRADE_ITEM_STAGE_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.UpgradeGroup, UPGRADE_GROUP_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Upgrade, UPGRADE_REQUEST_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, UPGRADE_CLUSTER_NAME);
    }
}

