/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.UpgradeDAO;
import id.onyx.obdp.server.orm.entities.UpgradeEntity;
import id.onyx.obdp.server.orm.entities.UpgradeGroupEntity;
import id.onyx.obdp.server.orm.entities.UpgradeItemEntity;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class UpgradeGroupResourceProvider
extends AbstractControllerResourceProvider {
    protected static final String UPGRADE_REQUEST_ID = "UpgradeGroup/request_id";
    protected static final String UPGRADE_GROUP_ID = "UpgradeGroup/group_id";
    protected static final String UPGRADE_CLUSTER_NAME = "UpgradeGroup/cluster_name";
    protected static final String UPGRADE_GROUP_NAME = "UpgradeGroup/name";
    protected static final String UPGRADE_GROUP_TITLE = "UpgradeGroup/title";
    protected static final String UPGRADE_GROUP_PROGRESS_PERCENT = "UpgradeGroup/progress_percent";
    protected static final String UPGRADE_GROUP_STATUS = "UpgradeGroup/status";
    protected static final String UPGRADE_GROUP_DISPLAY_STATUS = "UpgradeGroup/display_status";
    protected static final String UPGRADE_GROUP_TOTAL_TASKS = "UpgradeGroup/total_task_count";
    protected static final String UPGRADE_GROUP_IN_PROGRESS_TASKS = "UpgradeGroup/in_progress_task_count";
    protected static final String UPGRADE_GROUP_COMPLETED_TASKS = "UpgradeGroup/completed_task_count";
    private static final Set<String> PK_PROPERTY_IDS = new HashSet<String>(Arrays.asList("UpgradeGroup/request_id", "UpgradeGroup/group_id"));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    @Inject
    private static UpgradeDAO m_dao = null;
    @Inject
    private static HostRoleCommandDAO s_hostRoleCommandDao;

    UpgradeGroupResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.UpgradeGroup, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new SystemException("Upgrade Groups can only be created with an upgrade");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> results = new HashSet<Resource>();
        Set<String> requestPropertyIds = this.getRequestPropertyIds(request, predicate);
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            String upgradeIdStr = (String)propertyMap.get(UPGRADE_REQUEST_ID);
            if (null == upgradeIdStr || upgradeIdStr.isEmpty()) {
                throw new IllegalArgumentException("The upgrade id is required when querying for upgrades");
            }
            Long upgradeId = Long.valueOf(upgradeIdStr);
            UpgradeEntity upgrade = m_dao.findUpgradeByRequestId(upgradeId);
            Long requestId = upgrade.getRequestId();
            List<UpgradeGroupEntity> groups = upgrade.getUpgradeGroups();
            if (null == groups) continue;
            Map<Long, HostRoleCommandStatusSummaryDTO> map = s_hostRoleCommandDao.findAggregateCounts(requestId);
            for (UpgradeGroupEntity group : groups) {
                Resource r = this.toResource(upgrade, group, requestPropertyIds);
                HashSet<Long> stageIds = new HashSet<Long>();
                for (UpgradeItemEntity itemEntity : group.getItems()) {
                    stageIds.add(itemEntity.getStageId());
                }
                this.aggregate(map, r, requestId, stageIds, requestPropertyIds);
                results.add(r);
            }
        }
        return results;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Upgrade groups cannot be modified");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Upgrade groups cannot be removed");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Resource toResource(UpgradeEntity upgrade, UpgradeGroupEntity group, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.UpgradeGroup);
        UpgradeGroupResourceProvider.setResourceProperty(resource, UPGRADE_REQUEST_ID, upgrade.getRequestId(), requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(resource, UPGRADE_GROUP_ID, group.getId(), requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(resource, UPGRADE_GROUP_NAME, group.getName(), requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(resource, UPGRADE_GROUP_TITLE, group.getTitle(), requestedIds);
        return resource;
    }

    private void aggregate(Map<Long, HostRoleCommandStatusSummaryDTO> smap, Resource upgradeGroup, Long requestId, Set<Long> stageIds, Set<String> requestedIds) {
        int size = 0;
        Map<HostRoleStatus, Integer> counts = CalculatedStatus.calculateTaskStatusCounts(smap, stageIds);
        CalculatedStatus stageStatus = CalculatedStatus.statusFromStageSummary(smap, stageIds);
        for (Integer i : counts.values()) {
            size += i.intValue();
        }
        Integer inProgress = 0;
        Integer completed = 0;
        for (Map.Entry<HostRoleStatus, Integer> entry : counts.entrySet()) {
            if (entry.getKey().isCompletedState()) {
                completed = completed + entry.getValue();
                continue;
            }
            if (!entry.getKey().isInProgress()) continue;
            inProgress = inProgress + entry.getValue();
        }
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_TOTAL_TASKS, size, requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_IN_PROGRESS_TASKS, inProgress, requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_COMPLETED_TASKS, completed, requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_STATUS, (Object)stageStatus.getStatus(), requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_DISPLAY_STATUS, (Object)stageStatus.getDisplayStatus(), requestedIds);
        UpgradeGroupResourceProvider.setResourceProperty(upgradeGroup, UPGRADE_GROUP_PROGRESS_PERCENT, stageStatus.getPercent(), requestedIds);
    }

    static {
        PROPERTY_IDS.add(UPGRADE_REQUEST_ID);
        PROPERTY_IDS.add(UPGRADE_GROUP_ID);
        PROPERTY_IDS.add(UPGRADE_GROUP_NAME);
        PROPERTY_IDS.add(UPGRADE_GROUP_TITLE);
        PROPERTY_IDS.add(UPGRADE_GROUP_PROGRESS_PERCENT);
        PROPERTY_IDS.add(UPGRADE_GROUP_STATUS);
        PROPERTY_IDS.add(UPGRADE_GROUP_DISPLAY_STATUS);
        PROPERTY_IDS.add(UPGRADE_GROUP_TOTAL_TASKS);
        PROPERTY_IDS.add(UPGRADE_GROUP_IN_PROGRESS_TASKS);
        PROPERTY_IDS.add(UPGRADE_GROUP_COMPLETED_TASKS);
        KEY_PROPERTY_IDS.put(Resource.Type.UpgradeGroup, UPGRADE_GROUP_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Upgrade, UPGRADE_REQUEST_ID);
    }
}

