/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.BlueprintConfigurationProcessor;
import id.onyx.obdp.server.controller.internal.Stack;
import id.onyx.obdp.server.topology.ClusterTopology;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.validators.UnitValidatedProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apache.commons.lang.StringUtils;

public class UnitUpdater
implements BlueprintConfigurationProcessor.PropertyUpdater {
    private final String serviceName;
    private final String configType;

    public UnitUpdater(String serviceName, String configType) {
        this.serviceName = serviceName;
        this.configType = configType;
    }

    @Override
    public String updateForClusterCreate(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
        Stack stack = topology.getBlueprint().getStack();
        return UnitUpdater.updateForClusterCreate(stack, this.serviceName, this.configType, propertyName, origValue);
    }

    public static String updateForClusterCreate(Stack stack, String serviceName, String configType, String propertyName, String origValue) {
        PropertyUnit stackUnit = PropertyUnit.of(stack, serviceName, configType, propertyName);
        PropertyValue value = PropertyValue.of(propertyName, origValue);
        if (value.hasUnit(stackUnit)) {
            return value.toString();
        }
        if (!value.hasAnyUnit()) {
            return value.withUnit(stackUnit);
        }
        throw new IllegalArgumentException("Property " + propertyName + "=" + origValue + " has an unsupported unit. Stack supported unit is: " + stackUnit + " or no unit");
    }

    public static void updateUnits(Configuration configuration, Stack stack) {
        UnitUpdater.updateAllUnitValidatedProperties(configuration, (property, value) -> UnitUpdater.updateForClusterCreate(stack, property.getServiceName(), property.getConfigType(), property.getPropertyName(), value));
    }

    public static void removeUnits(Configuration configuration, Stack stack) {
        UnitUpdater.updateAllUnitValidatedProperties(configuration, (property, value) -> UnitUpdater.removeStackUnit(stack, property.getServiceName(), property.getConfigType(), property.getPropertyName(), value));
    }

    private static void updateAllUnitValidatedProperties(Configuration configuration, BiFunction<UnitValidatedProperty, String, String> valueUpdater) {
        for (UnitValidatedProperty p : UnitValidatedProperty.ALL) {
            String updatedValue;
            String value;
            if (!configuration.isPropertySet(p.getConfigType(), p.getPropertyName()) || Objects.equals(value = configuration.getPropertyValue(p.getConfigType(), p.getPropertyName()), updatedValue = valueUpdater.apply(p, value))) continue;
            configuration.setProperty(p.getConfigType(), p.getPropertyName(), updatedValue);
        }
    }

    @Override
    public String updateForBlueprintExport(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
        return UnitUpdater.removeStackUnit(topology.getBlueprint().getStack(), this.serviceName, this.configType, propertyName, origValue);
    }

    static String removeStackUnit(Stack stack, String serviceName, String configType, String propertyName, String origValue) {
        PropertyUnit stackUnit = PropertyUnit.of(stack, serviceName, configType, propertyName);
        PropertyValue value = PropertyValue.of(propertyName, origValue);
        return value.withoutUnit(stackUnit);
    }

    @Override
    public Collection<String> getRequiredHostGroups(String propertyName, String origValue, Map<String, Map<String, String>> properties, ClusterTopology topology) {
        return Collections.emptySet();
    }

    public static class PropertyUnit {
        private static final String DEFAULT_UNIT = "m";
        private final String unit;

        public static PropertyUnit of(Stack stack, UnitValidatedProperty property) {
            return PropertyUnit.of(stack, property.getServiceName(), property.getConfigType(), property.getPropertyName());
        }

        public static PropertyUnit of(Stack stack, String serviceName, String configType, String propertyName) {
            return new PropertyUnit(PropertyUnit.stackUnit(stack, serviceName, configType, propertyName).map(PropertyUnit::toJvmUnit).orElse(DEFAULT_UNIT));
        }

        private static Optional<String> stackUnit(Stack stack, String serviceName, String configType, String propertyName) {
            try {
                return Optional.ofNullable(stack.getConfigurationPropertiesWithMetadata(serviceName, configType).get(propertyName).getPropertyValueAttributes().getUnit());
            }
            catch (NullPointerException e) {
                return Optional.empty();
            }
        }

        private static String toJvmUnit(String stackUnit) {
            switch (stackUnit.toLowerCase()) {
                case "mb": {
                    return DEFAULT_UNIT;
                }
                case "gb": {
                    return "g";
                }
                case "b": 
                case "bytes": {
                    return "";
                }
            }
            throw new IllegalArgumentException("Unsupported stack unit: " + stackUnit);
        }

        private PropertyUnit(String unit) {
            this.unit = unit;
        }

        public String toString() {
            return this.unit;
        }
    }

    public static class PropertyValue {
        private final String value;

        public static PropertyValue of(String name, String value) {
            return new PropertyValue(PropertyValue.normalized(name, value));
        }

        private static String normalized(String name, String value) {
            if (StringUtils.isBlank((String)value)) {
                throw new IllegalArgumentException("Missing property value " + name);
            }
            return value.trim().toLowerCase();
        }

        private PropertyValue(String value) {
            this.value = value;
        }

        public boolean hasUnit(PropertyUnit unit) {
            return this.value.endsWith(unit.toString());
        }

        public boolean hasAnyUnit() {
            return PropertyValue.hasAnyUnit(this.value);
        }

        static boolean hasAnyUnit(String value) {
            return !Character.isDigit(value.charAt(value.length() - 1));
        }

        public String withUnit(PropertyUnit unit) {
            return this.value + unit;
        }

        public String withoutUnit(PropertyUnit unit) {
            return this.hasUnit(unit) ? this.value.substring(0, this.value.length() - unit.toString().length()) : this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

