/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.AppCookieManager;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import id.onyx.obdp.spi.net.HttpURLConnectionProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLStreamProvider
implements StreamProvider {
    public static final String COOKIE = "Cookie";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String NEGOTIATE = "Negotiate";
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC_AUTH = "Basic %s";
    private static final Logger LOG = LoggerFactory.getLogger(URLStreamProvider.class);
    private boolean setupTruststoreForHttps;
    private final int connTimeout;
    private final int readTimeout;
    private final String trustStorePath;
    private final String trustStorePassword;
    private final String trustStoreType;
    private volatile SSLSocketFactory sslSocketFactory = null;
    private AppCookieManager appCookieManager = null;

    public URLStreamProvider(int connectionTimeout, int readTimeout, ComponentSSLConfiguration configuration) {
        this(connectionTimeout, readTimeout, configuration.getTruststorePath(), configuration.getTruststorePassword(), configuration.getTruststoreType());
    }

    public URLStreamProvider(int connectionTimeout, int readTimeout, String trustStorePath, String trustStorePassword, String trustStoreType) {
        this.connTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.trustStorePath = trustStorePath;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.setupTruststoreForHttps = true;
    }

    public void setSetupTruststoreForHttps(boolean setupTruststoreForHttps) {
        this.setupTruststoreForHttps = setupTruststoreForHttps;
    }

    public boolean getSetupTruststoreForHttps() {
        return this.setupTruststoreForHttps;
    }

    @Override
    public InputStream readFrom(String spec, String requestMethod, String params) throws IOException {
        return this.processURL(spec, requestMethod, params, null).getInputStream();
    }

    @Override
    public InputStream readFrom(String spec) throws IOException {
        return this.readFrom(spec, "GET", null);
    }

    public HttpURLConnection processURL(String spec, String requestMethod, String body, Map<String, List<String>> headers) throws IOException {
        return this.processURL(spec, requestMethod, body == null ? null : body.getBytes(), headers);
    }

    public HttpURLConnection processURL(String spec, String requestMethod, InputStream body, Map<String, List<String>> headers) throws IOException {
        return this.processURL(spec, requestMethod, body == null ? null : IOUtils.toByteArray((InputStream)body), headers);
    }

    public HttpURLConnection processURL(String spec, String requestMethod, byte[] body, Map<String, List<String>> headers) throws IOException {
        int statusCode;
        if (LOG.isDebugEnabled()) {
            LOG.debug("readFrom spec:{}", (Object)URLCredentialsHider.hideCredentials(spec));
        }
        URL url = new URL(spec);
        HttpURLConnection connection = spec.startsWith("https") && this.setupTruststoreForHttps ? this.getSSLConnection(url) : this.getConnection(url);
        AppCookieManager appCookieManager = this.getAppCookieManager();
        String appCookie = appCookieManager.getCachedAppCookie(spec);
        if (appCookie != null) {
            LOG.debug("Using cached app cookie for URL:{}", (Object)URLCredentialsHider.hideCredentials(spec));
            if (headers == null || headers.isEmpty()) {
                headers = Collections.singletonMap(COOKIE, Collections.singletonList(appCookie));
            } else {
                List<String> cookieList = (headers = new HashMap<String, List<String>>(headers)).get(COOKIE);
                String string = cookieList == null || cookieList.isEmpty() ? null : (String)cookieList.get(0);
                headers.put(COOKIE, Collections.singletonList(URLStreamProvider.appendCookie(string, appCookie)));
            }
        }
        connection.setConnectTimeout(this.connTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setDoOutput(true);
        connection.setRequestMethod(requestMethod);
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                String paramValue = ((List)entry.getValue()).toString();
                connection.setRequestProperty((String)entry.getKey(), paramValue.substring(1, paramValue.length() - 1));
            }
        }
        if (body != null) {
            connection.getOutputStream().write(body);
        }
        if (url.getUserInfo() != null) {
            String basicAuth = String.format(BASIC_AUTH, new String(new Base64().encode(url.getUserInfo().getBytes())));
            connection.setRequestProperty(AUTHORIZATION, basicAuth);
        }
        if ((statusCode = connection.getResponseCode()) == 401) {
            String string = connection.getHeaderField(WWW_AUTHENTICATE);
            if (LOG.isInfoEnabled()) {
                LOG.info("Received WWW-Authentication header:" + string + ", for URL:" + URLCredentialsHider.hideCredentials(spec));
            }
            if (string != null && string.trim().startsWith(NEGOTIATE)) {
                connection = spec.startsWith("https") ? this.getSSLConnection(url) : this.getConnection(url);
                appCookie = appCookieManager.getAppCookie(spec, true);
                connection.setRequestProperty(COOKIE, appCookie);
                connection.setConnectTimeout(this.connTimeout);
                connection.setReadTimeout(this.readTimeout);
                connection.setDoOutput(true);
                return connection;
            }
            LOG.error("Unsupported WWW-Authentication header:" + string + ", for URL:" + URLCredentialsHider.hideCredentials(spec));
            return connection;
        }
        if (statusCode == 404 || statusCode == 403) {
            LOG.error(String.format("Received HTTP %s response from URL: %s", statusCode, URLCredentialsHider.hideCredentials(spec)));
        }
        return connection;
    }

    public synchronized AppCookieManager getAppCookieManager() {
        if (this.appCookieManager == null) {
            this.appCookieManager = new AppCookieManager();
        }
        return this.appCookieManager;
    }

    public static String appendCookie(String cookies, String newCookie) {
        if (cookies == null || cookies.length() == 0) {
            return newCookie;
        }
        return cookies + "; " + newCookie;
    }

    protected HttpURLConnection getConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (!this.setupTruststoreForHttps) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            TrustManager[] trustAllCerts = new TrustManager[]{new TrustAllManager()};
            TrustAllHostnameVerifier hostnameVerifier = new TrustAllHostnameVerifier();
            try {
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                httpsConnection.setSSLSocketFactory(sc.getSocketFactory());
                httpsConnection.setHostnameVerifier(hostnameVerifier);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("Cannot create unverified ssl context.", e);
            }
        }
        return (HttpURLConnection)connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpsURLConnection getSSLConnection(URL url) throws IOException, IllegalStateException {
        if (this.sslSocketFactory == null) {
            URLStreamProvider uRLStreamProvider = this;
            synchronized (uRLStreamProvider) {
                if (this.sslSocketFactory == null) {
                    if (this.trustStorePath == null || this.trustStorePassword == null) {
                        String msg = String.format("Can't get secure connection to %s.  Truststore path or password is not set.", URLCredentialsHider.hideCredentials(url.toString()));
                        LOG.error(msg);
                        throw new IllegalStateException(msg);
                    }
                    try (FileInputStream in = null;){
                        in = new FileInputStream(new File(this.trustStorePath));
                        KeyStore store = KeyStore.getInstance(this.trustStoreType == null ? KeyStore.getDefaultType() : this.trustStoreType);
                        store.load(in, this.trustStorePassword.toCharArray());
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(store);
                        SSLContext context = SSLContext.getInstance("TLS");
                        context.init(null, tmf.getTrustManagers(), null);
                        this.sslSocketFactory = context.getSocketFactory();
                    }
                }
            }
        }
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(this.sslSocketFactory);
        return connection;
    }

    public static class TrustAllManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    public static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static final class AmbariHttpUrlConnectionProvider
    implements HttpURLConnectionProvider {
        private final URLStreamProvider m_streamProvider = new URLStreamProvider(20000, 15000, ComponentSSLConfiguration.instance());

        public HttpURLConnection getConnection(String url, Map<String, List<String>> headers) throws IOException {
            return this.m_streamProvider.processURL(url, "GET", (InputStream)null, headers);
        }
    }
}

