/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.utils.URLCredentialsHider;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLRedirectProvider {
    private static final Logger LOG = LoggerFactory.getLogger(URLRedirectProvider.class);
    private final int connTimeout;
    private final int readTimeout;
    private final boolean skipSslCertificateCheck;

    public URLRedirectProvider(int connectionTimeout, int readTimeout, boolean skipSslCertificateCheck) {
        this.connTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.skipSslCertificateCheck = skipSslCertificateCheck;
    }

    public RequestResult executeGet(String spec) throws IOException {
        try (CloseableHttpClient httpClient = this.buildHttpClient();){
            RequestResult requestResult;
            block13: {
                HttpGet httpGet = new HttpGet(spec);
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.connTimeout).setSocketTimeout(this.readTimeout).build();
                httpGet.setConfig(requestConfig);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try {
                    HttpEntity entity = response.getEntity();
                    InputStream is = entity.getContent();
                    int statusCode = response.getStatusLine().getStatusCode();
                    RequestResult result = new RequestResult(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8), statusCode);
                    if (statusCode == 401 || statusCode == 404 || statusCode == 403) {
                        LOG.error(String.format("Received HTTP '%s' response from URL: '%s'", statusCode, URLCredentialsHider.hideCredentials(spec)));
                    }
                    requestResult = result;
                    if (response == null) break block13;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return requestResult;
        }
    }

    private CloseableHttpClient buildHttpClient() throws OBDPException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (this.skipSslCertificateCheck) {
            SSLContext sslContext;
            try {
                sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new OBDPException("Cannot build null truststore.", (Throwable)e);
            }
            httpClientBuilder.setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build()));
        }
        return httpClientBuilder.build();
    }

    public static class RequestResult {
        private final String content;
        private final int code;

        public RequestResult(String content, int code) {
            this.content = content;
            this.code = code;
        }

        public String getContent() {
            return this.content;
        }

        public int getCode() {
            return this.code;
        }
    }
}

