/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.ThemeInfo;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThemeArtifactResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ThemeArtifactResourceProvider.class);
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "stack_version");
    public static final String STACK_SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "service_name");
    public static final String THEME_FILE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "file_name");
    public static final String THEME_DEFAULT_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "default");
    public static final String THEME_DATA_PROPERTY_ID = PropertyHelper.getPropertyId("ThemeInfo", "theme_data");
    public static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)THEME_FILE_NAME_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Theme, (Object)THEME_FILE_NAME_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)STACK_SERVICE_NAME_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)STACK_NAME_PROPERTY_ID).add((Object)STACK_VERSION_PROPERTY_ID).add((Object)STACK_SERVICE_NAME_PROPERTY_ID).add((Object)THEME_FILE_NAME_PROPERTY_ID).add((Object)THEME_DEFAULT_PROPERTY_ID).add((Object)THEME_DATA_PROPERTY_ID).build();

    protected ThemeArtifactResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Theme, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Creating of themes is not supported");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        resources.addAll(this.getThemes(request, predicate));
        if (resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Themes not found, " + predicate);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Updating of themes is not supported");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Deleting of themes is not supported");
    }

    private Set<Resource> getThemes(Request request, Predicate predicate) throws NoSuchParentResourceException, NoSuchResourceException, UnsupportedPropertyException, SystemException {
        LinkedHashSet<Resource> resources = new LinkedHashSet<Resource>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            StackInfo stackInfo;
            String themeFileName = (String)properties.get(THEME_FILE_NAME_PROPERTY_ID);
            String stackName = (String)properties.get(STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)properties.get(STACK_VERSION_PROPERTY_ID);
            String stackService = (String)properties.get(STACK_SERVICE_NAME_PROPERTY_ID);
            try {
                stackInfo = this.getManagementController().getAmbariMetaInfo().getStack(stackName, stackVersion);
            }
            catch (OBDPException e) {
                throw new NoSuchParentResourceException(String.format("Parent stack resource doesn't exist: stackName='%s', stackVersion='%s'", stackName, stackVersion));
            }
            ArrayList<ServiceInfo> serviceInfoList = new ArrayList<ServiceInfo>();
            if (stackService == null) {
                serviceInfoList.addAll(stackInfo.getServices());
            } else {
                ServiceInfo service = stackInfo.getService(stackService);
                if (service == null) {
                    throw new NoSuchParentResourceException(String.format("Parent stack/service resource doesn't exist: stackName='%s', stackVersion='%s', serviceName='%s'", stackName, stackVersion, stackService));
                }
                serviceInfoList.add(service);
            }
            for (ServiceInfo serviceInfo : serviceInfoList) {
                ArrayList<ThemeInfo> serviceThemes = new ArrayList<ThemeInfo>();
                if (themeFileName != null) {
                    LOG.debug("Getting themes from service {}, themes = {}", (Object)serviceInfo.getName(), serviceInfo.getThemesMap());
                    serviceThemes.add(serviceInfo.getThemesMap().get(themeFileName));
                } else {
                    for (ThemeInfo themeInfo : serviceInfo.getThemesMap().values()) {
                        if (themeInfo.getIsDefault().booleanValue()) {
                            serviceThemes.add(0, themeInfo);
                            continue;
                        }
                        serviceThemes.add(themeInfo);
                    }
                }
                ArrayList<ResourceImpl> serviceResources = new ArrayList<ResourceImpl>();
                for (ThemeInfo themeInfo : serviceThemes) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.Theme);
                    Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, THEME_FILE_NAME_PROPERTY_ID, themeInfo.getFileName(), requestedIds);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, THEME_DEFAULT_PROPERTY_ID, themeInfo.getIsDefault(), requestedIds);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, THEME_DATA_PROPERTY_ID, themeInfo.getThemeMap(), requestedIds);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackName, requestedIds);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackVersion, requestedIds);
                    ThemeArtifactResourceProvider.setResourceProperty(resource, STACK_SERVICE_NAME_PROPERTY_ID, serviceInfo.getName(), requestedIds);
                    serviceResources.add(resource);
                }
                resources.addAll(serviceResources);
            }
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return null;
    }
}

