/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.HostRoleCommand;
import id.onyx.obdp.server.actionmanager.HostRoleCommandFactory;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.entities.HostRoleCommandEntity;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.StageUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class TaskResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TaskResourceProvider.class);
    public static final String TASK_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "cluster_name");
    public static final String TASK_REQUEST_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "request_id");
    public static final String TASK_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "id");
    public static final String TASK_STAGE_ID_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "stage_id");
    public static final String TASK_HOST_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "host_name");
    public static final String TASK_ROLE_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "role");
    public static final String TASK_COMMAND_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "command");
    public static final String TASK_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "status");
    public static final String TASK_EXIT_CODE_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "exit_code");
    public static final String TASK_STDERR_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "stderr");
    public static final String TASK_STOUT_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "stdout");
    public static final String TASK_OUTPUTLOG_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "output_log");
    public static final String TASK_ERRORLOG_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "error_log");
    public static final String TASK_STRUCT_OUT_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "structured_out");
    public static final String TASK_START_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "start_time");
    public static final String TASK_END_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "end_time");
    public static final String TASK_ATTEMPT_CNT_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "attempt_cnt");
    public static final String TASK_COMMAND_DET_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "command_detail");
    public static final String TASK_CUST_CMD_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Tasks", "custom_command_name");
    public static final String TASK_COMMAND_OPS_DISPLAY_NAME = PropertyHelper.getPropertyId("Tasks", "ops_display_name");
    static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> keyPropertyIds;
    @Inject
    static HostRoleCommandDAO s_dao;
    @Inject
    private static HostRoleCommandFactory s_hostRoleCommandFactory;
    @Inject
    static TopologyManager s_topologyManager;
    private static final ObjectMapper mapper;

    TaskResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Task, PROPERTY_IDS, keyPropertyIds, managementController);
    }

    @Override
    public RequestStatus createResources(Request request) {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> results = new LinkedHashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        List<HostRoleCommandEntity> entities = s_dao.findAll(request, predicate);
        String clusterName = null;
        Long requestId = null;
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            clusterName = (String)propertyMap.get(TASK_CLUSTER_NAME_PROPERTY_ID);
            String requestIdStr = (String)propertyMap.get(TASK_REQUEST_ID_PROPERTY_ID);
            requestId = Long.parseLong(requestIdStr);
        }
        ArrayList<HostRoleCommand> commands = new ArrayList<HostRoleCommand>(100);
        if (!entities.isEmpty()) {
            for (HostRoleCommandEntity entity : entities) {
                commands.add(s_hostRoleCommandFactory.createExisting(entity));
            }
        } else if (requestId != null) {
            commands.addAll(s_topologyManager.getTasks(requestId));
        }
        LOG.debug("Retrieved {} commands for request {}", (Object)commands.size(), (Object)request);
        for (HostRoleCommand hostRoleCommand : commands) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Task);
            if (null != clusterName) {
                TaskResourceProvider.setResourceProperty(resource, TASK_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
            }
            TaskResourceProvider.setResourceProperty(resource, TASK_REQUEST_ID_PROPERTY_ID, hostRoleCommand.getRequestId(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_ID_PROPERTY_ID, hostRoleCommand.getTaskId(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_STAGE_ID_PROPERTY_ID, hostRoleCommand.getStageId(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_HOST_NAME_PROPERTY_ID, this.ensureHostname(hostRoleCommand.getHostName()), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_ROLE_PROPERTY_ID, hostRoleCommand.getRole().toString(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_COMMAND_PROPERTY_ID, (Object)hostRoleCommand.getRoleCommand(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_STATUS_PROPERTY_ID, (Object)hostRoleCommand.getStatus(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_EXIT_CODE_PROPERTY_ID, hostRoleCommand.getExitCode(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_STDERR_PROPERTY_ID, hostRoleCommand.getStderr(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_STOUT_PROPERTY_ID, hostRoleCommand.getStdout(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_OUTPUTLOG_PROPERTY_ID, hostRoleCommand.getOutputLog(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_ERRORLOG_PROPERTY_ID, hostRoleCommand.getErrorLog(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_STRUCT_OUT_PROPERTY_ID, this.parseStructuredOutput(hostRoleCommand.getStructuredOut()), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_START_TIME_PROPERTY_ID, hostRoleCommand.getStartTime(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_END_TIME_PROPERTY_ID, hostRoleCommand.getEndTime(), requestedIds);
            TaskResourceProvider.setResourceProperty(resource, TASK_ATTEMPT_CNT_PROPERTY_ID, hostRoleCommand.getAttemptCount(), requestedIds);
            if (hostRoleCommand.getCustomCommandName() != null) {
                TaskResourceProvider.setResourceProperty(resource, TASK_CUST_CMD_NAME_PROPERTY_ID, hostRoleCommand.getCustomCommandName(), requestedIds);
            }
            if (hostRoleCommand.getCommandDetail() == null) {
                TaskResourceProvider.setResourceProperty(resource, TASK_COMMAND_DET_PROPERTY_ID, String.format("%s %s", new Object[]{hostRoleCommand.getRole().toString(), hostRoleCommand.getRoleCommand()}), requestedIds);
            } else {
                TaskResourceProvider.setResourceProperty(resource, TASK_COMMAND_DET_PROPERTY_ID, hostRoleCommand.getCommandDetail(), requestedIds);
            }
            TaskResourceProvider.setResourceProperty(resource, TASK_COMMAND_OPS_DISPLAY_NAME, hostRoleCommand.getOpsDisplayName(), requestedIds);
            results.add(resource);
        }
        return results;
    }

    Map<?, ?> parseStructuredOutput(String structuredOutput) {
        if (null == structuredOutput || structuredOutput.isEmpty()) {
            return null;
        }
        Map result = null;
        try {
            result = (Map)mapper.readValue(structuredOutput, Map.class);
        }
        catch (Exception excepton) {
            LOG.warn("Unable to parse task structured output: {}", (Object)structuredOutput);
        }
        return result;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Not currently supported.");
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected String ensureHostname(String hostName) {
        return hostName == null ? StageUtils.getHostName() : hostName;
    }

    static {
        PROPERTY_IDS.add(TASK_CLUSTER_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_REQUEST_ID_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_ID_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_STAGE_ID_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_HOST_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_ROLE_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_COMMAND_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_STATUS_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_EXIT_CODE_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_STDERR_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_STOUT_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_OUTPUTLOG_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_ERRORLOG_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_STRUCT_OUT_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_START_TIME_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_END_TIME_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_ATTEMPT_CNT_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_COMMAND_DET_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_CUST_CMD_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(TASK_COMMAND_OPS_DISPLAY_NAME);
        keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)TASK_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.Request, (Object)TASK_REQUEST_ID_PROPERTY_ID).put((Object)Resource.Type.Upgrade, (Object)TASK_REQUEST_ID_PROPERTY_ID).put((Object)Resource.Type.Stage, (Object)TASK_STAGE_ID_PROPERTY_ID).put((Object)Resource.Type.UpgradeItem, (Object)TASK_STAGE_ID_PROPERTY_ID).put((Object)Resource.Type.Task, (Object)TASK_ID_PROPERTY_ID).build();
        mapper = new ObjectMapper();
    }
}

