/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.controller.internal.AbstractJDBCResourceProvider;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.jdbc.ConnectionFactory;
import id.onyx.obdp.server.controller.jdbc.JobHistoryPostgresConnectionFactory;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskAttemptResourceProvider
extends AbstractJDBCResourceProvider<TaskAttemptFields> {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptResourceProvider.class);
    protected static final String TASK_ATTEMPT_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "cluster_name");
    protected static final String TASK_ATTEMPT_WORKFLOW_ID_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "workflow_id");
    protected static final String TASK_ATTEMPT_JOB_ID_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "job_id");
    protected static final String TASK_ATTEMPT_ID_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "task_attempt_id");
    protected static final String TASK_ATTEMPT_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "type");
    protected static final String TASK_ATTEMPT_START_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "start_time");
    protected static final String TASK_ATTEMPT_FINISH_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "finish_time");
    protected static final String TASK_ATTEMPT_MAP_FINISH_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "map_finish_time");
    protected static final String TASK_ATTEMPT_SHUFFLE_FINISH_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "shuffle_finish_time");
    protected static final String TASK_ATTEMPT_SORT_FINISH_TIME_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "sort_finish_fime");
    protected static final String TASK_ATTEMPT_INPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "input_bytes");
    protected static final String TASK_ATTEMPT_OUTPUT_BYTES_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "output_bytes");
    protected static final String TASK_ATTEMPT_STATUS_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "status");
    protected static final String TASK_ATTEMPT_LOCALITY_PROPERTY_ID = PropertyHelper.getPropertyId("TaskAttempt", "locality");
    protected TaskAttemptFetcher taskAttemptFetcher;
    protected static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)TASK_ATTEMPT_CLUSTER_NAME_PROPERTY_ID).put((Object)Resource.Type.Workflow, (Object)TASK_ATTEMPT_WORKFLOW_ID_PROPERTY_ID).put((Object)Resource.Type.Job, (Object)TASK_ATTEMPT_JOB_ID_PROPERTY_ID).put((Object)Resource.Type.TaskAttempt, (Object)TASK_ATTEMPT_ID_PROPERTY_ID).build();
    protected static final Set<String> propertyIds = ImmutableSet.of((Object)TASK_ATTEMPT_CLUSTER_NAME_PROPERTY_ID, (Object)TASK_ATTEMPT_WORKFLOW_ID_PROPERTY_ID, (Object)TASK_ATTEMPT_JOB_ID_PROPERTY_ID, (Object)TASK_ATTEMPT_ID_PROPERTY_ID, (Object)TASK_ATTEMPT_TYPE_PROPERTY_ID, (Object)TASK_ATTEMPT_START_TIME_PROPERTY_ID, (Object[])new String[]{TASK_ATTEMPT_FINISH_TIME_PROPERTY_ID, TASK_ATTEMPT_MAP_FINISH_TIME_PROPERTY_ID, TASK_ATTEMPT_SHUFFLE_FINISH_TIME_PROPERTY_ID, TASK_ATTEMPT_SORT_FINISH_TIME_PROPERTY_ID, TASK_ATTEMPT_INPUT_BYTES_PROPERTY_ID, TASK_ATTEMPT_OUTPUT_BYTES_PROPERTY_ID, TASK_ATTEMPT_STATUS_PROPERTY_ID, TASK_ATTEMPT_LOCALITY_PROPERTY_ID});

    protected TaskAttemptResourceProvider() {
        super(propertyIds, keyPropertyIds);
        this.taskAttemptFetcher = new PostgresTaskAttemptFetcher(new JobHistoryPostgresConnectionFactory());
    }

    protected TaskAttemptResourceProvider(Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds, TaskAttemptFetcher taskAttemptFetcher) {
        super(propertyIds, keyPropertyIds);
        this.taskAttemptFetcher = taskAttemptFetcher;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resourceSet = new HashSet<Resource>();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<Map<String, Object>> predicatePropertieSet = this.getPropertyMaps(predicate);
        for (Map<String, Object> predicateProperties : predicatePropertieSet) {
            String clusterName = (String)predicateProperties.get(TASK_ATTEMPT_CLUSTER_NAME_PROPERTY_ID);
            String workflowId = (String)predicateProperties.get(TASK_ATTEMPT_WORKFLOW_ID_PROPERTY_ID);
            String jobId = (String)predicateProperties.get(TASK_ATTEMPT_JOB_ID_PROPERTY_ID);
            String taskAttemptId = (String)predicateProperties.get(TASK_ATTEMPT_ID_PROPERTY_ID);
            resourceSet.addAll(this.taskAttemptFetcher.fetchTaskAttemptDetails(requestedIds, clusterName, workflowId, jobId, taskAttemptId));
        }
        return resourceSet;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public Map<Resource.Type, String> getKeyPropertyIds() {
        return keyPropertyIds;
    }

    @Override
    protected Map<String, TaskAttemptFields> getDBFieldMap() {
        HashMap<String, TaskAttemptFields> dbFields = new HashMap<String, TaskAttemptFields>();
        dbFields.put(TASK_ATTEMPT_JOB_ID_PROPERTY_ID, TaskAttemptFields.JOBID);
        dbFields.put(TASK_ATTEMPT_ID_PROPERTY_ID, TaskAttemptFields.TASKATTEMPTID);
        dbFields.put(TASK_ATTEMPT_TYPE_PROPERTY_ID, TaskAttemptFields.TASKTYPE);
        dbFields.put(TASK_ATTEMPT_START_TIME_PROPERTY_ID, TaskAttemptFields.STARTTIME);
        dbFields.put(TASK_ATTEMPT_FINISH_TIME_PROPERTY_ID, TaskAttemptFields.FINISHTIME);
        dbFields.put(TASK_ATTEMPT_MAP_FINISH_TIME_PROPERTY_ID, TaskAttemptFields.MAPFINISHTIME);
        dbFields.put(TASK_ATTEMPT_SHUFFLE_FINISH_TIME_PROPERTY_ID, TaskAttemptFields.SHUFFLEFINISHTIME);
        dbFields.put(TASK_ATTEMPT_SORT_FINISH_TIME_PROPERTY_ID, TaskAttemptFields.SORTFINISHTIME);
        dbFields.put(TASK_ATTEMPT_INPUT_BYTES_PROPERTY_ID, TaskAttemptFields.INPUTBYTES);
        dbFields.put(TASK_ATTEMPT_OUTPUT_BYTES_PROPERTY_ID, TaskAttemptFields.OUTPUTBYTES);
        dbFields.put(TASK_ATTEMPT_STATUS_PROPERTY_ID, TaskAttemptFields.STATUS);
        dbFields.put(TASK_ATTEMPT_LOCALITY_PROPERTY_ID, TaskAttemptFields.LOCALITY);
        return dbFields;
    }

    protected class PostgresTaskAttemptFetcher
    implements TaskAttemptFetcher {
        private static final String TASK_ATTEMPT_TABLE_NAME = "taskattempt";
        private ConnectionFactory connectionFactory;
        Connection db;
        PreparedStatement ps;

        public PostgresTaskAttemptFetcher(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            this.db = null;
            this.ps = null;
        }

        protected ResultSet getResultSet(Set<String> requestedIds, String workflowId, String jobId, String taskAttemptId) throws SQLException {
            this.db = null;
            this.ps = null;
            this.db = this.connectionFactory.getConnection();
            if (taskAttemptId == null) {
                this.ps = this.db.prepareStatement("SELECT " + TaskAttemptResourceProvider.this.getDBFieldString(requestedIds) + " FROM taskattempt WHERE " + TaskAttemptFields.JOBID + " = ? ");
                this.ps.setString(1, jobId);
            } else {
                this.ps = this.db.prepareStatement("SELECT " + TaskAttemptResourceProvider.this.getDBFieldString(requestedIds) + " FROM taskattempt WHERE " + TaskAttemptFields.TASKATTEMPTID + " = ? ");
                this.ps.setString(1, taskAttemptId);
            }
            return this.ps.executeQuery();
        }

        protected void close() {
            if (this.ps != null) {
                try {
                    this.ps.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing statment", (Throwable)e);
                }
            }
            if (this.db != null) {
                try {
                    this.db.close();
                }
                catch (SQLException e) {
                    LOG.error("Exception while closing connection", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Resource> fetchTaskAttemptDetails(Set<String> requestedIds, String clusterName, String workflowId, String jobId, String taskAttemptId) {
            HashSet<Resource> taskAttempts = new HashSet<Resource>();
            ResultSet rs = null;
            try {
                rs = this.getResultSet(requestedIds, workflowId, jobId, taskAttemptId);
                while (rs.next()) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.TaskAttempt);
                    BaseProvider.setResourceProperty(resource, TASK_ATTEMPT_CLUSTER_NAME_PROPERTY_ID, clusterName, requestedIds);
                    BaseProvider.setResourceProperty(resource, TASK_ATTEMPT_WORKFLOW_ID_PROPERTY_ID, workflowId, requestedIds);
                    TaskAttemptResourceProvider.this.setString(resource, TASK_ATTEMPT_JOB_ID_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setString(resource, TASK_ATTEMPT_ID_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setString(resource, TASK_ATTEMPT_TYPE_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_START_TIME_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_FINISH_TIME_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_MAP_FINISH_TIME_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_SHUFFLE_FINISH_TIME_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_SORT_FINISH_TIME_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_INPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setLong(resource, TASK_ATTEMPT_OUTPUT_BYTES_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setString(resource, TASK_ATTEMPT_STATUS_PROPERTY_ID, rs, requestedIds);
                    TaskAttemptResourceProvider.this.setString(resource, TASK_ATTEMPT_LOCALITY_PROPERTY_ID, rs, requestedIds);
                    taskAttempts.add(resource);
                }
            }
            catch (SQLException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Caught exception getting resource.", (Throwable)e);
                }
                Set<Resource> set = Collections.emptySet();
                return set;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        LOG.error("Exception while closing ResultSet", (Throwable)e);
                    }
                }
                this.close();
            }
            return taskAttempts;
        }
    }

    public static interface TaskAttemptFetcher {
        public Set<Resource> fetchTaskAttemptDetails(Set<String> var1, String var2, String var3, String var4, String var5);
    }

    static enum TaskAttemptFields {
        JOBID,
        TASKATTEMPTID,
        TASKTYPE,
        STARTTIME,
        FINISHTIME,
        MAPFINISHTIME,
        SHUFFLEFINISHTIME,
        SORTFINISHTIME,
        INPUTBYTES,
        OUTPUTBYTES,
        STATUS,
        LOCALITY;

    }
}

