/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.controller.internal.AbstractDRResourceProvider;
import id.onyx.obdp.server.controller.internal.RequestStatusImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.ivory.Cluster;
import id.onyx.obdp.server.controller.ivory.IvoryService;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TargetClusterResourceProvider
extends AbstractDRResourceProvider {
    protected static final String CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Cluster", "name");
    protected static final String CLUSTER_COLO_PROPERTY_ID = PropertyHelper.getPropertyId("Cluster", "colo");
    protected static final String CLUSTER_INTERFACES_PROPERTY_ID = PropertyHelper.getPropertyId("Cluster", "interfaces");
    protected static final String CLUSTER_LOCATIONS_PROPERTY_ID = PropertyHelper.getPropertyId("Cluster", "locations");
    protected static final String CLUSTER_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("Cluster", "properties");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Cluster, (Object)CLUSTER_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{CLUSTER_NAME_PROPERTY_ID, CLUSTER_COLO_PROPERTY_ID, CLUSTER_INTERFACES_PROPERTY_ID, CLUSTER_LOCATIONS_PROPERTY_ID, CLUSTER_PROPERTIES_PROPERTY_ID});

    public TargetClusterResourceProvider(IvoryService ivoryService) {
        super(propertyIds, keyPropertyIds, ivoryService);
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Set<Map<String, Object>> propertiesSet = request.getProperties();
        for (Map<String, Object> propertyMap : propertiesSet) {
            service.submitCluster(TargetClusterResourceProvider.getCluster((String)propertyMap.get(CLUSTER_NAME_PROPERTY_ID), propertyMap));
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        List<String> clusterNames = service.getClusterNames();
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (String clusterName : clusterNames) {
            Cluster cluster = service.getCluster(clusterName);
            ResourceImpl resource = new ResourceImpl(Resource.Type.DRTargetCluster);
            TargetClusterResourceProvider.setResourceProperty(resource, CLUSTER_NAME_PROPERTY_ID, cluster.getName(), requestedIds);
            TargetClusterResourceProvider.setResourceProperty(resource, CLUSTER_COLO_PROPERTY_ID, cluster.getColo(), requestedIds);
            TargetClusterResourceProvider.setResourceProperty(resource, CLUSTER_INTERFACES_PROPERTY_ID, cluster.getInterfaces(), requestedIds);
            TargetClusterResourceProvider.setResourceProperty(resource, CLUSTER_LOCATIONS_PROPERTY_ID, cluster.getLocations(), requestedIds);
            TargetClusterResourceProvider.setResourceProperty(resource, CLUSTER_PROPERTIES_PROPERTY_ID, cluster.getProperties(), requestedIds);
            if (predicate != null && !predicate.evaluate(resource)) continue;
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            Map<String, Object> propertyMap = iterator.next();
            Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
            for (Resource resource : resources) {
                service.updateCluster(TargetClusterResourceProvider.getCluster((String)resource.getPropertyValue(CLUSTER_NAME_PROPERTY_ID), propertyMap));
            }
        }
        return new RequestStatusImpl(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        IvoryService service = this.getService();
        Set<Resource> resources = this.getResources(PropertyHelper.getReadRequest(new String[0]), predicate);
        for (Resource resource : resources) {
            service.deleteCluster((String)resource.getPropertyValue(CLUSTER_NAME_PROPERTY_ID));
        }
        return new RequestStatusImpl(null);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected static Cluster getCluster(String clusterName, Map<String, Object> propertyMap) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            String property = entry.getKey();
            String category = PropertyHelper.getPropertyCategory(property);
            if (!category.equals(CLUSTER_PROPERTIES_PROPERTY_ID)) continue;
            properties.put(PropertyHelper.getPropertyName(property), (String)entry.getValue());
        }
        return new Cluster(clusterName, (String)propertyMap.get(CLUSTER_COLO_PROPERTY_ID), TargetClusterResourceProvider.getInterfaces((Set)propertyMap.get(CLUSTER_INTERFACES_PROPERTY_ID)), TargetClusterResourceProvider.getLocations((Set)propertyMap.get(CLUSTER_LOCATIONS_PROPERTY_ID)), properties);
    }

    protected static Set<Cluster.Interface> getInterfaces(Set<Map<String, Object>> maps) {
        HashSet<Cluster.Interface> interfaces = new HashSet<Cluster.Interface>();
        for (Map<String, Object> map : maps) {
            interfaces.add(new Cluster.Interface((String)map.get("type"), (String)map.get("endpoint"), (String)map.get("version")));
        }
        return interfaces;
    }

    protected static Set<Cluster.Location> getLocations(Set<Map<String, Object>> maps) {
        HashSet<Cluster.Location> locations = new HashSet<Cluster.Location>();
        for (Map<String, Object> map : maps) {
            locations.add(new Cluster.Location((String)map.get("name"), (String)map.get("path")));
        }
        return locations;
    }
}

