/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.actionmanager.HostRoleStatus;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.CalculatedStatus;
import id.onyx.obdp.server.controller.internal.QueryResponseImpl;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.ExtendedResourceProvider;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.QueryResponse;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.orm.dao.HostRoleCommandDAO;
import id.onyx.obdp.server.orm.dao.HostRoleCommandStatusSummaryDTO;
import id.onyx.obdp.server.orm.dao.StageDAO;
import id.onyx.obdp.server.orm.entities.StageEntity;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.topology.LogicalRequest;
import id.onyx.obdp.server.topology.TopologyManager;
import id.onyx.obdp.server.utils.SecretReference;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class StageResourceProvider
extends AbstractControllerResourceProvider
implements ExtendedResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StageResourceProvider.class);
    @Inject
    private static StageDAO dao = null;
    @Inject
    private static HostRoleCommandDAO hostRoleCommandDAO = null;
    @Inject
    private static Provider<Clusters> clustersProvider = null;
    @Inject
    private static TopologyManager topologyManager;
    public static final String STAGE_STAGE_ID = "Stage/stage_id";
    public static final String STAGE_CLUSTER_NAME = "Stage/cluster_name";
    public static final String STAGE_REQUEST_ID = "Stage/request_id";
    public static final String STAGE_LOG_INFO = "Stage/log_info";
    public static final String STAGE_CONTEXT = "Stage/context";
    public static final String STAGE_COMMAND_PARAMS = "Stage/command_params";
    public static final String STAGE_HOST_PARAMS = "Stage/host_params";
    public static final String STAGE_SKIPPABLE = "Stage/skippable";
    public static final String STAGE_PROGRESS_PERCENT = "Stage/progress_percent";
    public static final String STAGE_STATUS = "Stage/status";
    public static final String STAGE_DISPLAY_STATUS = "Stage/display_status";
    public static final String STAGE_START_TIME = "Stage/start_time";
    public static final String STAGE_END_TIME = "Stage/end_time";
    static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;
    static final Set<String> PROPERTIES_TO_MASK_PASSWORD_IN;

    StageResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Stage, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(KEY_PROPERTY_IDS.values());
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            Map<String, Object> updateProperties = iterator.next();
            List<StageEntity> entities = dao.findAll(request, predicate);
            for (StageEntity entity : entities) {
                String stageStatus = (String)updateProperties.get(STAGE_STATUS);
                if (stageStatus == null) continue;
                HostRoleStatus desiredStatus = HostRoleStatus.valueOf(stageStatus);
                dao.updateStageStatus(entity, desiredStatus, this.getManagementController().getActionManager());
            }
        }
        this.notifyUpdate(Resource.Type.Stage, request, predicate);
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        LinkedHashSet<Resource> results;
        block5: {
            HashMap<Long, Map<Long, HostRoleCommandStatusSummaryDTO>> cache;
            Set<String> propertyIds;
            block4: {
                results = new LinkedHashSet<Resource>();
                propertyIds = this.getRequestPropertyIds(request, predicate);
                cache = new HashMap<Long, Map<Long, HostRoleCommandStatusSummaryDTO>>();
                List<StageEntity> entities = dao.findAll(request, predicate);
                for (StageEntity entity : entities) {
                    results.add(StageResourceProvider.toResource(cache, entity, propertyIds));
                }
                cache.clear();
                Map<String, Object> map = PredicateHelper.getProperties(predicate);
                if (!map.containsKey(STAGE_REQUEST_ID)) break block4;
                Long requestId = NumberUtils.toLong((String)map.get(STAGE_REQUEST_ID).toString());
                LogicalRequest lr = topologyManager.getRequest(requestId);
                if (null == lr) break block5;
                Collection<StageEntity> topologyManagerStages = lr.getStageEntities();
                Map<Long, HostRoleCommandStatusSummaryDTO> summary = topologyManager.getStageSummaries(requestId);
                cache.put(requestId, summary);
                for (StageEntity entity : topologyManagerStages) {
                    Resource stageResource = StageResourceProvider.toResource(cache, entity, propertyIds);
                    if (!predicate.evaluate(stageResource)) continue;
                    results.add(stageResource);
                }
                break block5;
            }
            Collection<StageEntity> topologyManagerStages = topologyManager.getStages();
            for (StageEntity entity : topologyManagerStages) {
                Resource stageResource;
                if (!cache.containsKey(entity.getRequestId())) {
                    Map<Long, HostRoleCommandStatusSummaryDTO> summary = topologyManager.getStageSummaries(entity.getRequestId());
                    cache.put(entity.getRequestId(), summary);
                }
                if (!predicate.evaluate(stageResource = StageResourceProvider.toResource(cache, entity, propertyIds))) continue;
                results.add(stageResource);
            }
        }
        return results;
    }

    @Override
    public QueryResponse queryForResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<Resource> results = this.getResources(request, predicate);
        return new QueryResponseImpl(results, request.getSortRequest() != null, false, results.size());
    }

    static Resource toResource(Map<Long, Map<Long, HostRoleCommandStatusSummaryDTO>> cache, StageEntity entity, Set<String> requestedIds) {
        String value;
        ResourceImpl resource = new ResourceImpl(Resource.Type.Stage);
        Long clusterId = entity.getClusterId();
        if (clusterId != null && !clusterId.equals(-1L)) {
            try {
                Cluster cluster = ((Clusters)clustersProvider.get()).getClusterById(clusterId);
                StageResourceProvider.setResourceProperty(resource, STAGE_CLUSTER_NAME, cluster.getClusterName(), requestedIds);
            }
            catch (Exception e) {
                LOG.error("Can not get information for cluster " + clusterId + ".", (Throwable)e);
            }
        }
        if (!cache.containsKey(entity.getRequestId())) {
            cache.put(entity.getRequestId(), hostRoleCommandDAO.findAggregateCounts(entity.getRequestId()));
        }
        Map<Long, HostRoleCommandStatusSummaryDTO> summary = cache.get(entity.getRequestId());
        StageResourceProvider.setResourceProperty(resource, STAGE_STAGE_ID, entity.getStageId(), requestedIds);
        StageResourceProvider.setResourceProperty(resource, STAGE_REQUEST_ID, entity.getRequestId(), requestedIds);
        StageResourceProvider.setResourceProperty(resource, STAGE_CONTEXT, entity.getRequestContext(), requestedIds);
        if (StageResourceProvider.isPropertyRequested(STAGE_COMMAND_PARAMS, requestedIds)) {
            value = entity.getCommandParamsStage();
            if (!StringUtils.isBlank((String)value)) {
                value = SecretReference.maskPasswordInPropertyMap(value);
            }
            resource.setProperty(STAGE_COMMAND_PARAMS, value);
        }
        if (StageResourceProvider.isPropertyRequested(STAGE_HOST_PARAMS, requestedIds)) {
            value = entity.getHostParamsStage();
            if (!StringUtils.isBlank((String)value)) {
                value = SecretReference.maskPasswordInPropertyMap(value);
            }
            resource.setProperty(STAGE_HOST_PARAMS, value);
        }
        StageResourceProvider.setResourceProperty(resource, STAGE_SKIPPABLE, entity.isSkippable(), requestedIds);
        Long startTime = Long.MAX_VALUE;
        Long endTime = 0L;
        if (summary.containsKey(entity.getStageId())) {
            startTime = summary.get(entity.getStageId()).getStartTime();
            endTime = summary.get(entity.getStageId()).getEndTime();
        }
        StageResourceProvider.setResourceProperty(resource, STAGE_START_TIME, startTime, requestedIds);
        StageResourceProvider.setResourceProperty(resource, STAGE_END_TIME, endTime, requestedIds);
        CalculatedStatus status = summary.isEmpty() ? CalculatedStatus.COMPLETED : CalculatedStatus.statusFromStageSummary(summary, Collections.singleton(entity.getStageId()));
        StageResourceProvider.setResourceProperty(resource, STAGE_PROGRESS_PERCENT, status.getPercent(), requestedIds);
        StageResourceProvider.setResourceProperty(resource, STAGE_STATUS, (Object)status.getStatus(), requestedIds);
        StageResourceProvider.setResourceProperty(resource, STAGE_DISPLAY_STATUS, (Object)status.getDisplayStatus(), requestedIds);
        return resource;
    }

    static {
        PROPERTY_IDS = ImmutableSet.builder().add((Object)STAGE_STAGE_ID).add((Object)STAGE_CLUSTER_NAME).add((Object)STAGE_REQUEST_ID).add((Object)STAGE_LOG_INFO).add((Object)STAGE_CONTEXT).add((Object)STAGE_COMMAND_PARAMS).add((Object)STAGE_HOST_PARAMS).add((Object)STAGE_SKIPPABLE).add((Object)STAGE_PROGRESS_PERCENT).add((Object)STAGE_STATUS).add((Object)STAGE_DISPLAY_STATUS).add((Object)STAGE_START_TIME).add((Object)STAGE_END_TIME).build();
        KEY_PROPERTY_IDS = ImmutableMap.builder().put((Object)Resource.Type.Stage, (Object)STAGE_STAGE_ID).put((Object)Resource.Type.Cluster, (Object)STAGE_CLUSTER_NAME).put((Object)Resource.Type.Request, (Object)STAGE_REQUEST_ID).build();
        PROPERTIES_TO_MASK_PASSWORD_IN = ImmutableSet.of((Object)STAGE_COMMAND_PARAMS, (Object)STAGE_HOST_PARAMS);
    }
}

