/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackVersionRequest;
import id.onyx.obdp.server.controller.StackVersionResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.orm.dao.StackDAO;
import id.onyx.obdp.server.orm.entities.StackEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class StackVersionResourceProvider
extends ReadOnlyResourceProvider {
    public static final String RESPONSE_KEY = "Versions";
    public static final String ALL_PROPERTIES = "Versions/*";
    public static final String STACK_VERSION_PROPERTY_ID = "Versions/stack_version";
    public static final String STACK_NAME_PROPERTY_ID = "Versions/stack_name";
    public static final String STACK_MIN_VERSION_PROPERTY_ID = "Versions/min_upgrade_version";
    public static final String STACK_ACTIVE_PROPERTY_ID = "Versions/active";
    public static final String STACK_VALID_PROPERTY_ID = "Versions/valid";
    public static final String STACK_ERROR_SET = "Versions/stack-errors";
    public static final String STACK_CONFIG_TYPES = "Versions/config_types";
    public static final String STACK_PARENT_PROPERTY_ID = "Versions/parent_stack_version";
    public static final String UPGRADE_PACKS_PROPERTY_ID = "Versions/upgrade_packs";
    public static final String STACK_MIN_JDK = "Versions/min_jdk";
    public static final String STACK_MAX_JDK = "Versions/max_jdk";
    public static final String MPACK_RESOURCE_ID = "Versions/id";
    public static final Set<String> PROPERTY_IDS = new HashSet<String>();
    @Inject
    protected static StackDAO stackDAO;
    private static Set<String> pkPropertyIds;
    public static final Map<Resource.Type, String> KEY_PROPERTY_IDS;

    StackVersionResourceProvider(OBDPManagementController controller) {
        super(Resource.Type.StackVersion, PROPERTY_IDS, KEY_PROPERTY_IDS, controller);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackVersionRequest> requests = new HashSet<StackVersionRequest>();
        HashSet<Resource> resources = new HashSet<Resource>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(PredicateHelper.getProperties(predicate));
            if (propertyMap.containsKey(MPACK_RESOURCE_ID)) {
                ResourceImpl resource = new ResourceImpl(Resource.Type.StackVersion);
                Long mpackId = Long.valueOf((String)propertyMap.get(MPACK_RESOURCE_ID));
                StackEntity stackEntity = stackDAO.findByMpack(mpackId);
                requests.add(new StackVersionRequest(stackEntity.getStackName(), stackEntity.getStackVersion()));
                resource.setProperty(STACK_NAME_PROPERTY_ID, stackEntity.getStackName());
                resource.setProperty(STACK_VERSION_PROPERTY_ID, stackEntity.getStackVersion());
                resource.setProperty(MPACK_RESOURCE_ID, mpackId);
                resources.add(resource);
            } else {
                for (Map<String, Object> propertyMap1 : this.getPropertyMaps(predicate)) {
                    requests.add(this.getRequest(propertyMap1));
                }
                Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
                Set<StackVersionResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackVersionResponse>>(){

                    @Override
                    public Set<StackVersionResponse> invoke() throws OBDPException {
                        return StackVersionResourceProvider.this.getManagementController().getStackVersions(requests);
                    }
                });
                for (StackVersionResponse response : responses) {
                    ResourceImpl resource = new ResourceImpl(Resource.Type.StackVersion);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_ACTIVE_PROPERTY_ID, response.isActive(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_VALID_PROPERTY_ID, response.isValid(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_ERROR_SET, response.getErrors(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_PARENT_PROPERTY_ID, response.getParentVersion(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_CONFIG_TYPES, response.getConfigTypes(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, UPGRADE_PACKS_PROPERTY_ID, response.getUpgradePacks(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_MIN_JDK, response.getMinJdk(), requestedIds);
                    StackVersionResourceProvider.setResourceProperty(resource, STACK_MAX_JDK, response.getMaxJdk(), requestedIds);
                    resources.add(resource);
                }
            }
        }
        return resources;
    }

    private StackVersionRequest getRequest(Map<String, Object> properties) {
        return new StackVersionRequest((String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(this.keyPropertyIds.values());
    }

    static {
        pkPropertyIds = new HashSet<String>(Arrays.asList(STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, MPACK_RESOURCE_ID));
        KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
        PROPERTY_IDS.add(MPACK_RESOURCE_ID);
        PROPERTY_IDS.add(STACK_VERSION_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_MIN_VERSION_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_ACTIVE_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_VALID_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_ERROR_SET);
        PROPERTY_IDS.add(STACK_CONFIG_TYPES);
        PROPERTY_IDS.add(STACK_PARENT_PROPERTY_ID);
        PROPERTY_IDS.add(UPGRADE_PACKS_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_MIN_JDK);
        PROPERTY_IDS.add(STACK_MAX_JDK);
        KEY_PROPERTY_IDS.put(Resource.Type.Mpack, MPACK_RESOURCE_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Stack, STACK_NAME_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.StackVersion, STACK_VERSION_PROPERTY_ID);
    }
}

