/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackServiceRequest;
import id.onyx.obdp.server.controller.StackServiceResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptorFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@StaticallyInject
public class StackServiceResourceProvider
extends ReadOnlyResourceProvider {
    protected static final String SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "service_name");
    protected static final String SERVICE_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "service_type");
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "stack_version");
    private static final String SERVICE_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "display_name");
    private static final String USER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "user_name");
    private static final String COMMENTS_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "comments");
    private static final String SELECTION_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "selection");
    private static final String MAINTAINER_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "maintainer");
    private static final String VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "service_version");
    private static final String CONFIG_TYPES = PropertyHelper.getPropertyId("StackServices", "config_types");
    private static final String REQUIRED_SERVICES_ID = PropertyHelper.getPropertyId("StackServices", "required_services");
    private static final String SERVICE_CHECK_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "service_check_supported");
    private static final String CUSTOM_COMMANDS_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "custom_commands");
    private static final String SERVICE_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "properties");
    private static final String CREDENTIAL_STORE_SUPPORTED = PropertyHelper.getPropertyId("StackServices", "credential_store_supported");
    private static final String CREDENTIAL_STORE_REQUIRED = PropertyHelper.getPropertyId("StackServices", "credential_store_required");
    private static final String CREDENTIAL_STORE_ENABLED = PropertyHelper.getPropertyId("StackServices", "credential_store_enabled");
    private static final String SUPPORT_DELETE_VIA_UI = PropertyHelper.getPropertyId("StackServices", "support_delete_via_ui");
    private static final String SSO_INTEGRATION_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "sso_integration_supported");
    private static final String SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "sso_integration_requires_kerberos");
    private static final String LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "ldap_integration_supported");
    private static final String ROLLING_RESTART_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("StackServices", "rolling_restart_supported");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)SERVICE_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{SERVICE_NAME_PROPERTY_ID, SERVICE_TYPE_PROPERTY_ID, STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, SERVICE_DISPLAY_NAME_PROPERTY_ID, USER_NAME_PROPERTY_ID, COMMENTS_PROPERTY_ID, SELECTION_PROPERTY_ID, MAINTAINER_PROPERTY_ID, VERSION_PROPERTY_ID, CONFIG_TYPES, REQUIRED_SERVICES_ID, SERVICE_CHECK_SUPPORTED_PROPERTY_ID, CUSTOM_COMMANDS_PROPERTY_ID, SERVICE_PROPERTIES_PROPERTY_ID, CREDENTIAL_STORE_SUPPORTED, CREDENTIAL_STORE_REQUIRED, CREDENTIAL_STORE_ENABLED, SUPPORT_DELETE_VIA_UI, SSO_INTEGRATION_SUPPORTED_PROPERTY_ID, SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID, LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID, ROLLING_RESTART_SUPPORTED_PROPERTY_ID});
    @Inject
    private static KerberosServiceDescriptorFactory kerberosServiceDescriptorFactory;

    protected StackServiceResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.StackService, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackServiceRequest> requests = new HashSet<StackServiceRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<StackServiceResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackServiceResponse>>(){

            @Override
            public Set<StackServiceResponse> invoke() throws OBDPException {
                return StackServiceResourceProvider.this.getManagementController().getStackServices(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (StackServiceResponse response : responses) {
            Resource resource = this.createResource(response, requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    private Resource createResource(StackServiceResponse response, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.StackService);
        StackServiceResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_TYPE_PROPERTY_ID, response.getServiceType(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_DISPLAY_NAME_PROPERTY_ID, response.getServiceDisplayName(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, USER_NAME_PROPERTY_ID, response.getUserName(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, COMMENTS_PROPERTY_ID, response.getComments(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, VERSION_PROPERTY_ID, response.getServiceVersion(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SELECTION_PROPERTY_ID, (Object)response.getSelection(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, MAINTAINER_PROPERTY_ID, response.getMaintainer(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, CONFIG_TYPES, response.getConfigTypes(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, REQUIRED_SERVICES_ID, response.getRequiredServices(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_CHECK_SUPPORTED_PROPERTY_ID, response.isServiceCheckSupported(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, CUSTOM_COMMANDS_PROPERTY_ID, response.getCustomCommands(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SERVICE_PROPERTIES_PROPERTY_ID, response.getServiceProperties(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, CREDENTIAL_STORE_SUPPORTED, response.isCredentialStoreSupported(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, CREDENTIAL_STORE_REQUIRED, response.isCredentialStoreRequired(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, CREDENTIAL_STORE_ENABLED, response.isCredentialStoreEnabled(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SUPPORT_DELETE_VIA_UI, response.isSupportDeleteViaUI(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, ROLLING_RESTART_SUPPORTED_PROPERTY_ID, response.isRollingRestartSupported(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_SUPPORTED_PROPERTY_ID, response.isSsoIntegrationSupported(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID, response.isSsoIntegrationRequiresKerberos(), requestedIds);
        StackServiceResourceProvider.setResourceProperty(resource, LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID, response.isLdapIntegrationSupported(), requestedIds);
        return resource;
    }

    private StackServiceRequest getRequest(Map<String, Object> properties) {
        return new StackServiceRequest((String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID), (String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(CREDENTIAL_STORE_SUPPORTED), (String)properties.get(CREDENTIAL_STORE_ENABLED));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

