/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackServiceComponentRequest;
import id.onyx.obdp.server.controller.StackServiceComponentResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.AutoDeployInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StackServiceComponentResourceProvider
extends ReadOnlyResourceProvider {
    private static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "stack_name");
    private static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "stack_version");
    private static final String SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "service_name");
    private static final String COMPONENT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "component_name");
    private static final String COMPONENT_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "display_name");
    private static final String COMPONENT_CATEGORY_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "component_category");
    private static final String IS_CLIENT_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "is_client");
    private static final String IS_MASTER_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "is_master");
    private static final String CARDINALITY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "cardinality");
    private static final String ADVERTISE_VERSION_ID = PropertyHelper.getPropertyId("StackServiceComponents", "advertise_version");
    private static final String DECOMISSION_ALLOWED_ID = PropertyHelper.getPropertyId("StackServiceComponents", "decommission_allowed");
    private static final String REASSIGN_ALLOWED_ID = PropertyHelper.getPropertyId("StackServiceComponents", "reassign_allowed");
    private static final String CUSTOM_COMMANDS_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "custom_commands");
    private static final String HAS_BULK_COMMANDS_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "has_bulk_commands_definition");
    private static final String BULK_COMMANDS_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "bulk_commands_display_name");
    private static final String BULK_COMMANDS_MASTER_COMPONENT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackServiceComponents", "bulk_commands_master_component_name");
    private static final String RECOVERY_ENABLED = PropertyHelper.getPropertyId("StackServiceComponents", "recovery_enabled");
    private static final String ROLLING_RESTART_SUPPORTED = PropertyHelper.getPropertyId("StackServiceComponents", "rolling_restart_supported");
    private static final String AUTO_DEPLOY_ENABLED_ID = PropertyHelper.getPropertyId("auto_deploy", "enabled");
    private static final String AUTO_DEPLOY_LOCATION_ID = PropertyHelper.getPropertyId("auto_deploy", "location");
    private static final String COMPONENT_TYPE = PropertyHelper.getPropertyId("StackServiceComponents", "component_type");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)SERVICE_NAME_PROPERTY_ID).put((Object)Resource.Type.StackServiceComponent, (Object)COMPONENT_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, SERVICE_NAME_PROPERTY_ID, COMPONENT_NAME_PROPERTY_ID, COMPONENT_DISPLAY_NAME_PROPERTY_ID, COMPONENT_CATEGORY_PROPERTY_ID, IS_CLIENT_PROPERTY_ID, IS_MASTER_PROPERTY_ID, CARDINALITY_ID, ADVERTISE_VERSION_ID, DECOMISSION_ALLOWED_ID, REASSIGN_ALLOWED_ID, CUSTOM_COMMANDS_PROPERTY_ID, HAS_BULK_COMMANDS_PROPERTY_ID, BULK_COMMANDS_DISPLAY_NAME_PROPERTY_ID, BULK_COMMANDS_MASTER_COMPONENT_NAME_PROPERTY_ID, RECOVERY_ENABLED, ROLLING_RESTART_SUPPORTED, AUTO_DEPLOY_ENABLED_ID, AUTO_DEPLOY_LOCATION_ID, COMPONENT_TYPE});

    protected StackServiceComponentResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.StackServiceComponent, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackServiceComponentRequest> requests = new HashSet<StackServiceComponentRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<StackServiceComponentResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackServiceComponentResponse>>(){

            @Override
            public Set<StackServiceComponentResponse> invoke() throws OBDPException {
                return StackServiceComponentResourceProvider.this.getManagementController().getStackComponents(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (StackServiceComponentResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackServiceComponent);
            StackServiceComponentResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_NAME_PROPERTY_ID, response.getComponentName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_DISPLAY_NAME_PROPERTY_ID, response.getComponentDisplayName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_CATEGORY_PROPERTY_ID, response.getComponentCategory(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, IS_CLIENT_PROPERTY_ID, response.isClient(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, IS_MASTER_PROPERTY_ID, response.isMaster(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, CARDINALITY_ID, response.getCardinality(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, ADVERTISE_VERSION_ID, response.isVersionAdvertised(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, DECOMISSION_ALLOWED_ID, response.isDecommissionAlllowed(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, RECOVERY_ENABLED, response.isRecoveryEnabled(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, REASSIGN_ALLOWED_ID, response.isReassignAlllowed(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, CUSTOM_COMMANDS_PROPERTY_ID, response.getVisibleCustomCommands(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, BULK_COMMANDS_DISPLAY_NAME_PROPERTY_ID, response.getBulkCommandsDisplayName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, BULK_COMMANDS_MASTER_COMPONENT_NAME_PROPERTY_ID, response.getBulkCommandsMasterComponentName(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, HAS_BULK_COMMANDS_PROPERTY_ID, response.hasBulkCommands(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, ROLLING_RESTART_SUPPORTED, response.isRollingRestartSupported(), requestedIds);
            StackServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_TYPE, response.getComponentType(), requestedIds);
            AutoDeployInfo autoDeployInfo = response.getAutoDeploy();
            if (autoDeployInfo != null) {
                StackServiceComponentResourceProvider.setResourceProperty(resource, AUTO_DEPLOY_ENABLED_ID, autoDeployInfo.isEnabled(), requestedIds);
                if (autoDeployInfo.getCoLocate() != null) {
                    StackServiceComponentResourceProvider.setResourceProperty(resource, AUTO_DEPLOY_LOCATION_ID, autoDeployInfo.getCoLocate(), requestedIds);
                }
            }
            resources.add(resource);
        }
        return resources;
    }

    private StackServiceComponentRequest getRequest(Map<String, Object> properties) {
        return new StackServiceComponentRequest((String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID), (String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(COMPONENT_NAME_PROPERTY_ID), (String)properties.get(RECOVERY_ENABLED));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

