/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.StackRequest;
import id.onyx.obdp.server.controller.StackResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StackResourceProvider
extends ReadOnlyResourceProvider {
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Stacks", "stack_name");
    protected static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).build();
    protected static final Set<String> propertyIds = ImmutableSet.of((Object)STACK_NAME_PROPERTY_ID);

    protected StackResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.Stack, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackRequest> requests = new HashSet<StackRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<StackResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackResponse>>(){

            @Override
            public Set<StackResponse> invoke() throws OBDPException {
                return StackResourceProvider.this.getManagementController().getStacks(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (StackResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Stack);
            StackResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            resource.setProperty(STACK_NAME_PROPERTY_ID, response.getStackName());
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException {
                return StackResourceProvider.this.getManagementController().updateStacks();
            }
        });
        this.notifyUpdate(Resource.Type.Stack, request, predicate);
        return this.getRequestStatus(response);
    }

    private StackRequest getRequest(Map<String, Object> properties) {
        return new StackRequest((String)properties.get(STACK_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

