/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.DependencyConditionInfo;
import id.onyx.obdp.server.state.DependencyInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StackDependencyResourceProvider
extends AbstractResourceProvider {
    protected static final String STACK_NAME_ID = PropertyHelper.getPropertyId("Dependencies", "stack_name");
    protected static final String STACK_VERSION_ID = PropertyHelper.getPropertyId("Dependencies", "stack_version");
    protected static final String DEPENDENT_SERVICE_NAME_ID = PropertyHelper.getPropertyId("Dependencies", "dependent_service_name");
    protected static final String DEPENDENT_COMPONENT_NAME_ID = PropertyHelper.getPropertyId("Dependencies", "dependent_component_name");
    protected static final String SERVICE_NAME_ID = PropertyHelper.getPropertyId("Dependencies", "service_name");
    protected static final String COMPONENT_NAME_ID = PropertyHelper.getPropertyId("Dependencies", "component_name");
    protected static final String SCOPE_ID = PropertyHelper.getPropertyId("Dependencies", "scope");
    protected static final String TYPE_ID = PropertyHelper.getPropertyId("Dependencies", "type");
    protected static final String CONDITIONS_ID = PropertyHelper.getPropertyId("Dependencies", "conditions");
    protected static final String AUTO_DEPLOY_ENABLED_ID = PropertyHelper.getPropertyId("auto_deploy", "enabled");
    protected static final String AUTO_DEPLOY_LOCATION_ID = PropertyHelper.getPropertyId("auto_deploy", "location");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_ID).put((Object)Resource.Type.StackService, (Object)DEPENDENT_SERVICE_NAME_ID).put((Object)Resource.Type.StackServiceComponent, (Object)DEPENDENT_COMPONENT_NAME_ID).put((Object)Resource.Type.StackServiceComponentDependency, (Object)COMPONENT_NAME_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{STACK_NAME_ID, STACK_VERSION_ID, DEPENDENT_SERVICE_NAME_ID, DEPENDENT_COMPONENT_NAME_ID, SERVICE_NAME_ID, COMPONENT_NAME_ID, SCOPE_ID, TYPE_ID, CONDITIONS_ID, AUTO_DEPLOY_ENABLED_ID, AUTO_DEPLOY_LOCATION_ID});
    private static OBDPMetaInfo obdpMetaInfo;

    protected StackDependencyResourceProvider() {
        super(propertyIds, keyPropertyIds);
    }

    public static void init(OBDPMetaInfo metaInfo) {
        obdpMetaInfo = metaInfo;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<Map<String, Object>> requestProps = this.getPropertyMaps(predicate);
        for (Map<String, Object> properties : requestProps) {
            try {
                resources.addAll(this.getDependencyResources(properties, this.getRequestPropertyIds(request, predicate)));
            }
            catch (NoSuchParentResourceException | NoSuchResourceException e) {
                if (requestProps.size() != 1) continue;
                throw e;
            }
        }
        return resources;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new SystemException("Stack resources are read only");
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Stack resources are read only");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new SystemException("Stack resources are read only");
    }

    private Collection<Resource> getDependencyResources(Map<String, Object> properties, Set<String> requestedIds) throws SystemException, NoSuchParentResourceException, NoSuchResourceException {
        final String stackName = (String)properties.get(STACK_NAME_ID);
        final String version = (String)properties.get(STACK_VERSION_ID);
        final String dependentService = (String)properties.get(DEPENDENT_SERVICE_NAME_ID);
        final String dependentComponent = (String)properties.get(DEPENDENT_COMPONENT_NAME_ID);
        final String dependencyName = (String)properties.get(COMPONENT_NAME_ID);
        ArrayList<DependencyInfo> dependencies = new ArrayList<DependencyInfo>();
        if (dependencyName != null) {
            dependencies.add(this.getResources(new AbstractResourceProvider.Command<DependencyInfo>(){

                @Override
                public DependencyInfo invoke() throws OBDPException {
                    return obdpMetaInfo.getComponentDependency(stackName, version, dependentService, dependentComponent, dependencyName);
                }
            }));
        } else {
            dependencies.addAll((Collection)this.getResources(new AbstractResourceProvider.Command<List<DependencyInfo>>(){

                @Override
                public List<DependencyInfo> invoke() throws OBDPException {
                    return obdpMetaInfo.getComponentDependencies(stackName, version, dependentService, dependentComponent);
                }
            }));
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (DependencyInfo dependency : dependencies) {
            if (dependency == null) continue;
            resources.add(this.toResource(dependency, stackName, version, dependentService, dependentComponent, requestedIds));
        }
        return resources;
    }

    private Resource toResource(DependencyInfo dependency, String stackName, String version, String dependentService, String dependentComponent, Set<String> requestedIds) {
        List<DependencyConditionInfo> dependencyConditionsInfo;
        ResourceImpl resource = new ResourceImpl(Resource.Type.StackServiceComponentDependency);
        StackDependencyResourceProvider.setResourceProperty(resource, SERVICE_NAME_ID, dependency.getServiceName(), requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, COMPONENT_NAME_ID, dependency.getComponentName(), requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, STACK_NAME_ID, stackName, requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, STACK_VERSION_ID, version, requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, DEPENDENT_SERVICE_NAME_ID, dependentService, requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, DEPENDENT_COMPONENT_NAME_ID, dependentComponent, requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, SCOPE_ID, dependency.getScope(), requestedIds);
        StackDependencyResourceProvider.setResourceProperty(resource, TYPE_ID, dependency.getType(), requestedIds);
        AutoDeployInfo autoDeployInfo = dependency.getAutoDeploy();
        if (autoDeployInfo != null) {
            StackDependencyResourceProvider.setResourceProperty(resource, AUTO_DEPLOY_ENABLED_ID, autoDeployInfo.isEnabled(), requestedIds);
            if (autoDeployInfo.getCoLocate() != null) {
                StackDependencyResourceProvider.setResourceProperty(resource, AUTO_DEPLOY_LOCATION_ID, autoDeployInfo.getCoLocate(), requestedIds);
            }
        }
        if ((dependencyConditionsInfo = dependency.getDependencyConditions()) != null) {
            StackDependencyResourceProvider.setResourceProperty(resource, CONDITIONS_ID, dependencyConditionsInfo, requestedIds);
        }
        return resource;
    }
}

