/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Injector;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.configuration.ComponentSSLConfiguration;
import id.onyx.obdp.server.controller.internal.ConfigBasedJmxHostProvider;
import id.onyx.obdp.server.controller.internal.OverriddenMetricsHostProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.URLStreamProvider;
import id.onyx.obdp.server.controller.jmx.JMXHostProvider;
import id.onyx.obdp.server.controller.jmx.JMXPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricHostProvider;
import id.onyx.obdp.server.controller.metrics.MetricPropertyProviderFactory;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.MetricsPropertyProviderProxy;
import id.onyx.obdp.server.controller.metrics.MetricsServiceProvider;
import id.onyx.obdp.server.controller.metrics.RestMetricsPropertyProvider;
import id.onyx.obdp.server.controller.metrics.timeline.cache.TimelineMetricCacheProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.StreamProvider;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.ConfigHelper;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.UriInfo;
import id.onyx.obdp.server.state.stack.Metric;
import id.onyx.obdp.server.state.stack.MetricDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackDefinedPropertyProvider
implements PropertyProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StackDefinedPropertyProvider.class);
    @Inject
    private static Clusters clusters = null;
    @Inject
    private static OBDPMetaInfo metaInfo = null;
    @Inject
    private static Injector injector = null;
    @Inject
    private static MetricPropertyProviderFactory metricPropertyProviderFactory;
    private Resource.Type type = null;
    private String clusterNamePropertyId = null;
    private String hostNamePropertyId = null;
    private String componentNamePropertyId = null;
    private String resourceStatePropertyId = null;
    private ComponentSSLConfiguration sslConfig = null;
    private URLStreamProvider streamProvider = null;
    private JMXHostProvider jmxHostProvider;
    private PropertyProvider defaultJmx = null;
    private PropertyProvider defaultGanglia = null;
    private final MetricHostProvider metricHostProvider;
    private final MetricsServiceProvider metricsServiceProvider;
    private TimelineMetricCacheProvider cacheProvider;
    public static final String WRAPPED_METRICS_KEY = "WRAPPED_METRICS_KEY";

    @Inject
    public static void init(Injector injector) {
        clusters = (Clusters)injector.getInstance(Clusters.class);
        metaInfo = (OBDPMetaInfo)injector.getInstance(OBDPMetaInfo.class);
        metricPropertyProviderFactory = (MetricPropertyProviderFactory)injector.getInstance(MetricPropertyProviderFactory.class);
        StackDefinedPropertyProvider.injector = injector;
    }

    public StackDefinedPropertyProvider(Resource.Type type, JMXHostProvider jmxHostProvider, MetricHostProvider metricHostProvider, MetricsServiceProvider serviceProvider, URLStreamProvider streamProvider, String clusterPropertyId, String hostPropertyId, String componentPropertyId, String resourceStatePropertyId, PropertyProvider defaultJmxPropertyProvider, PropertyProvider defaultGangliaPropertyProvider) {
        this.metricHostProvider = metricHostProvider;
        this.metricsServiceProvider = serviceProvider;
        if (null == clusterPropertyId) {
            throw new NullPointerException("Cluster name property id cannot be null");
        }
        if (null == componentPropertyId) {
            throw new NullPointerException("Component name property id cannot be null");
        }
        this.type = type;
        this.clusterNamePropertyId = clusterPropertyId;
        this.hostNamePropertyId = hostPropertyId;
        this.componentNamePropertyId = componentPropertyId;
        this.resourceStatePropertyId = resourceStatePropertyId;
        this.jmxHostProvider = jmxHostProvider;
        this.sslConfig = ComponentSSLConfiguration.instance();
        this.streamProvider = streamProvider;
        this.defaultJmx = defaultJmxPropertyProvider;
        this.defaultGanglia = defaultGangliaPropertyProvider;
        this.cacheProvider = (TimelineMetricCacheProvider)injector.getInstance(TimelineMetricCacheProvider.class);
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        HashMap<String, Map<String, PropertyInfo>> gangliaMap = new HashMap<String, Map<String, PropertyInfo>>();
        HashMap<String, Map<String, PropertyInfo>> jmxMap = new HashMap<String, Map<String, PropertyInfo>>();
        ArrayList<PropertyProvider> additional = new ArrayList<PropertyProvider>();
        HashMap<String, String> overriddenHosts = new HashMap<String, String>();
        HashMap<String, UriInfo> overriddenJmxUris = new HashMap<String, UriInfo>();
        try {
            for (Resource r : resources) {
                String clusterName = r.getPropertyValue(this.clusterNamePropertyId).toString();
                String componentName = r.getPropertyValue(this.componentNamePropertyId).toString();
                Cluster cluster = clusters.getCluster(clusterName);
                Service service = null;
                try {
                    service = cluster.getServiceByComponentName(componentName);
                }
                catch (ServiceNotFoundException e) {
                    LOG.debug("Could not load component {}", (Object)componentName);
                    continue;
                }
                StackId stack = service.getDesiredStackId();
                List<MetricDefinition> defs = metaInfo.getMetrics(stack.getStackName(), stack.getStackVersion(), service.getName(), componentName, this.type.name());
                if (null == defs || 0 == defs.size()) continue;
                for (MetricDefinition m : defs) {
                    if (m.getType().equals("ganglia")) {
                        gangliaMap.put(componentName, StackDefinedPropertyProvider.getPropertyInfo(m));
                        m.getOverriddenHosts().ifPresent(host -> overriddenHosts.put(componentName, (String)host));
                        continue;
                    }
                    if (m.getType().equals("jmx")) {
                        jmxMap.put(componentName, StackDefinedPropertyProvider.getPropertyInfo(m));
                        m.getJmxSourceUri().ifPresent(uri -> overriddenJmxUris.put(componentName, (UriInfo)uri));
                        continue;
                    }
                    PropertyProvider pp = this.getDelegate(m, this.streamProvider, this.metricHostProvider, this.clusterNamePropertyId, this.hostNamePropertyId, this.componentNamePropertyId, this.resourceStatePropertyId, componentName);
                    if (pp == null) {
                        pp = this.getDelegate(m);
                    }
                    if (pp == null) continue;
                    additional.add(pp);
                }
            }
            if (gangliaMap.size() > 0) {
                MetricsPropertyProviderProxy propertyProvider = MetricsPropertyProvider.createInstance(this.type, gangliaMap, this.streamProvider, this.sslConfig, this.cacheProvider, this.metricHostProvider(overriddenHosts), this.metricsServiceProvider, this.clusterNamePropertyId, this.hostNamePropertyId, this.componentNamePropertyId);
                propertyProvider.populateResources(resources, request, predicate);
            } else {
                this.defaultGanglia.populateResources(resources, request, predicate);
            }
            if (jmxMap.size() > 0) {
                JMXPropertyProvider jpp = metricPropertyProviderFactory.createJMXPropertyProvider(jmxMap, this.streamProvider, this.jmxHostProvider(overriddenJmxUris, this.jmxHostProvider, (ConfigHelper)injector.getInstance(ConfigHelper.class)), this.metricHostProvider, this.clusterNamePropertyId, this.hostNamePropertyId, this.componentNamePropertyId, this.resourceStatePropertyId);
                jpp.populateResources(resources, request, predicate);
            } else {
                this.defaultJmx.populateResources(resources, request, predicate);
            }
            for (PropertyProvider pp : additional) {
                pp.populateResources(resources, request, predicate);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("Error loading deferred resources", (Throwable)e);
            throw new SystemException("Error loading deferred resources", e);
        }
        return resources;
    }

    private JMXHostProvider jmxHostProvider(Map<String, UriInfo> overriddenJmxUris, JMXHostProvider defaultProvider, ConfigHelper configHelper) {
        return overriddenJmxUris.isEmpty() ? defaultProvider : new ConfigBasedJmxHostProvider(overriddenJmxUris, defaultProvider, configHelper);
    }

    private MetricHostProvider metricHostProvider(Map<String, String> overriddenHosts) {
        return new OverriddenMetricsHostProvider(overriddenHosts, this.metricHostProvider, (ConfigHelper)injector.getInstance(ConfigHelper.class));
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        return Collections.emptySet();
    }

    public static Map<String, PropertyInfo> getPropertyInfo(MetricDefinition def) {
        HashMap<String, PropertyInfo> defs = new HashMap<String, PropertyInfo>();
        for (Map.Entry<String, Metric> entry : def.getMetrics().entrySet()) {
            Metric metric = entry.getValue();
            if (metric.getName() == null) continue;
            PropertyInfo propertyInfo = new PropertyInfo(metric.getName(), metric.isTemporal(), metric.isPointInTime());
            propertyInfo.setAmsHostMetric(metric.isAmsHostMetric());
            propertyInfo.setUnit(metric.getUnit());
            defs.put(entry.getKey(), propertyInfo);
        }
        return defs;
    }

    private PropertyProvider getDelegate(MetricDefinition definition) {
        try {
            Class<?> clz = Class.forName(definition.getType());
            try {
                Method m = clz.getMethod("getInstance", Map.class, Map.class);
                Object o = m.invoke(null, definition.getProperties(), definition.getMetrics());
                return (PropertyProvider)PropertyProvider.class.cast(o);
            }
            catch (Exception e) {
                LOG.info("Could not load singleton or factory method for type '" + definition.getType());
                try {
                    Constructor<?> ct = clz.getConstructor(Map.class, Map.class);
                    Object o = ct.newInstance(definition.getProperties(), definition.getMetrics());
                    return (PropertyProvider)PropertyProvider.class.cast(o);
                }
                catch (Exception e2) {
                    LOG.info("Could not find contructor for type '" + definition.getType());
                    return (PropertyProvider)PropertyProvider.class.cast(clz.newInstance());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not load class " + definition.getType());
            return null;
        }
    }

    /*
     * Loose catch block
     */
    private PropertyProvider getDelegate(MetricDefinition definition, StreamProvider streamProvider, MetricHostProvider metricsHostProvider, String clusterNamePropertyId, String hostNamePropertyId, String componentNamePropertyId, String statePropertyId, String componentName) {
        Class<?> clz;
        HashMap<String, Map<String, PropertyInfo>> componentMetrics;
        block5: {
            Map<String, PropertyInfo> metrics = StackDefinedPropertyProvider.getPropertyInfo(definition);
            componentMetrics = new HashMap<String, Map<String, PropertyInfo>>();
            componentMetrics.put(WRAPPED_METRICS_KEY, metrics);
            clz = Class.forName(definition.getType());
            if (!clz.equals(RestMetricsPropertyProvider.class)) break block5;
            return metricPropertyProviderFactory.createRESTMetricsPropertyProvider(definition.getProperties(), componentMetrics, streamProvider, metricsHostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId, statePropertyId, componentName);
            {
                catch (Exception e) {
                    LOG.error("Could not load class " + definition.getType());
                    return null;
                }
            }
        }
        try {
            Constructor<?> ct = clz.getConstructor(Map.class, Map.class, StreamProvider.class, MetricHostProvider.class, String.class, String.class, String.class, String.class, String.class);
            Object o = ct.newInstance(injector, definition.getProperties(), componentMetrics, streamProvider, metricsHostProvider, clusterNamePropertyId, hostNamePropertyId, componentNamePropertyId, statePropertyId, componentName);
            return (PropertyProvider)PropertyProvider.class.cast(o);
        }
        catch (Exception e) {
            LOG.info("Could not find contructor for type '" + definition.getType());
            return (PropertyProvider)PropertyProvider.class.cast(clz.newInstance());
        }
    }
}

