/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackConfigurationRequest;
import id.onyx.obdp.server.controller.StackConfigurationResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class StackConfigurationResourceProvider
extends ReadOnlyResourceProvider {
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "stack_version");
    public static final String SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "service_name");
    public static final String PROPERTY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_name");
    public static final String PROPERTY_VALUE_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_value");
    public static final String PROPERTY_VALUE_ATTRIBUTES_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_value_attributes");
    public static final String PROPERTY_DEPENDS_ON_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_depends_on");
    public static final String PROPERTY_DESCRIPTION_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_description");
    public static final String PROPERTY_DISPLAY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_display_name");
    public static final String PROPERTY_PROPERTY_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "property_type");
    public static final String PROPERTY_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "type");
    public static final String PROPERTY_FINAL_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurations", "final");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)SERVICE_NAME_PROPERTY_ID).put((Object)Resource.Type.StackConfiguration, (Object)PROPERTY_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, SERVICE_NAME_PROPERTY_ID, PROPERTY_NAME_PROPERTY_ID, PROPERTY_VALUE_PROPERTY_ID, PROPERTY_VALUE_ATTRIBUTES_PROPERTY_ID, PROPERTY_DEPENDS_ON_PROPERTY_ID, PROPERTY_DESCRIPTION_PROPERTY_ID, PROPERTY_DISPLAY_NAME_PROPERTY_ID, PROPERTY_PROPERTY_TYPE_PROPERTY_ID, PROPERTY_TYPE_PROPERTY_ID, PROPERTY_FINAL_PROPERTY_ID});

    protected StackConfigurationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.StackConfiguration, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackConfigurationRequest> requests = new HashSet<StackConfigurationRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<StackConfigurationResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackConfigurationResponse>>(){

            @Override
            public Set<StackConfigurationResponse> invoke() throws OBDPException {
                return StackConfigurationResourceProvider.this.getManagementController().getStackConfigurations(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (StackConfigurationResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackConfiguration);
            StackConfigurationResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_NAME_PROPERTY_ID, response.getPropertyName(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_VALUE_PROPERTY_ID, response.getPropertyValue(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_VALUE_ATTRIBUTES_PROPERTY_ID, response.getPropertyValueAttributes(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_DEPENDS_ON_PROPERTY_ID, response.getDependsOnProperties(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_DESCRIPTION_PROPERTY_ID, response.getPropertyDescription(), requestedIds);
            if (StringUtils.isNotEmpty((String)response.getPropertyDisplayName())) {
                StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_DISPLAY_NAME_PROPERTY_ID, response.getPropertyDisplayName(), requestedIds);
            }
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_PROPERTY_TYPE_PROPERTY_ID, response.getPropertyType(), requestedIds);
            StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_TYPE_PROPERTY_ID, response.getType(), requestedIds);
            this.setDefaultPropertiesAttributes(resource, requestedIds);
            for (Map.Entry<String, String> attribute : response.getPropertyAttributes().entrySet()) {
                StackConfigurationResourceProvider.setResourceProperty(resource, PropertyHelper.getPropertyId("StackConfigurations", attribute.getKey()), attribute.getValue(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private void setDefaultPropertiesAttributes(Resource resource, Set<String> requestedIds) {
        StackConfigurationResourceProvider.setResourceProperty(resource, PROPERTY_FINAL_PROPERTY_ID, "false", requestedIds);
    }

    private StackConfigurationRequest getRequest(Map<String, Object> properties) {
        return new StackConfigurationRequest((String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID), (String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(PROPERTY_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

