/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackConfigurationDependencyRequest;
import id.onyx.obdp.server.controller.StackConfigurationDependencyResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class StackConfigurationDependencyResourceProvider
extends ReadOnlyResourceProvider {
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "stack_version");
    public static final String SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "service_name");
    public static final String PROPERTY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "property_name");
    public static final String DEPENDENCY_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "dependency_name");
    public static final String DEPENDENCY_TYPE_PROPERTY_ID = PropertyHelper.getPropertyId("StackConfigurationDependency", "dependency_type");
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)SERVICE_NAME_PROPERTY_ID).put((Object)Resource.Type.StackConfiguration, (Object)PROPERTY_NAME_PROPERTY_ID).put((Object)Resource.Type.StackLevelConfiguration, (Object)PROPERTY_NAME_PROPERTY_ID).put((Object)Resource.Type.StackConfigurationDependency, (Object)DEPENDENCY_NAME_PROPERTY_ID).build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{STACK_NAME_PROPERTY_ID, STACK_VERSION_PROPERTY_ID, SERVICE_NAME_PROPERTY_ID, PROPERTY_NAME_PROPERTY_ID, DEPENDENCY_NAME_PROPERTY_ID, DEPENDENCY_TYPE_PROPERTY_ID});

    protected StackConfigurationDependencyResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.StackConfigurationDependency, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<StackConfigurationDependencyRequest> requests = new HashSet<StackConfigurationDependencyRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<StackConfigurationDependencyResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<StackConfigurationDependencyResponse>>(){

            @Override
            public Set<StackConfigurationDependencyResponse> invoke() throws OBDPException {
                return StackConfigurationDependencyResourceProvider.this.getManagementController().getStackConfigurationDependencies(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (StackConfigurationDependencyResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackConfigurationDependency);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, response.getStackName(), requestedIds);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, response.getStackVersion(), requestedIds);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, PROPERTY_NAME_PROPERTY_ID, response.getPropertyName(), requestedIds);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, DEPENDENCY_NAME_PROPERTY_ID, response.getDependencyName(), requestedIds);
            StackConfigurationDependencyResourceProvider.setResourceProperty(resource, DEPENDENCY_TYPE_PROPERTY_ID, response.getDependencyType(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    private StackConfigurationDependencyRequest getRequest(Map<String, Object> properties) {
        return new StackConfigurationDependencyRequest((String)properties.get(STACK_NAME_PROPERTY_ID), (String)properties.get(STACK_VERSION_PROPERTY_ID), (String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(PROPERTY_NAME_PROPERTY_ID), (String)properties.get(DEPENDENCY_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

