/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import id.onyx.obdp.server.StackAccessException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.PropertyInfo;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackInfo;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosDescriptorFactory;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptor;
import id.onyx.obdp.server.state.kerberos.KerberosServiceDescriptorFactory;
import id.onyx.obdp.server.state.stack.Metric;
import id.onyx.obdp.server.state.stack.MetricDefinition;
import id.onyx.obdp.server.state.stack.WidgetLayout;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class StackArtifactResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StackArtifactResourceProvider.class);
    public static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Artifacts", "stack_name");
    public static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Artifacts", "stack_version");
    public static final String STACK_SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Artifacts", "service_name");
    public static final String STACK_COMPONENT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Artifacts", "component_name");
    public static final String ARTIFACT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Artifacts", "artifact_name");
    public static final String ARTIFACT_DATA_PROPERTY_ID = "artifact_data";
    public static final Set<String> pkPropertyIds = ImmutableSet.builder().add((Object)ARTIFACT_NAME_PROPERTY_ID).build();
    public static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.StackArtifact, (Object)ARTIFACT_NAME_PROPERTY_ID).put((Object)Resource.Type.Stack, (Object)STACK_NAME_PROPERTY_ID).put((Object)Resource.Type.StackVersion, (Object)STACK_VERSION_PROPERTY_ID).put((Object)Resource.Type.StackService, (Object)STACK_SERVICE_NAME_PROPERTY_ID).build();
    public static final Set<String> propertyIds = ImmutableSet.builder().add((Object)STACK_NAME_PROPERTY_ID).add((Object)STACK_VERSION_PROPERTY_ID).add((Object)STACK_SERVICE_NAME_PROPERTY_ID).add((Object)ARTIFACT_NAME_PROPERTY_ID).add((Object)"artifact_data").build();
    public static final String KERBEROS_DESCRIPTOR_NAME = "kerberos_descriptor";
    public static final String METRICS_DESCRIPTOR_NAME = "metrics_descriptor";
    public static final String WIDGETS_DESCRIPTOR_NAME = "widgets_descriptor";
    @Inject
    private static KerberosDescriptorFactory kerberosDescriptorFactory;
    @Inject
    private static KerberosServiceDescriptorFactory kerberosServiceDescriptorFactory;
    Type widgetLayoutType = new TypeToken<Map<String, List<WidgetLayout>>>(){}.getType();
    Gson gson = new Gson();

    protected StackArtifactResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.StackArtifact, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        resources.addAll(this.getKerberosDescriptors(request, predicate));
        resources.addAll(this.getMetricsDescriptors(request, predicate));
        resources.addAll(this.getWidgetsDescriptors(request, predicate));
        if (resources.isEmpty()) {
            throw new NoSuchResourceException("The requested resource doesn't exist: Artifact not found, " + predicate);
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Creating stack artifacts is not supported");
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Updating of stack artifacts is not supported");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Deletion of stack artifacts is not supported");
    }

    private Set<Resource> getKerberosDescriptors(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, NoSuchResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            Map<String, Object> descriptor;
            String artifactName = (String)properties.get(ARTIFACT_NAME_PROPERTY_ID);
            if (artifactName != null && !artifactName.equals(KERBEROS_DESCRIPTOR_NAME)) continue;
            String stackName = (String)properties.get(STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)properties.get(STACK_VERSION_PROPERTY_ID);
            String stackService = (String)properties.get(STACK_SERVICE_NAME_PROPERTY_ID);
            try {
                descriptor = this.getKerberosDescriptor(stackName, stackVersion, stackService);
            }
            catch (IOException e) {
                LOG.error("Unable to process Kerberos Descriptor. Properties: " + properties, (Throwable)e);
                throw new SystemException("An internal exception occurred while attempting to build a Kerberos Descriptor artifact. See ambari server logs for more information", e);
            }
            if (descriptor == null) continue;
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackArtifact);
            Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_NAME_PROPERTY_ID, KERBEROS_DESCRIPTOR_NAME, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_DATA_PROPERTY_ID, descriptor, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackName, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackVersion, requestedIds);
            if (stackService != null) {
                StackArtifactResourceProvider.setResourceProperty(resource, STACK_SERVICE_NAME_PROPERTY_ID, stackService, requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private Set<Resource> getMetricsDescriptors(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, NoSuchResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            Map<Object, Object> descriptor;
            String artifactName = (String)properties.get(ARTIFACT_NAME_PROPERTY_ID);
            if (artifactName != null && !artifactName.equals(METRICS_DESCRIPTOR_NAME)) continue;
            String stackName = (String)properties.get(STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)properties.get(STACK_VERSION_PROPERTY_ID);
            String stackService = (String)properties.get(STACK_SERVICE_NAME_PROPERTY_ID);
            String componentName = (String)properties.get(STACK_COMPONENT_NAME_PROPERTY_ID);
            OBDPMetaInfo metaInfo = this.getManagementController().getAmbariMetaInfo();
            try {
                if (stackService != null) {
                    if (componentName == null) {
                        Map<String, Map<String, List<MetricDefinition>>> serviceMetrics = StackArtifactResourceProvider.removeAggregateFunctions(metaInfo.getServiceMetrics(stackName, stackVersion, stackService));
                        descriptor = Collections.singletonMap(stackService, serviceMetrics);
                    } else {
                        List<MetricDefinition> componentMetrics = StackArtifactResourceProvider.removeAggregateFunctions(metaInfo.getMetrics(stackName, stackVersion, stackService, componentName, Resource.Type.Component.name()));
                        descriptor = Collections.singletonMap(componentName, componentMetrics);
                    }
                } else {
                    Map<String, Map<String, PropertyInfo>> clusterMetrics = PropertyHelper.getMetricPropertyIds(Resource.Type.Cluster);
                    Map<String, Map<String, PropertyInfo>> hostMetrics = PropertyHelper.getMetricPropertyIds(Resource.Type.Host);
                    descriptor = new HashMap<String, Map<String, Map<String, PropertyInfo>>>();
                    descriptor.put(Resource.Type.Cluster.name(), clusterMetrics);
                    descriptor.put(Resource.Type.Host.name(), hostMetrics);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to process Metrics Descriptor. Properties: " + properties, (Throwable)e);
                throw new SystemException("An internal exception occurred while attempting to build a Metrics Descriptor artifact. See ambari server logs for more information", e);
            }
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackArtifact);
            Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_NAME_PROPERTY_ID, METRICS_DESCRIPTOR_NAME, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_DATA_PROPERTY_ID, descriptor, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackName, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackVersion, requestedIds);
            if (stackService != null) {
                StackArtifactResourceProvider.setResourceProperty(resource, STACK_SERVICE_NAME_PROPERTY_ID, stackService, requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private Set<Resource> getWidgetsDescriptors(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchParentResourceException, NoSuchResourceException {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            Map<String, Object> descriptor;
            String artifactName = (String)properties.get(ARTIFACT_NAME_PROPERTY_ID);
            if (artifactName != null && !artifactName.equals(WIDGETS_DESCRIPTOR_NAME)) continue;
            String stackName = (String)properties.get(STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)properties.get(STACK_VERSION_PROPERTY_ID);
            String stackService = (String)properties.get(STACK_SERVICE_NAME_PROPERTY_ID);
            try {
                descriptor = this.getWidgetsDescriptor(stackName, stackVersion, stackService);
            }
            catch (IOException e) {
                LOG.error("Unable to process Widgets Descriptor. Properties: " + properties, (Throwable)e);
                throw new SystemException("An internal exception occurred while attempting to build a Widgets Descriptor artifact. See ambari server logs for more information", e);
            }
            if (descriptor == null) continue;
            ResourceImpl resource = new ResourceImpl(Resource.Type.StackArtifact);
            Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_NAME_PROPERTY_ID, WIDGETS_DESCRIPTOR_NAME, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, ARTIFACT_DATA_PROPERTY_ID, descriptor, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_NAME_PROPERTY_ID, stackName, requestedIds);
            StackArtifactResourceProvider.setResourceProperty(resource, STACK_VERSION_PROPERTY_ID, stackVersion, requestedIds);
            if (stackService != null) {
                StackArtifactResourceProvider.setResourceProperty(resource, STACK_SERVICE_NAME_PROPERTY_ID, stackService, requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private Map<String, Object> getWidgetsDescriptor(String stackName, String stackVersion, String serviceName) throws NoSuchParentResourceException, IOException {
        StackInfo stackInfo;
        OBDPManagementController controller = this.getManagementController();
        try {
            stackInfo = controller.getAmbariMetaInfo().getStack(stackName, stackVersion);
        }
        catch (StackAccessException e) {
            throw new NoSuchParentResourceException(String.format("Parent stack resource doesn't exist: stackName='%s', stackVersion='%s'", stackName, stackVersion));
        }
        if (StringUtils.isEmpty((String)serviceName)) {
            return null;
        }
        return this.getWidgetsDescriptorForService(stackInfo, serviceName);
    }

    public Map<String, Object> getWidgetsDescriptorForService(StackInfo stackInfo, String serviceName) throws NoSuchParentResourceException, IOException {
        Map widgetDescriptor = null;
        ServiceInfo serviceInfo = stackInfo.getService(serviceName);
        if (serviceInfo == null) {
            throw new NoSuchParentResourceException("Service not found. serviceName = " + serviceName);
        }
        File widgetDescriptorFile = serviceInfo.getWidgetsDescriptorFile();
        if (widgetDescriptorFile != null && widgetDescriptorFile.exists()) {
            widgetDescriptor = (Map)this.gson.fromJson((Reader)new FileReader(widgetDescriptorFile), this.widgetLayoutType);
        }
        return widgetDescriptor;
    }

    private Map<String, Object> getKerberosDescriptor(String stackName, String stackVersion, String serviceName) throws NoSuchParentResourceException, IOException {
        return serviceName == null ? this.buildStackDescriptor(stackName, stackVersion) : this.getServiceDescriptor(stackName, stackVersion, serviceName);
    }

    private Map<String, Object> buildStackDescriptor(String stackName, String stackVersion) throws NoSuchParentResourceException, IOException {
        StackInfo stackInfo;
        KerberosDescriptor kerberosDescriptor = new KerberosDescriptor();
        OBDPManagementController controller = this.getManagementController();
        try {
            stackInfo = controller.getAmbariMetaInfo().getStack(stackName, stackVersion);
        }
        catch (StackAccessException e) {
            throw new NoSuchParentResourceException(String.format("Parent stack resource doesn't exist: stackName='%s', stackVersion='%s'", stackName, stackVersion));
        }
        Collection<KerberosServiceDescriptor> serviceDescriptors = this.getServiceDescriptors(stackInfo);
        serviceDescriptors.forEach(kerberosDescriptor::putService);
        return kerberosDescriptor.toMap();
    }

    private Map<String, Object> getServiceDescriptor(String stackName, String stackVersion, String serviceName) throws NoSuchParentResourceException, IOException {
        KerberosServiceDescriptor serviceDescriptor;
        ServiceInfo serviceInfo;
        OBDPManagementController controller = this.getManagementController();
        try {
            serviceInfo = controller.getAmbariMetaInfo().getService(stackName, stackVersion, serviceName);
        }
        catch (StackAccessException e) {
            throw new NoSuchParentResourceException(String.format("Parent stack/service resource doesn't exist: stackName='%s', stackVersion='%s', serviceName='%s'", stackName, stackVersion, serviceName));
        }
        File kerberosFile = serviceInfo.getKerberosDescriptorFile();
        if (kerberosFile != null && (serviceDescriptor = kerberosServiceDescriptorFactory.createInstance(kerberosFile, serviceName)) != null) {
            return serviceDescriptor.toMap();
        }
        return null;
    }

    private Collection<KerberosServiceDescriptor> getServiceDescriptors(StackInfo stack) throws IOException {
        ArrayList<KerberosServiceDescriptor> serviceDescriptors = new ArrayList<KerberosServiceDescriptor>();
        for (ServiceInfo service : stack.getServices()) {
            KerberosServiceDescriptor descriptor;
            File descriptorFile = service.getKerberosDescriptorFile();
            if (descriptorFile == null || (descriptor = kerberosServiceDescriptorFactory.createInstance(descriptorFile, service.getName())) == null) continue;
            serviceDescriptors.add(descriptor);
        }
        return serviceDescriptors;
    }

    private static Map<String, Map<String, List<MetricDefinition>>> removeAggregateFunctions(Map<String, Map<String, List<MetricDefinition>>> serviceMetrics) {
        HashMap filteredServiceMetrics = null;
        if (serviceMetrics != null) {
            filteredServiceMetrics = new HashMap();
            for (String component : serviceMetrics.keySet()) {
                HashMap<String, List<MetricDefinition>> componentMetricsCopy = new HashMap<String, List<MetricDefinition>>();
                Map<String, List<MetricDefinition>> componentMetrics = serviceMetrics.get(component);
                for (String category : componentMetrics.keySet()) {
                    componentMetricsCopy.put(category, StackArtifactResourceProvider.removeAggregateFunctions(componentMetrics.get(category)));
                }
                filteredServiceMetrics.put(component, componentMetricsCopy);
            }
        }
        return filteredServiceMetrics;
    }

    private static List<MetricDefinition> removeAggregateFunctions(List<MetricDefinition> metricsDefinitions) {
        ArrayList<MetricDefinition> filteredComponentMetrics = null;
        if (metricsDefinitions != null) {
            filteredComponentMetrics = new ArrayList<MetricDefinition>();
            for (MetricDefinition metricDefinition : metricsDefinitions) {
                HashMap<String, Map<String, Metric>> categorizedMetricsCopy = new HashMap<String, Map<String, Metric>>();
                Map<String, Map<String, Metric>> categorizedMetrics = metricDefinition.getMetricsByCategory();
                for (String category : categorizedMetrics.keySet()) {
                    HashMap<String, Metric> namedMetricsCopy = new HashMap<String, Metric>();
                    Map<String, Metric> namedMetrics = categorizedMetrics.get(category);
                    for (String metricName : namedMetrics.keySet()) {
                        if (metricDefinition.getType().equals("ganglia") && PropertyHelper.hasAggregateFunctionSuffix(metricName)) continue;
                        namedMetricsCopy.put(metricName, namedMetrics.get(metricName));
                    }
                    categorizedMetricsCopy.put(category, namedMetricsCopy);
                }
                filteredComponentMetrics.add(new MetricDefinition(metricDefinition.getType(), metricDefinition.getProperties(), categorizedMetricsCopy));
            }
        }
        return filteredComponentMetrics;
    }
}

