/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorHelper;
import id.onyx.obdp.server.api.services.stackadvisor.StackAdvisorRequest;
import id.onyx.obdp.server.api.services.stackadvisor.recommendations.RecommendationResponse;
import id.onyx.obdp.server.configuration.Configuration;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.state.ChangedConfigInfo;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.Config;
import id.onyx.obdp.server.state.DesiredConfig;
import id.onyx.obdp.server.state.Host;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.configgroup.ConfigGroup;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StackAdvisorResourceProvider
extends ReadOnlyResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(StackAdvisorResourceProvider.class);
    protected static final String STACK_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "stack_name");
    protected static final String STACK_VERSION_PROPERTY_ID = PropertyHelper.getPropertyId("Versions", "stack_version");
    private static final String CLUSTER_ID_PROPERTY = "clusterId";
    private static final String SERVICE_NAME_PROPERTY = "serviceName";
    private static final String AUTO_COMPLETE_PROPERTY = "autoComplete";
    private static final String CONFIGS_RESPONSE_PROPERTY = "configsResponse";
    private static final String CONFIG_GROUPS_GROUP_ID_PROPERTY = "group_id";
    private static final String HOST_PROPERTY = "hosts";
    private static final String SERVICES_PROPERTY = "services";
    private static final String CHANGED_CONFIGURATIONS_PROPERTY = "changed_configurations";
    private static final String OPERATION_PROPERTY = "operation";
    private static final String OPERATION_DETAILS_PROPERTY = "operation_details";
    private static final String BLUEPRINT_HOST_GROUPS_PROPERTY = "recommendations/blueprint/host_groups";
    private static final String BINDING_HOST_GROUPS_PROPERTY = "recommendations/blueprint_cluster_binding/host_groups";
    private static final String BLUEPRINT_HOST_GROUPS_NAME_PROPERTY = "name";
    private static final String BLUEPRINT_HOST_GROUPS_COMPONENTS_PROPERTY = "components";
    private static final String BLUEPRINT_HOST_GROUPS_COMPONENTS_NAME_PROPERTY = "name";
    private static final String BINDING_HOST_GROUPS_NAME_PROPERTY = "name";
    private static final String BINDING_HOST_GROUPS_HOSTS_PROPERTY = "hosts";
    private static final String BINDING_HOST_GROUPS_HOSTS_NAME_PROPERTY = "fqdn";
    private static final String CONFIG_GROUPS_PROPERTY = "recommendations/config_groups";
    private static final String CONFIG_GROUPS_CONFIGURATIONS_PROPERTY = "configurations";
    private static final String CONFIG_GROUPS_HOSTS_PROPERTY = "hosts";
    protected static StackAdvisorHelper saHelper;
    private static Configuration configuration;
    private static Clusters clusters;
    private static OBDPMetaInfo obdpMetaInfo;
    protected static final String USER_CONTEXT_OPERATION_PROPERTY = "user_context/operation";
    protected static final String USER_CONTEXT_OPERATION_DETAILS_PROPERTY = "user_context/operation_details";
    protected static final String CONFIGURATIONS_PROPERTY_ID = "recommendations/blueprint/configurations/";

    @Inject
    public static void init(StackAdvisorHelper instance, Configuration serverConfig, Clusters clusters, OBDPMetaInfo obdpMetaInfo) {
        saHelper = instance;
        configuration = serverConfig;
        StackAdvisorResourceProvider.clusters = clusters;
        StackAdvisorResourceProvider.obdpMetaInfo = obdpMetaInfo;
    }

    protected StackAdvisorResourceProvider(Resource.Type type, Set<String> propertyIds, Map<Resource.Type, String> keyPropertyIds, OBDPManagementController managementController) {
        super(type, propertyIds, keyPropertyIds, managementController);
    }

    protected abstract String getRequestTypePropertyId();

    protected StackAdvisorRequest prepareStackAdvisorRequest(Request request) {
        try {
            Set<RecommendationResponse.ConfigGroup> configGroups;
            Map<String, Map<String, Map<String, String>>> configurations;
            Map<String, Set<String>> componentHostsMap;
            Map<String, Set<String>> hgHostsMap;
            Map<String, Set<String>> hgComponentsMap;
            ArrayList<String> services;
            List<String> hosts;
            String clusterIdProperty = (String)this.getRequestProperty(request, CLUSTER_ID_PROPERTY);
            Long clusterId = clusterIdProperty == null ? null : Long.valueOf(clusterIdProperty);
            String serviceName = (String)this.getRequestProperty(request, SERVICE_NAME_PROPERTY);
            String autoCompleteProperty = (String)this.getRequestProperty(request, AUTO_COMPLETE_PROPERTY);
            Boolean autoComplete = autoCompleteProperty == null ? false : Boolean.valueOf(autoCompleteProperty);
            String stackName = (String)this.getRequestProperty(request, STACK_NAME_PROPERTY_ID);
            String stackVersion = (String)this.getRequestProperty(request, STACK_VERSION_PROPERTY_ID);
            StackAdvisorRequest.StackAdvisorRequestType requestType = StackAdvisorRequest.StackAdvisorRequestType.fromString((String)this.getRequestProperty(request, this.getRequestTypePropertyId()));
            if (autoComplete.booleanValue()) {
                if (clusterId == null || serviceName == null) {
                    throw new Exception(String.format("Incomplete request, clusterId and/or serviceName are not valid, clusterId=%s, serviceName=%s", clusterId, serviceName));
                }
                Cluster cluster = clusters.getCluster(clusterId);
                ArrayList<Host> hostObjects = new ArrayList<Host>(cluster.getHosts());
                Map<String, Service> serviceObjects = cluster.getServices();
                hosts = hostObjects.stream().map(h -> h.getHostName()).collect(Collectors.toList());
                services = new ArrayList<String>(serviceObjects.keySet());
                hgComponentsMap = this.calculateHostGroupComponentsMap(cluster);
                hgHostsMap = this.calculateHostGroupHostsMap(cluster);
                componentHostsMap = this.calculateComponentHostsMap(cluster);
                configurations = this.calculateConfigurations(cluster, serviceName);
                configGroups = this.calculateConfigGroups(cluster, request);
            } else {
                Object hostsObject = this.getRequestProperty(request, "hosts");
                if (hostsObject instanceof LinkedHashSet && ((LinkedHashSet)hostsObject).isEmpty()) {
                    throw new Exception("Empty host list passed to recommendation service");
                }
                hosts = (List<String>)hostsObject;
                Object servicesObject = this.getRequestProperty(request, SERVICES_PROPERTY);
                if (servicesObject instanceof LinkedHashSet && ((LinkedHashSet)servicesObject).isEmpty()) {
                    throw new Exception("Empty service list passed to recommendation service");
                }
                services = (ArrayList<String>)servicesObject;
                hgComponentsMap = this.calculateHostGroupComponentsMap(request);
                hgHostsMap = this.calculateHostGroupHostsMap(request);
                componentHostsMap = this.calculateComponentHostsMap(hgComponentsMap, hgHostsMap);
                configurations = this.calculateConfigurations(request);
                configGroups = this.calculateConfigGroups(request);
            }
            Map<String, String> userContext = this.readUserContext(request);
            Boolean gplLicenseAccepted = configuration.getGplLicenseAccepted();
            List<ChangedConfigInfo> changedConfigurations = requestType == StackAdvisorRequest.StackAdvisorRequestType.CONFIGURATION_DEPENDENCIES ? this.calculateChangedConfigurations(request) : Collections.emptyList();
            String configsResponseProperty = (String)this.getRequestProperty(request, CONFIGS_RESPONSE_PROPERTY);
            Boolean configsResponse = configsResponseProperty == null ? false : Boolean.valueOf(configsResponseProperty);
            return StackAdvisorRequest.StackAdvisorRequestBuilder.forStack(stackName, stackVersion).ofType(requestType).forHosts(hosts).forServices(services).forHostComponents(hgComponentsMap).forHostsGroupBindings(hgHostsMap).withComponentHostsMap(componentHostsMap).withConfigurations(configurations).withConfigGroups(configGroups).withChangedConfigurations(changedConfigurations).withUserContext(userContext).withGPLLicenseAccepted(gplLicenseAccepted).withClusterId(clusterId).withServiceName(serviceName).withConfigsResponse(configsResponse).build();
        }
        catch (Exception e) {
            LOG.warn("Error occurred during preparation of stack advisor request", (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Request body is not correct, error: %s", e.getMessage())).build();
            throw new WebApplicationException(response);
        }
    }

    private Map<String, Set<String>> calculateHostGroupComponentsMap(Request request) {
        Set hostGroups = (Set)this.getRequestProperty(request, BLUEPRINT_HOST_GROUPS_PROPERTY);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (hostGroups != null) {
            for (Map hostGroup : hostGroups) {
                String hostGroupName = (String)hostGroup.get("name");
                Set componentsSet = (Set)hostGroup.get(BLUEPRINT_HOST_GROUPS_COMPONENTS_PROPERTY);
                HashSet<String> components = new HashSet<String>();
                for (Map component : componentsSet) {
                    components.add((String)component.get("name"));
                }
                map.put(hostGroupName, components);
            }
        }
        return map;
    }

    private Map<String, Set<String>> calculateHostGroupComponentsMap(Cluster cluster) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ArrayList<Host> hosts = new ArrayList<Host>(cluster.getHosts());
        if (!hosts.isEmpty()) {
            for (Host host : hosts) {
                String hostGroupName = host.getHostName();
                HashSet<String> components = new HashSet<String>();
                for (ServiceComponentHost sch : cluster.getServiceComponentHosts(host.getHostName())) {
                    components.add(sch.getServiceComponentName());
                }
                map.put(hostGroupName, components);
            }
        }
        return map;
    }

    private Map<String, Set<String>> calculateHostGroupHostsMap(Request request) {
        Set bindingHostGroups = (Set)this.getRequestProperty(request, BINDING_HOST_GROUPS_PROPERTY);
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        if (bindingHostGroups != null) {
            for (Map hostGroup : bindingHostGroups) {
                String hostGroupName = (String)hostGroup.get("name");
                Set hostsSet = (Set)hostGroup.get("hosts");
                HashSet<String> hosts = new HashSet<String>();
                for (Map host : hostsSet) {
                    hosts.add((String)host.get(BINDING_HOST_GROUPS_HOSTS_NAME_PROPERTY));
                }
                map.put(hostGroupName, hosts);
            }
        }
        return map;
    }

    private Map<String, Set<String>> calculateHostGroupHostsMap(Cluster cluster) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        ArrayList<Host> hosts = new ArrayList<Host>(cluster.getHosts());
        if (!hosts.isEmpty()) {
            for (Host host : hosts) {
                map.put(host.getHostName(), Collections.singleton(host.getHostName()));
            }
        }
        return map;
    }

    protected List<ChangedConfigInfo> calculateChangedConfigurations(Request request) {
        LinkedList<ChangedConfigInfo> configs = new LinkedList<ChangedConfigInfo>();
        HashSet changedConfigs = (HashSet)this.getRequestProperty(request, CHANGED_CONFIGURATIONS_PROPERTY);
        for (HashMap props : changedConfigs) {
            configs.add(new ChangedConfigInfo((String)props.get("type"), (String)props.get("name"), (String)props.get("old_value")));
        }
        return configs;
    }

    protected Set<RecommendationResponse.ConfigGroup> calculateConfigGroups(Request request) {
        HashSet<RecommendationResponse.ConfigGroup> configGroups = new HashSet<RecommendationResponse.ConfigGroup>();
        HashSet configGroupsProperties = (HashSet)this.getRequestProperty(request, CONFIG_GROUPS_PROPERTY);
        if (configGroupsProperties != null) {
            for (HashMap props : configGroupsProperties) {
                RecommendationResponse.ConfigGroup configGroup = new RecommendationResponse.ConfigGroup();
                configGroup.setHosts((List)props.get("hosts"));
                for (Map property : (Set)props.get(CONFIG_GROUPS_CONFIGURATIONS_PROPERTY)) {
                    for (Map.Entry entry : property.entrySet()) {
                        String[] propertyPath = ((String)entry.getKey()).split("/");
                        String siteName = propertyPath[0];
                        String propertyName = propertyPath[2];
                        if (!configGroup.getConfigurations().containsKey(siteName)) {
                            RecommendationResponse.BlueprintConfigurations configurations = new RecommendationResponse.BlueprintConfigurations();
                            configGroup.getConfigurations().put(siteName, configurations);
                            configGroup.getConfigurations().get(siteName).setProperties(new HashMap<String, String>());
                        }
                        configGroup.getConfigurations().get(siteName).getProperties().put(propertyName, (String)entry.getValue());
                    }
                }
                configGroups.add(configGroup);
            }
        }
        return configGroups;
    }

    protected Set<RecommendationResponse.ConfigGroup> calculateConfigGroups(Cluster cluster, Request request) {
        HashSet<RecommendationResponse.ConfigGroup> configGroups = new HashSet<RecommendationResponse.ConfigGroup>();
        HashSet configGroupsProperties = (HashSet)this.getRequestProperty(request, CONFIG_GROUPS_PROPERTY);
        if (configGroupsProperties != null) {
            for (HashMap props : configGroupsProperties) {
                RecommendationResponse.ConfigGroup configGroup = new RecommendationResponse.ConfigGroup();
                Object groupIdObject = props.get(CONFIG_GROUPS_GROUP_ID_PROPERTY);
                if (groupIdObject == null) continue;
                Long groupId = Long.valueOf((String)groupIdObject);
                ConfigGroup clusterConfigGroup = cluster.getConfigGroupsById(groupId);
                HashMap<String, RecommendationResponse.BlueprintConfigurations> typedConfiguration = new HashMap<String, RecommendationResponse.BlueprintConfigurations>();
                for (Map.Entry<String, Config> config : clusterConfigGroup.getConfigurations().entrySet()) {
                    RecommendationResponse.BlueprintConfigurations blueprintConfiguration = new RecommendationResponse.BlueprintConfigurations();
                    blueprintConfiguration.setProperties(config.getValue().getProperties());
                    typedConfiguration.put(config.getKey(), blueprintConfiguration);
                }
                configGroup.setConfigurations(typedConfiguration);
                configGroup.setHosts(clusterConfigGroup.getHosts().values().stream().map(h -> h.getHostName()).collect(Collectors.toList()));
                configGroups.add(configGroup);
            }
        }
        return configGroups;
    }

    protected Map<String, String> readUserContext(Request request) {
        HashMap<String, String> userContext = new HashMap<String, String>();
        if (null != this.getRequestProperty(request, USER_CONTEXT_OPERATION_PROPERTY)) {
            userContext.put(OPERATION_PROPERTY, (String)this.getRequestProperty(request, USER_CONTEXT_OPERATION_PROPERTY));
        }
        if (null != this.getRequestProperty(request, USER_CONTEXT_OPERATION_DETAILS_PROPERTY)) {
            userContext.put(OPERATION_DETAILS_PROPERTY, (String)this.getRequestProperty(request, USER_CONTEXT_OPERATION_DETAILS_PROPERTY));
        }
        return userContext;
    }

    protected Map<String, Map<String, Map<String, String>>> calculateConfigurations(Request request) {
        HashMap<String, Map<String, Map<String, String>>> configurations = new HashMap<String, Map<String, Map<String, String>>>();
        Map<String, Object> properties = request.getProperties().iterator().next();
        for (String property : properties.keySet()) {
            if (!property.startsWith(CONFIGURATIONS_PROPERTY_ID)) continue;
            try {
                Object propVal;
                HashMap<String, String> propertiesMap;
                String propertyEnd = property.substring(CONFIGURATIONS_PROPERTY_ID.length());
                String[] propertyPath = propertyEnd.split("/");
                String siteName = propertyPath[0];
                String propertiesProperty = propertyPath[1];
                String propertyName = propertyPath[2];
                HashMap siteMap = (HashMap)configurations.get(siteName);
                if (siteMap == null) {
                    siteMap = new HashMap();
                    configurations.put(siteName, siteMap);
                }
                if ((propertiesMap = (HashMap<String, String>)siteMap.get(propertiesProperty)) == null) {
                    propertiesMap = new HashMap<String, String>();
                    siteMap.put(propertiesProperty, propertiesMap);
                }
                if ((propVal = properties.get(property)) != null) {
                    propertiesMap.put(propertyName, propVal.toString());
                    continue;
                }
                LOG.info(String.format("No value specified for configuration property, name = %s ", property));
            }
            catch (Exception e) {
                LOG.debug(String.format("Error handling configuration property, name = %s", property), (Throwable)e);
            }
        }
        return configurations;
    }

    protected Map<String, Map<String, Map<String, String>>> calculateConfigurations(Cluster cluster, String serviceName) throws OBDPException {
        HashMap<String, Map<String, Map<String, String>>> configurations = new HashMap<String, Map<String, Map<String, String>>>();
        Service service = cluster.getService(serviceName);
        StackId stackId = service.getDesiredStackId();
        ServiceInfo serviceInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), serviceName);
        List<String> requiredConfigTypes = serviceInfo.getConfigDependenciesWithComponents();
        Map<String, DesiredConfig> desiredConfigs = cluster.getDesiredConfigs();
        HashMap<String, DesiredConfig> requiredDesiredConfigs = new HashMap<String, DesiredConfig>();
        for (String string : requiredConfigTypes) {
            if (!desiredConfigs.containsKey(string)) continue;
            requiredDesiredConfigs.put(string, desiredConfigs.get(string));
        }
        for (Map.Entry entry : requiredDesiredConfigs.entrySet()) {
            Config config = cluster.getConfig((String)entry.getKey(), ((DesiredConfig)entry.getValue()).getTag());
            configurations.put((String)entry.getKey(), Collections.singletonMap("properties", config.getProperties()));
        }
        return configurations;
    }

    private Map<String, Set<String>> calculateComponentHostsMap(Map<String, Set<String>> hostGroups, Map<String, Set<String>> bindingHostGroups) {
        HashMap<String, Set<String>> componentHostsMap = new HashMap<String, Set<String>>();
        if (null != bindingHostGroups && null != hostGroups) {
            for (Map.Entry<String, Set<String>> hgComponents : hostGroups.entrySet()) {
                String hgName = hgComponents.getKey();
                Set<String> components = hgComponents.getValue();
                Set<String> hosts = bindingHostGroups.get(hgName);
                for (String component : components) {
                    HashSet<String> componentHosts = (HashSet<String>)componentHostsMap.get(component);
                    if (componentHosts == null) {
                        componentHosts = new HashSet<String>();
                        componentHostsMap.put(component, componentHosts);
                    }
                    componentHosts.addAll(hosts);
                }
            }
        }
        return componentHostsMap;
    }

    private Map<String, Set<String>> calculateComponentHostsMap(Cluster cluster) {
        HashMap<String, Set<String>> componentHostsMap = new HashMap<String, Set<String>>();
        List<ServiceComponentHost> schs = cluster.getServiceComponentHosts();
        for (ServiceComponentHost sch : schs) {
            componentHostsMap.putIfAbsent(sch.getServiceComponentName(), new HashSet());
            ((Set)componentHostsMap.get(sch.getServiceComponentName())).add(sch.getHostName());
        }
        return componentHostsMap;
    }

    protected Object getRequestProperty(Request request, String propertyName) {
        for (Map<String, Object> propertyMap : request.getProperties()) {
            if (!propertyMap.containsKey(propertyName)) continue;
            return propertyMap.get(propertyName);
        }
        return null;
    }
}

