/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.StackConfigurationRequest;
import id.onyx.obdp.server.controller.StackConfigurationResponse;
import id.onyx.obdp.server.controller.StackLevelConfigurationRequest;
import id.onyx.obdp.server.controller.StackServiceComponentRequest;
import id.onyx.obdp.server.controller.StackServiceComponentResponse;
import id.onyx.obdp.server.controller.StackServiceRequest;
import id.onyx.obdp.server.controller.StackServiceResponse;
import id.onyx.obdp.server.controller.internal.UnitUpdater;
import id.onyx.obdp.server.orm.entities.StackEntity;
import id.onyx.obdp.server.state.AutoDeployInfo;
import id.onyx.obdp.server.state.ComponentInfo;
import id.onyx.obdp.server.state.DependencyInfo;
import id.onyx.obdp.server.state.PropertyDependencyInfo;
import id.onyx.obdp.server.state.PropertyInfo;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.ValueAttributesInfo;
import id.onyx.obdp.server.topology.Cardinality;
import id.onyx.obdp.server.topology.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Stack {
    private String name;
    private String version;
    private Map<String, Collection<String>> serviceComponents = new HashMap<String, Collection<String>>();
    private Map<String, String> componentService = new HashMap<String, String>();
    private Map<String, Collection<DependencyInfo>> dependencies = new HashMap<String, Collection<DependencyInfo>>();
    private Map<DependencyInfo, String> dependencyConditionalServiceMap = new HashMap<DependencyInfo, String>();
    private Map<String, String> dbDependencyInfo = new HashMap<String, String>();
    private Map<String, String> cardinalityRequirements = new HashMap<String, String>();
    private Set<String> masterComponents = new HashSet<String>();
    private Map<String, AutoDeployInfo> componentAutoDeployInfo = new HashMap<String, AutoDeployInfo>();
    private Map<String, Map<String, Map<String, ConfigProperty>>> serviceConfigurations = new HashMap<String, Map<String, Map<String, ConfigProperty>>>();
    private Map<String, Map<String, Map<String, ConfigProperty>>> requiredServiceConfigurations = new HashMap<String, Map<String, Map<String, ConfigProperty>>>();
    private Map<String, Map<String, ConfigProperty>> stackConfigurations = new HashMap<String, Map<String, ConfigProperty>>();
    private Map<String, Set<String>> excludedConfigurationTypes = new HashMap<String, Set<String>>();
    private final OBDPManagementController controller;

    public Stack(StackEntity stack, OBDPManagementController ambariManagementController) throws OBDPException {
        this(stack.getStackName(), stack.getStackVersion(), ambariManagementController);
    }

    public Stack(StackId stackId, OBDPManagementController ambariManagementController) throws OBDPException {
        this(stackId.getStackName(), stackId.getStackVersion(), ambariManagementController);
    }

    public Stack(String name, String version, OBDPManagementController controller) throws OBDPException {
        this.name = name;
        this.version = version;
        this.controller = controller;
        Set<StackServiceResponse> stackServices = controller.getStackServices(Collections.singleton(new StackServiceRequest(name, version, null)));
        for (StackServiceResponse stackService : stackServices) {
            String serviceName = stackService.getServiceName();
            this.parseComponents(serviceName);
            this.parseExcludedConfigurations(stackService);
            this.parseConfigurations(stackService);
            this.registerConditionalDependencies();
        }
        this.parseStackConfigurations();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public StackId getStackId() {
        return new StackId(this.name, this.version);
    }

    public String toString() {
        return "stack " + this.getStackId();
    }

    Map<DependencyInfo, String> getDependencyConditionalServiceMap() {
        return this.dependencyConditionalServiceMap;
    }

    public Set<String> getServices() {
        return this.serviceComponents.keySet();
    }

    public Collection<String> getComponents(String service) {
        return this.serviceComponents.get(service);
    }

    public Map<String, Collection<String>> getComponents() {
        HashMap<String, Collection<String>> serviceComponents = new HashMap<String, Collection<String>>();
        for (String service : this.getServices()) {
            HashSet<String> components = new HashSet<String>();
            components.addAll(this.getComponents(service));
            serviceComponents.put(service, components);
        }
        return serviceComponents;
    }

    public ComponentInfo getComponentInfo(String component) {
        ComponentInfo componentInfo = null;
        String service = this.getServiceForComponent(component);
        if (service != null) {
            try {
                componentInfo = this.controller.getAmbariMetaInfo().getComponent(this.getName(), this.getVersion(), service, component);
            }
            catch (OBDPException oBDPException) {
                // empty catch block
            }
        }
        return componentInfo;
    }

    public Optional<ServiceInfo> getServiceInfo(String serviceName) {
        try {
            return Optional.of(this.controller.getAmbariMetaInfo().getService(this.getName(), this.getVersion(), serviceName));
        }
        catch (OBDPException e) {
            return Optional.empty();
        }
    }

    public Collection<String> getAllConfigurationTypes(String service) {
        return this.serviceConfigurations.get(service).keySet();
    }

    public Collection<String> getConfigurationTypes(String service) {
        HashSet<String> serviceTypes = new HashSet<String>(this.serviceConfigurations.get(service).keySet());
        serviceTypes.removeAll(this.getExcludedConfigurationTypes(service));
        return serviceTypes;
    }

    public Set<String> getExcludedConfigurationTypes(String service) {
        return this.excludedConfigurationTypes.containsKey(service) ? this.excludedConfigurationTypes.get(service) : Collections.emptySet();
    }

    public Map<String, String> getConfigurationProperties(String service, String type) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        Map<String, ConfigProperty> configProperties = this.serviceConfigurations.get(service).get(type);
        if (configProperties != null) {
            for (Map.Entry<String, ConfigProperty> configProperty : configProperties.entrySet()) {
                configMap.put(configProperty.getKey(), configProperty.getValue().getValue());
            }
        }
        return configMap;
    }

    public Map<String, ConfigProperty> getConfigurationPropertiesWithMetadata(String service, String type) {
        return this.serviceConfigurations.get(service).get(type);
    }

    public Collection<ConfigProperty> getRequiredConfigurationProperties(String service) {
        HashSet<ConfigProperty> requiredConfigProperties = new HashSet<ConfigProperty>();
        Map<String, Map<String, ConfigProperty>> serviceProperties = this.requiredServiceConfigurations.get(service);
        if (serviceProperties != null) {
            for (Map.Entry<String, Map<String, ConfigProperty>> typePropertiesEntry : serviceProperties.entrySet()) {
                requiredConfigProperties.addAll(typePropertiesEntry.getValue().values());
            }
        }
        return requiredConfigProperties;
    }

    public Collection<ConfigProperty> getRequiredConfigurationProperties(String service, PropertyInfo.PropertyType propertyType) {
        HashSet<ConfigProperty> matchingProperties = new HashSet<ConfigProperty>();
        Map<String, Map<String, ConfigProperty>> requiredProperties = this.requiredServiceConfigurations.get(service);
        if (requiredProperties != null) {
            for (Map.Entry<String, Map<String, ConfigProperty>> typePropertiesEntry : requiredProperties.entrySet()) {
                for (ConfigProperty configProperty : typePropertiesEntry.getValue().values()) {
                    if (!configProperty.getPropertyTypes().contains((Object)propertyType)) continue;
                    matchingProperties.add(configProperty);
                }
            }
        }
        return matchingProperties;
    }

    public boolean isPasswordProperty(String service, String type, String propertyName) {
        return this.serviceConfigurations.containsKey(service) && this.serviceConfigurations.get(service).containsKey(type) && this.serviceConfigurations.get(service).get(type).containsKey(propertyName) && this.serviceConfigurations.get(service).get(type).get(propertyName).getPropertyTypes().contains((Object)PropertyInfo.PropertyType.PASSWORD);
    }

    public Map<String, String> getStackConfigurationProperties(String type) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        Map<String, ConfigProperty> configProperties = this.stackConfigurations.get(type);
        if (configProperties != null) {
            for (Map.Entry<String, ConfigProperty> configProperty : configProperties.entrySet()) {
                configMap.put(configProperty.getKey(), configProperty.getValue().getValue());
            }
        }
        return configMap;
    }

    public boolean isKerberosPrincipalNameProperty(String service, String type, String propertyName) {
        return this.serviceConfigurations.containsKey(service) && this.serviceConfigurations.get(service).containsKey(type) && this.serviceConfigurations.get(service).get(type).containsKey(propertyName) && this.serviceConfigurations.get(service).get(type).get(propertyName).getPropertyTypes().contains((Object)PropertyInfo.PropertyType.KERBEROS_PRINCIPAL);
    }

    public Map<String, Map<String, String>> getConfigurationAttributes(String service, String type) {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        Map<String, ConfigProperty> configProperties = this.serviceConfigurations.get(service).get(type);
        if (configProperties != null) {
            for (Map.Entry<String, ConfigProperty> configProperty : configProperties.entrySet()) {
                String propertyName = configProperty.getKey();
                Map<String, String> propertyAttributes = configProperty.getValue().getAttributes();
                if (propertyAttributes == null) continue;
                for (Map.Entry<String, String> propertyAttribute : propertyAttributes.entrySet()) {
                    String attributeName = propertyAttribute.getKey();
                    String attributeValue = propertyAttribute.getValue();
                    if (attributeValue == null) continue;
                    HashMap<String, String> attributes = (HashMap<String, String>)attributesMap.get(attributeName);
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                        attributesMap.put(attributeName, attributes);
                    }
                    attributes.put(propertyName, attributeValue);
                }
            }
        }
        return attributesMap;
    }

    public Map<String, Map<String, String>> getStackConfigurationAttributes(String type) {
        HashMap<String, Map<String, String>> attributesMap = new HashMap<String, Map<String, String>>();
        Map<String, ConfigProperty> configProperties = this.stackConfigurations.get(type);
        if (configProperties != null) {
            for (Map.Entry<String, ConfigProperty> configProperty : configProperties.entrySet()) {
                String propertyName = configProperty.getKey();
                Map<String, String> propertyAttributes = configProperty.getValue().getAttributes();
                if (propertyAttributes == null) continue;
                for (Map.Entry<String, String> propertyAttribute : propertyAttributes.entrySet()) {
                    String attributeName = propertyAttribute.getKey();
                    String attributeValue = propertyAttribute.getValue();
                    HashMap<String, String> attributes = (HashMap<String, String>)attributesMap.get(attributeName);
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                        attributesMap.put(attributeName, attributes);
                    }
                    attributes.put(propertyName, attributeValue);
                }
            }
        }
        return attributesMap;
    }

    public String getServiceForComponent(String component) {
        return this.componentService.get(component);
    }

    public Collection<String> getServicesForComponents(Collection<String> components) {
        HashSet<String> services = new HashSet<String>();
        for (String component : components) {
            services.add(this.getServiceForComponent(component));
        }
        return services;
    }

    public String getServiceForConfigType(String config) {
        for (Map.Entry<String, Map<String, Map<String, ConfigProperty>>> entry : this.serviceConfigurations.entrySet()) {
            Map<String, Map<String, ConfigProperty>> typeMap = entry.getValue();
            String serviceName = entry.getKey();
            if (!typeMap.containsKey(config) || this.getExcludedConfigurationTypes(serviceName).contains(config)) continue;
            return serviceName;
        }
        throw new IllegalArgumentException("Specified configuration type is not associated with any service: " + config);
    }

    public List<String> getServicesForConfigType(String config) {
        ArrayList<String> serviceNames = new ArrayList<String>();
        for (Map.Entry<String, Map<String, Map<String, ConfigProperty>>> entry : this.serviceConfigurations.entrySet()) {
            Map<String, Map<String, ConfigProperty>> typeMap = entry.getValue();
            String serviceName = entry.getKey();
            if (!typeMap.containsKey(config) || this.getExcludedConfigurationTypes(serviceName).contains(config)) continue;
            serviceNames.add(serviceName);
        }
        return serviceNames;
    }

    public Collection<DependencyInfo> getDependenciesForComponent(String component) {
        return this.dependencies.containsKey(component) ? this.dependencies.get(component) : Collections.emptySet();
    }

    public String getConditionalServiceForDependency(DependencyInfo dependency) {
        return this.dependencyConditionalServiceMap.get(dependency);
    }

    public String getExternalComponentConfig(String component) {
        return this.dbDependencyInfo.get(component);
    }

    public Cardinality getCardinality(String component) {
        return new Cardinality(this.cardinalityRequirements.get(component));
    }

    public AutoDeployInfo getAutoDeployInfo(String component) {
        return this.componentAutoDeployInfo.get(component);
    }

    public boolean isMasterComponent(String component) {
        return this.masterComponents.contains(component);
    }

    public Configuration getConfiguration(Collection<String> services) {
        HashMap<String, Map<String, Map<String, String>>> attributes = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap<String, Map<String, String>> properties = new HashMap<String, Map<String, String>>();
        for (String service : services) {
            Collection<String> serviceConfigTypes = this.getConfigurationTypes(service);
            for (String type : serviceConfigTypes) {
                HashMap<String, String> typeProps = (HashMap<String, String>)properties.get(type);
                if (typeProps == null) {
                    typeProps = new HashMap<String, String>();
                    properties.put(type, typeProps);
                }
                typeProps.putAll(this.getConfigurationProperties(service, type));
                Map<String, Map<String, String>> stackTypeAttributes = this.getConfigurationAttributes(service, type);
                if (stackTypeAttributes.isEmpty()) continue;
                if (!attributes.containsKey(type)) {
                    attributes.put(type, new HashMap());
                }
                Map typeAttributes = (Map)attributes.get(type);
                for (Map.Entry<String, Map<String, String>> attribute : stackTypeAttributes.entrySet()) {
                    String attributeName = attribute.getKey();
                    HashMap<String, String> attributeProps = (HashMap<String, String>)typeAttributes.get(attributeName);
                    if (attributeProps == null) {
                        attributeProps = new HashMap<String, String>();
                        typeAttributes.put(attributeName, attributeProps);
                    }
                    attributeProps.putAll(attribute.getValue());
                }
            }
        }
        return new Configuration(properties, attributes);
    }

    public Configuration getConfiguration() {
        HashMap<String, Map<String, Map<String, String>>> stackAttributes = new HashMap<String, Map<String, Map<String, String>>>();
        HashMap<String, Map<String, String>> stackConfigs = new HashMap<String, Map<String, String>>();
        for (String service : this.getServices()) {
            for (String type : this.getAllConfigurationTypes(service)) {
                HashMap<String, String> typeProps = (HashMap<String, String>)stackConfigs.get(type);
                if (typeProps == null) {
                    typeProps = new HashMap<String, String>();
                    stackConfigs.put(type, typeProps);
                }
                typeProps.putAll(this.getConfigurationProperties(service, type));
                Map<String, Map<String, String>> stackTypeAttributes = this.getConfigurationAttributes(service, type);
                if (stackTypeAttributes.isEmpty()) continue;
                if (!stackAttributes.containsKey(type)) {
                    stackAttributes.put(type, new HashMap());
                }
                Map typeAttrs = (Map)stackAttributes.get(type);
                for (Map.Entry<String, Map<String, String>> attribute : stackTypeAttributes.entrySet()) {
                    String attributeName = attribute.getKey();
                    HashMap<String, String> attributes = (HashMap<String, String>)typeAttrs.get(attributeName);
                    if (attributes == null) {
                        attributes = new HashMap<String, String>();
                        typeAttrs.put(attributeName, attributes);
                    }
                    attributes.putAll(attribute.getValue());
                }
            }
        }
        return new Configuration(stackConfigs, stackAttributes);
    }

    public Configuration getValidDefaultConfig() {
        Configuration config = this.getDefaultConfig();
        UnitUpdater.updateUnits(config, this);
        return config;
    }

    public Configuration getDefaultConfig() {
        Configuration config = this.getConfiguration();
        config.getProperties().values().forEach(each -> each.values().removeIf(Objects::isNull));
        return config;
    }

    private void parseComponents(String service) throws OBDPException {
        HashSet<String> componentSet = new HashSet<String>();
        Set<StackServiceComponentResponse> components = this.controller.getStackComponents(Collections.singleton(new StackServiceComponentRequest(this.name, this.version, service, null)));
        for (StackServiceComponentResponse component : components) {
            List<DependencyInfo> componentDependencies;
            AutoDeployInfo autoDeploy;
            String componentName = component.getComponentName();
            componentSet.add(componentName);
            this.componentService.put(componentName, service);
            String cardinality = component.getCardinality();
            if (cardinality != null) {
                this.cardinalityRequirements.put(componentName, cardinality);
            }
            if ((autoDeploy = component.getAutoDeploy()) != null) {
                this.componentAutoDeployInfo.put(componentName, autoDeploy);
            }
            if ((componentDependencies = this.controller.getAmbariMetaInfo().getComponentDependencies(this.name, this.version, service, componentName)) != null && !componentDependencies.isEmpty()) {
                this.dependencies.put(componentName, componentDependencies);
            }
            if (!component.isMaster()) continue;
            this.masterComponents.add(componentName);
        }
        this.serviceComponents.put(service, componentSet);
    }

    private void parseConfigurations(StackServiceResponse stackService) throws OBDPException {
        String service = stackService.getServiceName();
        HashMap mapServiceConfig = new HashMap();
        HashMap<String, HashMap<String, ConfigProperty>> mapRequiredServiceConfig = new HashMap<String, HashMap<String, ConfigProperty>>();
        this.serviceConfigurations.put(service, mapServiceConfig);
        this.requiredServiceConfigurations.put(service, mapRequiredServiceConfig);
        Set<StackConfigurationResponse> serviceConfigs = this.controller.getStackConfigurations(Collections.singleton(new StackConfigurationRequest(this.name, this.version, service, null)));
        Set<StackConfigurationResponse> stackLevelConfigs = this.controller.getStackLevelConfigurations(Collections.singleton(new StackLevelConfigurationRequest(this.name, this.version, null)));
        serviceConfigs.addAll(stackLevelConfigs);
        for (StackConfigurationResponse config : serviceConfigs) {
            ConfigProperty configProperty = new ConfigProperty(config);
            String type = configProperty.getType();
            HashMap<String, ConfigProperty> mapTypeConfig = (HashMap<String, ConfigProperty>)mapServiceConfig.get(type);
            if (mapTypeConfig == null) {
                mapTypeConfig = new HashMap<String, ConfigProperty>();
                mapServiceConfig.put(type, mapTypeConfig);
            }
            mapTypeConfig.put(config.getPropertyName(), configProperty);
            if (!config.isRequired().booleanValue()) continue;
            HashMap<String, ConfigProperty> requiredTypeConfig = (HashMap<String, ConfigProperty>)mapRequiredServiceConfig.get(type);
            if (requiredTypeConfig == null) {
                requiredTypeConfig = new HashMap<String, ConfigProperty>();
                mapRequiredServiceConfig.put(type, requiredTypeConfig);
            }
            requiredTypeConfig.put(config.getPropertyName(), configProperty);
        }
        Set<String> configTypes = stackService.getConfigTypes().keySet();
        for (String configType : configTypes) {
            if (mapServiceConfig.containsKey(configType)) continue;
            mapServiceConfig.put(configType, Collections.emptyMap());
        }
    }

    private void parseStackConfigurations() throws OBDPException {
        Set<StackConfigurationResponse> stackLevelConfigs = this.controller.getStackLevelConfigurations(Collections.singleton(new StackLevelConfigurationRequest(this.name, this.version, null)));
        for (StackConfigurationResponse config : stackLevelConfigs) {
            ConfigProperty configProperty = new ConfigProperty(config);
            String type = configProperty.getType();
            Map<String, ConfigProperty> mapTypeConfig = this.stackConfigurations.get(type);
            if (mapTypeConfig == null) {
                mapTypeConfig = new HashMap<String, ConfigProperty>();
                this.stackConfigurations.put(type, mapTypeConfig);
            }
            mapTypeConfig.put(config.getPropertyName(), configProperty);
        }
    }

    private void parseExcludedConfigurations(StackServiceResponse stackServiceResponse) {
        this.excludedConfigurationTypes.put(stackServiceResponse.getServiceName(), stackServiceResponse.getExcludedConfigTypes());
    }

    void registerConditionalDependencies() {
        this.dbDependencyInfo.put("MYSQL_SERVER", "global/hive_database");
    }

    public static class ConfigProperty {
        private ValueAttributesInfo propertyValueAttributes = null;
        private String name;
        private String value;
        private Map<String, String> attributes;
        private Set<PropertyInfo.PropertyType> propertyTypes;
        private String type;
        private Set<PropertyDependencyInfo> dependsOnProperties = Collections.emptySet();

        public ConfigProperty(StackConfigurationResponse config) {
            this.name = config.getPropertyName();
            this.value = config.getPropertyValue();
            this.attributes = config.getPropertyAttributes();
            this.propertyTypes = config.getPropertyType();
            this.type = this.normalizeType(config.getType());
            this.dependsOnProperties = config.getDependsOnProperties();
            this.propertyValueAttributes = config.getPropertyValueAttributes();
        }

        public ConfigProperty(String type, String name, String value) {
            this.type = type;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public Set<PropertyInfo.PropertyType> getPropertyTypes() {
            return this.propertyTypes;
        }

        public void setPropertyTypes(Set<PropertyInfo.PropertyType> propertyTypes) {
            this.propertyTypes = propertyTypes;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        Set<PropertyDependencyInfo> getDependsOnProperties() {
            return this.dependsOnProperties;
        }

        private String normalizeType(String type) {
            if (type.endsWith(".xml")) {
                type = type.substring(0, type.length() - 4);
            }
            return type;
        }

        public ValueAttributesInfo getPropertyValueAttributes() {
            return this.propertyValueAttributes;
        }
    }
}

