/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.predicate.AlwaysPredicate;
import id.onyx.obdp.server.controller.predicate.AndPredicate;
import id.onyx.obdp.server.controller.predicate.ArrayPredicate;
import id.onyx.obdp.server.controller.predicate.CategoryPredicate;
import id.onyx.obdp.server.controller.predicate.ComparisonPredicate;
import id.onyx.obdp.server.controller.predicate.EqualsPredicate;
import id.onyx.obdp.server.controller.predicate.OrPredicate;
import id.onyx.obdp.server.controller.predicate.PredicateVisitor;
import id.onyx.obdp.server.controller.predicate.UnaryPredicate;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.ResourceProvider;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SimplifyingPredicateVisitor
implements PredicateVisitor {
    private ResourceProvider resourceProvider;
    private Predicate lastVisited = null;

    public SimplifyingPredicateVisitor(ResourceProvider provider) {
        this.resourceProvider = provider;
    }

    public List<Predicate> getSimplifiedPredicates() {
        if (this.lastVisited == null) {
            return Collections.emptyList();
        }
        if (this.lastVisited instanceof OrPredicate) {
            return Arrays.asList(((OrPredicate)this.lastVisited).getPredicates());
        }
        return Collections.singletonList(this.lastVisited);
    }

    @Override
    public void acceptComparisonPredicate(ComparisonPredicate predicate) {
        this.lastVisited = predicate instanceof EqualsPredicate && this.resourceProvider.checkPropertyIds(Collections.singleton(predicate.getPropertyId())).isEmpty() ? predicate : AlwaysPredicate.INSTANCE;
    }

    @Override
    public void acceptArrayPredicate(ArrayPredicate arrayPredicate) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        boolean hasOrs = false;
        Predicate[] predicates = arrayPredicate.getPredicates();
        if (predicates.length > 0) {
            for (Predicate predicate : predicates) {
                PredicateHelper.visit(predicate, this);
                predicateList.add(this.lastVisited);
                if (!(this.lastVisited instanceof OrPredicate)) continue;
                hasOrs = true;
            }
        }
        if (hasOrs && arrayPredicate instanceof AndPredicate) {
            int size = predicateList.size();
            LinkedList<Predicate> andPredicateList = new LinkedList<Predicate>();
            for (int i = 0; i < size; ++i) {
                for (int j = i + 1; j < size; ++j) {
                    andPredicateList.addAll(SimplifyingPredicateVisitor.distribute((Predicate)predicateList.get(i), (Predicate)predicateList.get(j)));
                }
            }
            this.lastVisited = OrPredicate.instance(andPredicateList.toArray(new Predicate[andPredicateList.size()]));
        } else {
            this.lastVisited = arrayPredicate.create(predicateList.toArray(new Predicate[predicateList.size()]));
        }
    }

    @Override
    public void acceptUnaryPredicate(UnaryPredicate predicate) {
        this.lastVisited = predicate;
    }

    @Override
    public void acceptAlwaysPredicate(AlwaysPredicate predicate) {
        this.lastVisited = predicate;
    }

    private static List<Predicate> distribute(Predicate left, Predicate right) {
        if (left instanceof OrPredicate) {
            return SimplifyingPredicateVisitor.distributeOr((OrPredicate)left, right);
        }
        if (right instanceof OrPredicate) {
            return SimplifyingPredicateVisitor.distributeOr((OrPredicate)right, left);
        }
        return Collections.singletonList(left.equals(right) ? left : AndPredicate.instance(left, right));
    }

    private static List<Predicate> distributeOr(OrPredicate orPredicate, Predicate other) {
        LinkedList<Predicate> andPredicateList = new LinkedList<Predicate>();
        OrPredicate otherOr = null;
        if (other instanceof OrPredicate) {
            otherOr = (OrPredicate)other;
        }
        for (Predicate basePredicate : orPredicate.getPredicates()) {
            if (otherOr != null) {
                andPredicateList.addAll(SimplifyingPredicateVisitor.distributeOr(otherOr, basePredicate));
                continue;
            }
            andPredicateList.add(basePredicate.equals(other) ? basePredicate : AndPredicate.instance(basePredicate, other));
        }
        return andPredicateList;
    }

    @Override
    public void acceptCategoryPredicate(CategoryPredicate predicate) {
        this.lastVisited = predicate;
    }
}

