/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.SettingResponse;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.orm.dao.SettingDAO;
import id.onyx.obdp.server.orm.entities.SettingEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

@StaticallyInject
public class SettingResourceProvider
extends AbstractAuthorizedResourceProvider {
    public static final String RESPONSE_KEY = "Settings";
    protected static final String ID = "id";
    protected static final String SETTING = "Setting";
    public static final String NAME = "name";
    public static final String SETTING_TYPE = "setting_type";
    public static final String CONTENT = "content";
    public static final String UPDATED_BY = "updated_by";
    public static final String UPDATE_TIMESTAMP = "update_timestamp";
    public static final String SETTING_NAME_PROPERTY_ID = "Settings/name";
    public static final String SETTING_SETTING_TYPE_PROPERTY_ID = "Settings/setting_type";
    public static final String SETTING_CONTENT_PROPERTY_ID = "Settings/content";
    public static final String SETTING_UPDATED_BY_PROPERTY_ID = "Settings/updated_by";
    public static final String SETTING_UPDATE_TIMESTAMP_PROPERTY_ID = "Settings/update_timestamp";
    public static final String ALL_PROPERTIES = "Settings/*";
    private static final Set<String> propertyIds = ImmutableSet.builder().add((Object)"Settings/name").add((Object)"Settings/setting_type").add((Object)"Settings/content").add((Object)"Settings/updated_by").add((Object)"Settings/update_timestamp").add((Object)"Settings/setting_type").add((Object)"Setting").build();
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.Setting, (Object)"Settings/name").build();
    private static final Set<String> REQUIRED_PROPERTIES = ImmutableSet.of((Object)"Settings/name", (Object)"Settings/setting_type", (Object)"Settings/content");
    @Inject
    private static SettingDAO dao;

    protected SettingResourceProvider() {
        super(Resource.Type.Setting, propertyIds, keyPropertyIds);
        EnumSet<RoleAuthorization> requiredAuthorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_SETTINGS);
        this.setRequiredCreateAuthorizations(requiredAuthorizations);
        this.setRequiredDeleteAuthorizations(requiredAuthorizations);
        this.setRequiredUpdateAuthorizations(requiredAuthorizations);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws NoSuchParentResourceException, ResourceAlreadyExistsException, SystemException {
        HashSet<Resource> associatedResources = new HashSet<Resource>();
        for (Map<String, Object> properties : request.getProperties()) {
            SettingResponse setting = this.createResources(this.newCreateCommand(request, properties));
            ResourceImpl resource = new ResourceImpl(Resource.Type.Setting);
            resource.setProperty(SETTING_NAME_PROPERTY_ID, setting.getName());
            associatedResources.add(resource);
        }
        return this.getRequestStatus(null, associatedResources);
    }

    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws NoSuchResourceException {
        List<Object> entities = new LinkedList();
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        if (propertyMaps.isEmpty()) {
            entities = dao.findAll();
        }
        for (Map<String, Object> propertyMap : propertyMaps) {
            if (propertyMap.containsKey(SETTING_NAME_PROPERTY_ID)) {
                String name = propertyMap.get(SETTING_NAME_PROPERTY_ID).toString();
                SettingEntity settingEntity = dao.findByName(name);
                if (settingEntity == null) {
                    throw new NoSuchResourceException(String.format("Setting with name %s does not exists", name));
                }
                entities.add(settingEntity);
                continue;
            }
            entities = dao.findAll();
            break;
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (SettingEntity settingEntity : entities) {
            resources.add(this.toResource(SettingResourceProvider.toResponse(settingEntity), requestedIds));
        }
        return resources;
    }

    @Override
    public RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws NoSuchResourceException, NoSuchParentResourceException, SystemException {
        this.modifyResources(this.newUpdateCommand(request));
        return this.getRequestStatus(null);
    }

    @Override
    public RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) {
        Set<Map<String, Object>> propertyMaps = this.getPropertyMaps(predicate);
        for (Map<String, Object> propertyMap : propertyMaps) {
            if (!propertyMap.containsKey(SETTING_NAME_PROPERTY_ID)) continue;
            dao.removeByName(propertyMap.get(SETTING_NAME_PROPERTY_ID).toString());
        }
        return this.getRequestStatus(null);
    }

    private AbstractResourceProvider.Command<SettingResponse> newCreateCommand(final Request request, final Map<String, Object> properties) {
        return new AbstractResourceProvider.Command<SettingResponse>(){

            @Override
            public SettingResponse invoke() throws OBDPException, AuthorizationException {
                SettingEntity entity = SettingResourceProvider.this.toEntity(properties);
                if (dao.findByName(entity.getName()) != null) {
                    throw new DuplicateResourceException(String.format("Setting already exists. setting name :%s ", entity.getName()));
                }
                dao.create(entity);
                SettingResourceProvider.this.notifyCreate(Resource.Type.Setting, request);
                return SettingResourceProvider.toResponse(entity);
            }
        };
    }

    private AbstractResourceProvider.Command<Void> newUpdateCommand(final Request request) throws NoSuchResourceException, SystemException {
        return new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException {
                Set<Map<String, Object>> propertyMaps = request.getProperties();
                for (Map<String, Object> propertyMap : propertyMaps) {
                    if (!propertyMap.containsKey(SettingResourceProvider.SETTING_NAME_PROPERTY_ID)) continue;
                    String name = propertyMap.get(SettingResourceProvider.SETTING_NAME_PROPERTY_ID).toString();
                    SettingEntity entity = dao.findByName(name);
                    if (entity == null) {
                        throw new OBDPException(String.format("There is no setting with name: %s ", name));
                    }
                    SettingResourceProvider.this.updateEntity(entity, propertyMap);
                    dao.merge(entity);
                }
                return null;
            }
        };
    }

    private void updateEntity(SettingEntity entity, Map<String, Object> propertyMap) throws OBDPException {
        String name = propertyMap.get(SETTING_NAME_PROPERTY_ID).toString();
        if (!Objects.equals(name, entity.getName())) {
            throw new OBDPException("Name for Setting is immutable, cannot change name.");
        }
        if (StringUtils.isNotBlank((String)ObjectUtils.toString((Object)propertyMap.get(SETTING_CONTENT_PROPERTY_ID)))) {
            entity.setContent(propertyMap.get(SETTING_CONTENT_PROPERTY_ID).toString());
        }
        if (StringUtils.isNotBlank((String)ObjectUtils.toString((Object)propertyMap.get(SETTING_SETTING_TYPE_PROPERTY_ID)))) {
            entity.setSettingType(propertyMap.get(SETTING_SETTING_TYPE_PROPERTY_ID).toString());
        }
        entity.setUpdatedBy(AuthorizationHelper.getAuthenticatedName());
        entity.setUpdateTimestamp(System.currentTimeMillis());
    }

    private Resource toResource(SettingResponse setting, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.Setting);
        SettingResourceProvider.setResourceProperty(resource, SETTING_NAME_PROPERTY_ID, setting.getName(), requestedIds);
        SettingResourceProvider.setResourceProperty(resource, SETTING_SETTING_TYPE_PROPERTY_ID, setting.getSettingType(), requestedIds);
        SettingResourceProvider.setResourceProperty(resource, SETTING_CONTENT_PROPERTY_ID, setting.getContent(), requestedIds);
        SettingResourceProvider.setResourceProperty(resource, SETTING_UPDATED_BY_PROPERTY_ID, setting.getUpdatedBy(), requestedIds);
        SettingResourceProvider.setResourceProperty(resource, SETTING_UPDATE_TIMESTAMP_PROPERTY_ID, setting.getUpdateTimestamp(), requestedIds);
        return resource;
    }

    private SettingEntity toEntity(Map<String, Object> properties) throws OBDPException {
        for (String propertyName : REQUIRED_PROPERTIES) {
            if (properties.get(propertyName) != null) continue;
            throw new OBDPException(String.format("Property %s should be provided", propertyName));
        }
        SettingEntity entity = new SettingEntity();
        entity.setName(properties.get(SETTING_NAME_PROPERTY_ID).toString());
        entity.setSettingType(properties.get(SETTING_SETTING_TYPE_PROPERTY_ID).toString());
        entity.setContent(properties.get(SETTING_CONTENT_PROPERTY_ID).toString());
        entity.setUpdatedBy(AuthorizationHelper.getAuthenticatedName());
        entity.setUpdateTimestamp(System.currentTimeMillis());
        return entity;
    }

    private static SettingResponse toResponse(SettingEntity entity) {
        return new SettingResponse(entity.getName(), entity.getSettingType(), entity.getContent(), entity.getUpdatedBy(), entity.getUpdateTimestamp());
    }
}

