/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import id.onyx.obdp.server.ClusterNotFoundException;
import id.onyx.obdp.server.DuplicateResourceException;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.ObjectNotFoundException;
import id.onyx.obdp.server.ParentObjectNotFoundException;
import id.onyx.obdp.server.RoleCommand;
import id.onyx.obdp.server.ServiceNotFoundException;
import id.onyx.obdp.server.api.services.OBDPMetaInfo;
import id.onyx.obdp.server.controller.KerberosHelper;
import id.onyx.obdp.server.controller.MaintenanceStateHelper;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RequestStatusResponse;
import id.onyx.obdp.server.controller.ServiceRequest;
import id.onyx.obdp.server.controller.ServiceResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.DeleteHostComponentStatusMetaData;
import id.onyx.obdp.server.controller.internal.RequestOperationLevel;
import id.onyx.obdp.server.controller.internal.RequestStageContainer;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.controller.utilities.ServiceCalculatedStateFactory;
import id.onyx.obdp.server.controller.utilities.state.ServiceCalculatedState;
import id.onyx.obdp.server.metadata.RoleCommandOrder;
import id.onyx.obdp.server.orm.dao.RepositoryVersionDAO;
import id.onyx.obdp.server.orm.entities.RepositoryVersionEntity;
import id.onyx.obdp.server.security.authorization.AuthorizationException;
import id.onyx.obdp.server.security.authorization.AuthorizationHelper;
import id.onyx.obdp.server.security.authorization.ResourceType;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.serveraction.kerberos.KerberosAdminAuthenticationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosInvalidConfigurationException;
import id.onyx.obdp.server.serveraction.kerberos.KerberosMissingAdminCredentialsException;
import id.onyx.obdp.server.state.Cluster;
import id.onyx.obdp.server.state.Clusters;
import id.onyx.obdp.server.state.MaintenanceState;
import id.onyx.obdp.server.state.Service;
import id.onyx.obdp.server.state.ServiceComponent;
import id.onyx.obdp.server.state.ServiceComponentHost;
import id.onyx.obdp.server.state.ServiceInfo;
import id.onyx.obdp.server.state.StackId;
import id.onyx.obdp.server.state.State;
import id.onyx.obdp.server.topology.STOMPComponentsDeleteHandler;
import id.onyx.obdp.server.topology.addservice.AddServiceOrchestrator;
import id.onyx.obdp.server.topology.addservice.AddServiceRequest;
import id.onyx.obdp.server.utils.LoggingPreconditions;
import id.onyx.obdp.spi.RepositoryType;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResourceProvider
extends AbstractControllerResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceResourceProvider.class);
    private static final LoggingPreconditions CHECK = new LoggingPreconditions(LOG);
    public static final String SERVICE_CLUSTER_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "cluster_name");
    public static final String SERVICE_SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "service_name");
    public static final String SERVICE_SERVICE_STATE_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "state");
    public static final String SERVICE_MAINTENANCE_STATE_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "maintenance_state");
    public static final String SERVICE_CREDENTIAL_STORE_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "credential_store_supported");
    public static final String SERVICE_CREDENTIAL_STORE_ENABLED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "credential_store_enabled");
    public static final String SERVICE_ATTRIBUTES_PROPERTY_ID = PropertyHelper.getPropertyId("Services", "attributes");
    public static final String SERVICE_DESIRED_STACK_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "desired_stack");
    public static final String SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "desired_repository_version_id");
    private static final String SSO_INTEGRATION_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "sso_integration_supported");
    private static final String SSO_INTEGRATION_ENABLED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "sso_integration_enabled");
    private static final String SSO_INTEGRATION_DESIRED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "sso_integration_desired");
    private static final String SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "sso_integration_requires_kerberos");
    private static final String KERBEROS_ENABLED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "kerberos_enabled");
    private static final String LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "ldap_integration_supported");
    private static final String LDAP_INTEGRATION_ENABLED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "ldap_integration_enabled");
    private static final String LDAP_INTEGRATION_DESIRED_PROPERTY_ID = PropertyHelper.getPropertyId("ServiceInfo", "ldap_integration_desired");
    public static final String OPERATION_TYPE = "operation_type";
    protected static final String SERVICE_REPOSITORY_STATE = "ServiceInfo/repository_state";
    private static final String QUERY_PARAMETERS_RUN_SMOKE_TEST_ID = "params/run_smoke_test";
    private static final String QUERY_PARAMETERS_RECONFIGURE_CLIENT = "params/reconfigure_client";
    private static final String QUERY_PARAMETERS_START_DEPENDENCIES = "params/start_dependencies";
    private static final Set<String> pkPropertyIds = new HashSet<String>(Arrays.asList(SERVICE_CLUSTER_NAME_PROPERTY_ID, SERVICE_SERVICE_NAME_PROPERTY_ID));
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    private MaintenanceStateHelper maintenanceStateHelper;
    @Inject
    private KerberosHelper kerberosHelper;
    @Inject
    private STOMPComponentsDeleteHandler STOMPComponentsDeleteHandler;
    @Inject
    private AddServiceOrchestrator addServiceOrchestrator;
    private final RepositoryVersionDAO repositoryVersionDAO;

    @AssistedInject
    public ServiceResourceProvider(@Assisted OBDPManagementController managementController, MaintenanceStateHelper maintenanceStateHelper, RepositoryVersionDAO repositoryVersionDAO) {
        super(Resource.Type.Service, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        this.maintenanceStateHelper = maintenanceStateHelper;
        this.repositoryVersionDAO = repositoryVersionDAO;
        this.setRequiredCreateAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES));
        this.setRequiredUpdateAuthorizations(RoleAuthorization.AUTHORIZATIONS_UPDATE_SERVICE);
        this.setRequiredGetAuthorizations(RoleAuthorization.AUTHORIZATIONS_VIEW_SERVICE);
        this.setRequiredDeleteAuthorizations(EnumSet.of(RoleAuthorization.SERVICE_ADD_DELETE_SERVICES));
    }

    @Override
    protected RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        Map<String, Object> requestProperties;
        if (request.getProperties().size() == 1 && ServiceResourceProvider.isAddServiceRequest(requestProperties = request.getProperties().iterator().next())) {
            RequestStatusResponse response = this.processAddServiceRequest(requestProperties, request.getRequestInfoProperties());
            this.notifyCreate(Resource.Type.Service, request);
            return this.getRequestStatus(response);
        }
        final HashSet<ServiceRequest> requests = new HashSet<ServiceRequest>();
        for (Map<String, Object> propertyMap : request.getProperties()) {
            requests.add(this.getRequest(propertyMap));
        }
        this.createResources(new AbstractResourceProvider.Command<Void>(){

            @Override
            public Void invoke() throws OBDPException, AuthorizationException {
                ServiceResourceProvider.this.createServices(requests);
                return null;
            }
        });
        this.notifyCreate(Resource.Type.Service, request);
        return this.getRequestStatus(null);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceRequest> requests = new HashSet<ServiceRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        Set<ServiceResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ServiceResponse>>(){

            @Override
            public Set<ServiceResponse> invoke() throws OBDPException {
                return ServiceResourceProvider.this.getServices(requests);
            }
        });
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ServiceResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.Service);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_CLUSTER_NAME_PROPERTY_ID, response.getClusterName(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_SERVICE_STATE_PROPERTY_ID, this.calculateServiceState(response.getClusterName(), response.getServiceName()), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_MAINTENANCE_STATE_PROPERTY_ID, response.getMaintenanceState(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_CREDENTIAL_STORE_SUPPORTED_PROPERTY_ID, String.valueOf(response.isCredentialStoreSupported()), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_CREDENTIAL_STORE_ENABLED_PROPERTY_ID, String.valueOf(response.isCredentialStoreEnabled()), requestedIds);
            RepositoryVersionEntity repoVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(response.getDesiredRepositoryVersionId());
            if (null != repoVersion) {
                ServiceResourceProvider.setResourceProperty(resource, SERVICE_DESIRED_STACK_PROPERTY_ID, repoVersion.getStackId(), requestedIds);
            }
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID, response.getDesiredRepositoryVersionId(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SERVICE_REPOSITORY_STATE, (Object)response.getRepositoryVersionState(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_SUPPORTED_PROPERTY_ID, response.isSsoIntegrationSupported(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_ENABLED_PROPERTY_ID, response.isSsoIntegrationEnabled(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_DESIRED_PROPERTY_ID, response.isSsoIntegrationDesired(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID, response.isSsoIntegrationRequiresKerberos(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, KERBEROS_ENABLED_PROPERTY_ID, response.isKerberosEnabled(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID, response.isLdapIntegrationSupported(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, LDAP_INTEGRATION_ENABLED_PROPERTY_ID, response.isLdapIntegrationEnabled(), requestedIds);
            ServiceResourceProvider.setResourceProperty(resource, LDAP_INTEGRATION_DESIRED_PROPERTY_ID, response.isLdapIntegrationDesired(), requestedIds);
            Map<String, Object> serviceSpecificProperties = this.getServiceSpecificProperties(response.getClusterName(), response.getServiceName(), requestedIds);
            for (Map.Entry<String, Object> entry : serviceSpecificProperties.entrySet()) {
                ServiceResourceProvider.setResourceProperty(resource, entry.getKey(), entry.getValue(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        RequestStageContainer requestStages = this.doUpdateResources(null, request, predicate);
        RequestStatusResponse response = null;
        if (requestStages != null) {
            try {
                requestStages.persist();
            }
            catch (OBDPException e) {
                throw new SystemException(e.getMessage(), e);
            }
            response = requestStages.getRequestStatusResponse();
        }
        this.notifyUpdate(Resource.Type.Service, request, predicate);
        return this.getRequestStatus(response);
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceRequest> requests = new HashSet<ServiceRequest>();
        for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
            requests.add(this.getRequest(propertyMap));
        }
        RequestStatusResponse response = this.modifyResources(new AbstractResourceProvider.Command<RequestStatusResponse>(){

            @Override
            public RequestStatusResponse invoke() throws OBDPException, AuthorizationException {
                return ServiceResourceProvider.this.deleteServices(requests);
            }
        });
        this.notifyDelete(Resource.Type.Service, predicate);
        return this.getRequestStatus(response);
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        if ((propertyIds = super.checkPropertyIds(propertyIds)).isEmpty()) {
            return propertyIds;
        }
        HashSet<String> unsupportedProperties = new HashSet<String>();
        for (String propertyId : propertyIds) {
            String propertyCategory;
            if (propertyId.equals("config") || (propertyCategory = PropertyHelper.getPropertyCategory(propertyId)) != null && propertyCategory.equals("config")) continue;
            unsupportedProperties.add(propertyId);
        }
        unsupportedProperties.removeAll(AddServiceRequest.TOP_LEVEL_PROPERTIES);
        return unsupportedProperties;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    private RequestStageContainer doUpdateResources(final RequestStageContainer stages, final Request request, Predicate predicate) throws UnsupportedPropertyException, SystemException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceRequest> requests = new HashSet<ServiceRequest>();
        RequestStageContainer requestStages = null;
        Iterator<Map<String, Object>> iterator = request.getProperties().iterator();
        if (iterator.hasNext()) {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(iterator.next(), predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
            final boolean runSmokeTest = "true".equals(ServiceResourceProvider.getQueryParameterValue(QUERY_PARAMETERS_RUN_SMOKE_TEST_ID, predicate));
            final boolean reconfigureClients = !"false".equals(ServiceResourceProvider.getQueryParameterValue(QUERY_PARAMETERS_RECONFIGURE_CLIENT, predicate));
            final boolean startDependencies = "true".equals(ServiceResourceProvider.getQueryParameterValue(QUERY_PARAMETERS_START_DEPENDENCIES, predicate));
            requestStages = this.modifyResources(new AbstractResourceProvider.Command<RequestStageContainer>(){

                @Override
                public RequestStageContainer invoke() throws OBDPException, AuthorizationException {
                    return ServiceResourceProvider.this.updateServices(stages, requests, request.getRequestInfoProperties(), runSmokeTest, reconfigureClients, startDependencies);
                }
            });
        }
        return requestStages;
    }

    private ServiceRequest getRequest(Map<String, Object> properties) {
        String desiredRepoId = (String)properties.get(SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID);
        ServiceRequest svcRequest = new ServiceRequest((String)properties.get(SERVICE_CLUSTER_NAME_PROPERTY_ID), (String)properties.get(SERVICE_SERVICE_NAME_PROPERTY_ID), null == desiredRepoId ? null : Long.valueOf(desiredRepoId), (String)properties.get(SERVICE_SERVICE_STATE_PROPERTY_ID), (String)properties.get(SERVICE_CREDENTIAL_STORE_ENABLED_PROPERTY_ID));
        Object o = properties.get(SERVICE_MAINTENANCE_STATE_PROPERTY_ID);
        if (null != o) {
            svcRequest.setMaintenanceState(o.toString());
        }
        if (null != (o = properties.get(SERVICE_CREDENTIAL_STORE_SUPPORTED_PROPERTY_ID))) {
            svcRequest.setCredentialStoreSupported(o.toString());
        }
        return svcRequest;
    }

    public void createServices(Set<ServiceRequest> requests) throws OBDPException, AuthorizationException {
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return;
        }
        Clusters clusters = this.getManagementController().getClusters();
        this.validateCreateRequests(requests, clusters);
        for (ServiceRequest request : requests) {
            Cluster cluster = clusters.getCluster(request.getClusterName());
            RepositoryVersionEntity repositoryVersion = request.getResolvedRepository();
            if (null == repositoryVersion) {
                throw new OBDPException("Could not find any repository on the request.");
            }
            if (repositoryVersion.getType() != RepositoryType.STANDARD && cluster.getProvisioningState() == State.INIT) {
                throw new OBDPException(String.format("Unable to add %s to %s because the cluster is still being provisioned and the repository for the service is not %s: %s", request.getServiceName(), cluster.getClusterName(), RepositoryType.STANDARD, repositoryVersion));
            }
            Service s = cluster.addService(request.getServiceName(), repositoryVersion);
            StackId stackId = repositoryVersion.getStackId();
            OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
            ServiceInfo serviceInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), request.getServiceName());
            boolean credentialStoreSupported = serviceInfo.isCredentialStoreSupported();
            boolean credentialStoreRequired = serviceInfo.isCredentialStoreRequired();
            LOG.info("Service: {}, credential_store_supported = {} and credential_store_required = {} from stack definition", new Object[]{request.getServiceName(), credentialStoreSupported, credentialStoreRequired});
            if (StringUtils.isNotEmpty((String)request.getCredentialStoreEnabled())) {
                boolean credentialStoreEnabled = Boolean.parseBoolean(request.getCredentialStoreEnabled());
                boolean enableCredStore = credentialStoreSupported && (credentialStoreRequired || credentialStoreEnabled);
                s.setCredentialStoreEnabled(enableCredStore);
                LOG.info("Service: {}, credential_store_enabled = {} from request and resulting credential store enabled status is = {}", new Object[]{request.getServiceName(), credentialStoreEnabled, enableCredStore});
            } else {
                boolean enableCredStore = credentialStoreSupported && (credentialStoreRequired || serviceInfo.isCredentialStoreEnabled());
                s.setCredentialStoreEnabled(enableCredStore);
                LOG.info("Service: {}, credential_store_enabled = {} from stack definition and resulting credential store enabled status is = {}", new Object[]{s.getName(), serviceInfo.isCredentialStoreEnabled(), enableCredStore});
            }
            this.getManagementController().initializeWidgetsAndLayouts(cluster, s);
        }
    }

    protected Set<ServiceResponse> getServices(Set<ServiceRequest> requests) throws OBDPException {
        HashSet<ServiceResponse> response = new HashSet<ServiceResponse>();
        for (ServiceRequest request : requests) {
            try {
                response.addAll(this.getServices(request));
            }
            catch (ServiceNotFoundException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<ServiceResponse> getServices(ServiceRequest request) throws OBDPException {
        Cluster cluster;
        if (request.getClusterName() == null || request.getClusterName().isEmpty()) {
            throw new OBDPException("Invalid arguments, cluster name cannot be null");
        }
        Clusters clusters = this.getManagementController().getClusters();
        String clusterName = request.getClusterName();
        try {
            cluster = clusters.getCluster(clusterName);
        }
        catch (ObjectNotFoundException e) {
            throw new ParentObjectNotFoundException("Parent Cluster resource doesn't exist", e);
        }
        HashSet<ServiceResponse> response = new HashSet<ServiceResponse>();
        if (request.getServiceName() != null) {
            Service s = cluster.getService(request.getServiceName());
            response.add(s.convertToResponse());
            return response;
        }
        boolean checkDesiredState = false;
        State desiredStateToCheck = null;
        if (request.getDesiredState() != null && !request.getDesiredState().isEmpty()) {
            desiredStateToCheck = State.valueOf(request.getDesiredState());
            if (!desiredStateToCheck.isValidDesiredState()) {
                throw new IllegalArgumentException("Invalid arguments, invalid desired state, desiredState=" + desiredStateToCheck);
            }
            checkDesiredState = true;
        }
        for (Service s : cluster.getServices().values()) {
            if (checkDesiredState && desiredStateToCheck != s.getDesiredState()) continue;
            response.add(s.convertToResponse());
        }
        return response;
    }

    protected RequestStageContainer updateServices(RequestStageContainer requestStages, Set<ServiceRequest> requests, Map<String, String> requestProperties, boolean runSmokeTest, boolean reconfigureClients, boolean startDependencies) throws OBDPException, AuthorizationException {
        Resource.Type reqOpLvl;
        OBDPManagementController controller = this.getManagementController();
        if (requests.isEmpty()) {
            LOG.warn("Received an empty requests set");
            return null;
        }
        EnumMap<State, List<Service>> changedServices = new EnumMap<State, List<Service>>(State.class);
        EnumMap<State, List<ServiceComponent>> changedComps = new EnumMap<State, List<ServiceComponent>>(State.class);
        HashMap<String, Map<State, List<ServiceComponentHost>>> changedScHosts = new HashMap<String, Map<State, List<ServiceComponentHost>>>();
        ArrayList<ServiceComponentHost> ignoredScHosts = new ArrayList<ServiceComponentHost>();
        HashSet<String> clusterNames = new HashSet<String>();
        HashMap serviceNames = new HashMap();
        HashSet<State> seenNewStates = new HashSet<State>();
        HashMap<Service, Boolean> serviceCredentialStoreEnabledMap = new HashMap<Service, Boolean>();
        if (requestProperties.containsKey("operation_level/level")) {
            RequestOperationLevel operationLevel = new RequestOperationLevel(requestProperties);
            reqOpLvl = operationLevel.getLevel();
        } else {
            String message = "Can not determine request operation level. Operation level property should be specified for this request.";
            LOG.warn(message);
            reqOpLvl = Resource.Type.Cluster;
        }
        Clusters clusters = controller.getClusters();
        for (ServiceRequest serviceRequest : requests) {
            if (serviceRequest.getClusterName() == null || serviceRequest.getClusterName().isEmpty() || serviceRequest.getServiceName() == null || serviceRequest.getServiceName().isEmpty()) {
                throw new IllegalArgumentException("Invalid arguments, cluster name and service name should be provided to update services");
            }
            LOG.info("Received a updateService request, clusterName=" + serviceRequest.getClusterName() + ", serviceName=" + serviceRequest.getServiceName() + ", request=" + serviceRequest);
            clusterNames.add(serviceRequest.getClusterName());
            if (clusterNames.size() > 1) {
                throw new IllegalArgumentException("Updates to multiple clusters is not supported");
            }
            if (!serviceNames.containsKey(serviceRequest.getClusterName())) {
                serviceNames.put(serviceRequest.getClusterName(), new HashSet());
            }
            if (((Set)serviceNames.get(serviceRequest.getClusterName())).contains(serviceRequest.getServiceName())) {
                throw new IllegalArgumentException("Invalid request contains duplicate service names");
            }
            ((Set)serviceNames.get(serviceRequest.getClusterName())).add(serviceRequest.getServiceName());
            Cluster cluster = clusters.getCluster(serviceRequest.getClusterName());
            Service s = cluster.getService(serviceRequest.getServiceName());
            State oldState = s.getDesiredState();
            State newState = null;
            if (serviceRequest.getDesiredState() != null && !(newState = State.valueOf(serviceRequest.getDesiredState())).isValidDesiredState()) {
                throw new IllegalArgumentException("Invalid arguments, invalid desired state, desiredState=" + newState);
            }
            if (null != serviceRequest.getMaintenanceState()) {
                if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_TOGGLE_MAINTENANCE)) {
                    throw new AuthorizationException("The authenticated user is not authorized to toggle the maintainence state of services");
                }
                MaintenanceState newMaint = MaintenanceState.valueOf(serviceRequest.getMaintenanceState());
                if (newMaint != s.getMaintenanceState()) {
                    if (newMaint.equals((Object)MaintenanceState.IMPLIED_FROM_HOST) || newMaint.equals((Object)MaintenanceState.IMPLIED_FROM_SERVICE)) {
                        throw new IllegalArgumentException("Invalid arguments, can only set maintenance state to one of " + EnumSet.of(MaintenanceState.OFF, MaintenanceState.ON));
                    }
                    s.setMaintenanceState(newMaint);
                }
            }
            if (StringUtils.isNotEmpty((String)serviceRequest.getCredentialStoreEnabled())) {
                boolean credentialStoreEnabled = Boolean.parseBoolean(serviceRequest.getCredentialStoreEnabled());
                if (!s.isCredentialStoreSupported() && credentialStoreEnabled) {
                    throw new IllegalArgumentException("Invalid arguments, cannot enable credential store as it is not supported by the service. Service=" + s.getName());
                }
                if (s.isCredentialStoreRequired() && !credentialStoreEnabled) {
                    throw new IllegalArgumentException("Invalid arguments, cannot disable credential store as it is required by the service. Service=" + s.getName());
                }
                serviceCredentialStoreEnabledMap.put(s, credentialStoreEnabled);
                LOG.info("Service: {}, credential_store_enabled from request: {}", (Object)serviceRequest.getServiceName(), (Object)credentialStoreEnabled);
            }
            if (StringUtils.isNotEmpty((String)serviceRequest.getCredentialStoreSupported())) {
                throw new IllegalArgumentException("Invalid arguments, cannot update credential_store_supported as it is set only via service definition. Service=" + s.getName());
            }
            if (newState == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Nothing to do for new updateService request, clusterName={}, serviceName={}, newDesiredState=null", (Object)serviceRequest.getClusterName(), (Object)serviceRequest.getServiceName());
                continue;
            }
            if (!this.maintenanceStateHelper.isOperationAllowed(reqOpLvl, s)) {
                LOG.info("Operations cannot be applied to service " + s.getName() + " in the maintenance state of " + s.getMaintenanceState());
                continue;
            }
            seenNewStates.add(newState);
            if (newState != oldState) {
                if (!(newState != State.INSTALLED && newState != State.STARTED || AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, cluster.getResourceId(), RoleAuthorization.SERVICE_START_STOP))) {
                    throw new AuthorizationException("The authenticated user is not authorized to start or stop services");
                }
                if (!State.isValidDesiredStateTransition(oldState, newState)) {
                    throw new OBDPException("Invalid transition for service, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + s.getName() + ", currentDesiredState=" + oldState + ", newDesiredState=" + newState);
                }
                if (!changedServices.containsKey((Object)newState)) {
                    changedServices.put(newState, new ArrayList());
                }
                ((List)changedServices.get((Object)newState)).add(s);
            }
            this.updateServiceComponents(requestStages, changedComps, changedScHosts, ignoredScHosts, reqOpLvl, s, newState);
        }
        if (startDependencies && changedServices.containsKey((Object)State.STARTED)) {
            HashSet depServices = new HashSet();
            for (Service service : (List)changedServices.get((Object)State.STARTED)) {
                RoleCommandOrder rco = controller.getRoleCommandOrder(service.getCluster());
                Set<Service> dependencies = rco.getTransitiveServices(service, RoleCommand.START);
                for (Service dependency : dependencies) {
                    if (((List)changedServices.get((Object)State.STARTED)).contains(dependency)) continue;
                    depServices.add(dependency);
                }
            }
            Iterator iterator = depServices.iterator();
            while (iterator.hasNext()) {
                Service service;
                service = (Service)iterator.next();
                this.updateServiceComponents(requestStages, changedComps, changedScHosts, ignoredScHosts, reqOpLvl, service, State.STARTED);
                ((List)changedServices.get((Object)State.STARTED)).add(service);
            }
        }
        if (seenNewStates.size() > 1) {
            throw new IllegalArgumentException("Cannot handle different desired state changes for a set of services at the same time");
        }
        for (Map.Entry entry : serviceCredentialStoreEnabledMap.entrySet()) {
            Service service2 = (Service)entry.getKey();
            Boolean credentialStoreEnabled = (Boolean)entry.getValue();
            service2.setCredentialStoreEnabled(credentialStoreEnabled);
        }
        Cluster cluster = clusters.getCluster((String)clusterNames.iterator().next());
        return controller.addStages(requestStages, cluster, requestProperties, null, changedServices, changedComps, changedScHosts, ignoredScHosts, runSmokeTest, reconfigureClients, false);
    }

    private void updateServiceComponents(RequestStageContainer requestStages, Map<State, List<ServiceComponent>> changedComps, Map<String, Map<State, List<ServiceComponentHost>>> changedScHosts, Collection<ServiceComponentHost> ignoredScHosts, Resource.Type reqOpLvl, Service service, State newState) throws OBDPException {
        Cluster cluster = service.getCluster();
        OBDPManagementController controller = this.getManagementController();
        OBDPMetaInfo obdpMetaInfo = controller.getAmbariMetaInfo();
        for (ServiceComponent sc : service.getServiceComponents().values()) {
            State oldScState = sc.getDesiredState();
            if (newState != oldScState) {
                if (sc.isClientComponent() && !newState.isValidClientComponentState()) continue;
                if (!State.isValidDesiredStateTransition(oldScState, newState)) {
                    throw new OBDPException("Invalid transition for servicecomponent, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + sc.getServiceName() + ", componentName=" + sc.getName() + ", currentDesiredState=" + oldScState + ", newDesiredState=" + newState);
                }
                if (!changedComps.containsKey((Object)newState)) {
                    changedComps.put(newState, new ArrayList());
                }
                changedComps.get((Object)newState).add(sc);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Handling update to ServiceComponent, clusterName={}, serviceName={}, componentName={}, currentDesiredState={}, newDesiredState={}", new Object[]{cluster.getClusterName(), service.getName(), sc.getName(), oldScState, newState});
            }
            for (ServiceComponentHost sch : sc.getServiceComponentHosts().values()) {
                State oldSchState = sch.getState();
                if (oldSchState == State.DISABLED || oldSchState == State.UNKNOWN) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignoring ServiceComponentHost, clusterName={}, serviceName={}, componentName={}, hostname={}, currentState={}, newDesiredState={}", new Object[]{cluster.getClusterName(), service.getName(), sc.getName(), sch.getHostName(), oldSchState, newState});
                    continue;
                }
                if (newState == oldSchState) {
                    ignoredScHosts.add(sch);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignoring ServiceComponentHost, clusterName={}, serviceName={}, componentName={}, hostname={}, currentState={}, newDesiredState={}", new Object[]{cluster.getClusterName(), service.getName(), sc.getName(), sch.getHostName(), oldSchState, newState});
                    continue;
                }
                if (!this.maintenanceStateHelper.isOperationAllowed(reqOpLvl, sch)) {
                    ignoredScHosts.add(sch);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Ignoring ServiceComponentHost, clusterName={}, serviceName={}, componentName={}, hostname={}", new Object[]{cluster.getClusterName(), service.getName(), sc.getName(), sch.getHostName()});
                    continue;
                }
                if (sc.isClientComponent() && !newState.isValidClientComponentState()) continue;
                if (!this.isValidStateTransition(requestStages, oldSchState, newState, sch)) {
                    String error = "Invalid transition for servicecomponenthost, clusterName=" + cluster.getClusterName() + ", clusterId=" + cluster.getClusterId() + ", serviceName=" + sch.getServiceName() + ", componentName=" + sch.getServiceComponentName() + ", hostname=" + sch.getHostName() + ", currentState=" + oldSchState + ", newDesiredState=" + newState;
                    StackId sid = service.getDesiredStackId();
                    if (obdpMetaInfo.getComponent(sid.getStackName(), sid.getStackVersion(), sc.getServiceName(), sch.getServiceComponentName()).isMaster()) {
                        throw new IllegalArgumentException(error);
                    }
                    LOG.warn("Ignoring: " + error);
                    continue;
                }
                if (!changedScHosts.containsKey(sc.getName())) {
                    changedScHosts.put(sc.getName(), new EnumMap(State.class));
                }
                if (!changedScHosts.get(sc.getName()).containsKey((Object)newState)) {
                    changedScHosts.get(sc.getName()).put(newState, new ArrayList());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Handling update to ServiceComponentHost, clusterName={}, serviceName={}, componentName={}, hostname={}, currentState={}, newDesiredState={}", new Object[]{cluster.getClusterName(), service.getName(), sc.getName(), sch.getHostName(), oldSchState, newState});
                }
                changedScHosts.get(sc.getName()).get((Object)newState).add(sch);
            }
        }
    }

    protected RequestStatusResponse deleteServices(Set<ServiceRequest> request) throws OBDPException, AuthorizationException {
        Clusters clusters = this.getManagementController().getClusters();
        HashSet<Service> removable = new HashSet<Service>();
        for (ServiceRequest serviceRequest : request) {
            if (StringUtils.isEmpty((String)serviceRequest.getClusterName()) || StringUtils.isEmpty((String)serviceRequest.getServiceName())) {
                throw new OBDPException("invalid arguments");
            }
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, this.getClusterResourceId(serviceRequest.getClusterName()), RoleAuthorization.SERVICE_ADD_DELETE_SERVICES)) {
                throw new AuthorizationException("The user is not authorized to delete services");
            }
            Service service = clusters.getCluster(serviceRequest.getClusterName()).getService(serviceRequest.getServiceName());
            List nonRemovableComponents = service.getServiceComponents().values().stream().flatMap(sch -> sch.getServiceComponentHosts().values().stream()).filter(sch -> !sch.canBeRemoved()).collect(Collectors.toList());
            if (!nonRemovableComponents.isEmpty()) {
                for (ServiceComponentHost sch2 : nonRemovableComponents) {
                    String msg = String.format("Cannot remove %s/%s. %s on %s is in %s state.", serviceRequest.getClusterName(), serviceRequest.getServiceName(), sch2.getServiceComponentName(), sch2.getHost(), String.valueOf((Object)sch2.getState()));
                    LOG.error(msg);
                }
                throw new OBDPException("Cannot remove " + serviceRequest.getClusterName() + "/" + serviceRequest.getServiceName() + ". One or more host components are in a non-removable state.");
            }
            removable.add(service);
        }
        DeleteHostComponentStatusMetaData deleteMetaData = new DeleteHostComponentStatusMetaData();
        for (Service service : removable) {
            service.getCluster().deleteService(service.getName(), deleteMetaData);
            this.STOMPComponentsDeleteHandler.processDeleteByMetaDataException(deleteMetaData);
        }
        this.STOMPComponentsDeleteHandler.processDeleteByMetaData(deleteMetaData);
        return null;
    }

    private String calculateServiceState(String clusterName, String serviceName) {
        ServiceCalculatedState serviceCalculatedState = ServiceCalculatedStateFactory.getServiceStateProvider(serviceName);
        return serviceCalculatedState.getState(clusterName, serviceName).toString();
    }

    private boolean isValidStateTransition(RequestStageContainer stages, State startState, State desiredState, ServiceComponentHost host) {
        if (stages != null) {
            State projectedState = stages.getProjectedState(host.getHostName(), host.getServiceComponentName());
            startState = projectedState == null ? startState : projectedState;
        }
        return State.isValidStateTransition(startState, desiredState);
    }

    private Map<String, Object> getServiceSpecificProperties(String clusterName, String serviceName, Set<String> requestedIds) {
        HashMap<String, Object> serviceSpecificProperties = new HashMap<String, Object>();
        if (serviceName.equals("KERBEROS") && (requestedIds.contains(SERVICE_ATTRIBUTES_PROPERTY_ID) || ServiceResourceProvider.isPropertyCategoryRequested(SERVICE_ATTRIBUTES_PROPERTY_ID, requestedIds) || ServiceResourceProvider.isPropertyEntryRequested(SERVICE_ATTRIBUTES_PROPERTY_ID, requestedIds))) {
            HashMap<String, String> kerberosAttributes = new HashMap<String, String>();
            String kdcValidationResult = "OK";
            String failureDetails = "";
            try {
                this.kerberosHelper.validateKDCCredentials(this.getManagementController().getClusters().getCluster(clusterName));
            }
            catch (KerberosInvalidConfigurationException e) {
                kdcValidationResult = "INVALID_CONFIGURATION";
                failureDetails = e.getMessage();
            }
            catch (KerberosAdminAuthenticationException e) {
                kdcValidationResult = "INVALID_CREDENTIALS";
                failureDetails = e.getMessage();
            }
            catch (KerberosMissingAdminCredentialsException e) {
                kdcValidationResult = "MISSING_CREDENTIALS";
                failureDetails = e.getMessage();
            }
            catch (OBDPException e) {
                kdcValidationResult = "VALIDATION_ERROR";
                failureDetails = e.getMessage();
            }
            kerberosAttributes.put("kdc_validation_result", kdcValidationResult);
            kerberosAttributes.put("kdc_validation_failure_details", failureDetails);
            serviceSpecificProperties.put(SERVICE_ATTRIBUTES_PROPERTY_ID, kerberosAttributes);
        }
        return serviceSpecificProperties;
    }

    private void validateCreateRequests(Set<ServiceRequest> requests, Clusters clusters) throws AuthorizationException, OBDPException {
        OBDPMetaInfo obdpMetaInfo = this.getManagementController().getAmbariMetaInfo();
        HashMap serviceNames = new HashMap();
        HashSet<String> duplicates = new HashSet<String>();
        for (ServiceRequest request : requests) {
            Long desiredRepositoryVersion;
            Cluster cluster;
            State state;
            String clusterName = request.getClusterName();
            String serviceName = request.getServiceName();
            Validate.notEmpty((String)clusterName, (String)"Cluster name should be provided when creating a service");
            Validate.notEmpty((String)serviceName, (String)"Service name should be provided when creating a service");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received a createService request, clusterName={}, serviceName={}, request={}", new Object[]{clusterName, serviceName, request});
            }
            if (!AuthorizationHelper.isAuthorized(ResourceType.CLUSTER, this.getClusterResourceId(clusterName), RoleAuthorization.SERVICE_ADD_DELETE_SERVICES)) {
                throw new AuthorizationException("The user is not authorized to create services");
            }
            if (!serviceNames.containsKey(clusterName)) {
                serviceNames.put(clusterName, new HashSet());
            }
            if (((Set)serviceNames.get(clusterName)).contains(serviceName)) {
                duplicates.add(serviceName);
                continue;
            }
            ((Set)serviceNames.get(clusterName)).add(serviceName);
            if (StringUtils.isNotEmpty((String)request.getDesiredState()) && (!(state = State.valueOf(request.getDesiredState())).isValidDesiredState() || state != State.INIT)) {
                throw new IllegalArgumentException("Invalid desired state only INIT state allowed during creation, providedDesiredState=" + request.getDesiredState());
            }
            try {
                cluster = clusters.getCluster(clusterName);
            }
            catch (ClusterNotFoundException e) {
                throw new ParentObjectNotFoundException("Attempted to add a service to a cluster which doesn't exist", e);
            }
            try {
                Service s = cluster.getService(serviceName);
                if (s != null) {
                    duplicates.add(serviceName);
                    continue;
                }
            }
            catch (ServiceNotFoundException s) {
                // empty catch block
            }
            if (null == (desiredRepositoryVersion = request.getDesiredRepositoryVersionId())) {
                HashSet<Long> repoIds = new HashSet<Long>();
                for (Service service : cluster.getServices().values()) {
                    RepositoryVersionEntity serviceRepo = service.getDesiredRepositoryVersion();
                    if (null != serviceRepo.getParentId()) {
                        repoIds.add(serviceRepo.getParentId());
                        continue;
                    }
                    repoIds.add(serviceRepo.getId());
                }
                LOG.info("{} was not specified; the following repository ids were found: {}", (Object)SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID, (Object)StringUtils.join(repoIds, (char)','));
                if (CollectionUtils.isEmpty(repoIds)) {
                    throw new IllegalArgumentException("No repositories were found for service installation");
                }
                if (repoIds.size() > 1) {
                    throw new IllegalArgumentException(String.format("%s was not specified, and the cluster contains more than one standard-type repository", SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID));
                }
                desiredRepositoryVersion = (Long)repoIds.iterator().next();
            }
            if (null == desiredRepositoryVersion) {
                throw new IllegalArgumentException(String.format("%s is required when adding a service.", SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID));
            }
            RepositoryVersionEntity repositoryVersion = (RepositoryVersionEntity)this.repositoryVersionDAO.findByPK(desiredRepositoryVersion);
            if (null == repositoryVersion) {
                throw new IllegalArgumentException(String.format("Could not find any repositories defined by %d", desiredRepositoryVersion));
            }
            StackId stackId = repositoryVersion.getStackId();
            request.setResolvedRepository(repositoryVersion);
            if (!obdpMetaInfo.isValidService(stackId.getStackName(), stackId.getStackVersion(), request.getServiceName())) {
                throw new IllegalArgumentException("Unsupported or invalid service in stack, clusterName=" + clusterName + ", serviceName=" + serviceName + ", stackInfo=" + stackId.getStackId());
            }
            ServiceInfo serviceInfo = obdpMetaInfo.getService(stackId.getStackName(), stackId.getStackVersion(), request.getServiceName());
            if (!StringUtils.isNotEmpty((String)request.getCredentialStoreEnabled())) continue;
            boolean credentialStoreEnabled = Boolean.parseBoolean(request.getCredentialStoreEnabled());
            if (serviceInfo.isCredentialStoreSupported() || !credentialStoreEnabled) continue;
            throw new IllegalArgumentException("Invalid arguments, cannot enable credential store as it is not supported by the service. Service=" + request.getServiceName());
        }
        if (serviceNames.size() != 1) {
            throw new IllegalArgumentException("Invalid arguments, updates allowedon only one cluster at a time");
        }
        if (!duplicates.isEmpty()) {
            String clusterName = requests.iterator().next().getClusterName();
            String msg = "Attempted to create a service which already exists: , clusterName=" + clusterName + " serviceName=" + StringUtils.join(duplicates, (String)",");
            throw new DuplicateResourceException(msg);
        }
    }

    private static boolean isAddServiceRequest(Map<String, Object> properties) {
        return AddServiceRequest.OperationType.ADD_SERVICE.name().equals(properties.get(OPERATION_TYPE));
    }

    private RequestStatusResponse processAddServiceRequest(Map<String, Object> requestProperties, Map<String, String> requestInfoProperties) throws NoSuchParentResourceException {
        AddServiceRequest request = ServiceResourceProvider.createAddServiceRequest(requestInfoProperties);
        String clusterName = String.valueOf(requestProperties.get(SERVICE_CLUSTER_NAME_PROPERTY_ID));
        try {
            return this.addServiceOrchestrator.processAddServiceRequest(this.getManagementController().getClusters().getCluster(clusterName), request);
        }
        catch (OBDPException e) {
            throw new NoSuchParentResourceException(e.getMessage(), e);
        }
    }

    private static AddServiceRequest createAddServiceRequest(Map<String, String> requestInfoProperties) {
        try {
            return AddServiceRequest.of(requestInfoProperties.get("RAW_REQUEST_BODY"));
        }
        catch (UncheckedIOException e) {
            return (AddServiceRequest)CHECK.wrapInUnchecked(e, IllegalArgumentException::new, "Could not parse input as valid Add Service request: " + e.getCause().getMessage(), new Object[0]);
        }
    }

    static {
        PROPERTY_IDS.add(SERVICE_CLUSTER_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_SERVICE_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_SERVICE_STATE_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_MAINTENANCE_STATE_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_CREDENTIAL_STORE_SUPPORTED_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_CREDENTIAL_STORE_ENABLED_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_ATTRIBUTES_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_DESIRED_STACK_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_DESIRED_REPO_VERSION_ID_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_REPOSITORY_STATE);
        PROPERTY_IDS.add(QUERY_PARAMETERS_RUN_SMOKE_TEST_ID);
        PROPERTY_IDS.add(QUERY_PARAMETERS_RECONFIGURE_CLIENT);
        PROPERTY_IDS.add(QUERY_PARAMETERS_START_DEPENDENCIES);
        PROPERTY_IDS.add(SSO_INTEGRATION_SUPPORTED_PROPERTY_ID);
        PROPERTY_IDS.add(SSO_INTEGRATION_ENABLED_PROPERTY_ID);
        PROPERTY_IDS.add(SSO_INTEGRATION_DESIRED_PROPERTY_ID);
        PROPERTY_IDS.add(SSO_INTEGRATION_REQUIRES_KERBEROS_PROPERTY_ID);
        PROPERTY_IDS.add(KERBEROS_ENABLED_PROPERTY_ID);
        PROPERTY_IDS.add(LDAP_INTEGRATION_SUPPORTED_PROPERTY_ID);
        PROPERTY_IDS.add(LDAP_INTEGRATION_ENABLED_PROPERTY_ID);
        PROPERTY_IDS.add(LDAP_INTEGRATION_DESIRED_PROPERTY_ID);
        PROPERTY_IDS.add(OPERATION_TYPE);
        PROPERTY_IDS.add("security");
        PROPERTY_IDS.add("credentials");
        KEY_PROPERTY_IDS.put(Resource.Type.Service, SERVICE_SERVICE_NAME_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, SERVICE_CLUSTER_NAME_PROPERTY_ID);
    }
}

