/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.ConfigurationResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.ServiceConfigVersionRequest;
import id.onyx.obdp.server.controller.ServiceConfigVersionResponse;
import id.onyx.obdp.server.controller.internal.AbstractControllerResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ServiceConfigVersionResourceProvider
extends AbstractControllerResourceProvider {
    public static final String CLUSTER_NAME_PROPERTY_ID = "cluster_name";
    public static final String SERVICE_CONFIG_VERSION_PROPERTY_ID = "service_config_version";
    public static final String SERVICE_NAME_PROPERTY_ID = "service_name";
    public static final String CREATE_TIME_PROPERTY_ID = "createtime";
    public static final String USER_PROPERTY_ID = "user";
    public static final String SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID = "service_config_version_note";
    public static final String GROUP_ID_PROPERTY_ID = "group_id";
    public static final String GROUP_NAME_PROPERTY_ID = "group_name";
    public static final String STACK_ID_PROPERTY_ID = "stack_id";
    public static final String IS_CURRENT_PROPERTY_ID = "is_current";
    public static final String IS_COMPATIBLE_PROPERTY_ID = "is_cluster_compatible";
    public static final String HOSTS_PROPERTY_ID = "hosts";
    public static final String CONFIGURATIONS_PROPERTY_ID = "configurations";
    public static final String APPLIED_TIME_PROPERTY_ID = "appliedtime";
    private static final Set<String> PROPERTY_IDS = new HashSet<String>();
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS = new HashMap<Resource.Type, String>();
    private static final Set<String> pkPropertyIds;

    ServiceConfigVersionResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.ServiceConfigVersion, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
        this.setRequiredGetAuthorizations(EnumSet.of(RoleAuthorization.CLUSTER_VIEW_CONFIGS, RoleAuthorization.SERVICE_VIEW_CONFIGS, RoleAuthorization.SERVICE_COMPARE_CONFIGS));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return pkPropertyIds;
    }

    @Override
    public RequestStatus createResources(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Cannot explicitly create service config version");
    }

    @Override
    public Set<Resource> getResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<ServiceConfigVersionRequest> requests = new HashSet<ServiceConfigVersionRequest>();
        for (Map<String, Object> properties : this.getPropertyMaps(predicate)) {
            requests.add(this.createRequest(properties));
        }
        Set<ServiceConfigVersionResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<ServiceConfigVersionResponse>>(){

            @Override
            public Set<ServiceConfigVersionResponse> invoke() throws OBDPException {
                return ServiceConfigVersionResourceProvider.this.getManagementController().getServiceConfigVersions(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (ServiceConfigVersionResponse response : responses) {
            String clusterName = response.getClusterName();
            List<ConfigurationResponse> configurationResponses = response.getConfigurations();
            List<Map<String, Object>> configVersionConfigurations = this.convertToSubResources(clusterName, configurationResponses);
            ResourceImpl resource = new ResourceImpl(Resource.Type.ServiceConfigVersion);
            resource.setProperty(CLUSTER_NAME_PROPERTY_ID, clusterName);
            resource.setProperty(SERVICE_NAME_PROPERTY_ID, response.getServiceName());
            resource.setProperty(USER_PROPERTY_ID, response.getUserName());
            resource.setProperty(SERVICE_CONFIG_VERSION_PROPERTY_ID, response.getVersion());
            resource.setProperty(CREATE_TIME_PROPERTY_ID, response.getCreateTime());
            resource.setProperty(CONFIGURATIONS_PROPERTY_ID, configVersionConfigurations);
            resource.setProperty(SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID, response.getNote());
            resource.setProperty(GROUP_ID_PROPERTY_ID, response.getGroupId());
            resource.setProperty(GROUP_NAME_PROPERTY_ID, response.getGroupName());
            resource.setProperty(HOSTS_PROPERTY_ID, response.getHosts());
            resource.setProperty(STACK_ID_PROPERTY_ID, response.getStackId());
            resource.setProperty(IS_CURRENT_PROPERTY_ID, response.getIsCurrent());
            resource.setProperty(IS_COMPATIBLE_PROPERTY_ID, response.isCompatibleWithCurrentStack());
            resources.add(resource);
        }
        return resources;
    }

    @Override
    public RequestStatus updateResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Cannot update service config version");
    }

    @Override
    public RequestStatus deleteResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        throw new UnsupportedOperationException("Cannot delete service config version");
    }

    @Override
    public Set<String> checkPropertyIds(Set<String> propertyIds) {
        if ((propertyIds = super.checkPropertyIds(propertyIds)).isEmpty()) {
            return propertyIds;
        }
        HashSet<String> unsupportedProperties = new HashSet<String>();
        for (String propertyId : propertyIds) {
            if (propertyId.equals(CLUSTER_NAME_PROPERTY_ID) || propertyId.equals(SERVICE_CONFIG_VERSION_PROPERTY_ID) || propertyId.equals(SERVICE_NAME_PROPERTY_ID) || propertyId.equals(CREATE_TIME_PROPERTY_ID) || propertyId.equals(APPLIED_TIME_PROPERTY_ID) || propertyId.equals(USER_PROPERTY_ID) || propertyId.equals(SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID) || propertyId.equals(GROUP_ID_PROPERTY_ID) || propertyId.equals(GROUP_NAME_PROPERTY_ID) || propertyId.equals(STACK_ID_PROPERTY_ID) || propertyId.equals(IS_CURRENT_PROPERTY_ID) || propertyId.equals(IS_COMPATIBLE_PROPERTY_ID) || propertyId.equals(HOSTS_PROPERTY_ID)) continue;
            unsupportedProperties.add(propertyId);
        }
        return unsupportedProperties;
    }

    private ServiceConfigVersionRequest createRequest(Map<String, Object> properties) {
        String clusterName = (String)properties.get(CLUSTER_NAME_PROPERTY_ID);
        String serviceName = (String)properties.get(SERVICE_NAME_PROPERTY_ID);
        String user = (String)properties.get(USER_PROPERTY_ID);
        Boolean isCurrent = Boolean.valueOf((String)properties.get(IS_CURRENT_PROPERTY_ID));
        Object versionObject = properties.get(SERVICE_CONFIG_VERSION_PROPERTY_ID);
        Long version = versionObject == null ? null : Long.valueOf(versionObject.toString());
        return new ServiceConfigVersionRequest(clusterName, serviceName, version, null, null, user, isCurrent);
    }

    private List<Map<String, Object>> convertToSubResources(String clusterName, List<ConfigurationResponse> configs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ConfigurationResponse config : configs) {
            LinkedHashMap<String, Object> subResourceMap = new LinkedHashMap<String, Object>();
            HashMap<String, String> configMap = new HashMap<String, String>();
            String stackId = config.getStackId().getStackId();
            configMap.put(CLUSTER_NAME_PROPERTY_ID, clusterName);
            configMap.put(STACK_ID_PROPERTY_ID, stackId);
            subResourceMap.put("Config", configMap);
            subResourceMap.put("type", config.getType());
            subResourceMap.put("tag", config.getVersionTag());
            subResourceMap.put("version", config.getVersion());
            subResourceMap.put("properties", new TreeMap<String, String>(config.getConfigs()));
            subResourceMap.put("properties_attributes", config.getConfigAttributes());
            result.add(subResourceMap);
        }
        return result;
    }

    static {
        PROPERTY_IDS.add(CLUSTER_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_CONFIG_VERSION_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(CREATE_TIME_PROPERTY_ID);
        PROPERTY_IDS.add(USER_PROPERTY_ID);
        PROPERTY_IDS.add(SERVICE_CONFIG_VERSION_NOTE_PROPERTY_ID);
        PROPERTY_IDS.add(GROUP_ID_PROPERTY_ID);
        PROPERTY_IDS.add(GROUP_NAME_PROPERTY_ID);
        PROPERTY_IDS.add(STACK_ID_PROPERTY_ID);
        PROPERTY_IDS.add(IS_CURRENT_PROPERTY_ID);
        PROPERTY_IDS.add(HOSTS_PROPERTY_ID);
        PROPERTY_IDS.add(CONFIGURATIONS_PROPERTY_ID);
        PROPERTY_IDS.add(IS_COMPATIBLE_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Service, SERVICE_NAME_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.Cluster, CLUSTER_NAME_PROPERTY_ID);
        KEY_PROPERTY_IDS.put(Resource.Type.ServiceConfigVersion, SERVICE_CONFIG_VERSION_PROPERTY_ID);
        pkPropertyIds = new HashSet<String>(Arrays.asList(CLUSTER_NAME_PROPERTY_ID, SERVICE_NAME_PROPERTY_ID));
    }
}

