/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.api.predicate.InvalidQueryException;
import id.onyx.obdp.server.controller.internal.BaseClusterRequest;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.stack.NoSuchStackException;
import id.onyx.obdp.server.topology.Blueprint;
import id.onyx.obdp.server.topology.Configuration;
import id.onyx.obdp.server.topology.HostGroupInfo;
import id.onyx.obdp.server.topology.InvalidTopologyTemplateException;
import id.onyx.obdp.server.topology.TopologyRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleClusterRequest
extends BaseClusterRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScaleClusterRequest.class);
    private String clusterName;

    public ScaleClusterRequest(Set<Map<String, Object>> propertySet) throws InvalidTopologyTemplateException {
        for (Map<String, Object> properties : propertySet) {
            if (this.getClusterName() == null) {
                this.setClusterName(String.valueOf(properties.get("Hosts/cluster_name")));
            }
            this.setConfiguration(new Configuration(Collections.emptyMap(), Collections.emptyMap()));
            this.parseHostGroups(properties);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public Long getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    @Override
    public TopologyRequest.Type getType() {
        return TopologyRequest.Type.SCALE;
    }

    @Override
    public String getDescription() {
        return String.format("Scale Cluster '%s' (+%s hosts)", this.clusterName, this.getTotalRequestedHostCount());
    }

    private void parseHostGroups(Map<String, Object> properties) throws InvalidTopologyTemplateException {
        String blueprintName = String.valueOf(properties.get("blueprint"));
        if (blueprintName == null || blueprintName.equals("null")) {
            throw new InvalidTopologyTemplateException("Blueprint name must be specified for all host groups");
        }
        String hgName = String.valueOf(properties.get("host_group"));
        if (hgName == null || hgName.equals("null")) {
            throw new InvalidTopologyTemplateException("A name must be specified for all host groups");
        }
        Blueprint blueprint = this.getBlueprint();
        if (this.getBlueprint() == null) {
            blueprint = this.parseBlueprint(blueprintName);
            this.setBlueprint(blueprint);
        } else if (!blueprintName.equals(blueprint.getName())) {
            throw new InvalidTopologyTemplateException("Currently, a scaling request may only refer to a single blueprint");
        }
        String hostName = HostResourceProvider.getHostNameFromProperties(properties);
        boolean containsHostCount = properties.containsKey("host_count");
        boolean containsHostPredicate = properties.containsKey("host_predicate");
        if (hostName != null && (containsHostCount || containsHostPredicate)) {
            throw new InvalidTopologyTemplateException("Can't specify host_count or host_predicate if host_name is specified in hostgroup: " + hgName);
        }
        if (hostName == null && !containsHostCount) {
            throw new InvalidTopologyTemplateException("Must specify either host_name or host_count for hostgroup: " + hgName);
        }
        HostGroupInfo hostGroupInfo = this.getHostGroupInfo().get(hgName);
        if (hostGroupInfo == null) {
            if (blueprint.getHostGroup(hgName) == null) {
                throw new InvalidTopologyTemplateException("Invalid host group specified in request: " + hgName);
            }
            hostGroupInfo = new HostGroupInfo(hgName);
            this.getHostGroupInfo().put(hgName, hostGroupInfo);
        }
        hostGroupInfo.setConfiguration(new Configuration(Collections.emptyMap(), Collections.emptyMap()));
        if (containsHostCount) {
            if (containsHostPredicate) {
                String predicate = String.valueOf(properties.get("host_predicate"));
                this.validateHostPredicateProperties(predicate);
                try {
                    hostGroupInfo.setPredicate(predicate);
                }
                catch (InvalidQueryException e) {
                    throw new InvalidTopologyTemplateException(String.format("Unable to compile host predicate '%s': %s", predicate, e), e);
                }
            }
            if (!hostGroupInfo.getHostNames().isEmpty()) {
                throw new InvalidTopologyTemplateException("Can't specify both host_name and host_count for the same hostgroup: " + hgName);
            }
            hostGroupInfo.setRequestedCount(Integer.parseInt(String.valueOf(properties.get("host_count"))));
        } else {
            if (hostGroupInfo.getRequestedHostCount() != hostGroupInfo.getHostNames().size()) {
                throw new InvalidTopologyTemplateException("Invalid host group specified in request: " + hgName);
            }
            hostGroupInfo.addHost(hostName);
            hostGroupInfo.addHostRackInfo(hostName, this.processRackInfo(properties));
        }
    }

    private String processRackInfo(Map<String, Object> properties) {
        String rackInfo = null;
        if (properties.containsKey("Hosts/rack_info")) {
            rackInfo = (String)properties.get("Hosts/rack_info");
        } else if (properties.containsKey("rack_info")) {
            rackInfo = (String)properties.get("rack_info");
        } else {
            LOGGER.debug("No rack info provided");
        }
        return rackInfo;
    }

    private Blueprint parseBlueprint(String blueprintName) throws InvalidTopologyTemplateException {
        Blueprint blueprint;
        try {
            blueprint = this.getBlueprintFactory().getBlueprint(blueprintName);
        }
        catch (NoSuchStackException e) {
            throw new InvalidTopologyTemplateException("Invalid stack specified in the blueprint: " + blueprintName);
        }
        if (blueprint == null) {
            throw new InvalidTopologyTemplateException("The specified blueprint doesn't exist: " + blueprintName);
        }
        return blueprint;
    }

    private int getTotalRequestedHostCount() {
        int count = 0;
        for (HostGroupInfo groupInfo : this.getHostGroupInfo().values()) {
            count += groupInfo.getRequestedHostCount();
        }
        return count;
    }
}

