/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RootServiceRequest;
import id.onyx.obdp.server.controller.RootServiceResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RootServiceResourceProvider
extends ReadOnlyResourceProvider {
    public static final String RESPONSE_KEY = "RootService";
    public static final String SERVICE_NAME = "service_name";
    public static final String SERVICE_NAME_PROPERTY_ID = "RootService/service_name";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.RootService, (Object)"RootService/service_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"RootService/service_name"});

    protected RootServiceResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.RootService, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RootServiceRequest> requests = new HashSet<RootServiceRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<RootServiceResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<RootServiceResponse>>(){

            @Override
            public Set<RootServiceResponse> invoke() throws OBDPException {
                return RootServiceResourceProvider.this.getManagementController().getRootServices(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (RootServiceResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.RootService);
            RootServiceResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    private RootServiceRequest getRequest(Map<String, Object> properties) {
        return new RootServiceRequest((String)properties.get(SERVICE_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

