/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.HostRequest;
import id.onyx.obdp.server.controller.HostResponse;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RootServiceHostComponentRequest;
import id.onyx.obdp.server.controller.RootServiceHostComponentResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.HostResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RootServiceHostComponentResourceProvider
extends ReadOnlyResourceProvider {
    public static final String RESPONSE_KEY = "RootServiceHostComponents";
    public static final String SERVICE_NAME = "service_name";
    public static final String HOST_NAME = "host_name";
    public static final String COMPONENT_NAME = "component_name";
    public static final String COMPONENT_VERSION = "component_version";
    public static final String COMPONENT_STATE = "component_state";
    public static final String PROPERTIES = "properties";
    public static final String SERVICE_NAME_PROPERTY_ID = "RootServiceHostComponents/service_name";
    public static final String HOST_NAME_PROPERTY_ID = "RootServiceHostComponents/host_name";
    public static final String COMPONENT_NAME_PROPERTY_ID = "RootServiceHostComponents/component_name";
    public static final String COMPONENT_VERSION_PROPERTY_ID = "RootServiceHostComponents/component_version";
    public static final String COMPONENT_STATE_PROPERTY_ID = "RootServiceHostComponents/component_state";
    public static final String PROPERTIES_PROPERTY_ID = "RootServiceHostComponents/properties";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.RootService, (Object)"RootServiceHostComponents/service_name").put((Object)Resource.Type.Host, (Object)"RootServiceHostComponents/host_name").put((Object)Resource.Type.RootServiceComponent, (Object)"RootServiceHostComponents/component_name").put((Object)Resource.Type.RootServiceHostComponent, (Object)"RootServiceHostComponents/component_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"RootServiceHostComponents/service_name", "RootServiceHostComponents/host_name", "RootServiceHostComponents/component_name", "RootServiceHostComponents/component_version", "RootServiceHostComponents/component_state", "RootServiceHostComponents/properties"});

    public RootServiceHostComponentResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.RootServiceHostComponent, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RootServiceHostComponentRequest> requests = new HashSet<RootServiceHostComponentRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<RootServiceHostComponentResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<RootServiceHostComponentResponse>>(){

            @Override
            public Set<RootServiceHostComponentResponse> invoke() throws OBDPException {
                return RootServiceHostComponentResourceProvider.this.getRootServiceHostComponents(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (RootServiceHostComponentResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.RootServiceHostComponent);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, HOST_NAME_PROPERTY_ID, response.getHostName(), requestedIds);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, COMPONENT_NAME_PROPERTY_ID, response.getComponentName(), requestedIds);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, COMPONENT_STATE_PROPERTY_ID, response.getComponentState(), requestedIds);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, COMPONENT_VERSION_PROPERTY_ID, response.getComponentVersion(), requestedIds);
            RootServiceHostComponentResourceProvider.setResourceProperty(resource, PROPERTIES_PROPERTY_ID, response.getProperties(), requestedIds);
            resources.add(resource);
        }
        return resources;
    }

    private RootServiceHostComponentRequest getRequest(Map<String, Object> properties) {
        return new RootServiceHostComponentRequest((String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(HOST_NAME_PROPERTY_ID), (String)properties.get(COMPONENT_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }

    protected Set<RootServiceHostComponentResponse> getRootServiceHostComponents(Set<RootServiceHostComponentRequest> requests) throws OBDPException {
        HashSet<RootServiceHostComponentResponse> response = new HashSet<RootServiceHostComponentResponse>();
        for (RootServiceHostComponentRequest request : requests) {
            try {
                Set<RootServiceHostComponentResponse> rootServiceHostComponents = this.getRootServiceHostComponents(request);
                response.addAll(rootServiceHostComponents);
            }
            catch (OBDPException e) {
                if (requests.size() != 1) continue;
                throw e;
            }
        }
        return response;
    }

    private Set<RootServiceHostComponentResponse> getRootServiceHostComponents(RootServiceHostComponentRequest request) throws OBDPException {
        OBDPManagementController controller = this.getManagementController();
        Set<HostResponse> hosts = HostResourceProvider.getHosts(controller, new HostRequest(request.getHostName(), null), null);
        return controller.getRootServiceResponseFactory().getRootServiceHostComponent(request, hosts);
    }
}

