/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootServiceComponentRequest;
import id.onyx.obdp.server.controller.RootServiceComponentResponse;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RootServiceComponentResourceProvider
extends ReadOnlyResourceProvider {
    public static final String RESPONSE_KEY = "RootServiceComponents";
    public static final String ALL_PROPERTIES = "RootServiceComponents/*";
    public static final String SERVICE_NAME = "service_name";
    public static final String COMPONENT_NAME = "component_name";
    public static final String COMPONENT_VERSION = "component_version";
    public static final String PROPERTIES = "properties";
    public static final String SERVER_CLOCK = "server_clock";
    public static final String SERVICE_NAME_PROPERTY_ID = "RootServiceComponents/service_name";
    public static final String COMPONENT_NAME_PROPERTY_ID = "RootServiceComponents/component_name";
    public static final String COMPONENT_VERSION_PROPERTY_ID = "RootServiceComponents/component_version";
    public static final String PROPERTIES_PROPERTY_ID = "RootServiceComponents/properties";
    public static final String SERVER_CLOCK_PROPERTY_ID = "RootServiceComponents/server_clock";
    private static final Map<Resource.Type, String> keyPropertyIds = ImmutableMap.builder().put((Object)Resource.Type.RootService, (Object)"RootServiceComponents/service_name").put((Object)Resource.Type.RootServiceComponent, (Object)"RootServiceComponents/component_name").build();
    private static final Set<String> propertyIds = Sets.newHashSet((Object[])new String[]{"RootServiceComponents/service_name", "RootServiceComponents/component_name", "RootServiceComponents/component_version", "RootServiceComponents/properties", "RootServiceComponents/server_clock"});

    protected RootServiceComponentResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.RootServiceComponent, propertyIds, keyPropertyIds, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        final HashSet<RootServiceComponentRequest> requests = new HashSet<RootServiceComponentRequest>();
        if (predicate == null) {
            requests.add(this.getRequest(Collections.emptyMap()));
        } else {
            for (Map<String, Object> propertyMap : this.getPropertyMaps(predicate)) {
                requests.add(this.getRequest(propertyMap));
            }
        }
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        Set<RootServiceComponentResponse> responses = this.getResources(new AbstractResourceProvider.Command<Set<RootServiceComponentResponse>>(){

            @Override
            public Set<RootServiceComponentResponse> invoke() throws OBDPException {
                return RootServiceComponentResourceProvider.this.getManagementController().getRootServiceComponents(requests);
            }
        });
        HashSet<Resource> resources = new HashSet<Resource>();
        for (RootServiceComponentResponse response : responses) {
            ResourceImpl resource = new ResourceImpl(Resource.Type.RootServiceComponent);
            RootServiceComponentResourceProvider.setResourceProperty(resource, SERVICE_NAME_PROPERTY_ID, response.getServiceName(), requestedIds);
            RootServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_NAME_PROPERTY_ID, response.getComponentName(), requestedIds);
            RootServiceComponentResourceProvider.setResourceProperty(resource, PROPERTIES_PROPERTY_ID, response.getProperties(), requestedIds);
            RootServiceComponentResourceProvider.setResourceProperty(resource, COMPONENT_VERSION_PROPERTY_ID, response.getComponentVersion(), requestedIds);
            if (RootComponent.OBDP_SERVER.name().equals(response.getComponentName())) {
                RootServiceComponentResourceProvider.setResourceProperty(resource, SERVER_CLOCK_PROPERTY_ID, response.getServerClock(), requestedIds);
            }
            resources.add(resource);
        }
        return resources;
    }

    private RootServiceComponentRequest getRequest(Map<String, Object> properties) {
        return new RootServiceComponentRequest((String)properties.get(SERVICE_NAME_PROPERTY_ID), (String)properties.get(COMPONENT_NAME_PROPERTY_ID));
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return new HashSet<String>(keyPropertyIds.values());
    }
}

