/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.internal.BaseProvider;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.PropertyProvider;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootServiceComponentPropertyProvider
extends BaseProvider
implements PropertyProvider {
    public static final String JCE_POLICY_PROPERTY_ID = PropertyHelper.getPropertyId("RootServiceComponents", "jce_policy");
    public static final String CIPHER_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("RootServiceComponents", "ciphers");
    private static final Set<String> SUPPORTED_PROPERTY_IDS;
    private static final Logger LOG;
    private static final Map<String, Integer> CACHED_CIPHER_MAX_KEY_LENGTHS;

    public RootServiceComponentPropertyProvider() {
        super(SUPPORTED_PROPERTY_IDS);
    }

    @Override
    public Set<Resource> populateResources(Set<Resource> resources, Request request, Predicate predicate) throws SystemException {
        Set<String> requestedIds = request.getPropertyIds();
        for (Resource resource : resources) {
            if (!RootComponent.OBDP_SERVER.name().equals(resource.getPropertyValue("RootServiceComponents/component_name")) || !requestedIds.contains(JCE_POLICY_PROPERTY_ID) && !requestedIds.contains(CIPHER_PROPERTIES_PROPERTY_ID)) continue;
            this.setCipherDetails(resource, requestedIds);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCipherDetails(Resource resource, Set<String> requestedIds) {
        Map<String, Integer> map = CACHED_CIPHER_MAX_KEY_LENGTHS;
        synchronized (map) {
            if (CACHED_CIPHER_MAX_KEY_LENGTHS.isEmpty()) {
                for (Provider provider : Security.getProviders()) {
                    String providerName = provider.getName();
                    for (Provider.Service service : provider.getServices()) {
                        String algorithmName = service.getAlgorithm();
                        if (!"Cipher".equalsIgnoreCase(service.getType())) continue;
                        try {
                            CACHED_CIPHER_MAX_KEY_LENGTHS.put(String.format("%s.%s", providerName, algorithmName).toLowerCase(), Cipher.getMaxAllowedKeyLength(algorithmName));
                        }
                        catch (NoSuchAlgorithmException e) {
                            LOG.warn(String.format("Failed to get the max key length of cipher %s, skipping.", algorithmName), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (requestedIds.contains(CIPHER_PROPERTIES_PROPERTY_ID)) {
            for (Map.Entry<String, Integer> entry : CACHED_CIPHER_MAX_KEY_LENGTHS.entrySet()) {
                RootServiceComponentPropertyProvider.setResourceProperty(resource, PropertyHelper.getPropertyId(CIPHER_PROPERTIES_PROPERTY_ID, entry.getKey()), entry.getValue(), requestedIds);
            }
        }
        if (requestedIds.contains(JCE_POLICY_PROPERTY_ID)) {
            Map.Entry<String, Integer> entry;
            Boolean unlimitedKeyJCEPolicyInstalled = null;
            entry = CACHED_CIPHER_MAX_KEY_LENGTHS.entrySet().iterator().next();
            if (entry != null) {
                unlimitedKeyJCEPolicyInstalled = Integer.MAX_VALUE == entry.getValue();
            }
            RootServiceComponentPropertyProvider.setResourceProperty(resource, PropertyHelper.getPropertyId(JCE_POLICY_PROPERTY_ID, "unlimited_key"), unlimitedKeyJCEPolicyInstalled, requestedIds);
        }
    }

    static {
        LOG = LoggerFactory.getLogger(RootServiceComponentPropertyProvider.class);
        HashSet<String> propertyIds = new HashSet<String>();
        propertyIds.add(JCE_POLICY_PROPERTY_ID);
        propertyIds.add(CIPHER_PROPERTIES_PROPERTY_ID);
        SUPPORTED_PROPERTY_IDS = Collections.unmodifiableSet(propertyIds);
        CACHED_CIPHER_MAX_KEY_LENGTHS = new HashMap<String, Integer>();
    }
}

