/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.OBDPException;
import id.onyx.obdp.server.api.services.RootServiceComponentConfiguration;
import id.onyx.obdp.server.controller.internal.AbstractAuthorizedResourceProvider;
import id.onyx.obdp.server.controller.internal.AbstractResourceProvider;
import id.onyx.obdp.server.controller.internal.OperationStatusMetaData;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationHandler;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationHandlerFactory;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.RequestStatus;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.ResourceAlreadyExistsException;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PredicateHelper;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.security.authorization.RoleAuthorization;
import id.onyx.obdp.server.utils.SecretReference;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class RootServiceComponentConfigurationResourceProvider
extends AbstractAuthorizedResourceProvider {
    static final String RESOURCE_KEY = "Configuration";
    public static final String CONFIGURATION_CATEGORY_PROPERTY_ID = PropertyHelper.getPropertyId("Configuration", "category");
    public static final String CONFIGURATION_PROPERTIES_PROPERTY_ID = PropertyHelper.getPropertyId("Configuration", "properties");
    public static final String CONFIGURATION_PROPERTY_TYPES_PROPERTY_ID = PropertyHelper.getPropertyId("Configuration", "property_types");
    public static final String CONFIGURATION_COMPONENT_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Configuration", "component_name");
    public static final String CONFIGURATION_SERVICE_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("Configuration", "service_name");
    private static final Set<String> PROPERTIES;
    private static final Map<Resource.Type, String> PK_PROPERTY_MAP;
    private static final Set<String> PK_PROPERTY_IDS;
    @Inject
    private RootServiceComponentConfigurationHandlerFactory rootServiceComponentConfigurationHandlerFactory;

    public RootServiceComponentConfigurationResourceProvider() {
        super(Resource.Type.RootServiceComponentConfiguration, PROPERTIES, PK_PROPERTY_MAP);
        EnumSet<RoleAuthorization> authorizations = EnumSet.of(RoleAuthorization.OBDP_MANAGE_CONFIGURATION);
        this.setRequiredCreateAuthorizations(authorizations);
        this.setRequiredDeleteAuthorizations(authorizations);
        this.setRequiredUpdateAuthorizations(authorizations);
        this.setRequiredGetAuthorizations(authorizations);
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    @Override
    public RequestStatus createResourcesAuthorized(Request request) throws SystemException, UnsupportedPropertyException, ResourceAlreadyExistsException, NoSuchParentResourceException {
        OperationStatusMetaData operationStatusMetadata = null;
        Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
        if (requestInfoProperties.containsKey("op")) {
            String operationType = requestInfoProperties.get("op");
            Map<String, Object> operationParameters = this.getOperationParameters(requestInfoProperties);
            operationStatusMetadata = this.performOperation(null, null, null, request.getProperties(), false, operationType, operationParameters);
        } else {
            this.createOrAddProperties(null, null, null, request.getProperties(), true);
        }
        return this.getRequestStatus(null, null, operationStatusMetadata);
    }

    @Override
    protected Set<Resource> getResourcesAuthorized(final Request request, final Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        return this.getResources(new AbstractResourceProvider.Command<Set<Resource>>(){

            @Override
            public Set<Resource> invoke() throws OBDPException {
                HashSet<Resource> resources = new HashSet<Resource>();
                Set<String> requestedIds = RootServiceComponentConfigurationResourceProvider.this.getRequestPropertyIds(request, predicate);
                if (CollectionUtils.isEmpty(requestedIds)) {
                    requestedIds = PROPERTIES;
                }
                if (predicate == null) {
                    Set<Resource> _resources;
                    try {
                        _resources = RootServiceComponentConfigurationResourceProvider.this.getConfigurationResources(requestedIds, null);
                    }
                    catch (NoSuchResourceException e) {
                        throw new OBDPException(e.getMessage(), (Throwable)e);
                    }
                    if (!CollectionUtils.isEmpty(_resources)) {
                        resources.addAll(_resources);
                    }
                } else {
                    for (Map<String, Object> propertyMap : RootServiceComponentConfigurationResourceProvider.this.getPropertyMaps(predicate)) {
                        Set<Resource> _resources;
                        try {
                            _resources = RootServiceComponentConfigurationResourceProvider.this.getConfigurationResources(requestedIds, propertyMap);
                        }
                        catch (NoSuchResourceException e) {
                            throw new OBDPException(e.getMessage(), (Throwable)e);
                        }
                        if (CollectionUtils.isEmpty(_resources)) continue;
                        resources.addAll(_resources);
                    }
                }
                return resources;
            }
        });
    }

    @Override
    protected RequestStatus deleteResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        String categoryName;
        String componentName;
        String serviceName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_SERVICE_NAME_PROPERTY_ID);
        RootServiceComponentConfigurationHandler handler = this.rootServiceComponentConfigurationHandlerFactory.getInstance(serviceName, componentName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_COMPONENT_NAME_PROPERTY_ID), categoryName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_CATEGORY_PROPERTY_ID));
        if (handler == null) {
            throw new SystemException(String.format("Configurations may not be updated for the %s component of the root service %s", componentName, serviceName));
        }
        handler.removeComponentConfiguration(categoryName);
        return this.getRequestStatus(null);
    }

    @Override
    protected RequestStatus updateResourcesAuthorized(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        String serviceName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_SERVICE_NAME_PROPERTY_ID);
        String componentName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_COMPONENT_NAME_PROPERTY_ID);
        String categoryName = (String)PredicateHelper.getProperties(predicate).get(CONFIGURATION_CATEGORY_PROPERTY_ID);
        OperationStatusMetaData operationStatusMetadata = null;
        Map<String, String> requestInfoProperties = request.getRequestInfoProperties();
        if (requestInfoProperties.containsKey("op")) {
            String operationType = requestInfoProperties.get("op");
            Map<String, Object> operationParameters = this.getOperationParameters(requestInfoProperties);
            operationStatusMetadata = this.performOperation(serviceName, componentName, categoryName, request.getProperties(), true, operationType, operationParameters);
        } else {
            this.createOrAddProperties(serviceName, componentName, categoryName, request.getProperties(), false);
        }
        return this.getRequestStatus(null, null, operationStatusMetadata);
    }

    private Resource toResource(String serviceName, String componentName, String categoryName, Map<String, String> properties, Map<String, String> propertyTypes, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.RootServiceComponentConfiguration);
        RootServiceComponentConfigurationResourceProvider.setResourceProperty(resource, CONFIGURATION_SERVICE_NAME_PROPERTY_ID, serviceName, requestedIds);
        RootServiceComponentConfigurationResourceProvider.setResourceProperty(resource, CONFIGURATION_COMPONENT_NAME_PROPERTY_ID, componentName, requestedIds);
        RootServiceComponentConfigurationResourceProvider.setResourceProperty(resource, CONFIGURATION_CATEGORY_PROPERTY_ID, categoryName, requestedIds);
        RootServiceComponentConfigurationResourceProvider.setResourceProperty(resource, CONFIGURATION_PROPERTIES_PROPERTY_ID, SecretReference.maskPasswordInPropertyMap(properties), requestedIds);
        RootServiceComponentConfigurationResourceProvider.setResourceProperty(resource, CONFIGURATION_PROPERTY_TYPES_PROPERTY_ID, propertyTypes, requestedIds);
        return resource;
    }

    private void createOrAddProperties(String defaultServiceName, String defaultComponentName, String defaultCategoryName, Set<Map<String, Object>> requestProperties, boolean removePropertiesIfNotSpecified) throws SystemException {
        if (requestProperties != null) {
            for (Map<String, Object> resourceProperties : requestProperties) {
                RequestDetails requestDetails = this.parseProperties(defaultServiceName, defaultComponentName, defaultCategoryName, resourceProperties);
                RootServiceComponentConfigurationHandler handler = this.rootServiceComponentConfigurationHandlerFactory.getInstance(requestDetails.serviceName, requestDetails.componentName, requestDetails.categoryName);
                if (handler != null) {
                    try {
                        handler.updateComponentCategory(requestDetails.categoryName, requestDetails.properties, removePropertiesIfNotSpecified);
                        continue;
                    }
                    catch (OBDPException | IllegalArgumentException e) {
                        throw new SystemException(e.getMessage(), e.getCause());
                    }
                }
                throw new SystemException(String.format("Configurations may not be updated for the %s component of the root service, %s", requestDetails.serviceName, requestDetails.componentName));
            }
        }
    }

    private OperationStatusMetaData performOperation(String defaultServiceName, String defaultComponentName, String defaultCategoryName, Set<Map<String, Object>> requestProperties, boolean mergeExistingProperties, String operationType, Map<String, Object> operationParameters) throws SystemException {
        OperationStatusMetaData metaData = new OperationStatusMetaData();
        if (requestProperties != null) {
            for (Map<String, Object> resourceProperties : requestProperties) {
                RequestDetails requestDetails = this.parseProperties(defaultServiceName, defaultComponentName, defaultCategoryName, resourceProperties);
                RootServiceComponentConfigurationHandler handler = this.rootServiceComponentConfigurationHandlerFactory.getInstance(requestDetails.serviceName, requestDetails.componentName, requestDetails.categoryName);
                if (handler != null) {
                    RootServiceComponentConfigurationHandler.OperationResult operationResult = handler.performOperation(requestDetails.categoryName, requestDetails.properties, mergeExistingProperties, operationType, operationParameters);
                    if (operationResult == null) {
                        throw new SystemException(String.format("An unexpected error has occurred while handling an operation for the %s component of the root service, %s", requestDetails.serviceName, requestDetails.componentName));
                    }
                    metaData.addResult(operationResult.getId(), operationResult.isSuccess(), operationResult.getMessage(), operationResult.getResponse());
                    continue;
                }
                throw new SystemException(String.format("Operations may not be performed on configurations for the %s component of the root service, %s", requestDetails.serviceName, requestDetails.componentName));
            }
        }
        return metaData;
    }

    private RequestDetails parseProperties(String defaultServiceName, String defaultComponentName, String defaultCategoryName, Map<String, Object> resourceProperties) throws SystemException {
        String serviceName = defaultServiceName;
        String componentName = defaultComponentName;
        String categoryName = defaultCategoryName;
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : resourceProperties.entrySet()) {
            String propertyName = entry.getKey();
            if (CONFIGURATION_CATEGORY_PROPERTY_ID.equals(propertyName)) {
                if (!(entry.getValue() instanceof String)) continue;
                categoryName = (String)entry.getValue();
                continue;
            }
            if (CONFIGURATION_COMPONENT_NAME_PROPERTY_ID.equals(propertyName)) {
                if (!(entry.getValue() instanceof String)) continue;
                componentName = (String)entry.getValue();
                continue;
            }
            if (CONFIGURATION_SERVICE_NAME_PROPERTY_ID.equals(propertyName)) {
                if (!(entry.getValue() instanceof String)) continue;
                serviceName = (String)entry.getValue();
                continue;
            }
            String propertyCategory = PropertyHelper.getPropertyCategory(entry.getKey());
            if (propertyCategory == null || !propertyCategory.equals(CONFIGURATION_PROPERTIES_PROPERTY_ID)) continue;
            String name = PropertyHelper.getPropertyName(entry.getKey());
            Object value = entry.getValue();
            properties.put(name, value == null ? null : value.toString());
        }
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new SystemException("The service name must be set");
        }
        if (StringUtils.isEmpty((String)componentName)) {
            throw new SystemException("The component name must be set");
        }
        if (StringUtils.isEmpty((String)categoryName)) {
            throw new SystemException("The configuration category must be set");
        }
        if (properties.isEmpty()) {
            throw new SystemException("The configuration properties must be set");
        }
        return new RequestDetails(serviceName, componentName, categoryName, properties);
    }

    private Map<String, Object> getOperationParameters(Map<String, String> requestInfoProperties) {
        HashMap<String, Object> operationParameters = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : requestInfoProperties.entrySet()) {
            String propertyCategory = PropertyHelper.getPropertyCategory(entry.getKey());
            if (propertyCategory == null || !propertyCategory.equals("parameters")) continue;
            String name = PropertyHelper.getPropertyName(entry.getKey());
            String value = entry.getValue();
            operationParameters.put(name, value == null ? null : value.toString());
        }
        return operationParameters;
    }

    private Set<Resource> getConfigurationResources(Set<String> requestedIds, Map<String, Object> propertyMap) throws NoSuchResourceException {
        String categoryName;
        String componentName;
        HashSet<Resource> resources = new HashSet<Resource>();
        String serviceName = this.getStringProperty(propertyMap, CONFIGURATION_SERVICE_NAME_PROPERTY_ID);
        RootServiceComponentConfigurationHandler handler = this.rootServiceComponentConfigurationHandlerFactory.getInstance(serviceName, componentName = this.getStringProperty(propertyMap, CONFIGURATION_COMPONENT_NAME_PROPERTY_ID), categoryName = this.getStringProperty(propertyMap, CONFIGURATION_CATEGORY_PROPERTY_ID));
        if (handler != null) {
            Map<String, RootServiceComponentConfiguration> configurations = handler.getComponentConfigurations(categoryName);
            if (configurations == null) {
                throw new NoSuchResourceException(categoryName);
            }
            for (Map.Entry<String, RootServiceComponentConfiguration> entry : configurations.entrySet()) {
                resources.add(this.toResource(serviceName, componentName, entry.getKey(), entry.getValue().getProperties(), entry.getValue().getPropertyTypes(), requestedIds));
            }
        }
        return resources;
    }

    private String getStringProperty(Map<String, Object> propertyMap, String propertyId) {
        Object o;
        String value = null;
        if (propertyMap != null && (o = propertyMap.get(propertyId)) instanceof String) {
            value = (String)o;
        }
        return value;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(CONFIGURATION_SERVICE_NAME_PROPERTY_ID);
        set.add(CONFIGURATION_COMPONENT_NAME_PROPERTY_ID);
        set.add(CONFIGURATION_CATEGORY_PROPERTY_ID);
        set.add(CONFIGURATION_PROPERTIES_PROPERTY_ID);
        set.add(CONFIGURATION_PROPERTY_TYPES_PROPERTY_ID);
        PROPERTIES = Collections.unmodifiableSet(set);
        HashMap<Resource.Type, String> map = new HashMap<Resource.Type, String>();
        map.put(Resource.Type.RootService, CONFIGURATION_SERVICE_NAME_PROPERTY_ID);
        map.put(Resource.Type.RootServiceComponent, CONFIGURATION_COMPONENT_NAME_PROPERTY_ID);
        map.put(Resource.Type.RootServiceComponentConfiguration, CONFIGURATION_CATEGORY_PROPERTY_ID);
        PK_PROPERTY_MAP = Collections.unmodifiableMap(map);
        PK_PROPERTY_IDS = Collections.unmodifiableSet(new HashSet<String>(PK_PROPERTY_MAP.values()));
    }

    private class RequestDetails {
        final String serviceName;
        final String componentName;
        final String categoryName;
        final Map<String, String> properties;

        private RequestDetails(String serviceName, String componentName, String categoryName, Map<String, String> properties) {
            this.serviceName = serviceName;
            this.componentName = componentName;
            this.categoryName = categoryName;
            this.properties = properties;
        }
    }
}

