/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import id.onyx.obdp.server.configuration.OBDPServerConfigurationCategory;
import id.onyx.obdp.server.controller.RootComponent;
import id.onyx.obdp.server.controller.RootService;
import id.onyx.obdp.server.controller.internal.OBDPServerConfigurationHandler;
import id.onyx.obdp.server.controller.internal.OBDPServerLDAPConfigurationHandler;
import id.onyx.obdp.server.controller.internal.OBDPServerSSOConfigurationHandler;
import id.onyx.obdp.server.controller.internal.RootServiceComponentConfigurationHandler;

@Singleton
public class RootServiceComponentConfigurationHandlerFactory {
    @Inject
    private OBDPServerConfigurationHandler defaultConfigurationHandler;
    @Inject
    private OBDPServerLDAPConfigurationHandler ldapConfigurationHandler;
    @Inject
    private OBDPServerSSOConfigurationHandler ssoConfigurationHandler;
    @Inject
    private OBDPServerConfigurationHandler tproxyConfigurationHandler;

    public RootServiceComponentConfigurationHandler getInstance(String serviceName, String componentName, String categoryName) {
        if (RootService.OBDP.name().equals(serviceName) && RootComponent.OBDP_SERVER.name().equals(componentName)) {
            if (OBDPServerConfigurationCategory.LDAP_CONFIGURATION.getCategoryName().equals(categoryName)) {
                return this.ldapConfigurationHandler;
            }
            if (OBDPServerConfigurationCategory.SSO_CONFIGURATION.getCategoryName().equals(categoryName)) {
                return this.ssoConfigurationHandler;
            }
            if (OBDPServerConfigurationCategory.TPROXY_CONFIGURATION.getCategoryName().equals(categoryName)) {
                return this.tproxyConfigurationHandler;
            }
            return this.defaultConfigurationHandler;
        }
        return null;
    }
}

