/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import com.google.inject.Inject;
import id.onyx.obdp.server.StaticallyInject;
import id.onyx.obdp.server.controller.OBDPManagementController;
import id.onyx.obdp.server.controller.internal.ReadOnlyResourceProvider;
import id.onyx.obdp.server.controller.internal.ResourceImpl;
import id.onyx.obdp.server.controller.spi.NoSuchParentResourceException;
import id.onyx.obdp.server.controller.spi.NoSuchResourceException;
import id.onyx.obdp.server.controller.spi.Predicate;
import id.onyx.obdp.server.controller.spi.Request;
import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.controller.spi.UnsupportedPropertyException;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import id.onyx.obdp.server.orm.dao.PermissionDAO;
import id.onyx.obdp.server.orm.dao.RoleAuthorizationDAO;
import id.onyx.obdp.server.orm.entities.PermissionEntity;
import id.onyx.obdp.server.orm.entities.RoleAuthorizationEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StaticallyInject
public class RoleAuthorizationResourceProvider
extends ReadOnlyResourceProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RoleAuthorizationResourceProvider.class);
    public static final String AUTHORIZATION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "authorization_id");
    public static final String PERMISSION_ID_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "permission_id");
    public static final String AUTHORIZATION_NAME_PROPERTY_ID = PropertyHelper.getPropertyId("AuthorizationInfo", "authorization_name");
    private static final Set<String> PK_PROPERTY_IDS;
    private static final Set<String> PROPERTY_IDS;
    private static final Map<Resource.Type, String> KEY_PROPERTY_IDS;
    @Inject
    private static RoleAuthorizationDAO roleAuthorizationDAO;
    @Inject
    private static PermissionDAO permissionDAO;

    public RoleAuthorizationResourceProvider(OBDPManagementController managementController) {
        super(Resource.Type.RoleAuthorization, PROPERTY_IDS, KEY_PROPERTY_IDS, managementController);
    }

    @Override
    public Set<Resource> getResources(Request request, Predicate predicate) throws SystemException, UnsupportedPropertyException, NoSuchResourceException, NoSuchParentResourceException {
        Set<String> requestedIds = this.getRequestPropertyIds(request, predicate);
        HashSet<Resource> resources = new HashSet<Resource>();
        Set<Map<Object, Object>> propertyMaps = predicate == null ? Collections.singleton(Collections.emptyMap()) : this.getPropertyMaps(predicate);
        if (propertyMaps != null) {
            for (Map<Object, Object> propertyMap : propertyMaps) {
                PermissionEntity permissionEntity;
                Object authorizationEntities;
                Integer permissionId;
                Object object = propertyMap.get(PERMISSION_ID_PROPERTY_ID);
                if (object instanceof String) {
                    try {
                        permissionId = Integer.valueOf((String)object);
                    }
                    catch (NumberFormatException e) {
                        LOG.warn(PERMISSION_ID_PROPERTY_ID + " is not a valid integer value", (Throwable)e);
                        throw new NoSuchResourceException("The requested resource doesn't exist: Authorization not found, " + predicate, e);
                    }
                } else {
                    permissionId = object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : null;
                }
                if ((authorizationEntities = permissionId == null ? roleAuthorizationDAO.findAll() : ((permissionEntity = permissionDAO.findById(permissionId)) == null ? null : permissionEntity.getAuthorizations())) == null) continue;
                String authorizationId = (String)propertyMap.get(AUTHORIZATION_ID_PROPERTY_ID);
                if (!StringUtils.isEmpty((String)authorizationId)) {
                    Iterator<RoleAuthorizationEntity> iterator = authorizationEntities.iterator();
                    while (iterator.hasNext()) {
                        if (authorizationId.equals(iterator.next().getAuthorizationId())) continue;
                        iterator.remove();
                    }
                }
                Iterator<RoleAuthorizationEntity> iterator = authorizationEntities.iterator();
                while (iterator.hasNext()) {
                    RoleAuthorizationEntity entity = iterator.next();
                    resources.add(this.toResource(permissionId, entity, requestedIds));
                }
            }
        }
        return resources;
    }

    @Override
    protected Set<String> getPKPropertyIds() {
        return PK_PROPERTY_IDS;
    }

    private Resource toResource(Integer permissionId, RoleAuthorizationEntity entity, Set<String> requestedIds) {
        ResourceImpl resource = new ResourceImpl(Resource.Type.RoleAuthorization);
        RoleAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_ID_PROPERTY_ID, entity.getAuthorizationId(), requestedIds);
        if (permissionId != null) {
            RoleAuthorizationResourceProvider.setResourceProperty(resource, PERMISSION_ID_PROPERTY_ID, permissionId, requestedIds);
        }
        RoleAuthorizationResourceProvider.setResourceProperty(resource, AUTHORIZATION_NAME_PROPERTY_ID, entity.getAuthorizationName(), requestedIds);
        return resource;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(AUTHORIZATION_ID_PROPERTY_ID);
        set.add(PERMISSION_ID_PROPERTY_ID);
        PK_PROPERTY_IDS = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(AUTHORIZATION_ID_PROPERTY_ID);
        set.add(PERMISSION_ID_PROPERTY_ID);
        set.add(AUTHORIZATION_NAME_PROPERTY_ID);
        PROPERTY_IDS = Collections.unmodifiableSet(set);
        HashMap<Resource.Type, String> map = new HashMap<Resource.Type, String>();
        map.put(Resource.Type.Permission, PERMISSION_ID_PROPERTY_ID);
        map.put(Resource.Type.RoleAuthorization, AUTHORIZATION_ID_PROPERTY_ID);
        KEY_PROPERTY_IDS = Collections.unmodifiableMap(map);
    }
}

