/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.internal.JsonHttpPropertyRequest;
import id.onyx.obdp.server.controller.spi.SystemException;
import id.onyx.obdp.server.state.Cluster;
import java.util.Collections;
import java.util.Map;

public class ResourceManagerHttpPropertyRequest
extends JsonHttpPropertyRequest {
    private static final String CONFIG_YARN_SITE = "yarn-site";
    private static final String CONFIG_CORE_SITE = "core-site";
    private static final String PROPERTY_YARN_HTTP_POLICY = "yarn.http.policy";
    private static final String PROPERTY_HADOOP_SSL_ENABLED = "hadoop.ssl.enabled";
    private static final String PROPERTY_YARN_HTTP_POLICY_VALUE_HTTPS_ONLY = "HTTPS_ONLY";
    private static final String PROPERTY_HADOOP_SSL_ENABLED_VALUE_TRUE = "true";
    private static final String PROPERTY_WEBAPP_ADDRESS = "yarn.resourcemanager.webapp.address";
    private static final String PROPERTY_WEBAPP_HTTPS_ADDRESS = "yarn.resourcemanager.webapp.https.address";
    private static final String PROPERTY_HA_RM_IDS = "yarn.resourcemanager.ha.rm-ids";
    private static final String PROPERTY_HOSTNAME_TEMPLATE = "yarn.resourcemanager.hostname.%s";
    private static final String PROPERTY_WEBAPP_ADDRESS_TEMPLATE = "yarn.resourcemanager.webapp.address.%s";
    private static final String PROPERTY_WEBAPP_HTTPS_ADDRESS_TEMPLATE = "yarn.resourcemanager.webapp.https.address.%s";
    private static final String URL_TEMPLATE = "%s://%s:%s/ws/v1/cluster/info";
    private static final Map<String, String> PROPERTY_MAPPINGS = Collections.singletonMap("clusterInfo/haState", "HostRoles/ha_state");

    public ResourceManagerHttpPropertyRequest() {
        super(PROPERTY_MAPPINGS);
    }

    @Override
    public String getUrl(Cluster cluster, String hostName) throws SystemException {
        Map<String, String> yarnConfig = cluster.getDesiredConfigByType(CONFIG_YARN_SITE).getProperties();
        Map<String, String> coreConfig = cluster.getDesiredConfigByType(CONFIG_CORE_SITE).getProperties();
        String yarnHttpPolicy = yarnConfig.get(PROPERTY_YARN_HTTP_POLICY);
        String hadoopSslEnabled = coreConfig.get(PROPERTY_HADOOP_SSL_ENABLED);
        boolean useHttps = yarnHttpPolicy != null && yarnHttpPolicy.equals(PROPERTY_YARN_HTTP_POLICY_VALUE_HTTPS_ONLY) || hadoopSslEnabled != null && hadoopSslEnabled.equals(PROPERTY_HADOOP_SSL_ENABLED_VALUE_TRUE);
        return String.format(URL_TEMPLATE, this.getProtocol(useHttps), hostName, this.getPort(hostName, yarnConfig, useHttps));
    }

    private String getProtocol(boolean useHttps) {
        return useHttps ? "https" : "http";
    }

    private String getPort(String hostName, Map<String, String> yarnConfig, boolean useHttps) {
        if (yarnConfig.containsKey(PROPERTY_HA_RM_IDS)) {
            String rmId = this.getConfigResourceManagerId(yarnConfig, hostName);
            return useHttps ? this.getConfigPortValue(yarnConfig, String.format(PROPERTY_WEBAPP_HTTPS_ADDRESS_TEMPLATE, rmId), "8090") : this.getConfigPortValue(yarnConfig, String.format(PROPERTY_WEBAPP_ADDRESS_TEMPLATE, rmId), "8088");
        }
        return useHttps ? this.getConfigPortValue(yarnConfig, PROPERTY_WEBAPP_HTTPS_ADDRESS, "8090") : this.getConfigPortValue(yarnConfig, PROPERTY_WEBAPP_ADDRESS, "8088");
    }

    private String getConfigResourceManagerId(Map<String, String> yarnConfig, String hostName) {
        for (String id : yarnConfig.get(PROPERTY_HA_RM_IDS).split(",")) {
            String hostNameProperty = String.format(PROPERTY_HOSTNAME_TEMPLATE, id);
            String hostNameById = yarnConfig.get(hostNameProperty);
            if (!hostNameById.equals(hostName)) continue;
            return id;
        }
        return null;
    }

    private String getConfigPortValue(Map<String, String> yarnConfig, String property, String defaultValue) {
        return yarnConfig.containsKey(property) ? yarnConfig.get(property).split(":")[1] : defaultValue;
    }
}

