/*
 * Decompiled with CFR 0.152.
 */
package id.onyx.obdp.server.controller.internal;

import id.onyx.obdp.server.controller.spi.Resource;
import id.onyx.obdp.server.controller.utilities.PropertyHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ResourceImpl
implements Resource {
    private final Resource.Type type;
    private final Map<String, Map<String, Object>> propertiesMap = Collections.synchronizedMap(new TreeMap());

    public ResourceImpl(Resource.Type type) {
        this.type = type;
    }

    public ResourceImpl(Resource resource) {
        this(resource, null);
    }

    public ResourceImpl(Resource resource, Set<String> propertyIds) {
        this.type = resource.getType();
        for (Map.Entry<String, Map<String, Object>> categoryEntry : resource.getPropertiesMap().entrySet()) {
            String category = categoryEntry.getKey();
            Map<String, Object> propertyMap = categoryEntry.getValue();
            if (propertyMap == null) continue;
            for (Map.Entry<String, Object> propertyEntry : propertyMap.entrySet()) {
                String propertyId = PropertyHelper.getPropertyId(category, propertyEntry.getKey());
                if (propertyIds != null && !propertyIds.isEmpty() && !PropertyHelper.containsProperty(propertyIds, propertyId)) continue;
                Object propertyValue = propertyEntry.getValue();
                this.setProperty(propertyId, propertyValue);
            }
        }
    }

    @Override
    public Resource.Type getType() {
        return this.type;
    }

    @Override
    public Map<String, Map<String, Object>> getPropertiesMap() {
        return this.propertiesMap;
    }

    @Override
    public void setProperty(String id, Object value) {
        String categoryKey = this.getCategoryKey(PropertyHelper.getPropertyCategory(id));
        Map<String, Object> properties = this.propertiesMap.get(categoryKey);
        if (properties == null) {
            properties = Collections.synchronizedMap(new TreeMap());
            this.propertiesMap.put(categoryKey, properties);
        }
        properties.put(PropertyHelper.getPropertyName(id), value);
    }

    @Override
    public void addCategory(String id) {
        String categoryKey = this.getCategoryKey(id);
        if (!this.propertiesMap.containsKey(categoryKey)) {
            this.propertiesMap.put(categoryKey, new HashMap());
        }
    }

    @Override
    public Object getPropertyValue(String id) {
        String categoryKey = this.getCategoryKey(PropertyHelper.getPropertyCategory(id));
        Map<String, Object> properties = this.propertiesMap.get(categoryKey);
        return properties == null ? null : properties.get(PropertyHelper.getPropertyName(id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Resource : ").append(this.type).append("\n");
        sb.append("Properties:\n");
        sb.append(this.propertiesMap);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceImpl resource = (ResourceImpl)o;
        return this.type == resource.type && !(this.propertiesMap == null ? resource.propertiesMap != null : !this.propertiesMap.equals(resource.propertiesMap));
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + (this.propertiesMap != null ? this.propertiesMap.hashCode() : 0);
    }

    private String getCategoryKey(String category) {
        return category == null ? "" : category;
    }
}

